local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, thisLevel, childBurnable
local igniteCalled = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  if thisObj.Child ~= nil then
    childBurnable = thisObj.Child
  end
end
function OnUseWorld(level, obj)
end
function TriggerBurnTutorial()
end
function CloseBurnTutorial()
end
function IsChildBurned()
  if childBurnable == nil then
    return true
  elseif childBurnable ~= nil then
    local breakable = childBurnable:FindSingleGOByName("flammablePile00")
    if breakable ~= nil and breakable:GetBreakable() ~= nil and breakable.Broken == false then
      return false
    else
      return true
    end
  end
end
function IgniteObject()
  if not igniteCalled then
    if childBurnable == nil then
      return
    end
    timers.StartLevelTimer(0.1, IgniteChildObject)
    igniteCalled = true
  end
end
function IgniteChildObject()
  childBurnable.LuaObjectScript.IgniteObject()
end
function ObjectLit()
  LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:GetLuaTableAttribute("onBlockerIgnited"), "Parent callback for lit")
  FireOnIgniteCallbacks()
end
local onIgniteCallbacks
function OnIgnite(fn)
  if onIgniteCallbacks == nil then
    onIgniteCallbacks = {}
  end
  onIgniteCallbacks[#onIgniteCallbacks + 1] = fn
end
function FireOnIgniteCallbacks()
  if onIgniteCallbacks ~= nil then
    for _, fn in pairs(onIgniteCallbacks) do
      fn()
    end
  end
end
function ClearOnIgniteCallbacks()
  onIgniteCallbacks = nil
end
function ObjectBurnedOut()
  print("PARENT:burned out!!")
  LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:GetLuaTableAttribute("onBlockerRemoved"), "Blocker Removed")
end
