local LD = require("design.LevelDesignLibrary")
local elevatorLeft, elevatorRight, thisObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  elevatorLeft = obj:FindSingleGOByName("CalderaRealmTowerElevatorL")
  elevatorRight = obj:FindSingleGOByName("CalderaRealmTowerElevatorR")
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function StartAtTopFloor(jumpElevator)
  if elevatorLeft then
    if LD.GetCurrentWaterLevel() == 2 and elevatorLeft.LuaObjectScript.SetBottomFloorToWaterLevel2 then
      elevatorLeft.LuaObjectScript.SetBottomFloorToWaterLevel2()
    end
    if jumpElevator then
      elevatorLeft.LuaObjectScript.JumpElevatorToTop()
    else
      elevatorLeft.LuaObjectScript.MoveElevatorToTop()
    end
  end
  if elevatorRight then
    if LD.GetCurrentWaterLevel() == 2 and elevatorRight.LuaObjectScript.SetBottomFloorToWaterLevel2 then
      elevatorRight.LuaObjectScript.SetBottomFloorToWaterLevel2()
    end
    if jumpElevator then
      elevatorRight.LuaObjectScript.JumpElevatorToTop()
    else
      elevatorRight.LuaObjectScript.MoveElevatorToTop()
    end
  end
end
function StartAtBottomFloor(jumpElevator)
  MoveLeftToBottomFloor(jumpElevator)
  MoveRightToBottomFloor(jumpElevator)
end
function MoveLeftToBottomFloor(jumpElevator)
  if elevatorLeft then
    if LD.GetCurrentWaterLevel() == 2 and elevatorLeft.LuaObjectScript.SetBottomFloorToWaterLevel2 then
      elevatorLeft.LuaObjectScript.SetBottomFloorToWaterLevel2()
    end
    if jumpElevator then
      elevatorLeft.LuaObjectScript.JumpElevatorToBottom()
    else
      elevatorLeft.LuaObjectScript.MoveElevatorToBottom()
    end
  end
end
function MoveRightToBottomFloor(jumpElevator)
  if elevatorRight then
    if LD.GetCurrentWaterLevel() == 2 and elevatorRight.LuaObjectScript.SetBottomFloorToWaterLevel2 then
      elevatorRight.LuaObjectScript.SetBottomFloorToWaterLevel2()
    end
    if jumpElevator then
      elevatorRight.LuaObjectScript.JumpElevatorToBottom()
    else
      elevatorRight.LuaObjectScript.MoveElevatorToBottom()
    end
  end
end
function EnableElevators()
  EnableLeftElevator()
  EnableRightElevator()
end
function DisableElevators()
  DisableLeftElevator()
  DisableRightElevator()
end
function StartLocked()
  if elevatorLeft and elevatorLeft.LuaObjectScript.StartLocked then
    elevatorLeft.LuaObjectScript.StartLocked()
  end
  if elevatorRight and elevatorRight.LuaObjectScript.StartLocked then
    elevatorRight.LuaObjectScript.StartLocked()
  end
end
function StartLocked_Left()
  if elevatorLeft and elevatorLeft.LuaObjectScript.StartLocked then
    elevatorLeft.LuaObjectScript.StartLocked()
  end
end
function StartLocked_Right()
  if elevatorRight and elevatorRight.LuaObjectScript.StartLocked then
    elevatorRight.LuaObjectScript.StartLocked()
  end
end
function UnlockElevators()
  if elevatorLeft then
    elevatorLeft.LuaObjectScript.UnlockElevator()
  end
  if elevatorRight then
    elevatorRight.LuaObjectScript.UnlockElevator()
  end
end
function EnableLeftElevator()
  if elevatorLeft then
    elevatorLeft.LuaObjectScript.EnableElevator()
  end
end
function DisableLeftElevator()
  if elevatorLeft then
    elevatorLeft.LuaObjectScript.DisableElevator()
  end
end
function EnableRightElevator()
  if elevatorRight then
    elevatorRight.LuaObjectScript.EnableElevator()
  end
end
function DisableRightElevator()
  if elevatorRight then
    elevatorRight.LuaObjectScript.DisableElevator()
  end
end
function ShowElevators(value)
  ShowLeftElevator(value)
  ShowRightElevator(value)
end
function ShowLeftElevator(value)
  if value == nil then
    value = true
  end
  if elevatorLeft then
    if value == true then
      elevatorLeft.LuaObjectScript.ShowElevator()
    else
      elevatorLeft.LuaObjectScript.HideElevator()
    end
  end
end
function ShowRightElevator(value)
  if value == nil then
    value = true
  end
  if elevatorRight then
    if value == true then
      elevatorRight.LuaObjectScript.ShowElevator()
    else
      elevatorRight.LuaObjectScript.HideElevator()
    end
  end
end
function UpdateWaterLv1Flags(hideLeft, hideRight)
  if hideRight then
    thisObj:FindSingleGOByName("Caldera_Docking_Flag_R1"):Hide()
  end
  thisObj:FindSingleGOByName("Caldera_Docking_Flag_R2"):Hide()
  if hideLeft then
    thisObj:FindSingleGOByName("Caldera_Docking_Flag_L1"):Hide()
  end
  thisObj:FindSingleGOByName("Caldera_Docking_Flag_L2"):Hide()
end
function UpdateWaterLv2Flags(hideLeft, hideRight)
  thisObj:FindSingleGOByName("Caldera_Docking_Flag_R1"):Hide()
  if not hideRight then
    thisObj:FindSingleGOByName("Caldera_Docking_Flag_R2"):Show()
  end
  thisObj:FindSingleGOByName("Caldera_Docking_Flag_L1"):Hide()
  if not hideLeft then
    thisObj:FindSingleGOByName("Caldera_Docking_Flag_L2"):Show()
  end
end
