local LD = require("design.LevelDesignLibrary")
local thisObj, elevatorManager
local isActivated = false
local isHidden = false
local topSwitch, bottomSwitch, topCollision, bottomCollision
function OnScriptLoaded(level, obj)
  thisObj = obj
  elevatorManager = obj:FindSingleGOByName("BasicElevator_Manager")
  topSwitch = thisObj:FindSingleGOByName("SwitchWallTop")
  topCollision = obj:FindSingleGOByName("TopFloorBlocker")
  bottomCollision = obj:FindSingleGOByName("BottomFloorBlocker")
  bottomSwitch = obj:FindSingleGOByName("SwitchWallL2")
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  if isHidden then
    topCollision:Hide()
    bottomCollision:Hide()
  else
    topCollision:Hide()
    bottomCollision:Show()
  end
end
function OnStart(level, obj)
  elevatorManager.LuaObjectScript.SetIsUsingRealmTravelShakeTiming()
  elevatorManager.LuaObjectScript.AddOnMoveUpCallback(ElevatorMoving)
  elevatorManager.LuaObjectScript.AddOnMoveDownCallback(ElevatorMoving)
  elevatorManager.LuaObjectScript.AddOnReachTopCallback(ElevatorReachFloor)
  elevatorManager.LuaObjectScript.AddOnReachBottomCallback(ElevatorReachFloor)
  elevatorManager.LuaObjectScript.UpdateCallSpeed(0.75, 0.75)
  if not isHidden then
    if LD.GetEntityVariable("_GBL_WaterDrop02Triggered") == false then
      elevatorManager.LuaObjectScript.DisableElevator()
    else
      local switchInteractZone = elevatorManager.LuaObjectScript.GetElevatorSwitch().LuaObjectScript.GetInteractZoneTable()
      switchInteractZone[1]:SetEnableLineOfSightTest(true)
      switchInteractZone[1]:SetInteractFrontAngleWeight(0.5)
      switchInteractZone[1]:SetCameraFrontAngle(0, 80)
      switchInteractZone[1]:SetCameraFrontAngleWeight(1)
    end
    if isActivated == false then
      bottomSwitch.LuaObjectScript.Disable(true)
    end
    ElevatorReachFloor()
  else
    if topSwitch then
      topSwitch.LuaObjectScript.Disable(true)
    end
    if bottomSwitch then
      bottomSwitch.LuaObjectScript.Disable(true)
    end
    elevatorManager.LuaObjectScript.GetElevatorSwitch().LuaObjectScript.Disable(true)
  end
end
function OnSaveCheckpoint(level, obj)
  return {isActivated = isActivated, isHidden = isHidden}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  isActivated = savedInfo.isActivated
  isHidden = savedInfo.isHidden
end
function StartLocked()
  isActivated = false
  bottomSwitch.LuaObjectScript.Disable(true)
end
function UnlockElevator()
  if isActivated == false then
    isActivated = true
    local topSwitch = elevatorManager.LuaObjectScript.GetTopFloorCallSwitch()
    local elevatorState = elevatorManager.LuaObjectScript.GetState()
    if elevatorState == "Top" then
      bottomSwitch.LuaObjectScript.Enable()
      topSwitch.LuaObjectScript.Disable(true)
    elseif elevatorState == "Bottom" then
      bottomSwitch.LuaObjectScript.Disable(true)
      topSwitch.LuaObjectScript.Enable()
    end
    local realmTowerParent = thisObj.Parent
    if realmTowerParent.IsRefNode then
      realmTowerParent = realmTowerParent.Parent
    end
    realmTowerParent.LuaObjectScript.UnlockElevators()
  end
end
function ElevatorMoving()
  UnlockElevator()
  topCollision:Show()
  bottomCollision:Show()
end
function ElevatorReachFloor()
  if elevatorManager.LuaObjectScript.GetState() == "Top" then
    topCollision:Hide()
    bottomCollision:Show()
  else
    topCollision:Show()
    bottomCollision:Hide()
  end
end
function EnableElevator()
  elevatorManager.LuaObjectScript.EnableElevator()
  if isActivated then
    ElevatorReachFloor()
  end
end
function DisableElevator()
  elevatorManager.LuaObjectScript.DisableElevator()
end
function ShowElevator()
  isHidden = false
  thisObj:Show()
  thisObj:FindSingleGOByName("ElevatorDynamicNav"):Hide()
  EnableElevator()
end
function HideElevator()
  isHidden = true
  thisObj:Hide()
  elevatorManager.LuaObjectScript.DisableElevator()
  thisObj:FindSingleGOByName("SwitchWall_RealmTower").LuaObjectScript.Disable()
end
function MoveElevatorToBottom()
  elevatorManager.LuaObjectScript.MoveDown()
end
function MoveElevatorToTop()
  elevatorManager.LuaObjectScript.MoveUp()
end
function JumpElevatorToBottom()
  elevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  elevatorManager.LuaObjectScript.JumpToTopFloor()
end
function ShowDebugText(distance)
  local color = require("core.color")
  distance = distance or 50
  if distance >= game.Player.FindPlayer():GetWorldPosition():Distance(elevatorManager:GetWorldPosition()) then
    local debugText = " isActivated " .. tostring(isActivated) .. "\n"
    debugText = debugText .. " isHidden " .. tostring(isHidden) .. "\n"
    engine.DrawTextInWorld(elevatorManager:GetWorldPosition() + engine.Vector.New(0, 1.5, 0), debugText, color.white)
  end
  elevatorManager.LuaObjectScript.ShowDebugText(distance)
end
function ShowDebugTable(X, Y, title)
  local debugTable = {}
  debugTable.Title = title or "RealmTower Info"
  debugTable.X = X or 120
  debugTable.Y = Y or 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  engine.DrawDebugTable(debugTable)
end
