local LD = require("design.LevelDesignLibrary")
local thisObj, elevatorManager
local isActivated = true
local bottomSwitch, topCollision, bottomCollision
function OnScriptLoaded(level, obj)
  thisObj = obj
  topCollision = obj:FindSingleGOByName("TopFloorBlocker")
  bottomCollision = obj:FindSingleGOByName("BottomFloorBlocker")
  elevatorManager = obj:FindSingleGOByName("BasicElevator_Manager")
  if LD.GetCurrentWaterLevel() == 2 then
    bottomSwitch = obj:FindSingleGOByName("SwitchWallL2")
  else
    bottomSwitch = obj:FindSingleGOByName("SwitchWallL1")
  end
  elevatorManager.LuaObjectScript.SetBottomFloorCallSwitch(bottomSwitch, true)
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  topCollision:Hide()
  bottomCollision:Show()
end
function OnStart(level, obj)
  elevatorManager.LuaObjectScript.SetIsUsingRealmTravelShakeTiming()
  elevatorManager.LuaObjectScript.AddOnMoveUpCallback(ElevatorMoving)
  elevatorManager.LuaObjectScript.AddOnMoveDownCallback(ElevatorMoving)
  elevatorManager.LuaObjectScript.AddOnReachTopCallback(ElevatorReachFloor)
  elevatorManager.LuaObjectScript.AddOnReachBottomCallback(ElevatorReachFloor)
  local switchInteractZone = elevatorManager.LuaObjectScript.GetElevatorSwitch().LuaObjectScript.GetInteractZoneTable()[1]
  switchInteractZone:SetEnableLineOfSightTest(true)
  switchInteractZone:SetInteractFrontAngleWeight(0.5)
  switchInteractZone:SetCameraFrontAngle(0, 80)
  switchInteractZone:SetCameraFrontAngleWeight(1)
  if isActivated == false then
    bottomSwitch.LuaObjectScript.Disable(true)
  end
  elevatorManager.LuaObjectScript.UpdateCallSpeed(0.75, 0.75)
  ElevatorReachFloor()
  SoundOnStart()
end
function OnSaveCheckpoint(level, obj)
  return {isActivated = isActivated}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  isActivated = savedInfo.isActivated
end
function StartLocked()
  isActivated = false
  bottomSwitch.LuaObjectScript.Disable(true)
end
function UnlockElevator()
  if isActivated == false then
    isActivated = true
    local topSwitch = elevatorManager.LuaObjectScript.GetTopFloorCallSwitch()
    local elevatorState = elevatorManager.LuaObjectScript.GetState()
    if elevatorState == "Top" then
      bottomSwitch.LuaObjectScript.Enable()
      topSwitch.LuaObjectScript.Disable(true)
    elseif elevatorState == "Bottom" then
      bottomSwitch.LuaObjectScript.Disable(true)
      topSwitch.LuaObjectScript.Enable()
    end
    local realmTowerParent = thisObj.Parent
    if realmTowerParent.IsRefNode then
      realmTowerParent = realmTowerParent.Parent
    end
    realmTowerParent.LuaObjectScript.UnlockElevators()
  end
end
function SetBottomFloorToWaterLevel2()
  elevatorManager.LuaObjectScript.SetBottomFloorFrame("end")
  local lv1Switch = thisObj:FindSingleGOByName("SwitchWallL1")
  lv1Switch.LuaObjectScript.Disable(true)
  bottomSwitch = thisObj:FindSingleGOByName("SwitchWallL2")
  elevatorManager.LuaObjectScript.SetBottomFloorCallSwitch(bottomSwitch)
  if not isActivated then
    bottomSwitch.LuaObjectScript.Disable(true)
  end
  SoundOverrideElevatorBasedOnWaterLevel(2)
end
function ElevatorMoving()
  UnlockElevator()
  topCollision:Show()
  bottomCollision:Show()
end
function ElevatorReachFloor()
  if elevatorManager.LuaObjectScript.GetState() == "Top" then
    topCollision:Hide()
    bottomCollision:Show()
  else
    topCollision:Show()
    bottomCollision:Hide()
  end
end
function EnableElevator()
  elevatorManager.LuaObjectScript.EnableElevator()
  if isActivated then
    ElevatorReachFloor()
  end
end
function DisableElevator()
  elevatorManager.LuaObjectScript.DisableElevator()
end
function MoveElevatorToBottom()
  elevatorManager.LuaObjectScript.MoveDown()
end
function MoveElevatorToTop()
  elevatorManager.LuaObjectScript.MoveUp()
end
function JumpElevatorToBottom()
  elevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  elevatorManager.LuaObjectScript.JumpToTopFloor()
end
local elevatorSoundOverride_WaterLevel1 = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnForward = 10,
  OnBackward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1,
  AnimFrameTopFloor = 10,
  AnimFrameBottomFloor = -1
}
local elevatorSoundOverride_WaterLevel2 = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnForward = 10,
  OnBackward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnBackward = 150,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1,
  AnimFrameTopFloor = 10,
  AnimFrameBottomFloor = 150
}
function SoundOnStart()
  SoundOverrideElevatorBasedOnWaterLevel()
end
function SoundOverrideElevatorBasedOnWaterLevel(waterLevel)
  if waterLevel == nil then
    waterLevel = LD.GetCurrentWaterLevel()
  end
  if waterLevel == 2 then
    elevatorManager.LuaObjectScript.SoundSetup(elevatorSoundOverride_WaterLevel2)
  else
    elevatorManager.LuaObjectScript.SoundSetup(elevatorSoundOverride_WaterLevel1)
  end
end
function ShowDebugText(distance)
  local color = require("core.color")
  distance = distance or 50
  if distance >= game.Player.FindPlayer():GetWorldPosition():Distance(elevatorManager:GetWorldPosition()) then
    local debugText = " isActivated " .. tostring(isActivated) .. "\n"
    engine.DrawTextInWorld(elevatorManager:GetWorldPosition() + engine.Vector.New(0, 1.5, 0), debugText, color.white)
  end
  elevatorManager.LuaObjectScript.ShowDebugText(distance)
end
function ShowDebugTable(X, Y, title)
  local debugTable = {}
  debugTable.Title = title or "RealmTower Info"
  debugTable.X = X or 120
  debugTable.Y = Y or 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  engine.DrawDebugTable(debugTable)
end
