local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, player, son, ChiselElevator, ElevatorManagerScript, onMoveDown, onMoveUp, onReachTop, onReachBottom
function OnScriptLoaded(level, obj)
  thisObj = obj
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManagerScript = ChiselElevator:FindSingleGOByName("ElevatorManager").LuaObjectScript
  if ElevatorManagerScript ~= nil then
    print("EM Script gucci")
  else
    print("EM Script not gucci")
  end
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
  SoundOnInitGears()
end
function OnStart(level, obj)
  ElevatorManagerScript.AddOnMoveDownCallback(SoundGearsOnStart)
  ElevatorManagerScript.AddOnMoveUpCallback(SoundGearsOnStart)
  ElevatorManagerScript.AddOnReachTopCallback(SoundGearsStop)
  ElevatorManagerScript.AddOnReachBottomCallback(SoundGearsStop)
end
local gearSoundEmitters = {}
local soundEvents = {
  GearStartSound = "SND_MECH_Chisel_Elevator_Gear_Movement_LP"
}
local elevatorObj = {
  Elevator = "PlatAnimNode"
}
function SoundOnInitGears(obj)
  gearSoundEmitters = thisObj.Parent.SoundEmitters
  local tempGearSoundEmitters = gearSoundEmitters
  for i = 1, #gearSoundEmitters do
    if string.find(gearSoundEmitters[i].Name, "SNDGear") == nil then
      table.remove(tempGearSoundEmitters, i)
    end
  end
  gearSoundEmitters = tempGearSoundEmitters
end
function SoundGearsOnStart()
  print("Starting")
  for i = 1, #gearSoundEmitters do
    LD.PlaySound(gearSoundEmitters[i], soundEvents.GearStartSound)
  end
end
function SoundGearsStop()
  for i = 1, #gearSoundEmitters do
    LD.StopSound(gearSoundEmitters[i], soundEvents.GearStartSound)
  end
end
