local thisObj, interactDoor, chiselBreakable, chiselBreakable_Back
local softSaveOnOpen = false
local doesDoorStayOpenAfterUse = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  local doorObjectName = obj:GetLuaTableAttribute("DoorObjectName")
  softSaveOnOpen = obj:FindLuaTableAttribute("Allow_SoftSaveOnOpen")
  doesDoorStayOpenAfterUse = obj:FindLuaTableAttribute("DoesDoorStayOpenAfterUse")
  if softSaveOnOpen == nil then
    softSaveOnOpen = false
  end
  if doesDoorStayOpenAfterUse == nil then
    doesDoorStayOpenAfterUse = false
  end
  interactDoor = obj:FindSingleGOByName(doorObjectName).Child
  chiselBreakable = obj:FindSingleGOByName("chiselBreakableObject")
  if chiselBreakable == nil then
    chiselBreakable = obj:FindSingleGOByName("chiselBreakable_Front")
  end
  chiselBreakable_Back = obj:FindSingleGOByName("chiselBreakable_Back")
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnPreStart(level, obj)
  ResolveSoftSave()
end
function EnableDoor()
  interactDoor.LuaObjectScript.Enable()
end
function DisableDoor()
  interactDoor.LuaObjectScript.Disable()
end
function LockDoor()
  interactDoor.LuaObjectScript.Lock()
end
function UnlockDoor()
  interactDoor.LuaObjectScript.Unlock()
end
function LockMiniGame()
  chiselBreakable.LuaObjectScript.Lock()
  if chiselBreakable_Back ~= nil then
    chiselBreakable_Back.LuaObjectScript.Lock()
  end
end
function UnlockMiniGame()
  chiselBreakable.LuaObjectScript.Unlock()
  if chiselBreakable_Back ~= nil then
    chiselBreakable_Back.LuaObjectScript.Unlock()
  end
end
function EnableCinematicTrigger(useBack)
  if chiselBreakable_Back ~= nil and useBack then
    chiselBreakable_Back.LuaObjectScript.EnableCinematicTrigger()
  else
    chiselBreakable.LuaObjectScript.EnableCinematicTrigger()
  end
end
function DisableCinematicTrigger(useBack)
  if chiselBreakable_Back ~= nil and useBack then
    chiselBreakable_Back.LuaObjectScript.DisableCinematicTrigger()
  else
    chiselBreakable.LuaObjectScript.DisableCinematicTrigger()
  end
end
function ImmediatelyDestroyDoor()
  if chiselBreakable_Back ~= nil then
    chiselBreakable_Back.LuaObjectScript.ImmediatelyDestroyDoor()
  end
  chiselBreakable.LuaObjectScript.ImmediatelyDestroyDoor()
end
function ResolveSoftSave()
  if softSaveOnOpen == true then
    if chiselBreakable_Back ~= nil then
      chiselBreakable_Back.LuaObjectScript.ResolveSoftState()
    end
    chiselBreakable.LuaObjectScript.ResolveSoftState()
    if doesDoorStayOpenAfterUse and chiselBreakable.LuaObjectScript.IsPuzzleSolved() then
      interactDoor.LuaObjectScript.ForceDoorOpen(true)
    end
  end
end
function SoftSave()
  if softSaveOnOpen == true then
    if chiselBreakable_Back ~= nil then
      chiselBreakable_Back.LuaObjectScript.SoftSave()
    end
    chiselBreakable.LuaObjectScript.SoftSave()
  end
end
function DebugDrawCallbacks()
  chiselBreakable.LuaObjectScript.DebugDrawCallbacks()
end
