LD = require("design.LevelDesignLibrary")
thisObj = nil
sonInteract = nil
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(obj)
  sonInteract = thisObj:FindSingleGOByName("genericSonInteract_sonSwitch"):FindSingleGOByName("GenericSonInteract")
  SoundInit()
end
function OnFirstStart(level, obj)
  thisObj:PauseAnim()
end
function Enable()
  LD.CallFunctionAfterDelay(function()
    sonInteract.LuaObjectScript.Enable()
  end, 2)
end
function SwitchPulled()
  thisObj:PlayAnimToEnd()
  soundGatePlaying()
end
local soundEmitter
local soundEvents = {
  GateLoop = "SND_DOOR_Metal_Lift_Gate_Forest_LP",
  GateOpen = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up",
  GateHitEnd = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling",
  EndFrame = -1
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDSonBoostDoorXPL")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for k, v in pairs(soundEvents) do
      for i, j in pairs(sounds) do
        if i == k and j ~= nil and j ~= "" then
          soundEvents[k] = j
        end
      end
      LD.SoundDebug(tostring(k) .. ": " .. tostring(v))
    end
  end
end
function soundGatePlaying()
  LD.PlaySound(soundEmitter, soundEvents.GateOpen)
  LD.PlaySound(soundEmitter, soundEvents.GateLoop)
  if soundEvents.EndFrame > -1 then
    LD.PlaySoundOnFrame(soundEmitter, thisObj, soundEvents.GateHitEnd, soundEvents.EndFrame, "forward")
    LD.StopSoundOnFrame(soundEmitter, thisObj, soundEvents.GateLoop, soundEvents.EndFrame, "forward")
  else
    LD.PlaySoundOnFrame(soundEmitter, thisObj, soundEvents.GateHitEnd, thisObj.AnimLengthFrames, "forward")
    LD.StopSoundOnFrame(soundEmitter, thisObj, soundEvents.GateLoop, thisObj.AnimLengthFrames, "forward")
  end
end
