local LD = require("design.LevelDesignLibrary")
interactZone = nil
local thisObj
local bEnabled = true
local sonInteract = false
local forceSonAvailable = false
local disableAfterUse, interactBanter, requestInteract, cine_useCameraAngle, cine_useCameraAngleValue, allowInteractDuringTraversal
function OnScriptLoaded(level, obj)
  thisObj = obj
  interactZone = LD.CreateInteractZone_Standard_360(obj, "promptJoint")
  interactZone:SetXZRange(GetValidRangeFromInput(obj:FindLuaTableAttribute("HorizontalRange")))
  interactZone:SetYRange(GetValidRangeFromInput(obj:FindLuaTableAttribute("VerticalRange")))
  interactZone:SetAngle(GetValidAngleFromInput(obj:FindLuaTableAttribute("Angle")))
  interactZone:SetHintXZRange(GetValidRangeFromInput(obj:FindLuaTableAttribute("HintHorizontalRange")))
  interactZone:SetHintAngle(GetValidAngleFromInput(obj:FindLuaTableAttribute("HintAngle")))
  interactZone:ClearTags("NotAllowedOnBoat")
  cine_useCameraAngle = obj:FindLuaTableAttribute("cine_useCameraAngle") or false
  cine_useCameraAngleValue = obj:FindLuaTableAttribute("cine_useCameraAngleValue")
  sonInteract = obj:GetLuaTableAttribute("sonInteract")
  disableAfterUse = obj:GetLuaTableAttribute("OneTimeUse")
  interactBanter = obj:FindLuaTableAttribute("interactBanter")
  requestInteract = obj:GetLuaTableAttribute("requestInteract")
  allowInteractDuringTraversal = obj:GetLuaTableAttribute("allowInteractDuringTraversal")
  if allowInteractDuringTraversal == true and interactZone.SetInteractTraversalAllowed then
    interactZone:SetInteractTraversalAllowed(true)
  end
  if sonInteract then
    LD.CreateSonInteractZone(interactZone)
    if not obj:GetLuaTableAttribute("forceSonAvailable") then
      interactZone:SetRequiresSonUnoccupied()
    end
  end
  if cine_useCameraAngle == true then
    interactZone:SetCameraFrontAngleWeight(1)
    interactZone:SetCameraFrontAngle(cine_useCameraAngleValue)
  end
  if interactBanter == "" then
    interactBanter = nil
  end
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  bEnabled = obj:GetLuaTableAttribute("StartEnabled")
end
function OnStart(level, obj)
  if bEnabled == false then
    Disable()
  else
    Enable()
  end
end
function OnInteractStart(level, obj, creature)
  LD.ExtractAndExecuteCallbacksForEvent(level, obj, obj:FindLuaTableAttribute("InteractFunctions"), "Interact Event")
  if interactBanter then
    game.Audio.PlayBanter(interactBanter)
  end
  if disableAfterUse then
    Disable()
  end
end
function OnSonInteractButtonPressed(level, obj)
  if interactZone:PlayerCanInteract() and sonInteract then
    OnInteractStart(level, obj)
  end
end
function OnUseWorld(level, obj)
  if not sonInteract and interactZone:PlayerCanInteract() then
    if requestInteract == true then
      game.Player.FindPlayer():RequestInteract(obj, interactZone)
    else
      OnInteractStart(level, obj)
    end
  end
end
function Enable()
  bEnabled = true
  interactZone:Enable()
end
function Disable()
  bEnabled = false
  interactZone:Disable()
end
function DisablePrompt()
  interactZone:DisablePrompt()
end
function EnablePrompt()
  interactZone:EnablePrompt()
end
function GetInteractZone()
  return interactZone
end
function GetValidRangeFromInput(input)
  if input < 0 then
    print("WARNING: Interact zone range value on obj " .. thisObj:GetName() .. " is less than 0.  Setting to 0...")
    return 0
  end
  if 20 < input then
    print("WARNING: Large interact zone range value on obj: " .. thisObj:GetName())
  end
  return input
end
function GetValidAngleFromInput(input)
  while input < 0 do
    input = input + 360
  end
  while 360 < input do
    input = input - 360
  end
  return input
end
function OnSaveCheckpoint(level, obj)
  return {
    bEnabled = interactZone:IsEnabled()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bEnabled = savedInfo.bEnabled
end
