local lookAtConsts = require("game.lookAtConsts")
local thisObj, player, render, renderIsVisible
_G.thisLookAtEntry = nil
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  _G.thisLookAtEntry = game.AddGlobalLookAtTarget(thisObj, engine.Vector.New(0, 0, 0), lookAtConsts.TargetType.InterestingObject)
  render = thisObj:FindSingleGOByName("render")
  print("render obj... is vis..", render, renderIsVisible)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if render ~= nil then
    if renderIsVisible then
      render:Show()
    else
      render:Hide()
    end
  end
end
function ForcePlayerLookAt()
  print("getting force look at")
  player:ForceLookAtToObject(thisObj)
end
function DisableLookAt()
  player:ClearForcedLookAtToObject()
end
