local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
monitors = require("level.MonitorLibrary")
local player, thisObj, freya, son
miniGameActive = false
exitInProgress = false
local exitCheckInProgress
boarGameWon = nil
local abortedMinigame = false
local exitThresholdTimer, leftHand_ReminderTimer, rightHandReminderTimer, boarAttached, boarHealFailed, leftHandFailed
monitor_R1Button = nil
monitor_R2Button = nil
monitor_L2Button = nil
local leftHandStarted = false
local rightHandStarted = false
local l2TutorialActive, r2TutorialActive, sonReminderPlayed, leftHandReminderPlayed, freyaReminderPlayed
local timeBeforeReminder = 10
local isL2Down = false
local isR1Down = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
  freya = LD.FindFreya()
  print("freya, son ...", freya, son)
  exitThresholdTimer = StartLevelTimer(0.5, TriggerSuccessBanter)
  exitThresholdTimer:Stop()
  leftHand_ReminderTimer = StartLevelTimer(timeBeforeReminder, TriggerHintLine)
  leftHand_ReminderTimer:Stop()
  rightHandReminderTimer = StartLevelTimer(timeBeforeReminder, TriggerRightHandHintLine)
  rightHandReminderTimer:Stop()
  print("Boar Heal: Status", boarHealFailed, leftHandFailed, leftHandStarted, rightHandStarted)
end
function OnStart()
  if freya ~= nil then
    freya = LD.FindFreya()
  end
end
function OnUseWorld(level, obj)
end
function StartMiniGame(data)
  if data == true then
    miniGameActive = true
    player:RequestInteract(thisObj)
  else
    miniGameActive = false
    boarGameWon = true
    L2MonitorEnable(false)
    R2MonitorEnable(false)
  end
end
function RequestNpcMoveEvent(eventName, npc)
  if npc ~= nil then
    npc:TriggerMoveEvent(eventName)
  end
end
function TriggerLHGrab()
  RequestNpcMoveEvent("triggerLH_Grab", player)
end
function ReleaseLHGrab()
  RequestNpcMoveEvent("releaseLH_Grab", player)
end
function TriggerRHGrab()
  RequestNpcMoveEvent("triggerRH_Grab", player)
end
function LuaHook_AnimateDoor()
  GameObjects.FreyaDoor:PlayAnimToEnd()
  GameObjects.FreyaDoor:ShowParticleEmitter()
end
function LuaHook_BoarCineEnterEnding()
  game.Cinematics.DisableCinematicMode()
  leftHand_ReminderTimer:Start()
  game.Audio.PlayBanter("RIV_BoarMini_LeftHold", ShowL2Button)
end
function LuaHook_MinigameIdleActive()
  if leftHandStarted then
    ShowL2Button()
    leftHandStarted = false
  end
end
function LuaHook_LHGrabStarted()
  leftHandStarted = true
  leftHand_ReminderTimer:Stop()
  rightHandReminderTimer:Start()
end
function LuaHook_LHGrab_ExitStarted()
  print("Left hand failedd")
  leftHandFailed = true
  r2TutorialActive = false
  uiCalls.UI_Event_ClearAllDesignerMessages()
end
function LuaHook_LHGrabIdleActive()
  TriggerRHTutorial()
  if not monitor_R2Button then
    CreateR2ButtonMonitor()
  end
end
function LuaHook_RHIdle_Started()
  if not exitCheckInProgress then
    exitThresholdTimer:Start()
    exitCheckInProgress = true
  end
end
function LuaHook_RHGrabStarted()
  rightHandReminderTimer:Stop()
  rightHandStarted = true
end
function LuaHook_RHGrab_ExitStarted()
  rightHandStarted = false
  r2TutorialActive = false
end
function LuaHook_BoarReactStarted()
  exitInProgress = false
  exitCheckInProgress = false
  l2TutorialActive = false
  r2TutorialActive = false
  rightHandStarted = false
  leftHandStarted = false
  if not boarHealFailed then
    game.Audio.PlayBanter("RIV_BoarMini_Fail", ShowL2Button)
  else
    game.Audio.PlayBanter("RIV_BoarMini_BothRemind1", ShowL2Button)
  end
  boarHealFailed = true
  exitThresholdTimer:Stop()
  exitThresholdTimer:Reset()
end
function TriggerSuccessBanter()
  game.Audio.PlayBanter("RIV_BoarMini_Success", TriggerExitStart)
end
function TriggerExitStart()
  exitInProgress = true
  StartMiniGame(false)
  _G.StartLevelTimer(0.1, TriggerFinalAnimsAndExit)
end
function TriggerFinalAnimsAndExit()
  game.Cinematics.EnableCinematicMode()
  RequestNpcMoveEvent("triggerBoarHealExit", player)
end
function AbortMinigame()
  StartMiniGame(false)
  RequestNpcMoveEvent("triggerBoarHealExitOverride", player)
  abortedMinigame = true
  uiCalls.UI_Event_ClearAllDesignerMessages()
end
function TriggerLHTutorial()
  if not abortedMinigame and not l2TutorialActive then
    if not leftHandFailed then
      print("Boar Heal: Playing First time left hand instruct Banter")
      uiCalls.UI_Event_ClearAllDesignerMessages()
      uiCalls.SendSidebarDesignerMessage({
        Text = 40079,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
        Critical = true
      })
    else
      print("Boar Heal: Playing second left hand reminder Banter")
      TriggerHintLine()
      R2MonitorEnable(false)
      uiCalls.UI_Event_ClearAllDesignerMessages()
      uiCalls.SendSidebarDesignerMessage({
        Text = 40079,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
        Critical = true
      })
    end
    l2TutorialActive = true
  end
end
function ShowL2Button()
  TriggerLHTutorial()
  if not monitor_L2Button then
    CreateL2ButtonMonitor()
  else
    L2MonitorEnable(true)
  end
end
function TriggerRHTutorial()
  if not r2TutorialActive then
    R2MonitorEnable(true)
    if not boarHealFailed then
      r2TutorialActive = true
      game.Audio.PlayBanter("RIV_BoarMini_RightHold")
      uiCalls.UI_Event_ClearAllDesignerMessages()
      uiCalls.SendSidebarDesignerMessage({
        Text = 40080,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
        Critical = true
      })
    else
      uiCalls.UI_Event_ClearAllDesignerMessages()
      uiCalls.SendSidebarDesignerMessage({
        Text = 40080,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
        Critical = true
      })
    end
  end
end
function TriggerHintLine()
  if not leftHandReminderPlayed then
    leftHand_ReminderTimer:Reset()
    leftHand_ReminderTimer:Start()
    leftHandReminderPlayed = true
    game.Audio.PlayBanter("RIV_BoarMini_LeftRemind")
  elseif leftHand_ReminderTimer and not sonReminderPlayed then
    game.Audio.PlayBanter("RIV_BoarMini_BothRemind2")
    sonReminderPlayed = true
  end
end
function TriggerRightHandHintLine()
  game.Audio.PlayBanter("RIV_BoarMini_BothRemind1")
end
function CreateL2ButtonMonitor()
  monitor_L2Button = monitors.CreateL2ButtonMonitor()
  monitor_L2Button:OnButtonDown(L2ButtonDown)
  monitor_L2Button:OnButtonUp(L2ButtonUp)
  monitor_R1Button = monitors.CreateR1ButtonMonitor()
  monitor_R1Button:OnButtonDown(R1ButtonDown)
  monitor_R1Button:OnButtonUp(R1ButtonUp)
end
function CreateR2ButtonMonitor()
  monitor_R2Button = monitors.CreateR2ButtonMonitor()
  monitor_R2Button:OnButtonDown(R2ButtonDown)
end
function L2MonitorEnable(value)
  if monitor_L2Button ~= nil then
    if value == false then
      monitor_R1Button:Stop()
      monitor_L2Button:Stop()
      if boarGameWon then
        monitor_R1Button = nil
        monitor_L2Button = nil
      end
    else
      monitor_R1Button:Start()
      monitor_L2Button:Start()
    end
  end
end
function R2MonitorEnable(value)
  if monitor_R2Button ~= nil then
    if value == false then
      monitor_R2Button:Stop()
      if boarGameWon then
        monitor_R2Button = nil
      end
    else
      monitor_R2Button:Start()
    end
  end
end
function L2ButtonDown()
  uiCalls.UI_Event_ClearAllDesignerMessages()
  leftHandStarted = true
  l2TutorialActive = false
  isL2Down = true
  TriggerLHGrab()
end
function L2ButtonUp()
  if isL2Down and not isR1Down then
    ReleaseLHGrab()
  end
  isL2Down = false
end
function R1ButtonDown()
  uiCalls.UI_Event_ClearAllDesignerMessages()
  leftHandStarted = true
  l2TutorialActive = false
  isR1Down = true
  TriggerLHGrab()
end
function R1ButtonUp()
  if isR1Down and not isL2Down then
    ReleaseLHGrab()
  end
  isR1Down = false
end
function R2ButtonDown()
  TriggerRHGrab()
  uiCalls.UI_Event_ClearAllDesignerMessages()
  rightHandStarted = true
end
