LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
uiCalls = require("ui.uicalls")
local collisionCheck = require("camera.collisioncheck")
local TUT = require("game.GlobalTutorials")
local isInView = false
local isInOuterView = false
local isInMidView = false
local currentCamera
local timeBeforeBreathReset = 6
local breathIsHeld = false
local player, banterCooldownTime, banterTimer
local buttonSuccessTime = 2
local buttonPressTime = 0
local breathTimer
local successInProgress = false
local tutorialDisplayed
local gestureIsAllowed = true
local sonGestureIsAllowed = true
local shootTutorialShown = false
miniGameActive = false
boarJoint = nil
boarTarget = nil
boarTargetPos = nil
successDialoguePlaying = nil
distanceToLockOn = nil
deerWiseValue = nil
offset = nil
deerOffset = nil
aimIsValidActive = nil
local son
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  breathTimer = StartLevelTimer(timeBeforeBreathReset, BreathTimedOut)
  breathTimer:Stop()
end
function OnUpdate(level, obj)
  if miniGameActive == true then
    if boarTarget == nil then
      boarTarget = LD.FindSingleAIByMarker("wildboar00")
      if boarTarget == nil then
        GameObjects.Cine_BoarIntro.LuaObjectScript.SpawnMinigameBoar()
      end
    end
    if boarTarget ~= nil then
      boarTargetPos = boarTarget:GetWorldPosition()
    end
    local offset = engine.Vector.New(0, 0.6, 0)
    local boarCombinedOffset = boarTargetPos + offset
    isInOuterView = collisionCheck.isTargetInFrustumUnobstructed(boarCombinedOffset, 0.3, 0, 0.55, true)
    isInMidView = collisionCheck.isTargetInFrustumUnobstructed(boarCombinedOffset, 0.3, 0, 0.7, true)
    isInView = collisionCheck.isTargetInFrustumUnobstructed(boarCombinedOffset, 0.3, 0, 0.85, true)
    if isInView == true and successInProgress == false then
      TargetIsInView()
      isInOuterView = false
      isInMidView = false
    elseif isInOuterView == true and successInProgress == false then
      TargetIsInOuterView()
      isInView = false
      isInMidView = false
    elseif isInMidView and successInProgress == false then
      TargetIsMidView()
      isInOuterView = false
      isInView = false
    end
  end
  if miniGameActive == true and son:IsPlayingMove("MOV_BoarIntroBreathLoop") then
    if isInView ~= true then
      game.Camera.SubmitCameraByName("PLYR_BoarAim_Test_BreathHeld")
      PlayerIsHoldingBreath()
    else
      PlayerIsHoldingBreath()
    end
  end
  if miniGameActive == true and player.Pad.L2Down == false and breathIsHeld == true then
    BreathTimedOut()
  end
  if miniGameActive == true and breathIsHeld == true then
    if isInView == true and successInProgress ~= true then
      uiCalls.UI_Event_Minigame_Hold_Breath_Valid_Target()
      ShowShootTutorialMessage()
      buttonPressTime = math.min(buttonPressTime + player:GetUnitTime(), buttonSuccessTime + 0.01)
      if buttonPressTime >= buttonSuccessTime then
        AimIsValid(true)
      end
    else
      uiCalls.UI_Event_Minigame_Hold_Breath_Invalid_Target()
      if 0 < buttonPressTime then
        buttonPressTime = buttonPressTime - player:GetUnitTime()
        if buttonPressTime < 0 then
          buttonPressTime = 0
        end
      end
    end
  end
end
function OnUseWorld(level, obj)
end
function AimIsValid(data)
  if data == true then
    if not player:PickupIsAcquired("MiniGameAimValid") then
      player:PickupAcquire("MiniGameAimValid")
      aimIsValidActive = true
    end
  elseif data == false and aimIsValidActive then
    if player:PickupIsAcquired("MiniGameAimValid") then
      player:PickupRelinquish("MiniGameAimValid")
    end
    aimIsValidActive = false
  end
end
function UITurnOn()
  print("for bryce!")
  uiCalls.UI_Event_Minigame_Start()
end
function StartMiniGame(data)
  if data == true then
    miniGameActive = true
    ShowSteadyAimTutorialMessage()
    if boarTarget == nil then
      boarTarget = LD.GetSingleAIByMarker("wildboar00")
    end
    UITurnOn()
  else
    miniGameActive = false
    print("shut game +ui off")
    uiCalls.UI_Event_Minigame_End()
  end
end
function ShowSteadyAimTutorialMessage()
  TUT.SteadyAim_Tutorial()
end
function ShowShootTutorialMessage()
  if not shootTutorialShown then
    TUT.FireArrow_Tutorial()
    shootTutorialShown = true
  end
end
function PlayerIsHoldingBreath()
  if not breathIsHeld then
    breathIsHeld = true
    print("Breath is held")
    uiCalls.UI_Event_Minigame_Hold_Breath_Start()
  else
    uiCalls.UI_Event_Minigame_Hold_Breath(buttonPressTime / buttonSuccessTime)
  end
  breathTimer:Start()
end
function BreathTimedOut()
  print("Breath Timed out")
  game.Camera.SubmitCameraByName("PLYR_BoarAim_Test")
  player:TriggerMoveEvent("breathTimeOut")
  buttonPressTime = 0
  breathIsHeld = false
  breathTimer:Reset()
  uiCalls.UI_Event_Minigame_Hold_Breath_End()
  game.Blender.Stop({
    Name = "FFB_LOOP_SMALL"
  })
  game.Blender.Stop({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM"
  })
end
function TargetIsInOuterView()
  AimIsValid(false)
end
function TargetIsMidView()
  AimIsValid(false)
  print("target in Mid view")
end
function TargetIsInView()
  if breathIsHeld then
    game.Blender.Submit("FFB_GENERIC_RUMBLE_MEDIUM")
  end
end
