local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local thisObj, drivenObject
drivenObjectInitIdleAnim = "narForOpeningScene000IntIdle"
drivenObjectEnterCineAnim = "narForOpeningScene010cineEnter"
drivenObjectExitAnim = "narForOpeningScene090CineScene"
local axeSmashIsActive = true
local useStartChop
local hitStage = 0
local hitMax = 6
local tutorialDone, breakableObj1, breakableObj2, breakableObj3, breakableObj4, breakableObjSim_Trunk_Mid, breakableObjSim_Trunk_Mid_skirt, breakableObjSim_Stump, breakableObjSim1, breakableObjSim2, breakableObjSim3, breakableObjSim4
function OnScriptLoaded(level, obj)
  drivenObject = obj
  breakableObj1 = drivenObject:FindSingleGOByName("treeChop_stage1_break").Child:GetBreakable()
  breakableObj2 = drivenObject:FindSingleGOByName("treeChop_stage2_break").Child:GetBreakable()
  breakableObj3 = drivenObject:FindSingleGOByName("treeChop_stage3_break").Child:GetBreakable()
  breakableObj4 = drivenObject:FindSingleGOByName("treeChop_stage4_break").Child:GetBreakable()
  breakableObjSim_Trunk_Mid = drivenObject:FindSingleGOByName("Birch_Cine_Trunk_Mid_1").Child
  breakableObjSim_Trunk_Mid_skirt = breakableObjSim_Trunk_Mid:FindSingleGOByName("mid_trunk_skirt")
  breakableObjSim_Stump = drivenObject:FindSingleGOByName("Birch_Cine_Trunk_Stump_1").Child
  breakableObjSim1 = drivenObject:FindSingleGOByName("treeChop_stage1_sim").Child
  breakableObjSim2 = drivenObject:FindSingleGOByName("treeChop_stage2_sim").Child
  breakableObjSim3 = drivenObject:FindSingleGOByName("treeChop_stage3_sim").Child
  breakableObjSim4 = drivenObject:FindSingleGOByName("treeChop_stage4_sim").Child
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  drivenObject:StartAnim(drivenObjectInitIdleAnim)
end
function LH_OnOpeningCineEnter(level, obj, creature)
  print("Beginning of opening scene enter")
  drivenObject:StartAnimation({
    Animation = drivenObjectEnterCineAnim,
    Tween = 0.2
  })
end
function LuaHook_ShowTutorialMsg()
  print("Beginning of first axe chop idle")
  if not tutorialDone then
    TUT.AxeSwingTutorial()
    tutorialDone = true
  end
end
function LH_OnOpeningHitEnter(level, obj, creature)
  print("Beginning of first axe chop")
  uiCalls.UI_Event_ClearAllDesignerMessages()
end
function LH_OnOpeningHit(level, obj, creature)
  print("First axe chop impact")
  IncrementHitStage()
end
function LH_Onldle02Enter(level, obj, creature)
  print("Beginning of second axe chop idle")
end
function LH_OnLightHitToRageEnter(level, obj, creature)
  print("Beginning of second axe chop")
end
function LH_OnLightHitToRage(level, obj, creature)
  print("Second axe chop impact")
  IncrementHitStage()
end
function LH_Onldle03RageEnter(level, obj, creature)
  print("Beginning of third (or fourth or fifth) axe chop idle")
end
function LH_OnAxeHitRage01Enter(level, obj, creature)
  print("Beginning of third axe chop")
end
function LH_OnAxeHitRage01(level, obj, creature)
  print("Third axe chop impact")
  IncrementHitStage()
end
function LH_OnAxeHitRage02Enter(level, obj, creature)
  print("Beginning of fourth axe chop")
end
function LH_OnAxeHitRage02(level, obj, creature)
  print("Fourth axe chop impact")
  IncrementHitStage()
end
function LH_OnExitStart(level, obj, creature)
  print("Beginning of opening scene exit")
  drivenObject:StartAnimation({
    Animation = drivenObjectExitAnim,
    Tween = 0.2
  })
end
function LH_OnAxeHitFinal(level, obj, creature)
  print("Fifth axe chop impact")
  IncrementHitStage()
end
function IncrementHitStage()
  hitStage = hitStage + 1
  print("incrementing hit stage to " .. tostring(hitStage))
  if hitStage == 1 then
    TriggerFirstBreak()
  elseif hitStage == 2 then
    TriggerSecondBreak()
  elseif hitStage == 3 then
    TriggerThirdBreak()
  elseif hitStage == 4 then
    TriggerForthBreak()
  elseif hitStage == 5 then
    TriggerFifthBreak()
  end
end
function TriggerFirstBreak()
  print("first break triggered")
  breakableObj1:Break()
  breakableObjSim1:Show()
  breakableObjSim1:PlayAnimToEnd()
end
function TriggerSecondBreak()
  print("second break triggered")
  breakableObj2:Break()
  breakableObjSim2:Show()
  breakableObjSim2:PlayAnimToEnd()
end
function TriggerThirdBreak()
  print("third break triggered")
  breakableObj3:Break()
  breakableObjSim1:Hide()
  breakableObjSim2:Hide()
  breakableObjSim3:Show()
  breakableObjSim3:PlayAnimToEnd()
end
function TriggerForthBreak()
  print("fourth break triggered")
  breakableObj4:Break()
  breakableObjSim3:Hide()
  breakableObjSim4:Show()
  breakableObjSim4:PlayAnimToEnd()
end
function TriggerFifthBreak()
  print("fifth break triggered")
  breakableObjSim_Trunk_Mid_skirt:Show()
  breakableObjSim_Trunk_Mid:PlayAnimToEnd()
  breakableObjSim_Stump:PlayAnimToEnd()
  breakableObjSim4:Hide()
end
function OnInteractStart(level, obj, creature)
  drivenObject:StartAnim(drivenObjectInitIdleAnim)
  print("got interact start msg")
end
function OnInteractAbort(level, obj, creature)
  print("got interact Abort msg")
end
function OnInteractFinish(level, obj, creature)
  print("got interact finish msg")
end
function OnInteractDone(level, obj, creature)
  print("got interact done msg")
end
