local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local mpicon = require("ui.mpicon")
local TUT = require("game.GlobalTutorials")
local monitors = require("level.MonitorLibrary")
local skipApproach, interactZone, player, son, thisObj, thisLevel, greetingMonitor
local interactIsGhostVersion = false
local characterIndex = 0
local ambientBanterEnabled, playerInZone
local testZoneCheck = false
local testDialogIndex = 0
local greetingHasPlayed = false
local checkInHasPlayed = false
local readyForTurnIn = false
local questGiverAvailable = false
local exitTriggered = false
local greetingCooldown = 45
local checkInCooldown = 120
local triggerCinematic = false
local includeSon, sonPuppeteer
local banterInProgress = false
local brokQuestInProgress = false
local sindriQuestInProgress = false
local brokGreetingPlayed = false
local sindriGreetingPlayed = false
local armorQuestInProgress = false
local httkGreetingPlayed = false
local sindriQuestParent01, sindriQuestParent02, brokQuestParent01, brokQuestParent02, sindriReturn01, sindriReturn02, brokReturn01, brokReturn02, httkParent, httkReturn
local sindriInteractCheckIn = false
local httkCheckInHasPlayed = false
local sindriNiflheim01, sindriNiflheim02, niflheim
local mistEchoesNeeded = 500
local niflheimCraftConvoPlayed = false
local sindriNiflheim03, sindriReturnNif03, muspelheim
local triggerBrokCinematic = false
local triangleMonitor, trianglePressed
local mpIconCreated = false
local promptJointTEMP
local VendorQuestInterruptQueue = {}
local safetyExitTimer
local safetyExitTimerDelay = 60
local ambientBanterTimer
local ambientBanterDelay = 5
local brokAmbientBanterTimer, sindriStoryTimeMonitor, brokStoryTimeMonitor, goQuestCamera
local failcount = 0
local failMax = 20
local talkIconTable, questIconTable, sonLastPos, warpPos, warpObj, sonDistanceToSync, sonDistanceToAltSync, currentTalkNpc
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  thisObj = obj
  son = game.AI.FindSon()
  interactZone = LD.CreateInteractZone_Standard_90(obj, "promptJointFront")
  LD.OverrideInteractZoneTags(interactZone, "NotWhileSonInteracting", true)
  interactZone:SetPromptJoint("promptJointFront")
  interactZone:SetDebugOffset(0, 0.2, -0.5)
  interactZone:SetHintXZRange(8)
  interactZone:ClearTags("CarryActive")
  interactZone:SetTags("NotInQuestBanter")
  if interactZone.SetUsesSecondaryButton then
    interactZone:SetUsesSecondaryButton(true)
  end
  talkIconTable = {
    normal = "WORLD_INTERACT_TALK",
    unavailable = "WORLD_INTERACT_UNAVAILABLE",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  }
  questIconTable = {
    normal = "WORLD_INTERACT_QUEST",
    unavailable = "WORLD_INTERACT_UNAVAILABLE",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  }
  SetInteractToQuest()
  interactZone:Disable()
  promptJointTEMP = thisObj:FindSingleGOByName("promptJointTEMP")
  if promptJointTEMP then
    promptJointTEMP:Hide()
  end
  greetingMonitor = obj:FindSingleGOByName("QuestZoneEvents")
  characterIndex = thisObj:GetLuaTableAttribute("characterIndex")
  game.SubObject.Sleep(obj)
  safetyExitTimer = timer.StartLevelTimer(safetyExitTimerDelay, TriggerCharacterExit)
  safetyExitTimer:Stop()
  ambientBanterTimer = timer.StartLevelTimer(ambientBanterDelay, CheckForStoryTimeBanter)
  ambientBanterTimer:Stop()
  brokAmbientBanterTimer = timer.StartLevelTimer(ambientBanterDelay, CheckForBrokStoryTimeBanter)
  brokAmbientBanterTimer:Stop()
  local mainQuestModule = obj.Parent.Parent
  goQuestCamera = mainQuestModule:FindSingleGOByName("HuldraBrothersCamera")
end
function QuestStateCheck()
  sindriQuestParent01 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Parent")
  sindriQuestParent02 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_02_Parent")
  sindriReturn01 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_Return")
  sindriReturn02 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_02_Objective_Return")
  brokQuestParent01 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Parent")
  brokQuestParent02 = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Parent")
  brokReturn01 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_Return")
  brokReturn02 = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_Return")
  httkParent = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Parent")
  httkReturn = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Objective_Return")
  sindriNiflheim01 = game.QuestManager.GetQuestState("Quest_Sindri_Niflheim_Parent")
  sindriNiflheim02 = game.QuestManager.GetQuestState("Quest_NiflheimArmorChest")
  sindriNiflheim03 = game.QuestManager.GetQuestState("Quest_Sindri_Niflheim03_Parent")
  sindriReturnNif03 = game.QuestManager.GetQuestState("Quest_Sindri_Niflheim03_Objective_Return")
  niflheim = game.FindLevel("Nid100_Entrance")
  muspelheim = game.FindLevel("Msp100_Base")
  if sindriQuestParent01 == "Active" or sindriQuestParent02 == "Active" or httkParent == "Active" then
    sindriQuestInProgress = true
  else
    sindriQuestInProgress = false
  end
  if VendorQuestInterruptQueue:HasInterrupt(0) then
    armorQuestInProgress = true
  else
    armorQuestInProgress = false
  end
  if brokQuestParent01 == "Active" or brokQuestParent02 == "Active" or httkParent == "Active" then
    brokQuestInProgress = true
  else
    brokQuestInProgress = false
  end
end
function OnFirstStart(level, obj)
  QuestStateCheck()
  InitializeBrokInterruptQuests()
  InitializeSindriInterruptQuests()
end
function OnStart()
  InitializeBrokInterruptQuests()
  InitializeSindriInterruptQuests()
end
function SindriPromptEnableCheck()
  QuestStateCheck()
  if game.Level.GetVariable("CompletedCineNumber") >= 450 and game.Level.GetVariable("CompletedCineNumber") <= 470 then
    DisableInteract()
    return
  end
  if niflheim ~= nil then
    if sindriNiflheim01 ~= "Complete" then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
      return
    elseif sindriNiflheim02 == "Active" then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
      return
    elseif sindriNiflheim03 == "Active" then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
      return
    else
      CheckForStoryTimeBanter()
      return
    end
  end
  if sindriQuestParent01 ~= "Complete" then
    if game.Level.GetVariable("CompletedCineNumber") >= 245 then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
    elseif armorQuestInProgress == true then
      FindAndEnableGreetingVolume()
    else
      CheckForStoryTimeBanter()
    end
  elseif sindriQuestParent01 == "Complete" and sindriQuestParent02 ~= "Complete" then
    if game.Level.GetVariable("CompletedCineNumber") >= 340 then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
    elseif armorQuestInProgress == true then
      FindAndEnableGreetingVolume()
    else
      CheckForStoryTimeBanter()
    end
  elseif brokQuestParent02 == "Complete" and sindriQuestParent02 == "Complete" and httkParent ~= "Complete" then
    if game.Level.GetVariable("CompletedCineNumber") >= 510 then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
    elseif armorQuestInProgress == true then
      FindAndEnableGreetingVolume()
    else
      CheckForStoryTimeBanter()
    end
  elseif armorQuestInProgress == true then
    FindAndEnableGreetingVolume()
  else
    CheckForStoryTimeBanter()
  end
end
function BrokPromptEnableCheck()
  QuestStateCheck()
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    CheckForBrokStoryTimeBanter()
    return
  end
  if brokQuestParent01 ~= "Complete" then
    local xpl400 = game.FindLevel("Xpl400_HuldraMines")
    if xpl400 ~= nil then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
    elseif game.Level.GetVariable("CompletedCineNumber") >= 245 then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
    elseif armorQuestInProgress == true then
      FindAndEnableGreetingVolume()
    else
      CheckForBrokStoryTimeBanter()
    end
  elseif brokQuestParent01 == "Complete" and brokQuestParent02 ~= "Complete" then
    if game.Level.GetVariable("CompletedCineNumber") >= 340 then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
      print("BROK FAILING 4")
    elseif armorQuestInProgress == true then
      FindAndEnableGreetingVolume()
    else
      CheckForBrokStoryTimeBanter()
    end
  elseif brokQuestParent02 == "Complete" and sindriQuestParent02 == "Complete" and httkParent ~= "Complete" then
    if game.Level.GetVariable("CompletedCineNumber") >= 510 then
      FindAndEnableGreetingVolume()
      EnableQuestGiver()
      brokAmbientBanterTimer:Stop()
      print("BROK FAILING 5")
    elseif armorQuestInProgress == true then
      FindAndEnableGreetingVolume()
    else
      CheckForBrokStoryTimeBanter()
    end
  elseif armorQuestInProgress == true then
    FindAndEnableGreetingVolume()
  else
    CheckForBrokStoryTimeBanter()
  end
end
function FindAndEnableGreetingVolume(obj)
  if greetingMonitor == nil then
    greetingMonitor = obj:FindSingleGOByName("QuestZoneEvents")
    greetingMonitor.LuaObjectScript.Enable()
  else
    greetingMonitor.LuaObjectScript.Enable()
  end
end
function CheckIfCanInteract()
  if interactZone:PlayerCanInteract() then
    if ambientBanterEnabled and CheckIfOtherBanterNotPlaying() == false then
      TriggerStoryTimeBanter()
    elseif ambientBanterEnabled and CheckIfOtherBanterNotPlaying() == true then
      print("do nothing")
    else
      player:RequestInteract(thisObj, interactZone)
    end
  end
end
function CheckIfOtherBanterNotPlaying()
  local banterTime = game.Audio.GetTimeSinceBanterPlayed()
  print("TIME SINCE BANTER PLAYED", banterTime)
  if banterTime == 0 then
    return true
  else
    return false
  end
end
function OnInteractStart(level, obj, creature)
  if StartInteraction() then
    EnableCamera()
    player:PickupAcquire("QuestDisableEvades")
    uiCalls.UI_Event_Update_Compass()
    EnableSpeedZone()
    EnableCollision()
    SyncCharacters()
    TriggerInteractStartedEvent()
  end
end
function OnInteractAbort(level, obj, creature)
end
function OnInteractFinish(level, obj, creature)
end
function OnInteractDone(level, obj, creature)
  DisableDummyInteract()
  if includeSon then
    RemoveSonOccupied()
  end
end
function RemoveSonOccupied()
  son:EndInteract()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function ClearSonPuppeteer()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Clear()
    sonPuppeteer:DetachPuppet()
    sonPuppeteer = nil
  end
end
function StartInteraction()
  QuestStateCheck()
  if questGiverAvailable == true then
    if characterIndex == 0 then
      if niflheim ~= nil then
        if sindriNiflheim01 == "Inactive" then
          CheckBriefingDialogueType()
        elseif sindriNiflheim02 == "Active" then
          CheckQuestCompleteDialogueType()
        elseif sindriReturnNif03 == "Active" then
          CheckQuestCompleteDialogueType()
        end
      elseif sindriQuestInProgress == false then
        CheckBriefingDialogueType()
      elseif sindriQuestInProgress == true then
        if sindriInteractCheckIn == false then
          CheckQuestCompleteDialogueType()
        elseif sindriInteractCheckIn == true then
          CheckSindriHTTKCheckIn()
        end
      end
    elseif characterIndex == 1 then
      if brokQuestInProgress == false then
        CheckBriefingDialogueType()
      elseif brokQuestInProgress == true then
        if triggerBrokCinematic == false then
          CheckQuestCompleteDialogueType()
        elseif triggerBrokCinematic == true then
          local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01")
          if questState == "Active" then
            return not CheckBriefingBrok02CineDialogue()
          end
        end
      end
    end
  elseif armorQuestInProgress == true then
    CheckQuestCompleteDialogueType()
  end
  return true
end
function SyncCharacters()
  if son ~= nil and son:IsAvailableInLevel() == true then
    PerformSonInteraction()
    if currentTalkNpc ~= nil and player ~= nil then
      currentTalkNpc:ForceLookAtToObject(player)
      player:ForceLookAtToObject(currentTalkNpc)
    end
  end
  if goQuestCamera == nil then
    LD.PlaySingleSynchMove_KratosObject(thisObj, "syncJoint", "Quest Enter", "BRA_QuestEnter", "", interactZone, true)
  end
  safetyExitTimer:Start()
end
function CheckIfSonInValidRange()
  warpObj = thisObj:FindSingleGOByName("warpPosSon")
  warpPos = warpObj:GetWorldPosition()
  sonLastPos = son:GetWorldPosition()
  local distanceToSyncJoint = sonLastPos:Distance(warpPos)
  local sonCameraPercent = game.Camera.GetViewPenetration(son:GetWorldPosition(), 0, 0)
  if 0.1 < sonCameraPercent then
    SyncSon()
  elseif 8 <= distanceToSyncJoint then
    WarpAndSyncSon()
  else
    SyncSon()
  end
end
function PerformSonInteraction(level, obj)
  includeSon = true
  LD.CallFunctionAfterDelay(CheckIfSonInValidRange, 3)
end
function WarpAndSyncSon()
  DistanceCheck()
  son:Warp(warpObj:GetWorldPosition(), warpObj:GetWorldForward())
  if sonDistanceToSync > sonDistanceToAltSync then
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSonAlt", "syncJointSonAlt", 0.5, true)
  else
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSon", "syncJointSon", 0.5, true)
  end
end
function SyncSon()
  DistanceCheck()
  if sonDistanceToSync > sonDistanceToAltSync then
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSonAlt", "syncJointSonAlt", 0.5, true)
  else
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSon", "syncJointSon", 0.5, true)
  end
end
function DistanceCheck()
  local syncJointSon = thisObj:FindSingleGOByName("syncJointSonObj")
  local syncJointSonAlt = thisObj:FindSingleGOByName("syncJointSonAltObj")
  local syncJointSonPos = syncJointSon:GetWorldPosition()
  local syncJointSonAltPos = syncJointSonAlt:GetWorldPosition()
  sonDistanceToSync = sonLastPos:Distance(syncJointSonPos)
  sonDistanceToAltSync = sonLastPos:Distance(syncJointSonAltPos)
end
function TriggerCharacterExit()
  local shopModule = thisObj.Parent.Parent
  if shopModule ~= nil and shopModule.LuaObjectScript.DisableShopContextAction then
    shopModule.LuaObjectScript.DisableShopContextAction()
  end
  safetyExitTimer:Stop()
  safetyExitTimer:Reset()
  if goQuestCamera == nil then
    player:TriggerMoveEvent("QuestBriefingDone")
  elseif player:GetCurrentInteractObject() == thisObj then
    player:EndInteract()
  end
  if currentTalkNpc ~= nil and player ~= nil then
    currentTalkNpc:ClearForcedLookAtToObject()
    player:ClearForcedLookAtToObject()
  end
  TriggerInteractEndedEvent()
  DisableSpeedZone()
  DisableCollision()
  DisableCamera()
  if sonPuppeteer == nil then
    LD.CallFunctionAfterDelay(ClearSonPuppeteer, 2)
  else
    ClearSonPuppeteer()
  end
  if player:PickupIsAcquired("QuestDisableEvades") then
    player:PickupRelinquish("QuestDisableEvades")
  end
  uiCalls.UI_Event_Update_Compass()
  if son ~= nil then
    son:TriggerMoveEvent("QuestBriefingDone")
  end
end
function ClearSonPuppeteer()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Clear()
    sonPuppeteer:DetachPuppet()
    sonPuppeteer = nil
  end
end
function SetTalkNpc(character)
  if character ~= nil then
    currentTalkNpc = character
    print("CURRENT TALK NPC", currentTalkNpc)
    if characterIndex == 0 then
      SindriPromptEnableCheck()
    elseif characterIndex == 1 then
      BrokPromptEnableCheck()
    end
  end
end
function ClearTalkNPC()
  currentTalkNpc = nil
  DisableInteract()
end
function AttemptToTriggerGreeting()
  print("story Doing attempt")
  if currentTalkNpc ~= nil then
    playerInZone = true
    if son ~= nil and son:IsAvailableInLevel() == false then
      print("son is sick, abort AttemptToTriggerGreeting")
      return
    end
    if triggerCinematic == true then
      print("cinematic trigger is enabled, did someone forget to turn it off? Abort AttemptToTriggerGreeting")
      return
    end
    if CheckIsInteracting() == true then
      print("already in an interaction: abort AttemptToTriggerGreeting")
      return
    end
    if game.Combat.GetCombatStatus() == true then
      print("you are in combat, abort AttemptToTriggerGreeting")
      return
    end
    if player:IsInVehicle() == true then
      print("you are in a boat, abort AttemptToTriggerGreeting")
      return
    end
    local questState = game.QuestManager.GetQuestState("Quest_PeaksPass_Objective830")
    if questState == "Active" then
      print("you're in the henge cine, abort AttemptToTriggerGreeting")
      return
    end
    if characterIndex == 0 then
      SindriPromptEnableCheck()
    elseif characterIndex == 1 then
      BrokPromptEnableCheck()
    end
    if questGiverAvailable == false then
      if armorQuestInProgress then
        if banterInProgress == false then
          CheckInProgressDialogueType()
          return
        else
          return
        end
      else
        print("quest giver is not available: abort AttemptToTriggerGreeting")
        return
      end
    end
    QuestStateCheck()
    if characterIndex == 0 then
      if niflheim ~= nil then
        if sindriNiflheim01 == "Inactive" then
          if sindriGreetingPlayed == false then
            CheckGreetingDialogueType()
          elseif sindriGreetingPlayed == true then
            EnableInteract()
          end
        elseif sindriNiflheim01 == "Active" then
          if checkInHasPlayed == false and banterInProgress == false then
            CheckInProgressDialogueType()
          end
        elseif sindriNiflheim02 == "Active" then
          EnableInteract()
        elseif sindriNiflheim03 == "Active" then
          if checkInHasPlayed == false and banterInProgress == false then
            CheckInProgressDialogueType()
          elseif checkInHasPlayed and readyForTurnIn then
            EnableInteract()
          end
        end
      else
        if sindriQuestInProgress == false then
          if sindriGreetingPlayed == false then
            CheckGreetingDialogueType()
          elseif sindriGreetingPlayed == true then
            EnableInteract()
            return
          end
        elseif sindriQuestInProgress == true then
          if checkInHasPlayed == false and banterInProgress == false then
            CheckInProgressDialogueType()
          elseif checkInHasPlayed and readyForTurnIn then
            EnableInteract()
            return
          end
        end
        if armorQuestInProgress and banterInProgress == false then
          CheckInProgressDialogueType()
        end
      end
    elseif characterIndex == 1 then
      if muspelheim ~= nil then
        CheckForBrokStoryTimeBanter()
        return
      end
      if brokQuestInProgress == false then
        if brokGreetingPlayed == false and banterInProgress == false then
          CheckGreetingDialogueType()
        elseif brokGreetingPlayed == true then
          EnableInteract()
          return
        end
      elseif brokQuestInProgress == true then
        if checkInHasPlayed == false and banterInProgress == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed and readyForTurnIn then
          ambientBanterEnabled = false
          EnableInteract()
          return
        elseif checkInHasPlayed and readyForTurnIn == false and banterInProgress == false then
          local questStateBrokCine = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01")
          local questStateBrokReturn = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_Return")
          if questStateBrokCine == "Active" and thisLevel == game.FindLevel("Xpl475_HuldraMinesLH") then
            EnableInteract()
            GameObjects.Smallshop.LuaObjectScript.DisableVendorInteract()
            return
          end
          if questStateBrokReturn == "Active" and thisLevel == game.FindLevel("Xpl425_HuldraMinesLH") then
            ambientBanterEnabled = false
            EnableInteract()
            return
          end
        end
      end
      if armorQuestInProgress and banterInProgress == false then
        CheckInProgressDialogueType()
      end
    end
  end
end
function CheckIsInteracting()
  return player:IsInteracting() or son ~= nil and son:IsInteracting()
end
function CheckGreetingDialogueType()
  if banterInProgress == false then
    QuestStateCheck()
    if characterIndex == 0 then
      if niflheim ~= nil then
        if sindriNiflheim01 == "Inactive" then
          EnableInteract()
          sindriGreetingPlayed = true
          TriggerGreetingStartedEvent()
          if game.Audio.CanBanterConversationPlay("Nifl_QuestGreeting") then
            game.Audio.PlayBanterNonCritical("Nifl_QuestGreeting", GreetingTriggered)
          else
            GreetingTriggered()
          end
        end
      elseif sindriQuestParent01 == "Inactive" then
        EnableInteract()
        sindriGreetingPlayed = true
        TriggerGreetingStartedEvent()
        if game.Audio.CanBanterConversationPlay("Sindri_Global_Greetings01") then
          game.Audio.PlayBanterNonCritical("Sindri_Global_Greetings01", GreetingTriggered)
        else
          GreetingTriggered()
        end
      elseif sindriQuestParent02 == "Inactive" and sindriQuestParent01 == "Complete" then
        EnableInteract()
        sindriGreetingPlayed = true
        TriggerGreetingStartedEvent()
        if game.Audio.CanBanterConversationPlay("Sindri_Global_Greetings02") then
          game.Audio.PlayBanterNonCritical("Sindri_Global_Greetings02", GreetingTriggered)
        else
          GreetingTriggered()
        end
      elseif httkParent == "Inactive" and sindriQuestParent02 == "Complete" and brokQuestParent02 == "Complete" and httkGreetingPlayed == false then
        TriggerGreetingStartedEvent()
        if game.Audio.CanBanterConversationPlay("Sindri_Global_Greetings03") then
          game.Audio.PlayBanterNonCritical("Sindri_Global_Greetings03", HTTKGreetingTriggered)
        else
          HTTKGreetingTriggered()
        end
      end
    elseif characterIndex == 1 then
      if brokQuestParent01 == "Inactive" then
        EnableInteract()
        brokGreetingPlayed = true
        TriggerGreetingStartedEvent()
        if game.Audio.CanBanterConversationPlay("Brok_Global_Greetings01") then
          game.Audio.PlayBanterNonCritical("Brok_Global_Greetings01", GreetingTriggered)
        else
          GreetingTriggered()
        end
      elseif brokQuestParent02 == "Inactive" and brokQuestParent01 == "Complete" then
        EnableInteract()
        brokGreetingPlayed = true
        TriggerGreetingStartedEvent()
        if game.Audio.CanBanterConversationPlay("Brok_Global_Greetings02") then
          game.Audio.PlayBanterNonCritical("Brok_Global_Greetings02", GreetingTriggered)
        else
          GreetingTriggered()
        end
      elseif httkParent == "Inactive" and brokQuestParent02 == "Complete" and sindriQuestParent02 == "Complete" then
        if LD.GetEntityVariable("QST_InLargeShop") == true then
          EnableInteract()
          brokGreetingPlayed = true
          TriggerGreetingStartedEvent()
          if game.Audio.CanBanterConversationPlay("Brok_Global_Greetings03") then
            game.Audio.PlayBanterNonCritical("Brok_Global_Greetings03", GreetingTriggered)
          else
            GreetingTriggered()
          end
        elseif httkGreetingPlayed == false then
          TriggerGreetingStartedEvent()
          if game.Audio.CanBanterConversationPlay("Brok_Global_Roaming_Briefings03") then
            game.Audio.PlayBanterNonCritical("Brok_Global_Roaming_Briefings03", HTTKGreetingTriggered)
          else
            HTTKGreetingTriggered()
          end
        end
      end
    end
  end
end
function CheckBriefingDialogueType()
  TriggerBriefingStartedEvent()
  banterInProgress = true
  QuestStateCheck()
  DisableInteract()
  if characterIndex == 0 then
    if niflheim ~= nil then
      if sindriNiflheim01 == "Inactive" then
        game.Audio.PlayBanter("Nifl_QuestBriefing", BriefingTriggered)
      end
    elseif sindriQuestParent01 == "Inactive" then
      game.Audio.PlayBanter("Sindri_Global_Briefings01", BriefingTriggered)
    elseif sindriQuestParent02 == "Inactive" and sindriQuestParent01 == "Complete" then
      game.Audio.PlayBanter("Sindri_Global_Briefings02", BriefingTriggered)
    elseif VendorQuestInterruptQueue:HasInterrupt(0) then
      VendorQuestInterruptQueue:GetCurrent(0):CheckQuestCompleteDialogueType()
    end
  elseif characterIndex == 1 then
    if brokQuestParent01 == "Inactive" then
      game.Audio.PlayBanter("Brok_Global_Briefings01", BriefingTriggered)
    elseif brokQuestParent02 == "Inactive" and brokQuestParent01 == "Complete" then
      game.Audio.PlayBanter("Brok_Global_Briefings02", BriefingTriggered)
    elseif httkParent == "Inactive" and brokQuestParent02 == "Complete" and sindriQuestParent02 == "Complete" then
      game.Audio.PlayBanter("Brok_Global_Briefings03", BriefingTriggered)
      local httkVisited = game.Level.GetVariable("QST_HTTKVisited")
      if httkVisited then
        game.Audio.SetBanterFact("AlreadyBeenToHTTK", "True")
      end
    elseif VendorQuestInterruptQueue:HasInterrupt(1) then
      VendorQuestInterruptQueue:GetCurrent(1):CheckQuestCompleteDialogueType()
    end
  end
end
function CheckContinuedBriefing()
  if player:InsideZone(thisObj) then
    QuestStateCheck()
    banterInProgress = true
    if characterIndex == 0 then
      if niflheim ~= nil then
        if sindriNiflheim01 ~= "Complete" then
          game.Audio.PlayBanter("Nifl_QuestBriefing_Contd", NifBriefingContdTriggered)
        else
          BriefingContdTriggered()
        end
      elseif niflheim == nil then
        if sindriQuestParent01 ~= "Complete" then
          game.Audio.PlayBanter("Sindri_Global_Briefing_Contd01", BriefingContdTriggered)
        elseif sindriQuestParent01 == "Complete" and sindriQuestParent02 ~= "Complete" then
          game.Audio.PlayBanter("Sindri_Global_Briefing_Contd02", BriefingContdTriggered)
        end
      else
        BriefingContdTriggered()
      end
    elseif characterIndex == 1 then
      if brokQuestParent01 ~= "Complete" then
        local xpl400 = game.FindLevel("Xpl400_HuldraMines")
        if xpl400 ~= nil then
          game.Audio.PlayBanter("Brok_Global_Briefing_Contd01", BriefingContdTriggered)
        else
          BriefingContdTriggered()
        end
      elseif brokQuestParent02 ~= "Complete" and brokQuestParent01 == "Complete" then
        game.Audio.PlayBanter("Brok_Global_Briefing_Contd02", BriefingContdTriggered)
      elseif brokQuestParent02 == "Complete" and httkParent == "Active" then
        game.Audio.PlayBanter("Brok_Global_Briefing_Contd03", BriefingContdTriggered)
      else
        BriefingContdTriggered()
      end
    end
  end
end
function CheckInProgressDialogueType()
  QuestStateCheck()
  if characterIndex == 0 then
    if niflheim ~= nil then
      if sindriNiflheim01 ~= "Complete" then
        local mistEchoes = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
        if mistEchoes < mistEchoesNeeded then
          TriggerCheckInStartedEvent()
          if game.Audio.CanBanterConversationPlay("Nifl_CheckIn") then
            game.Audio.PlayBanterNonCritical("Nifl_CheckIn", CheckInTriggered)
          else
            CheckInTriggered()
          end
        elseif mistEchoes >= mistEchoesNeeded then
          TriggerCheckInStartedEvent()
          local mistEchoQuest = game.QuestManager.GetQuestState("Quest_Sindri_Niflheim_Objective01a")
          if mistEchoQuest == "Active" then
            game.QuestManager.ProposeQuestState("Quest_Sindri_Niflheim_Objective01a", "Complete")
            game.Wallets.AddRecipe("HERO", "Recipe_EntryStoneNiflheim")
            game.World.StoreCheckpoint()
          end
          if game.Audio.CanBanterConversationPlay("Nifl_CheckInComplete") then
            game.Audio.PlayBanterNonCritical("Nifl_CheckInComplete", Nif01CheckInCompleteTriggered)
          else
            Nif01CheckInCompleteTriggered()
          end
        end
      elseif sindriNiflheim03 == "Active" then
        if sindriReturnNif03 ~= "Active" then
          TriggerCheckInStartedEvent()
          if game.Audio.CanBanterConversationPlay("Nifl_CheckIn03") then
            game.Audio.PlayBanterNonCritical("Nifl_CheckIn03", CheckInTriggered)
          else
            CheckInTriggered()
          end
        elseif sindriReturnNif03 == "Active" then
          EnableInteract()
          readyForTurnIn = true
          checkInHasPlayed = true
          TriggerCheckInStartedEvent()
          if game.Audio.CanBanterConversationPlay("Nifl_CheckInComplete03") then
            game.Audio.PlayBanterNonCritical("Nifl_CheckInComplete03", CheckInCompleteTriggered)
          else
            CheckInCompleteTriggered()
          end
        end
      end
    elseif sindriReturn01 == "Active" then
      EnableInteract()
      readyForTurnIn = true
      checkInHasPlayed = true
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Sindri_Global_Checkin_Complete01") then
        game.Audio.PlayBanterNonCritical("Sindri_Global_Checkin_Complete01", CheckInCompleteTriggered)
      else
        CheckInCompleteTriggered()
      end
    elseif sindriReturn02 == "Active" then
      EnableInteract()
      readyForTurnIn = true
      checkInHasPlayed = true
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Sindri_Global_Checkin_Complete02") then
        game.Audio.PlayBanterNonCritical("Sindri_Global_Checkin_Complete02", CheckInCompleteTriggered)
      else
        CheckInCompleteTriggered()
      end
    elseif httkReturn == "Active" then
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Sindri_Global_Checkin_Complete03") then
        game.Audio.PlayBanterNonCritical("Sindri_Global_Checkin_Complete03", CheckInTriggered)
      else
        CheckInTriggered()
      end
    elseif VendorQuestInterruptQueue:HasInterrupt(0) then
      TriggerCheckInStartedEvent()
      VendorQuestInterruptQueue:GetCurrent(0):CheckInProgressDialogueType()
    elseif sindriQuestParent01 == "Active" and sindriReturn01 == "Inactive" then
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Sindri_Global_Checkin01") then
        game.Audio.PlayBanterNonCritical("Sindri_Global_Checkin01", CheckInTriggered)
      else
        CheckInTriggered()
      end
    elseif sindriQuestParent02 == "Active" and sindriReturn02 == "Inactive" then
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Sindri_Global_Checkin02") then
        game.Audio.PlayBanterNonCritical("Sindri_Global_Checkin02", CheckInTriggered)
      else
        CheckInTriggered()
      end
    elseif httkParent == "Active" and httkReturn == "Inactive" then
      local xplHTTK = game.FindLevel("Xpl100_HTTK")
      if xplHTTK ~= nil and httkCheckInHasPlayed == false then
        EnableInteract()
        TriggerCheckInStartedEvent()
        if game.Audio.CanBanterConversationPlay("Sindri_HTTK_Checkin03") then
          game.Audio.PlayBanterNonCritical("Sindri_HTTK_Checkin03", SindriHTTKCheckInTriggered)
        else
          SindriHTTKCheckInTriggered()
        end
        sindriInteractCheckIn = true
        httkCheckInHasPlayed = true
      elseif xplHTTK ~= nil and httkCheckInHasPlayed == true then
        TriggerCheckInStartedEvent()
        if game.Audio.CanBanterConversationPlay("Sindri_HTTK_Checkin03_Repeat") then
          game.Audio.PlayBanterNonCritical("Sindri_HTTK_Checkin03_Repeat", CheckInTriggered)
        else
          CheckInTriggered()
        end
      else
        TriggerCheckInStartedEvent()
        if game.Audio.CanBanterConversationPlay("Sindri_Global_Checkin03") then
          game.Audio.PlayBanterNonCritical("Sindri_Global_Checkin03", CheckInTriggered)
        else
          CheckInTriggered()
        end
      end
    end
  elseif characterIndex == 1 then
    local questStateBrokCine = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01")
    if questStateBrokCine == "Active" and thisLevel == game.FindLevel("Xpl475_HuldraMinesLH") then
      EnableInteract()
      TriggerCheckInStartedEvent()
      game.Interact.DisableTags("NotInQuestBanter")
      game.Audio.PlayBanter("Brok_02Cine_Checkin", BrokCineCheckInTriggered)
      GameObjects.Smallshop.LuaObjectScript.DisableVendorInteract()
    elseif brokReturn01 == "Active" then
      EnableInteract()
      readyForTurnIn = true
      checkInHasPlayed = true
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Brok_Global_Checkin_Complete01") then
        game.Audio.PlayBanterNonCritical("Brok_Global_Checkin_Complete01", CheckInCompleteTriggered)
      else
        CheckInCompleteTriggered()
      end
    elseif brokReturn02 == "Active" then
      EnableInteract()
      readyForTurnIn = true
      checkInHasPlayed = true
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Brok_Global_Checkin_Complete02") then
        game.Audio.PlayBanterNonCritical("Brok_Global_Checkin_Complete02", CheckInCompleteTriggered)
      else
        CheckInCompleteTriggered()
      end
    elseif httkReturn == "Active" then
      if LD.GetEntityVariable("QST_InLargeShop") == true then
        EnableInteract()
        readyForTurnIn = true
        checkInHasPlayed = true
        TriggerCheckInStartedEvent()
        if game.Audio.CanBanterConversationPlay("Brok_Global_CheckIn_Complete03") then
          game.Audio.PlayBanterNonCritical("Brok_Global_CheckIn_Complete03", CheckInCompleteTriggered)
        else
          CheckInCompleteTriggered()
        end
      elseif LD.GetEntityVariable("QST_InLargeShop") == false then
        TriggerCheckInStartedEvent()
        if game.Audio.CanBanterConversationPlay("Brok_Global_Roaming_CheckIn_Complete03") then
          game.Audio.PlayBanterNonCritical("Brok_Global_Roaming_CheckIn_Complete03", CheckInTriggered)
        else
          CheckInTriggered()
        end
      end
    elseif VendorQuestInterruptQueue:HasInterrupt(1) then
      TriggerCheckInStartedEvent()
      VendorQuestInterruptQueue:GetCurrent(1):CheckInProgressDialogueType()
    elseif brokQuestParent01 == "Active" and brokReturn01 == "Inactive" then
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Brok_Global_Checkin01") then
        game.Audio.PlayBanterNonCritical("Brok_Global_Checkin01", CheckInTriggered)
      else
        CheckInTriggered()
      end
    elseif brokQuestParent02 == "Active" and brokReturn02 == "Inactive" then
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Brok_Global_Checkin02") then
        game.Audio.PlayBanterNonCritical("Brok_Global_Checkin02", CheckInTriggered)
      else
        CheckInTriggered()
      end
      CheckForBrokStoryTimeBanter()
    elseif httkParent == "Active" and httkReturn == "Inactive" then
      TriggerCheckInStartedEvent()
      if game.Audio.CanBanterConversationPlay("Brok_Global_Checkin03") then
        game.Audio.PlayBanterNonCritical("Brok_Global_Checkin03", CheckInTriggered)
      else
        CheckInTriggered()
      end
    end
  end
end
function CheckBriefingBrok02CineDialogue()
  TriggerBriefingStartedEventBrok02Cine()
  if characterIndex == 1 then
    player:AbortInteract()
    GameObjects.Cine_BrokQuest2.LuaObjectScript:SetupSeq()
    return true
  end
  return false
end
function CheckQuestCompleteDialogueType()
  DisableInteract()
  QuestStateCheck()
  banterInProgress = true
  TriggerCompleteStartedEvent()
  if characterIndex == 0 then
    if niflheim ~= nil then
      if sindriNiflheim02 == "Active" then
        game.Audio.PlayBanter("Sindri_Global_Nif_Armor_Complete", CompleteQuests)
      elseif sindriReturnNif03 == "Active" then
        game.Audio.PlayBanter("Nif_TurnIn03", CompleteQuests)
      end
    elseif sindriReturn01 == "Active" then
      game.Audio.PlayBanter("Sindri_Global_Complete01", CompleteQuests)
    elseif sindriQuestParent02 == "Active" and sindriReturn02 == "Active" then
      game.Audio.PlayBanter("Sindri_Global_Complete02", CompleteQuests)
    elseif VendorQuestInterruptQueue:HasInterrupt(0) then
      VendorQuestInterruptQueue:GetCurrent(0):CheckQuestCompleteDialogueType()
    end
  elseif characterIndex == 1 then
    if brokReturn01 == "Active" then
      game.Audio.PlayBanter("Brok_Global_Complete01", Brok01CompleteBranchingVO)
    elseif brokQuestParent02 == "Active" and brokReturn02 == "Active" then
      game.Audio.PlayBanter("Brok_Global_Complete02", CompleteQuests)
      local hammer = game.Wallets.GetResourceValue("HERO", "AndvarisHammer")
      if hammer == 1 then
        game.Wallets.RemoveResource("HERO", "AndvarisHammer", 1)
      end
    elseif httkParent == "Active" and httkReturn == "Active" then
      game.Audio.PlayBanter("Brok_Global_Complete03", CompleteQuests)
    elseif VendorQuestInterruptQueue:HasInterrupt(1) then
      VendorQuestInterruptQueue:GetCurrent(1):CheckQuestCompleteDialogueType()
    end
  end
end
function Brok01CompleteBranchingVO()
  local runeRead = game.Wallets.GetResourceValue("HERO", "Xpl450_InnMenn")
  if runeRead == 1 then
    game.Audio.PlayBanter("Brok_Global_Complete01_RuneRead", CompleteQuests)
  else
    game.Audio.PlayBanter("Brok_Global_Complete01_NoRead", CompleteQuests)
  end
end
function CheckCompleteContinued()
  DisableInteract()
  QuestStateCheck()
  banterInProgress = true
  if characterIndex == 0 then
    if sindriQuestParent01 == "Complete" and sindriQuestParent02 == "Inactive" then
      game.Audio.PlayBanter("Sindri_Global_Complete01_Contd", CompleteContinuedTriggered)
      game.Audio.StartMusic("SND_MX_XPL850_quest_complete")
    elseif sindriQuestParent02 == "Complete" then
      game.Audio.PlayBanter("Sindri_Global_Complete02_Contd", CompleteContinuedTriggered)
    else
      CompleteContinuedTriggered()
    end
  elseif characterIndex == 1 then
    if brokQuestParent01 == "Complete" and brokQuestParent02 == "Inactive" then
      game.Audio.PlayBanter("Brok_Global_Complete01_Contd", CompleteContinuedTriggered)
    elseif brokQuestParent02 == "Complete" and httkParent == "Inactive" then
      game.Audio.PlayBanter("Brok_Global_Complete02_Contd", CompleteContinuedTriggered)
      game.Audio.StartMusic("SND_MX_XPL450_quest_complete")
    else
      CompleteContinuedTriggered()
    end
  end
end
function GreetingTriggered()
  banterInProgress = false
  TriggerGreetingGivenEvent()
  game.Interact.EnableTags("NotInQuestBanter")
  LD.CallFunctionAfterDelay(RestartGreetingCheck, greetingCooldown)
  if characterIndex == 0 then
    sindriGreetingPlayed = true
  elseif characterIndex == 1 then
    brokGreetingPlayed = true
  end
end
function HTTKGreetingTriggered()
  TriggerGreetingGivenEvent()
  if characterIndex == 0 then
    httkGreetingPlayed = true
    LD.CallFunctionAfterDelay(function()
      banterInProgress = false
      httkGreetingPlayed = false
    end, greetingCooldown)
  elseif characterIndex == 1 then
    httkGreetingPlayed = true
    LD.CallFunctionAfterDelay(function()
      banterInProgress = false
      httkGreetingPlayed = false
    end, greetingCooldown)
  end
end
function BriefingTriggered()
  TriggerBriefingGivenEvent()
  QuestStateCheck()
  banterInProgress = false
  checkInHasPlayed = true
  LD.CallFunctionAfterDelay(TriggerCharacterExit, 0.5)
  LD.CallFunctionAfterDelay(CheckContinuedBriefing, 5)
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
  LD.CallFunctionAfterDelay(Checkpoint, 1)
  if characterIndex == 0 then
    if niflheim ~= nil then
      if sindriNiflheim01 == "Inactive" then
        game.QuestManager.StartQuest("Quest_Sindri_Niflheim_Parent")
      end
    elseif sindriQuestParent01 == "Inactive" then
      game.QuestManager.StartQuest("Quest_Sindri_Epic_01_Parent")
      game.Audio.SetBanterFact("FafnirCaveCheck", "true")
      game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneForestDungeon", 1, nil, "Quest")
      LD.AddRecipe_Safe("HERO_SAVEONLY", "EntryStoneForestDungeon_Unlock")
    elseif sindriQuestParent02 == "Inactive" and sindriQuestParent01 == "Complete" then
      game.QuestManager.StartQuest("Quest_Sindri_Epic_02_Parent")
      game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra3", 1, nil, "Quest")
      LD.AddRecipe_Safe("HERO_SAVEONLY", "EntryStoneHuldra3_Unlock")
    end
  elseif characterIndex == 1 then
    if brokQuestParent01 == "Inactive" then
      game.QuestManager.StartQuest("Quest_Brok_Epic_01_Parent")
      print("why is this firing")
      game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneVolundr", 1, nil, "Quest")
      LD.AddRecipe_Safe("HERO_SAVEONLY", "EntryStoneVolundr_Unlock")
    elseif brokQuestParent01 == "Complete" and brokQuestParent02 == "Inactive" then
      game.QuestManager.StartQuest("Quest_Brok_Epic_02_Parent")
    elseif brokQuestParent02 == "Complete" and httkParent == "Inactive" then
      game.QuestManager.StartQuest("Quest_Brothers_Epic_03_Parent")
      game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHTTK_LH", 1, nil, "Quest")
      LD.AddRecipe_Safe("HERO_SAVEONLY", "EntryStoneHTTK_LH_Unlock")
      LD.SetRecentlyActivatedQuest("Quest_Brothers_Epic_03_Objective_01")
    end
  end
end
function BriefingContdTriggered()
  checkInHasPlayed = false
  banterInProgress = false
  if playerInZone == true then
    LD.CallFunctionAfterDelay(AttemptToTriggerGreeting, 1)
  end
end
function NifBriefingContdTriggered()
  checkInHasPlayed = false
  banterInProgress = false
  if playerInZone == true then
    local mistEchoes = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
    if mistEchoes >= mistEchoesNeeded then
      LD.CallFunctionAfterDelay(CheckInProgressDialogueType, 1)
    else
      LD.CallFunctionAfterDelay(AttemptToTriggerGreeting, 1)
    end
  end
end
function SindriHTTKBriefingPlayed()
  checkInHasPlayed = true
  banterInProgress = false
  LD.CallFunctionAfterDelay(TriggerCharacterExit, 0.5)
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function CheckInTriggered()
  if characterIndex == 0 then
    CheckForStoryTimeBanter()
  elseif characterIndex == 1 then
    CheckForBrokStoryTimeBanter()
  end
  banterInProgress = false
  checkInHasPlayed = true
  TriggerCheckInGivenEvent()
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function CheckInCompleteTriggered()
  banterInProgress = false
  checkInHasPlayed = true
  readyForTurnIn = true
  ambientBanterEnabled = false
  SetInteractToQuest()
  TriggerCheckInGivenEvent()
  game.Interact.EnableTags("NotInQuestBanter")
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function BrokCineCheckInTriggered()
  game.Interact.EnableTags("NotInQuestBanter")
  triggerBrokCinematic = true
  banterInProgress = false
  checkInHasPlayed = true
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function SindriHTTKCheckInTriggered()
  game.Interact.EnableTags("NotInQuestBanter")
  checkInHasPlayed = true
  banterInProgress = false
  sindriInteractCheckIn = true
  TriggerCheckInGivenEvent()
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function CheckSindriHTTKCheckIn()
  DisableInteract()
  TriggerBriefingStartedEvent()
  sindriInteractCheckIn = false
  banterInProgress = true
  game.Audio.PlayBanter("Sindri_HTTK_Checkin03_Interact", SindriHTTKBriefingPlayed)
end
function Nif01CheckInCompleteTriggered(level, obj)
  banterInProgress = false
  checkInHasPlayed = true
  TriggerCheckInGivenEvent()
  if niflheimCraftConvoPlayed == false then
    game.Audio.PlayBanter("Nifl_CheckInComplete_Contd")
    niflheimCraftConvoPlayed = true
  end
  LD.CallFunctionAfterDelay(RestartCheckInCheck, 3)
end
function CompleteQuests()
  readyForTurnIn = false
  banterInProgress = false
  questGiverAvailable = false
  QuestStateCheck()
  TriggerCompleteGivenEvent()
  LD.CallFunctionAfterDelay(Checkpoint, 1)
  LD.CallFunctionAfterDelay(TriggerCharacterExit, 0.5)
  if characterIndex == 0 then
    sindriQuestInProgress = false
    if niflheim ~= nil then
      if sindriNiflheim02 == "Active" then
        LD.CompleteQuest("Quest_NiflheimArmorChest")
        game.Audio.SetBanterFact("NifArmorCrafted", "True")
        LD.ActivateQuest("Quest_Sindri_Niflheim03_Parent")
      elseif sindriReturnNif03 == "Active" then
        LD.CompleteQuest("Quest_Sindri_Niflheim03_Objective_Return")
      end
    elseif sindriReturn01 == "Active" then
      game.QuestManager.ProposeQuestState("Quest_Sindri_Epic_01_Objective_Return", "Complete")
      LD.CallFunctionAfterDelay(CheckCompleteContinued, 5)
    elseif sindriReturn02 == "Active" then
      game.QuestManager.ProposeQuestState("Quest_Sindri_Epic_02_Objective_Return", "Complete")
      game.Audio.StartMusic("SND_MX_XPL300_quest_complete")
      LD.CallFunctionAfterDelay(CheckCompleteContinued, 5)
    elseif VendorQuestInterruptQueue:HasInterrupt(0) then
      VendorQuestInterruptQueue:GetCurrent(0):CompleteQuests()
      VendorQuestInterruptQueue:FinishCurrent(0)
    end
  elseif characterIndex == 1 then
    brokQuestInProgress = false
    if brokReturn01 == "Active" then
      game.QuestManager.ProposeQuestState("Quest_Brok_Epic_01_Objective_Return", "Complete")
      LD.CallFunctionAfterDelay(CheckCompleteContinued, 5)
    elseif brokReturn02 == "Active" then
      game.QuestManager.ProposeQuestState("Quest_Brok_Epic_02_Objective_Return", "Complete")
      LD.UnlockBestiaryEntry("Bestiary_Unlock_Andvari")
      LD.CallFunctionAfterDelay(CheckCompleteContinued, 5)
    elseif httkParent == "Active" and httkReturn == "Active" then
      game.QuestManager.ProposeQuestState("Quest_Brothers_Epic_03_Objective_Return", "Complete")
      LD.CallFunctionAfterDelay(CheckCompleteContinued, 5)
      print("Trophy Awarded: Like Oil and Water")
      game.UnlockTrophy(23)
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_HuldraBrokSet_Tier06")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_HuldraBrokSet_Tier06")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_HuldraBrokSet_Tier06")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_HuldraSindriSet_Tier06")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_HuldraSindriSet_Tier06")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_HuldraSindriSet_Tier06")
      if game.GetNewGamePlus() then
        game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_HuldraBrokSet_Tier06_NGP")
        game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_HuldraBrokSet_Tier06_NGP")
        game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_HuldraBrokSet_Tier06_NGP")
        game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_HuldraSindriSet_Tier06_NGP")
        game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_HuldraSindriSet_Tier06_NGP")
        game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_HuldraSindriSet_Tier06_NGP")
      end
    elseif VendorQuestInterruptQueue:HasInterrupt(1) then
      VendorQuestInterruptQueue:GetCurrent(1):CompleteQuests()
      VendorQuestInterruptQueue:FinishCurrent(1)
    end
  end
end
function CompleteContinuedTriggered()
  banterInProgress = false
  checkInHasPlayed = false
  if playerInZone == true then
    LD.CallFunctionAfterDelay(AttemptToTriggerGreeting, 1)
  end
end
function InitializeBrokInterruptQuests()
  local tyrArmorArgs = {
    characterIndex = 1,
    interruptName = "TyrArmor",
    greetingBanter = "Brok_Global_SideArmor_Greeting",
    completeBanter = "Brok_TyrArmor_Complete",
    questName = "Quest_TyrArmor"
  }
  local tyrInterrupt = VendorQuestInterrupt:New(tyrArmorArgs)
  VendorQuestInterruptQueue:AddInterrupt(tyrInterrupt)
  local travelerArmorArgs = {
    characterIndex = 1,
    interruptName = "TravelerArmor",
    greetingBanter = "Brok_Global_SideArmor_Greeting",
    completeBanter = "Brok_TravelerArmor_Complete",
    questName = "Quest_TravelerArmor"
  }
  local travelerInterrupt = VendorQuestInterrupt:New(travelerArmorArgs)
  VendorQuestInterruptQueue:AddInterrupt(travelerInterrupt)
  local golemArmorArgs = {
    characterIndex = 1,
    interruptName = "GolemArmor",
    greetingBanter = "Brok_Global_SideArmor_Greeting",
    completeBanter = "Brok_GolemArmor_Complete",
    questName = "Quest_GolemArmor"
  }
  local golemInterrupt = VendorQuestInterrupt:New(golemArmorArgs)
  VendorQuestInterruptQueue:AddInterrupt(golemInterrupt)
end
function InitializeSindriInterruptQuests()
  local tyrArmorArgs = {
    characterIndex = 0,
    interruptName = "TyrArmor",
    greetingBanter = "Sindri_Global_SideArmor_Greeting",
    completeBanter = "Sindri_TyrArmor_Complete",
    questName = "Quest_TyrArmor"
  }
  local tyrInterrupt = VendorQuestInterrupt:New(tyrArmorArgs)
  VendorQuestInterruptQueue:AddInterrupt(tyrInterrupt)
  local travelerArmorArgs = {
    characterIndex = 0,
    interruptName = "TravelerArmor",
    greetingBanter = "Sindri_Global_SideArmor_Greeting",
    completeBanter = "Sindri_TravelerArmor_Complete",
    questName = "Quest_TravelerArmor"
  }
  local travelerInterrupt = VendorQuestInterrupt:New(travelerArmorArgs)
  VendorQuestInterruptQueue:AddInterrupt(travelerInterrupt)
  local golemArmorArgs = {
    characterIndex = 0,
    interruptName = "GolemArmor",
    greetingBanter = "Sindri_Global_SideArmor_Greeting",
    completeBanter = "Sindri_GolemArmor_Complete",
    questName = "Quest_GolemArmor"
  }
  local golemInterrupt = VendorQuestInterrupt:New(golemArmorArgs)
  VendorQuestInterruptQueue:AddInterrupt(golemInterrupt)
end
function VendorQuestInterruptQueue:HasInterrupt(characterIndex)
  if self.m_queue == nil then
    return false
  end
  if self.m_queue[characterIndex] == nil then
    return false
  end
  for _, inter in pairs(self.m_queue[characterIndex]) do
    local questState = game.QuestManager.GetQuestState(inter.questName .. "_Parent")
    if questState == "Active" then
      return true
    end
  end
  return false
end
function VendorQuestInterruptQueue:GetCurrent(characterIndex)
  if not self:HasInterrupt(characterIndex) then
    return nil
  end
  if self.m_current == nil then
    self.m_current = {}
  end
  if self.m_current[characterIndex] == nil then
    for _, inter in pairs(self.m_queue[characterIndex]) do
      local questState = game.QuestManager.GetQuestState(inter.questName .. "_Parent")
      if questState == "Active" then
        self.m_current[characterIndex] = inter
        break
      end
    end
  end
  return self.m_current[characterIndex]
end
function VendorQuestInterruptQueue:AddInterrupt(newInterrupt)
  if self.m_queue == nil then
    self.m_queue = {}
  end
  if self.m_queue[newInterrupt.characterIndex] == nil then
    self.m_queue[newInterrupt.characterIndex] = {}
  end
  self.m_queue[newInterrupt.characterIndex][newInterrupt.interruptName] = newInterrupt
end
function VendorQuestInterruptQueue:IsInitialized()
  if self.initialized == nil then
    self.initialized = false
  end
  return self.initialized
end
function VendorQuestInterruptQueue:FinishCurrent(characterIndex)
  local name = self.m_current[characterIndex].interruptName
  if self.m_queue[0][name] then
    self.m_queue[0][name] = nil
  end
  if self.m_queue[1][name] then
    self.m_queue[1][name] = nil
  end
  if self.m_current[0] then
    self.m_current[0] = nil
  end
  if self.m_current[1] then
    self.m_current[1] = nil
  end
end
VendorQuestInterrupt = {}
function VendorQuestInterrupt:New(args)
  local newInterrupt = {}
  setmetatable(newInterrupt, self)
  self.__index = self
  newInterrupt.characterIndex = args.characterIndex
  newInterrupt.interruptName = args.interruptName
  newInterrupt.greetingBanter = args.greetingBanter
  newInterrupt.completeBanter = args.completeBanter
  newInterrupt.questName = args.questName
  return newInterrupt
end
function VendorQuestInterrupt:CheckInProgressDialogueType()
  TriggerCheckInGivenEvent()
  if self.greetingBanter then
    if game.Audio.CanBanterConversationPlay(self.greetingBanter) then
      game.Audio.PlayBanterNonCritical(self.greetingBanter, CheckInCompleteTriggered)
    else
      CheckInCompleteTriggered()
    end
    EnableInteract()
    readyForTurnIn = true
    checkInHasPlayed = true
    return
  end
end
function VendorQuestInterrupt:CheckQuestCompleteDialogueType()
  TriggerCompleteStartedEvent()
  if self.completeBanter then
    game.Audio.PlayBanter(self.completeBanter, CompleteQuests)
    return
  end
end
function VendorQuestInterrupt:CompleteQuests()
  TriggerCompleteGivenEvent()
  LD.CompleteQuest(self.questName)
  LD.CallFunctionAfterDelay(CompleteContinuedTriggered, 3)
end
function PlayerExitedVolume()
  DisableInteract()
  TriggerExitEvent()
  ambientBanterTimer:Stop()
  ambientBanterEnabled = false
  playerInZone = false
  failcount = 0
  brokAmbientBanterTimer:Stop()
end
function RestartGreetingCheck()
  if characterIndex == 0 then
    sindriGreetingPlayed = false
  elseif characterIndex == 1 then
    brokGreetingPlayed = false
  end
end
function RestartCheckInCheck()
  checkInHasPlayed = false
  readyForTurnIn = false
end
function TriggerGreetingStartedEvent(level, obj)
  banterInProgress = true
  if thisObj ~= nil then
    if thisObj:FindLuaTableAttribute("onGreetingStartedEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onGreetingStartedEvent"), "Greeting Started Triggered")
    end
  else
    thisObj = obj
    thisLevel = level
    if thisObj:FindLuaTableAttribute("onGreetingStartedEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onGreetingStartedEvent"), "Greeting Started Triggered")
    end
  end
end
function TriggerGreetingGivenEvent(level, obj)
  if thisObj:FindLuaTableAttribute("onGreetingGivenEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onGreetingGivenEvent"), "Greeting Done Triggered")
  end
end
function TriggerBriefingStartedEvent()
  if thisObj:FindLuaTableAttribute("onBriefingStartedEvent") ~= nil then
    print("triggering briefing started")
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onBriefingStartedEvent"), "Briefing Started Triggered")
  end
end
function TriggerBriefingStartedEventBrok02Cine()
  DisableInteract()
  triggerBrokCinematic = false
end
function TriggerExitEvent()
  if thisObj:FindLuaTableAttribute("onExitTriggeredEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onExitTriggeredEvent"), "Exit Triggered")
  end
end
function TriggerBriefingGivenEvent()
  LD.CallFunctionAfterDelay(TriggerCharacterExit, 0.1)
  if thisObj:FindLuaTableAttribute("onBriefingGivenEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onBriefingGivenEvent"), "Briefing Done Triggered")
  end
end
function TriggerInteractStartedEvent()
  if thisObj:FindLuaTableAttribute("onInteractStarted") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onInteractStarted"), "Briefing Done Triggered")
  end
end
function TriggerInteractEndedEvent()
  if thisObj:FindLuaTableAttribute("onInteractEnded") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onInteractEnded"), "Briefing Done Triggered")
  end
end
function TriggerCheckInStartedEvent(level, obj)
  banterInProgress = true
  if thisObj ~= nil then
    if thisObj:FindLuaTableAttribute("onCheckInStartedEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onCheckInStartedEvent"), "Check-In Started Triggered")
    end
  else
    thisObj = obj
    thisLevel = level
    if thisObj:FindLuaTableAttribute("onCheckInStartedEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onCheckInStartedEvent"), "Check-In Started Triggered")
    end
  end
end
function TriggerCheckInGivenEvent(level, obj)
  if thisObj:FindLuaTableAttribute("onCheckInGivenEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onCheckInGivenEvent"), "Check-In Done Triggered")
  end
end
function TriggerCompleteStartedEvent()
  if thisObj:FindLuaTableAttribute("onCompleteStartedEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onCompleteStartedEvent"), "Complete Started Triggered")
  end
end
function TriggerCompleteGivenEvent()
  if thisObj:FindLuaTableAttribute("onCompleteGivenEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onCompleteGivenEvent"), "Complete Done Triggered")
  end
end
function EnableQuestGiver()
  questGiverAvailable = true
end
function DisableQuestGiver()
  questGiverAvailable = false
end
function EnableCinematicTrigger()
  triggerCinematic = true
end
function DisableCinematicTrigger()
  triggerCinematic = false
end
function DisableInteract()
  DisableDummyInteract()
  interactZone:Disable()
  questGiverAvailable = false
end
function EnableInteract()
  if triangleMonitor == nil then
    triangleMonitor = monitors.CreateTriangleButtonMonitor()
    triangleMonitor:OnButtonDown(CheckIfCanInteract)
    interactZone:Enable()
    if ambientBanterEnabled then
      SetInteractToTalk()
    else
      SetInteractToQuest()
    end
  end
end
function SetInteractToQuest()
  interactZone:SetPromptIconSet(questIconTable)
end
function SetInteractToTalk()
  interactZone:SetPromptIconSet(talkIconTable)
end
function DisableDummyInteract()
  if triangleMonitor ~= nil then
    triangleMonitor:Stop()
    triangleMonitor = nil
  end
end
function TriggerStoryTimeBanter()
  if characterIndex == 0 then
    game.Audio.PlayBanterNonCritical("SindriStoryTimeBanter", StoryTimeDoneSindri)
    CreateSindriStoryTimeRangeMonitor()
  else
    game.Audio.PlayBanterNonCritical("BrokStoryTimeBanter", StoryTimeDoneBrok)
    CreateBrokStoryTimeRangeMonitor()
  end
  print("TRIGGERING STORY TIME")
  DisableInteract()
  if player:GetCurrentInteractObject() == thisObj then
    player:EndInteract()
  end
  if thisObj:FindLuaTableAttribute("onGreetingStartedEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onGreetingStartedEvent"), "Greeting Started Triggered")
  end
end
function CreateSindriStoryTimeRangeMonitor()
  sindriStoryTimeMonitor = monitors.CreateDistanceMonitor(player, thisObj)
  sindriStoryTimeMonitor:OnFartherThan(16, CancelSindriStoryTime)
end
function CancelSindriStoryTime()
  if currentTalkNpc ~= nil then
    if currentTalkNpc ~= nil and player ~= nil then
      currentTalkNpc:ClearForcedLookAtToObject()
      player:ClearForcedLookAtToObject()
    end
    StopSindriStoryTimeMonitor()
    game.Audio.PlayBanterNonCritical("triptych_breakout")
    local objArray = game.World.FindGameObjectsByMarker("Sindri00")
    for _, obj in ipairs(objArray) do
      if obj:GetCreature() ~= nil then
        game.Audio.InterruptBanterOnCharacter("Sindri00")
      end
    end
    if StoryTimeBanterAvailable() then
      ambientBanterEnabled = true
      EnableInteract()
    end
    if thisObj:FindLuaTableAttribute("onGreetingGivenEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onGreetingGivenEvent"), "Greeting Done Triggered")
    end
  end
end
function StopSindriStoryTimeMonitor()
  if sindriStoryTimeMonitor ~= nil then
    sindriStoryTimeMonitor:Stop()
    sindriStoryTimeMonitor = nil
  end
end
function StoryTimeDoneBrok()
  CheckForBrokStoryTimeBanter()
  TriggerGreetingGivenEvent()
  StopBrokStoryTimeMonitor()
end
function StoryTimeDoneSindri()
  CheckForStoryTimeBanter()
  TriggerGreetingGivenEvent()
  StopSindriStoryTimeMonitor()
end
function CheckForStoryTimeBanter()
  if playerInZone then
    if failcount < failMax and ambientBanterTimer then
      failcount = failcount + 1
      ambientBanterTimer:Reset()
    end
    if StoryTimeBanterAvailable() then
      ambientBanterEnabled = true
      EnableInteract()
    else
      ambientBanterEnabled = false
      DisableInteract()
    end
  end
end
function CreateBrokStoryTimeRangeMonitor()
  brokStoryTimeMonitor = monitors.CreateDistanceMonitor(player, thisObj)
  brokStoryTimeMonitor:OnFartherThan(16, CancelBrokStoryTime)
end
function CancelBrokStoryTime()
  if currentTalkNpc ~= nil then
    if currentTalkNpc ~= nil and player ~= nil then
      currentTalkNpc:ClearForcedLookAtToObject()
      player:ClearForcedLookAtToObject()
    end
    local objArray = game.World.FindGameObjectsByMarker("Brok00")
    for _, obj in ipairs(objArray) do
      if obj:GetCreature() ~= nil then
        game.Audio.InterruptBanterOnCharacter("Brok00")
      end
    end
    game.Audio.PlayBanterNonCritical("triptych_breakout")
    StopBrokStoryTimeMonitor()
    if BrokStoryTimeBanterAvailable() then
      ambientBanterEnabled = true
      EnableInteract()
    end
    if thisObj:FindLuaTableAttribute("onGreetingGivenEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onGreetingGivenEvent"), "Greeting Done Triggered")
    end
  end
end
function StopBrokStoryTimeMonitor()
  if brokStoryTimeMonitor ~= nil then
    brokStoryTimeMonitor:Stop()
    brokStoryTimeMonitor = nil
  end
end
function CheckForBrokStoryTimeBanter()
  if playerInZone then
    if failcount < failMax and brokAmbientBanterTimer then
      failcount = failcount + 1
      print("fail count is...", failcount)
      brokAmbientBanterTimer:Reset()
    end
    if BrokStoryTimeBanterAvailable() then
      ambientBanterEnabled = true
      EnableInteract()
      print("Storytime passed")
    else
      ambientBanterEnabled = false
      DisableInteract()
      print("Storytime failed")
    end
  end
end
function StoryTimeBanterAvailable()
  local questState = game.QuestManager.GetQuestState("Quest_Alfheim_Objective100")
  if questState == "Active" then
    return false
  end
  if game.Audio.CanBanterConversationPlay("SindriStoryTimeBanter") and CheckIsInteracting() == false then
    return true
  else
    if ambientBanterTimer then
      ambientBanterTimer:Start()
    end
    return false
  end
end
function BrokStoryTimeBanterAvailable()
  print("DOING BROK STORY TIME CHECK!!!!!!!!")
  if game.Audio.CanBanterConversationPlay("BrokStoryTimeBanter") and CheckIsInteracting() == false then
    return true
  else
    if brokAmbientBanterTimer then
      brokAmbientBanterTimer:Start()
    end
    return false
  end
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, tab)
end
function DisableSpeedZone()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableSpeedZone()
end
function EnableSpeedZone()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableSpeedZone()
end
function EnableCamera()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableCamera()
end
function EnableCollision()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableCollision()
end
function DisableCollision()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableCollision()
end
function DisableCamera()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableCamera()
end
function EnableHeadtracking()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableHeadtracking()
end
function DisableHeadtracking()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableHeadtracking()
end
