local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local mpicon = require("ui.mpicon")
local monitors = require("level.MonitorLibrary")
local thunk = require("core.thunk")
local interactZone, player, son, thisObj, thisLevel
local interactIsGhostVersion = false
local characterIndex = 0
local questCompleted = false
local banterInProgress = false
local completionInProgress = false
local questStateParent02, questStateParent03, questStateParent04, questStateDMReturn, questStateLo9SpotA, questStateLo9SpotB, questStateLo9SpotC, questStateLo9SpotD, questStateSecretBusiness02, questStateSindri01_Objective04
local ubQuestInProgress02 = false
local ubQuestInProgress03 = false
local ubQuestInProgress04 = false
local ubQuestInProgress05 = false
local ub05ProgressCount = 0
local sindriQuest01InProgress = false
local deadGuyInBetweenQuests = false
local sbQuestInProgress02 = false
local ubGreetingPlayed02 = false
local ubGreetingPlayed03 = false
local ubGreetingPlayed04 = false
local sindriGreetingPlayed01 = false
local readyForTurnIn = false
local checkInHasPlayed = false
local briefingInProgress = false
local animIsPlaying = false
local insideBanterZone, insideSpawnZone, lakeOfNineLocation, lakeOfNineSpotAEnabled, lakeOfNineSpotBEnabled, lakeOfNineSpotCEnabled, lakeOfNineSpotDEnabled
local checkInCooldown = 45
local greetingCooldown = 15
local sonSick, idleFX
local gullveigSpecialCheckInPlayed = false
local sindri01ExitBanterPlayedOnce = false
local onBriefingGivenEvent, onExitTriggeredEvent
local ghostIsSpawned = false
local despawnRecheckTimer, spawnRecheckTimer, showGhostTimer, hideGhostTimer
local recheckTime = 0.1
local talkIconGhost, triangleMonitor
local gullveigSequenceTriggered = false
local ghostPassive, banterZoneEvents, spawnZoneEvents, includeSon, sonPuppeteer, sonLastPos, warpPos, warpObj, sonDistanceToSync, sonDistanceToAltSync, goQuestCamera
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  interactZone = LD.CreateInteractZone_Standard_180(obj, "promptJointFront")
  interactZone:Disable()
  interactZone:SetHintXZRange(7)
  interactZone:SetXZRange(3)
  interactZone:SetYRange(3)
  interactZone:ClearTags("CarryActive")
  interactZone:SetTags("GreetingActive")
  interactZone:SetTags("CheckInCompleteActive")
  if interactZone.SetUsesSecondaryButton then
    interactZone:SetUsesSecondaryButton(true)
  end
  talkIconGhost = {
    normal = "WORLD_INTERACT_QUEST",
    unavailable = "WORLD_INTERACT_UNAVAILABLE",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  }
  interactZone:SetPromptIconSet(talkIconGhost)
  despawnRecheckTimer = timer.StartLevelTimer(recheckTime, DespawnGhost)
  despawnRecheckTimer:Stop()
  spawnRecheckTimer = timer.StartLevelTimer(recheckTime, SpawnGhost)
  spawnRecheckTimer:Stop()
  showGhostTimer = timer.StartLevelTimer(recheckTime, ShowGhost)
  showGhostTimer:Stop()
  hideGhostTimer = timer.StartLevelTimer(recheckTime, HideGhost)
  hideGhostTimer:Stop()
  game.SubObject.Sleep(thisObj)
end
function OnTeardown()
  if despawnRecheckTimer ~= nil then
    despawnRecheckTimer:Stop()
  end
  if spawnRecheckTimer ~= nil then
    spawnRecheckTimer:Stop()
  end
  if showGhostTimer ~= nil then
    showGhostTimer:Stop()
  end
  if hideGhostTimer ~= nil then
    hideGhostTimer:Stop()
  end
end
function OnPreStart(level, obj)
  spawnZoneEvents = obj:FindSingleGOByName("SpawnZoneEvents").Child.LuaObjectScript
  spawnZoneEvents.RegisterEntryCallback(PlayerEnteredSpawnVolume)
  spawnZoneEvents.RegisterExitCallback(PlayerExitedSpawnVolume)
  banterZoneEvents = obj:FindSingleGOByName("BanterZoneEvents").Child.LuaObjectScript
  banterZoneEvents.RegisterEntryCallback(PlayerEnteredBanterVolume)
  banterZoneEvents.RegisterExitCallback(PlayerExitedBanterVolume)
end
function OnStart(level, obj)
  characterIndex = thisObj:GetLuaTableAttribute("characterIndex")
  lakeOfNineLocation = thisObj:FindLuaTableAttribute("LakeOfNineLocation")
  goQuestCamera = obj:FindSingleGOByName("QuestCamera")
  goQuestCamera.LuaObjectScript.SetCameraType("GhostInteractCamera")
  ghostIsSpawned = false
  TrophyCheck()
end
function OnPassiveSpawned(level, passive)
  local passiveName = passive:GetName()
  if passive:GetPassive() ~= nil then
    if ghostPassive == nil and passiveName == "fallenwarrior00" then
      local distance = (passive:GetWorldPosition() - thisObj:GetWorldPosition()):Length()
      if distance <= 2 then
        ghostPassive = passive
        ghostPassive:AddMarker("FallenWarrior00")
        ghostPassive:Hide()
        if characterIndex == 2 then
          ghostPassive:SetMaterialSwap("hammerfall")
        elseif characterIndex == 3 then
          ghostPassive:SetMaterialSwap("anatomyhope")
        elseif characterIndex == 4 then
          ghostPassive:SetMaterialSwap("deadfreight")
        elseif characterIndex == 7 then
          ghostPassive:SetMaterialSwap("unfinishedbusiness")
        end
      end
    end
  else
    engine.Error("Ghost passive is NOT a Passive!", passive)
  end
end
function OnPassiveDestroyed(level, passive)
  if passive == ghostPassive then
    ghostPassive = nil
  end
end
thunk.Install("OnPassiveSpawned", OnPassiveSpawned)
thunk.Install("OnPassiveDestroyed", OnPassiveDestroyed)
function QuestStateCheck()
  if characterIndex == 0 then
    characterIndex = thisObj:GetLuaTableAttribute("characterIndex")
  end
  if characterIndex == 7 and lakeOfNineLocation == nil then
    lakeOfNineLocation = thisObj:FindLuaTableAttribute("LakeOfNineLocation")
  end
  if characterIndex == 2 then
    questStateParent02 = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Parent")
    questStateDMReturn = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Return")
    if questStateParent02 == "Active" and questStateDMReturn ~= "Complete" then
      ubQuestInProgress02 = true
    else
      ubQuestInProgress02 = false
    end
  end
  if characterIndex == 3 then
    questStateParent03 = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness03_Parent")
    if questStateParent03 == "Active" then
      ubQuestInProgress03 = true
    end
  end
  if characterIndex == 4 then
    questStateParent04 = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness04_Parent")
    if questStateParent04 == "Active" then
      ubQuestInProgress04 = true
    end
  end
  if characterIndex == 6 then
    questStateSindri01_Objective04 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_04")
    questStateSecretBusiness02 = game.QuestManager.GetQuestState("Quest_SecretBusiness02_Parent")
    if questStateSindri01_Objective04 ~= "Complete" then
      sindriQuest01InProgress = true
      deadGuyInBetweenQuests = false
      sbQuestInProgress02 = false
    elseif questStateSindri01_Objective04 == "Complete" then
      if questStateSecretBusiness02 == "Inactive" then
        deadGuyInBetweenQuests = true
        sbQuestInProgress02 = false
      elseif questStateSecretBusiness02 == "Active" then
        sbQuestInProgress02 = true
        deadGuyInBetweenQuests = false
      elseif questStateSecretBusiness02 == "Complete" then
        sindriQuest01InProgress = false
        deadGuyInBetweenQuests = false
        sbQuestInProgress02 = false
      end
    end
  end
  if characterIndex == 7 then
    ubQuestInProgress05, ub05ProgressCount = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    if ubQuestInProgress05 == "Active" then
      print("Lake of Nine Active")
    end
    questStateLo9SpotA = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Objective_01_SpotA")
    questStateLo9SpotB = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Objective_01_SpotB")
    questStateLo9SpotC = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Objective_01_SpotC")
    questStateLo9SpotD = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Objective_01_SpotD")
  end
end
function CheckForSonSick()
  if son:IsAvailableInLevel() then
    sonSick = false
  else
    sonSick = true
  end
end
function PlayerEnteredSpawnVolume()
  QuestStateCheck()
  insideSpawnZone = true
  if characterIndex == 2 then
    if questStateDMReturn ~= "Complete" then
      if animIsPlaying == false then
        SpawnGhost()
      else
        LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
      end
    end
  elseif characterIndex == 3 then
    if questStateParent03 ~= "Complete" then
      if animIsPlaying == false then
        SpawnGhost()
      else
        LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
      end
    end
  elseif characterIndex == 4 then
    if questStateParent04 ~= "Complete" then
      if animIsPlaying == false then
        SpawnGhost()
      else
        LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
      end
    end
  elseif characterIndex == 6 then
    if questStateSecretBusiness02 ~= "Complete" then
      if animIsPlaying == false then
        SpawnGhost()
      else
        LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
      end
    end
  elseif characterIndex == 7 then
    if lakeOfNineLocation == "SpotA" then
      if lakeOfNineSpotAEnabled and questStateLo9SpotA ~= "Complete" then
        if animIsPlaying == false then
          SpawnGhost()
        else
          LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
        end
      end
    elseif lakeOfNineLocation == "SpotB" then
      if lakeOfNineSpotBEnabled and questStateLo9SpotB ~= "Complete" then
        if animIsPlaying == false then
          SpawnGhost()
        else
          LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
        end
      end
    elseif lakeOfNineLocation == "SpotC" then
      if lakeOfNineSpotCEnabled and questStateLo9SpotC ~= "Complete" then
        if animIsPlaying == false then
          SpawnGhost()
        else
          LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
        end
      end
    elseif lakeOfNineLocation == "SpotD" and lakeOfNineSpotDEnabled and questStateLo9SpotD ~= "Complete" then
      if animIsPlaying == false then
        SpawnGhost()
      else
        LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
      end
    end
  end
end
function PlayerExitedSpawnVolume()
  insideSpawnZone = false
  banterInProgress = false
  briefingInProgress = false
  DisableInteract()
  TriggerExitEvent()
  if animIsPlaying == false then
    if ghostIsSpawned == true then
      DespawnGhost()
    end
  else
    LD.CallFunctionAfterDelay(ShowHideGhostCheck, 3)
  end
  if characterIndex == 6 then
    PlayLeavingBanter()
  end
end
function PlayLeavingBanter()
  local questState03 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_03")
  local questState04 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_04")
  if sindri01ExitBanterPlayedOnce == false and (questState03 == "Active" or questState04 == "Active") then
    game.Audio.PlayBanter("Sindri01_Ghost_Intro_Leave")
    sindri01ExitBanterPlayedOnce = true
  end
end
function PlayerEnteredBanterVolume()
  insideBanterZone = true
  CheckForSonSick()
  if sonSick == true then
    DisableInteract()
  elseif ghostIsSpawned == true then
    AttemptToTriggerGreeting()
  else
    LD.CallFunctionAfterDelay(BanterDoubleCheck, 1)
  end
end
function BanterDoubleCheck()
  if ghostIsSpawned == true then
    AttemptToTriggerGreeting()
  end
end
function PlayerExitedBanterVolume()
  insideBanterZone = false
end
function DespawnGhost()
  despawnRecheckTimer:Reset()
  if ghostPassive ~= nil and ghostPassive:GetPassive() ~= nil then
    local despawnFX = game.FX.Spawn("helheimDead_despawn", thisLevel, {GameObject = thisObj, AutoDelete = true})
    ghostPassive:TriggerMoveEvent("PlayDespawnAnim")
    animIsPlaying = true
    PlaySoundOnGhostDespawn(ghostPassive)
    LD.CallFunctionAfterDelay(ResetAnimCooldown, 3)
    if animIsPlaying == true then
      LD.CallFunctionAfterDelay(HideGhost, 2)
    end
  else
    despawnRecheckTimer:Start()
  end
end
function HideGhost()
  hideGhostTimer:Reset()
  if idleFX ~= nil and idleFX.Spawned and ghostIsSpawned == true then
    idleFX:Destroy()
    idleFX = nil
  end
  if ghostPassive ~= nil and ghostPassive:GetPassive() ~= nil then
    local burstFX = game.FX.Spawn("heldead_burst", thisLevel, {GameObject = thisObj, AutoDelete = true})
    ghostPassive:Hide()
    ghostIsSpawned = false
  else
    hideGhostTimer:Start()
  end
end
function SpawnGhost()
  spawnRecheckTimer:Reset()
  local inCombatCheck = game.Combat.GetCombatStatus()
  if inCombatCheck == false then
    if ghostPassive ~= nil and ghostPassive:GetPassive() ~= nil then
      local burstFX = game.FX.Spawn("heldead_burst", thisLevel, {GameObject = thisObj, AutoDelete = true})
      local spawnFX = game.FX.Spawn("helheimDead_spawn", thisLevel, {GameObject = thisObj, AutoDelete = true})
      ghostPassive:TriggerMoveEvent("PlaySpawnAnim")
      animIsPlaying = true
      PlaySoundOnGhostSpawn(ghostPassive)
      LD.CallFunctionAfterDelay(ResetAnimCooldown, 3)
      LD.CallFunctionAfterDelay(ShowGhost, 0.5)
    else
      spawnRecheckTimer:Start()
    end
  else
    spawnRecheckTimer:Start()
  end
end
function ShowGhost()
  showGhostTimer:Reset()
  if ghostPassive ~= nil and ghostPassive:GetPassive() ~= nil then
    ghostPassive:Show()
    idleFX = game.FX.Spawn("helheimDead_idle", thisLevel, {GameObject = thisObj, AutoDelete = false})
    ghostIsSpawned = true
  else
    showGhostTimer:Start()
  end
end
function ResetAnimCooldown()
  animIsPlaying = false
  QuestStateCheck()
  if characterIndex == 2 and questStateDMReturn ~= "Complete" then
    if gullveigSequenceTriggered == false then
      ShowHideGhostCheck()
    end
  elseif characterIndex == 3 and questStateParent03 ~= "Complete" then
    ShowHideGhostCheck()
  elseif characterIndex == 4 and questStateParent04 ~= "Complete" then
    ShowHideGhostCheck()
  elseif characterIndex == 6 and questStateSecretBusiness02 ~= "Complete" then
    ShowHideGhostCheck()
  elseif characterIndex == 7 then
    if lakeOfNineLocation == "SpotA" and questStateLo9SpotA ~= "Complete" and lakeOfNineSpotAEnabled then
      ShowHideGhostCheck()
    elseif lakeOfNineLocation == "SpotB" and questStateLo9SpotB ~= "Complete" and lakeOfNineSpotBEnabled then
      ShowHideGhostCheck()
    elseif lakeOfNineLocation == "SpotC" and questStateLo9SpotC ~= "Complete" and lakeOfNineSpotCEnabled then
      ShowHideGhostCheck()
    elseif lakeOfNineLocation == "SpotD" and questStateLo9SpotD ~= "Complete" and lakeOfNineSpotDEnabled then
      ShowHideGhostCheck()
    end
  end
end
function ShowHideGhostCheck()
  if insideSpawnZone then
    if ghostIsSpawned == false then
      SpawnGhost()
      if insideBanterZone then
        LD.CallFunctionAfterDelay(PlayerEnteredBanterVolume, 0.5)
      end
    end
  elseif insideSpawnZone == false and ghostIsSpawned == true then
    DespawnGhost()
  end
end
function OnUpdate(level, obj)
end
function AttemptToTriggerGreeting()
  QuestStateCheck()
  if banterInProgress == false then
    if characterIndex == 2 then
      if ubQuestInProgress02 == false and questStateDMReturn ~= "Complete" then
        if ubGreetingPlayed02 == false then
          CheckGreetingDialogueType()
        elseif ubGreetingPlayed02 == true then
          EnableInteract()
        end
      elseif ubQuestInProgress02 == true then
        if checkInHasPlayed == false and readyForTurnIn == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true and readyForTurnIn == true then
          EnableInteract()
        end
      end
    elseif characterIndex == 3 then
      if ubQuestInProgress03 == false and questStateParent03 ~= "Complete" then
        if ubGreetingPlayed03 == false then
          CheckGreetingDialogueType()
        elseif ubGreetingPlayed03 == true and banterInProgress == false then
          EnableInteract()
        end
      elseif ubQuestInProgress03 == true then
        if checkInHasPlayed == false and readyForTurnIn == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true and readyForTurnIn == true and banterInProgress == false then
          EnableInteract()
        end
      end
    elseif characterIndex == 4 then
      if ubQuestInProgress04 == false and questStateParent04 ~= "Complete" then
        if ubGreetingPlayed04 == false then
          CheckGreetingDialogueType()
        elseif ubGreetingPlayed04 == true and banterInProgress == false then
          EnableInteract()
        end
      elseif ubQuestInProgress04 == true then
        if checkInHasPlayed == false and readyForTurnIn == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true and readyForTurnIn == true and banterInProgress == false then
          EnableInteract()
        end
      end
    elseif characterIndex == 6 then
      if sindriQuest01InProgress == true then
        if sindriGreetingPlayed01 == false then
          CheckGreetingDialogueType()
        elseif sindriGreetingPlayed01 == true then
          EnableInteract()
        end
      elseif deadGuyInBetweenQuests == true then
        if checkInHasPlayed == false then
          CheckInProgressDialogueType()
        end
      elseif sbQuestInProgress02 == true and questStateSecretBusiness02 ~= "Complete" then
        if checkInHasPlayed == false and readyForTurnIn == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true and readyForTurnIn == true then
          EnableInteract()
        end
      end
    elseif characterIndex == 7 then
      if lakeOfNineLocation == "SpotA" and questStateLo9SpotA ~= "Complete" then
        if checkInHasPlayed == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true then
          EnableInteract()
        end
      end
      if lakeOfNineLocation == "SpotB" and questStateLo9SpotB ~= "Complete" then
        if checkInHasPlayed == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true then
          EnableInteract()
        end
      end
      if lakeOfNineLocation == "SpotC" and questStateLo9SpotC ~= "Complete" then
        if checkInHasPlayed == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true then
          EnableInteract()
        end
      end
      if lakeOfNineLocation == "SpotD" and questStateLo9SpotD ~= "Complete" then
        if checkInHasPlayed == false then
          CheckInProgressDialogueType()
        elseif checkInHasPlayed == true then
          EnableInteract()
        end
      end
    end
  end
end
function CheckGreetingDialogueType()
  banterInProgress = true
  EnableInteract()
  if characterIndex == 2 then
    game.Audio.PlayBanter("FallenWarrior_Global_Greeting02", FallenWarriorGreetingTriggered)
    ubGreetingPlayed02 = true
  elseif characterIndex == 3 then
    game.Audio.PlayBanter("FallenWarrior_Global_Greeting03", FallenWarriorGreetingTriggered)
    ubGreetingPlayed03 = true
  elseif characterIndex == 4 then
    game.Audio.PlayBanter("DF_QuestInitialGreeting", FallenWarriorGreetingTriggered)
    ubGreetingPlayed04 = true
  elseif characterIndex == 6 then
    game.Interact.DisableTags("GreetingActive")
    game.Audio.PlayBanter("Sindri01_Ghost_Intro", FallenWarriorGreetingTriggered)
    sindriGreetingPlayed01 = true
  end
end
function FallenWarriorGreetingTriggered()
  game.Interact.EnableTags("GreetingActive")
  TriggerGreetingEvent()
  if briefingInProgress == false then
    banterInProgress = false
  end
  LD.CallFunctionAfterDelay(RestartGreetingCheck, greetingCooldown)
  if characterIndex == 6 then
    local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_03")
    if questState == "Active" then
      game.QuestManager.ProposeQuestState("Quest_Sindri_Epic_01_Objective_03", "Complete")
    end
  end
end
function RestartGreetingCheck()
  if characterIndex == 2 then
    ubGreetingPlayed02 = false
  elseif characterIndex == 3 then
    ubGreetingPlayed03 = false
  elseif characterIndex == 4 then
    ubGreetingPlayed04 = false
  elseif characterIndex == 6 then
    sindriGreetingPlayed01 = false
  end
end
function OnInteractStart(level, obj, creature)
  StartInteraction()
  EnableCamera()
  player:PickupAcquire("QuestDisableEvades")
  uiCalls.UI_Event_Update_Compass()
  EnableSpeedZone()
  EnableCollision()
  SyncCharacters()
  game.Interact.DisableAll()
  if son ~= nil then
    son:SetNewAvailabilityRequest("LevelDesignScript", {AvailableForCombat = false})
  end
end
function StartInteraction(level, obj)
  QuestStateCheck()
  if characterIndex == 2 then
    if ubQuestInProgress02 == false then
      CheckBriefingDialogueType()
    elseif ubQuestInProgress02 == true then
      CheckQuestCompleteDialogueType()
    end
  elseif characterIndex == 3 then
    if ubQuestInProgress03 == false then
      CheckBriefingDialogueType()
    elseif ubQuestInProgress03 == true then
      CheckQuestCompleteDialogueType()
    end
  elseif characterIndex == 4 then
    if ubQuestInProgress04 == false then
      CheckBriefingDialogueType()
      game.Audio.StartMusic("SND_MX_XPL940_talk_spirit")
    elseif ubQuestInProgress04 == true then
      CheckQuestCompleteDialogueType()
    end
  elseif characterIndex == 6 then
    if sbQuestInProgress02 == true then
      CheckQuestCompleteDialogueType()
    end
  elseif characterIndex == 7 then
    CheckQuestCompleteDialogueType()
  end
end
function OnInteractAbort(level, obj, creature)
  TriggerCharacterExit()
end
function OnInteractFinish(level, obj, creature)
end
function OnInteractDone(level, obj, creature)
  if triangleMonitor ~= nil then
    triangleMonitor:Stop()
    triangleMonitor = nil
  end
  if includeSon then
    RemoveSonOccupied()
  end
end
function RemoveSonOccupied()
  son:EndInteract()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function ClearSonPuppeteer()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Clear()
    sonPuppeteer:DetachPuppet()
    sonPuppeteer = nil
  end
end
function CheckBriefingDialogueType()
  DisableInteract()
  banterInProgress = true
  briefingInProgress = true
  if characterIndex == 2 then
    game.Audio.PlayBanter("FallenWarrior_Global_Briefings02", TriggerBriefingTriggered)
  elseif characterIndex == 3 then
    game.Audio.PlayBanter("FallenWarrior_Global_Briefings03", TriggerBriefingTriggered)
  elseif characterIndex == 4 then
    game.Audio.PlayBanter("DF_QuestBriefing", TriggerBriefingTriggered)
  elseif characterIndex == 6 then
    PlayBanterDaggerPull()
  end
end
function TriggerBriefingTriggered()
  banterInProgress = false
  briefingInProgress = false
  checkInHasPlayed = true
  QuestStateCheck()
  TriggerBriefingGivenEvent()
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
  LD.CallFunctionAfterDelay(CheckContinuedBriefing, 3)
  if characterIndex == 2 then
    if questStateParent02 == "Inactive" then
      game.QuestManager.StartQuest("Quest_UnfinishedBusiness02_Parent")
      LD.CallFunctionAfterDelay(Checkpoint, 1)
    end
  elseif characterIndex == 3 then
    if questStateParent03 == "Inactive" then
      game.QuestManager.StartQuest("Quest_UnfinishedBusiness03_Parent")
      game.QuestManager.StartQuest("Quest_UnfinishedBusiness03_GraveDigger")
      LD.CallFunctionAfterDelay(CheckForThorCompletion, 3)
      LD.CallFunctionAfterDelay(Checkpoint, 1)
      LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness03_Objective_01")
    end
  elseif characterIndex == 4 and questStateParent04 == "Inactive" then
    game.QuestManager.StartQuest("Quest_UnfinishedBusiness04_Parent")
    LD.CallFunctionAfterDelay(Checkpoint, 1)
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Parent")
  end
end
function CheckContinuedBriefing()
  if insideBanterZone then
    if characterIndex == 2 then
      game.Audio.PlayBanterNonCritical("UB1DesMdn_BringEmBones", CheckForFollowUpMaiden)
    elseif characterIndex == 3 then
      game.Audio.PlayBanter("UB_TR_QuestBriefing_cont01", CheckContinuedContinuedBriefing)
    elseif characterIndex == 4 then
      game.Audio.PlayBanter("DF_QuestBriefing_cont")
    end
  end
end
function CheckForFollowUpMaiden()
  LD.CallFunctionAfterDelay(PlayFollowUpMaidenConvo, 3.5)
end
function PlayFollowUpMaidenConvo()
  if game.Combat.GetCombatStatus() == false then
    game.Audio.PlayBanterNonCritical("UB1DesMdn_FoolsErrand")
  end
end
function CheckContinuedContinuedBriefing()
  if insideSpawnZone == true then
    game.Audio.PlayBanter("UB_TR_QuestBriefingResp")
  end
end
function CheckForThorCompletion()
  local questAlreadyComplete = game.Level.GetVariable("ThorStatueBroken", true)
  if questAlreadyComplete == true then
    local questStateObjective = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness03_Objective_01")
    if questStateObjective == "Active" then
      game.QuestManager.ProposeQuestState("Quest_UnfinishedBusiness03_Objective_01", "Complete")
      LD.CallFunctionAfterDelay(SoftSave, 1)
    end
  end
end
function PlayBanterDaggerPull()
  briefingInProgress = false
  player:AbortInteract()
  GameObjects.Cine_SindriQuest1.LuaObjectScript:SetupCineSeq()
end
function CompleteSindri01Objective()
  TriggerBriefingTriggered()
  sindriQuest01InProgress = false
  LD.CompleteQuest("Quest_Sindri_Epic_01_Objective_04")
  GameObjects.Cbt_Xpl850_Script.LuaObjectScript:A10_Start_Boss()
  LD.CallFunctionAfterDelay(PlayReaverTauntBanter, 2)
  LD.CallFunctionAfterDelay(Checkpoint, 1)
end
function PlayReaverTauntBanter()
  game.Audio.PlayBanter("Sindri1_ReaverTaunts_PreFight")
  if characterIndex == 6 then
    banterInProgress = true
  end
end
function CheckInProgressDialogueType()
  banterInProgress = true
  DisableInteract()
  if characterIndex == 2 then
    local questStateReturn02 = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Return")
    if questStateReturn02 == "Active" then
      EnableInteract()
      game.Audio.PlayBanter("FallenWarrior_Global_QuestCheckin_Complete02", FallenWarriorCheckInCompleteTriggered)
    else
      local questStateDeliver = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Objective_02")
      if questStateDeliver ~= "Active" then
        local _, objective01Progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness02_Objective_01")
        if 0 < objective01Progress and gullveigSpecialCheckInPlayed == false then
          game.Audio.PlayBanter("FallenWarrior_Global_QuestCheckin02_Special", FallenWarriorCheckInTriggered)
          gullveigSpecialCheckInPlayed = true
        else
          game.Audio.PlayBanter("FallenWarrior_Global_QuestCheckin02", FallenWarriorCheckInTriggered)
        end
      elseif questStateDeliver == "Active" then
        banterInProgress = false
      end
    end
  elseif characterIndex == 3 then
    local questStateReturn03 = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness03_Return")
    if questStateReturn03 == "Active" then
      EnableInteract()
      game.Audio.PlayBanter("FallenWarrior_Global_QuestCheckin_Complete03", FallenWarriorCheckInCompleteTriggered)
    else
      game.Audio.PlayBanter("FallenWarrior_Global_QuestCheckin03", FallenWarriorCheckInTriggered)
    end
  elseif characterIndex == 4 then
    local questStateReturn04 = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness04_Return")
    if questStateReturn04 == "Active" then
      EnableInteract()
      game.Audio.PlayBanter("DF_QuestCheckIn_complete", FallenWarriorCheckInCompleteTriggered)
    else
      game.Audio.PlayBanter("DF_QuestCheckIn", FallenWarriorCheckInTriggered)
    end
  elseif characterIndex == 6 then
    local questStateReturn06 = game.QuestManager.GetQuestState("Quest_SecretBusiness02_Parent")
    if questStateReturn06 == "Active" then
      EnableInteract()
      game.Audio.PlayBanter("Sindri01_Ghost_CheckIn_Complete", FallenWarriorCheckInCompleteTriggered)
    else
      game.Audio.PlayBanter("Sindri01_Ghost_CheckIn", FallenWarriorCheckInTriggered)
    end
  elseif characterIndex == 7 then
    QuestStateCheck()
    LD.CallFunctionAfterDelay(EnableInteract, 0.5)
    if ub05ProgressCount == 0 then
      local aoh = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Parent")
      local thr = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness03_Parent")
      local dfr = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness04_Parent")
      local sin = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_04")
      if aoh == "Inactive" and thr == "Inactive" and dfr == "Inactive" and sin == "Inactive" then
        LD.CallFunctionAfterDelay(function()
          game.Audio.PlayBanter("XPL0_QuestGreeting1", FallenWarriorCheckInCompleteTriggered)
        end, 0.5)
      else
        LD.CallFunctionAfterDelay(function()
          game.Audio.PlayBanter("XPL0_QuestGreeting_Alt", FallenWarriorCheckInCompleteTriggered)
        end, 0.5)
      end
    elseif ub05ProgressCount == 1 then
      LD.CallFunctionAfterDelay(function()
        game.Audio.PlayBanter("XPL0_QuestGreeting2", FallenWarriorCheckInCompleteTriggered)
      end, 0.5)
    elseif ub05ProgressCount == 2 then
      LD.CallFunctionAfterDelay(function()
        game.Audio.PlayBanter("XPL0_QuestGreeting3", FallenWarriorCheckInCompleteTriggered)
      end, 0.5)
    elseif ub05ProgressCount == 3 then
      LD.CallFunctionAfterDelay(function()
        game.Audio.PlayBanter("XPL0_QuestGreeting4", FallenWarriorCheckInCompleteTriggered)
      end, 0.5)
    end
  end
end
function FallenWarriorCheckInTriggered()
  banterInProgress = false
  checkInHasPlayed = true
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function FallenWarriorCheckInCompleteTriggered()
  game.Interact.EnableTags("CheckInCompleteActive")
  if completionInProgress == false then
    banterInProgress = false
  end
  checkInHasPlayed = true
  readyForTurnIn = true
  LD.CallFunctionAfterDelay(RestartCheckInCheck, checkInCooldown)
end
function RestartCheckInCheck()
  checkInHasPlayed = false
  readyForTurnIn = false
end
function CheckQuestCompleteDialogueType()
  DisableInteract()
  banterInProgress = true
  completionInProgress = true
  if characterIndex == 2 then
    game.Audio.PlayBanter("FallenWarrior_Global_Complete02", FallenWarriorCompleteTriggered)
  elseif characterIndex == 3 then
    game.Audio.PlayBanter("FallenWarrior_Global_Complete03", FallenWarriorCompleteTriggered)
  elseif characterIndex == 4 then
    game.Audio.PlayBanter("DF_QuestTurnIn", FallenWarriorCompleteTriggered)
  elseif characterIndex == 6 then
    game.Audio.PlayBanter("Sindri01_Ghost_Complete", FallenWarriorCompleteTriggered)
  elseif characterIndex == 7 then
    QuestStateCheck()
    if ub05ProgressCount == 0 then
      game.Audio.PlayBanter("XPL0_QuestBriefing1", FallenWarriorCompleteTriggered)
    elseif ub05ProgressCount == 1 then
      game.Audio.PlayBanter("XPL0_QuestBriefing2", FallenWarriorCompleteTriggered)
    elseif ub05ProgressCount == 2 then
      game.Audio.PlayBanter("XPL0_QuestBriefing3", FallenWarriorCompleteTriggered)
    elseif ub05ProgressCount == 3 then
      game.Audio.PlayBanter("XPL0_QuestBriefing4", FallenWarriorCompleteTriggered)
    end
  end
end
function FallenWarriorCompleteTriggered(level, obj)
  QuestStateCheck()
  banterInProgress = false
  completionInProgress = false
  if characterIndex == 2 then
    local skeleton = GameObjects.Maiden_Body
    if skeleton ~= nil then
      skeleton.LuaObjectScript.StartGullveigSequence()
      gullveigSequenceTriggered = true
    else
      print("Did someone change the name of the skeleton object? It returned nil")
    end
    DespawnGhost()
    ubQuestInProgress02 = false
  elseif characterIndex == 3 then
    game.QuestManager.ProposeQuestState("Quest_UnfinishedBusiness03_Return", "Complete")
    CheckCompleteContdBanter()
    DespawnGhost()
    ubQuestInProgress03 = false
  elseif characterIndex == 4 then
    game.QuestManager.ProposeQuestState("Quest_UnfinishedBusiness04_Return", "Complete")
    CheckCompleteContdBanter()
    DespawnGhost()
    ubQuestInProgress04 = false
  elseif characterIndex == 6 then
    sindriQuest01InProgress = false
    if sbQuestInProgress02 then
      game.QuestManager.ProposeQuestState("Quest_SecretBusiness02_Objective01", "Complete")
      DespawnGhost()
      sbQuestInProgress02 = false
      LD.CallFunctionAfterDelay(CheckCompleteContdBanter, 3)
    end
  elseif characterIndex == 7 then
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    if questState == "Inactive" then
      LD.ActivateQuest("Quest_UnfinishedBusiness05_Parent")
    end
    DespawnGhost()
    LD.CallFunctionAfterDelay(CheckCompleteContdBanter, 3)
    LD.CallFunctionAfterDelay(CompleteLakeOfNineSpots, 1)
  end
  LD.CallFunctionAfterDelay(TrophyCheck, 2)
  LD.CallFunctionAfterDelay(TriggerCharacterExit, 0.1)
  if characterIndex ~= 2 and characterIndex ~= 7 then
    LD.CallFunctionAfterDelay(Checkpoint, 1)
  end
end
function CompleteLakeOfNineSpots()
  local _, ub05Progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
  if lakeOfNineLocation == "SpotA" then
    LD.CompleteQuest("Quest_UnfinishedBusiness05_Objective_01_SpotA")
    game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness05_Objective_01", 1)
    if ub05Progress < 3 then
      LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness05_Objective_01")
    end
  elseif lakeOfNineLocation == "SpotB" then
    LD.CompleteQuest("Quest_UnfinishedBusiness05_Objective_01_SpotB")
    game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness05_Objective_01", 1)
    if ub05Progress < 3 then
      LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness05_Objective_01")
    end
  elseif lakeOfNineLocation == "SpotC" then
    LD.CompleteQuest("Quest_UnfinishedBusiness05_Objective_01_SpotC")
    game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness05_Objective_01", 1)
    if ub05Progress < 3 then
      LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness05_Objective_01")
    end
  elseif lakeOfNineLocation == "SpotD" then
    LD.CompleteQuest("Quest_UnfinishedBusiness05_Objective_01_SpotD")
    game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness05_Objective_01", 1)
    if ub05Progress < 3 then
      LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness05_Objective_01")
    end
  end
  LD.CallFunctionAfterDelay(Checkpoint, 1)
end
function CheckForTyrArmorQuest()
  local questState = game.QuestManager.GetQuestState("Quest_TyrArmor_Parent")
  if questState == "Inactive" then
    game.Audio.PlayBanter("Son_Tyr_Offering_Found", StartTyrArmorQuest)
  end
end
function StartTyrArmorQuest()
  LD.ActivateQuest("Quest_TyrArmor_Parent")
  LD.CallFunctionAfterDelay(function()
    game.SubObject.SoftSave(thisObj)
  end, 1)
end
function CheckCompleteContdBanter()
  if characterIndex == 3 then
    game.Audio.PlayBanter("FallenWarrior_Global_Complete03_Contd", function()
      LD.CallFunctionAfterDelay(CheckForTyrArmorQuest, 2)
    end)
  elseif characterIndex == 4 then
    game.Audio.PlayBanter("DF_PostQuestBanter", function()
      LD.CallFunctionAfterDelay(CheckForTyrArmorQuest, 2)
    end)
  elseif characterIndex == 6 then
    game.Audio.PlayBanter("Sindri01_Ghost_Complete_Contd")
  elseif characterIndex == 7 then
    QuestStateCheck()
    if ub05ProgressCount == 1 then
      LD.CallFunctionAfterDelay(LakeOfNineObj1CompleteContd, 6)
    elseif ub05ProgressCount == 3 then
      game.Audio.PlayBanter("XPL0_QuestBriefing3_Cont")
    elseif ub05ProgressCount == 4 then
      game.Audio.PlayBanter("XPL0_QuestBriefing4_Cont", function()
        LD.CallFunctionAfterDelay(LakeOfNineCompleteContd, 3)
      end)
    end
  end
end
function LakeOfNineObj1CompleteContd()
  game.Audio.PlayBanter("XPL0_QuestBriefing1_Cont")
end
function LakeOfNineCompleteContd()
  game.Audio.PlayBanter("XPL0_BoatBanter4")
end
function TrophyCheck()
  if game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_UnfinishedBusiness03_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_UnfinishedBusiness04_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_SecretBusiness02_Parent") == "Complete" then
    AwardTrophy()
  end
end
function AwardTrophy()
  print("Trophy Awarded: Unfinished Business")
  game.UnlockTrophy(31)
end
function SyncCharacters()
  if son ~= nil and son:IsAvailableInLevel() == true then
    PerformSonInteraction()
  end
  if goQuestCamera == nil then
    LD.MoveAndAlignToLocationSyncAndPlayBranch(player, thisObj, "BRA_QuestEnter", 3.5, true, "syncJoint", 1.2, 0.5, "")
  end
end
function CheckIfSonInValidRange()
  warpObj = thisObj:FindSingleGOByName("warpPosSon")
  warpPos = warpObj:GetWorldPosition()
  sonLastPos = son:GetWorldPosition()
  local distanceToSyncJoint = sonLastPos:Distance(warpPos)
  local sonCameraPercent = game.Camera.GetViewPenetration(son:GetWorldPosition(), 0, 0)
  if 0.1 < sonCameraPercent then
    SyncSon()
  elseif 8 <= distanceToSyncJoint then
    WarpAndSyncSon()
  else
    SyncSon()
  end
end
function PerformSonInteraction(level, obj)
  includeSon = true
  LD.CallFunctionAfterDelay(CheckIfSonInValidRange, 1.5)
end
function WarpAndSyncSon()
  DistanceCheck()
  son:Warp(warpObj:GetWorldPosition(), warpObj:GetWorldForward())
  if sonDistanceToSync > sonDistanceToAltSync then
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSonAlt", "syncJointSonAlt", 0.5, true)
  else
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSon", "syncJointSon", 0.5, true)
  end
end
function SyncSon()
  DistanceCheck()
  if sonDistanceToSync > sonDistanceToAltSync then
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSonAlt", "syncJointSonAlt", 0.5, true)
  else
    sonPuppeteer = LD.GoToLocationSyncAndPlayBranch(son, thisObj, "BRA_QuestEnter", 4, true, "syncJointSon", "syncJointSon", 0.5, true)
  end
end
function DistanceCheck()
  local syncJointSon = thisObj:FindSingleGOByName("syncJointSonObj")
  local syncJointSonAlt = thisObj:FindSingleGOByName("syncJointSonAltObj")
  local syncJointSonPos = syncJointSon:GetWorldPosition()
  local syncJointSonAltPos = syncJointSonAlt:GetWorldPosition()
  sonDistanceToSync = sonLastPos:Distance(syncJointSonPos)
  sonDistanceToAltSync = sonLastPos:Distance(syncJointSonAltPos)
end
function TriggerCharacterExit()
  DisableSpeedZone()
  DisableCollision()
  DisableCamera()
  if player:PickupIsAcquired("QuestDisableEvades") then
    player:PickupRelinquish("QuestDisableEvades")
  end
  uiCalls.UI_Event_Update_Compass()
  game.Interact.ReenableAll()
  if goQuestCamera == nil then
    player:TriggerMoveEvent("QuestBriefingDone")
  end
  if son ~= nil then
    son:TriggerMoveEvent("QuestBriefingDone")
    son:RemoveAvailabilityRequest("LevelDesignScript")
    ClearSonPuppeteer()
  end
end
function ClearSonPuppeteer()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Clear()
    sonPuppeteer:DetachPuppet()
    sonPuppeteer = nil
  end
end
function SetupInteract()
  EnableCamera()
  EnableSpeedZone()
  EnableCollision()
  player:PickupAcquire("QuestDisableEvades")
  uiCalls.UI_Event_Update_Compass()
  game.Interact.DisableAll()
  if son ~= nil then
    son:SetNewAvailabilityRequest("LevelDesignScript", {AvailableForCombat = false})
  end
end
function TriggerExitEvent()
  if thisObj:FindLuaTableAttribute("onExitTriggeredEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onExitTriggeredEvent"), "Exit Triggered")
  end
end
function TriggerGreetingEvent()
  if thisObj:FindLuaTableAttribute("onBriefingGivenEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onBriefingGivenEvent"), "Greeting Triggered")
  end
end
function TriggerBriefingGivenEvent()
  LD.CallFunctionAfterDelay(TriggerCharacterExit, 0.1)
  if thisObj:FindLuaTableAttribute("onBriefingGivenEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onBriefingGivenEvent"), "Briefing Triggered")
  end
end
function FireMaidenQuestComplete()
  SetupInteract()
  SyncCharacters()
  LD.CallFunctionAfterDelay(CheckQuestCompleteDialogueType, 1)
end
function ResetGullveig()
  gullveigSequenceTriggered = false
end
function EnableLakeOfNine(level, obj)
  if lakeOfNineLocation == "SpotA" then
    lakeOfNineSpotAEnabled = true
  elseif lakeOfNineLocation == "SpotB" then
    lakeOfNineSpotBEnabled = true
  elseif lakeOfNineLocation == "SpotC" then
    lakeOfNineSpotCEnabled = true
  elseif lakeOfNineLocation == "SpotD" then
    lakeOfNineSpotDEnabled = true
  end
  LD.CallFunctionAfterDelay(Checkpoint, 1)
  local spawnTrigger = thisObj:FindSingleGOByName("TriggerSpawn")
  if player:IsInsideEntityZone(spawnTrigger) then
    insideSpawnZone = true
  end
  if insideSpawnZone == true then
    LD.CallFunctionAfterDelay(PlayerEnteredSpawnVolume, 2)
    LD.CallFunctionAfterDelay(RestartGreetingCheck, 2)
    LD.CallFunctionAfterDelay(RestartCheckInCheck, 2)
    local banterTrigger = thisObj:FindSingleGOByName("TriggerBanter")
    if player:IsInsideEntityZone(banterTrigger) then
      insideBanterZone = true
    end
    if insideBanterZone == true then
      LD.CallFunctionAfterDelay(PlayerEnteredBanterVolume, 4)
    end
  end
end
function IsGhostInteractEnabled()
  if lakeOfNineLocation == "SpotA" then
    return lakeOfNineSpotAEnabled
  elseif lakeOfNineLocation == "SpotB" then
    return lakeOfNineSpotBEnabled
  elseif lakeOfNineLocation == "SpotC" then
    return lakeOfNineSpotCEnabled
  elseif lakeOfNineLocation == "SpotD" then
    return lakeOfNineSpotDEnabled
  end
end
function DisableInteract()
  interactZone:Disable()
  if triangleMonitor ~= nil then
    triangleMonitor:Stop()
    triangleMonitor = nil
  end
end
function EnableInteract()
  triangleMonitor = monitors.CreateTriangleButtonMonitor()
  triangleMonitor:OnButtonDown(CheckIfCanInteract)
  interactZone:Enable()
end
function CheckIfCanInteract()
  if interactZone:PlayerCanInteract() then
    if characterIndex ~= 6 then
      player:RequestInteract(thisObj, interactZone)
    else
      QuestStateCheck()
      if sindriQuest01InProgress == true then
        CheckBriefingDialogueType()
      elseif sbQuestInProgress02 == true then
        player:RequestInteract(thisObj, interactZone)
      end
    end
  end
end
function DisableSpeedZone()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableSpeedZone()
end
function EnableSpeedZone()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableSpeedZone()
end
function EnableCamera()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableCamera()
end
function EnableCollision()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableCollision()
end
function DisableCollision()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableCollision()
end
function DisableCamera()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:DisableCamera()
end
function EnableHeadtracking()
  if goQuestCamera == nil then
    return
  end
  goQuestCamera.Child.LuaObjectScript:EnableHeadtracking()
end
function PlaySoundOnGhostSpawn(passiveGO)
  LD.PlayRestartableSoundLoop(passiveGO:FindSingleSoundEmitterByName("SNDMouth"), "SND_CHR_Quest_Giver_LP")
end
function PlaySoundOnGhostDespawn(passiveGO)
  LD.StopRestartableSoundLoop(passiveGO:FindSingleSoundEmitterByName("SNDMouth"), "SND_CHR_Quest_Giver_LP")
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function SoftSave(level, obj)
  game.SubObject.SoftSave(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {
    lakeOfNineSpotAEnabled = lakeOfNineSpotAEnabled,
    lakeOfNineSpotBEnabled = lakeOfNineSpotBEnabled,
    lakeOfNineSpotCEnabled = lakeOfNineSpotCEnabled,
    lakeOfNineSpotDEnabled = lakeOfNineSpotDEnabled,
    gullveigSpecialCheckInPlayed = gullveigSpecialCheckInPlayed
  }
end
function OnRestoreCheckpoint(level, obj, tab)
  lakeOfNineSpotAEnabled = tab.lakeOfNineSpotAEnabled
  lakeOfNineSpotBEnabled = tab.lakeOfNineSpotBEnabled
  lakeOfNineSpotCEnabled = tab.lakeOfNineSpotCEnabled
  lakeOfNineSpotDEnabled = tab.lakeOfNineSpotDEnabled
  gullveigSpecialCheckInPlayed = tab.gullveigSpecialCheckInPlayed
  RestartGreetingCheck()
  RestartCheckInCheck()
end
