local LD = require("design.LevelDesignLibrary")
local thisObj, interactZone
local enabled = false
local player, heroBranch
local isRightChainBlocker = true
local additionalSlaves, additionalAnims, interactionOnStart, interactionOnFinish, onMOVStart
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  isRightChainBlocker = obj:GetLuaTableAttribute("IsRightChainBlocker")
  interactionOnStart = obj:GetLuaTableAttribute("InteractionOnStart")
  interactionOnFinish = obj:GetLuaTableAttribute("InteractionOnFinish")
  onMOVStart = obj:GetLuaTableAttribute("OnMOV_Start")
  if interactionOnStart ~= nil then
    interactionOnStart = LD.ExtractCallbacksForEvent(level, obj, interactionOnStart)
  end
  if interactionOnFinish ~= nil then
    interactionOnFinish = LD.ExtractCallbacksForEvent(level, obj, interactionOnFinish)
  end
  if onMOVStart ~= nil then
    onMOVStart = LD.ExtractCallbacksForEvent(level, obj, onMOVStart)
  end
  local promptJointName = "promptJointLeft"
  if isRightChainBlocker then
    promptJointName = "promptJointRight"
  end
  interactZone = LD.CreateInteractZone_Standard_180(thisObj, promptJointName)
  interactZone:SetHintAngle(180)
  interactZone:SetHintXZRange(12)
  interactZone:SetRequiresSonUnoccupied(true)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if not enabled then
    Disable()
  else
    Enable()
  end
  additionalSlaves = {
    thisObj,
    GameObjects.templeFlipChain00.Child
  }
  additionalAnims = {"", ""}
end
function OnUseWorld(level, obj)
  if interactZone:PlayerCanInteract() then
    player:RequestInteract(obj, interactZone)
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    enabled = interactZone:IsEnabled()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
function Enable()
  enabled = true
  interactZone:Enable()
end
function Disable()
  enabled = false
  interactZone:Disable()
end
function OnInteractStart(level, obj)
  local rightChainBroken = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  local leftChainBroken = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  if interactionOnStart ~= nil then
    LD.ExecuteCallbacksForEvent(thisObj.Level, thisObj, interactionOnStart, "Interaction Event Start")
  end
  local suffixName = "Right"
  if isRightChainBlocker and leftChainBroken then
    suffixName = "Right2"
  elseif not isRightChainBlocker then
    suffixName = "Left"
    if rightChainBroken then
      suffixName = "Left2"
    end
  end
  heroBranch = "BRA_TempleFlipBreakChain_" .. suffixName
  for i = 1, #additionalSlaves do
    additionalAnims[i] = "envTempleFlipBreakChain_" .. suffixName
  end
  local synchObj = additionalSlaves
  local anims = additionalAnims
  LD.PlaySingleSynchMove_KratosObject(synchObj, "synchJoint", "TempleFlip BreakChain_" .. thisObj:GetName(), heroBranch, anims, interactZone, true)
  Disable()
end
function OnInteractFinish()
  if interactionOnFinish ~= nil then
    LD.ExecuteCallbacksForEvent(thisObj.Level, thisObj, interactionOnFinish, "Interaction Event Finish")
  end
end
function OnInteractDone()
  thisObj:HideCollision()
end
function LuaHook_OnMov_Start()
  if onMOVStart ~= nil then
    LD.ExecuteCallbacksForEvent(thisObj.Level, thisObj, onMOVStart, "On MOV Start")
  end
end
