local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local TUT = require("game.GlobalTutorials")
local bboardUtil = require("game.BlackboardUtil")
local thisObj, son, player, heroPuppeteer, frontInteractZone, backInteractZone, interactFunction
local enterStarted = false
local endStarted = false
local fseStarted = false
local warpStarted = false
local finalDestinationMarkerID, doorFX
function OnScriptLoaded(level, obj)
  thisObj = obj
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
  doorFX = obj:FindSingleGOByName("DoorFX")
  if obj:FindJointIndex("promptJoint") ~= nil then
    frontInteractZone = LD.CreateInteractZone_Standard_180(obj, "promptJoint")
    frontInteractZone:SetCameraFrontAngle(135)
    frontInteractZone:SetCameraFrontAngleWeight(3)
    LD.OverrideInteractZoneTags(frontInteractZone, "NotWhileSonInteracting", true)
  end
  if obj:FindJointIndex("promptJointBack") ~= nil then
    backInteractZone = LD.CreateInteractZone_Standard_180(obj, "promptJointBack")
    backInteractZone:SetCameraFrontAngle(135)
    backInteractZone:SetCameraFrontAngleWeight(3)
    LD.OverrideInteractZoneTags(backInteractZone, "NotWhileSonInteracting", true)
  end
  SoundInit()
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
end
function OnStart(level, obj)
  doorFX:Hide()
end
function OnUseWorld(level, obj)
  if frontInteractZone:PlayerCanInteract() then
    interactFunction = PerformInteraction
    player:RequestInteract(obj, frontInteractZone)
  elseif backInteractZone ~= nil and backInteractZone:PlayerCanInteract() then
    interactFunction = PerformInteraction_Back
    player:RequestInteract(obj, backInteractZone)
  end
end
function OnInteractStart(level, obj, creature)
  if interactFunction ~= nil then
    ExecuteCallbackOnInteractStart()
    interactFunction()
  end
end
local isEnabled = false
function Enable()
  frontInteractZone:Enable()
  backInteractZone:Enable()
  doorFX:Show()
  PlaySoundPortalLoop()
  isEnabled = true
end
function Disable()
  frontInteractZone:Disable()
  backInteractZone:Disable()
  doorFX:Hide()
  StopSoundPortalLoop()
  isEnabled = false
end
function IsEnabled()
  return isEnabled
end
function PerformInteraction()
  LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJoint", "Fast Travel Interact", "BRA_FastTravel_RealmExit", "", frontInteractZone, false, "BareOnBack")
  TryLoadBrokEarly()
end
function PerformInteraction_Back()
  LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJointBack", "Fast Travel Interact BACK", "BRA_FastTravel_RealmExit", "", backInteractZone, false, "BareOnBack")
  TryLoadBrokEarly()
end
function TryLoadBrokEarly()
  local cal120 = game.FindLevel("Cal120_Airlock")
  if cal120 ~= nil then
    cal120:CallScript("LoadBrokVendor")
  end
end
function LuaHook_StartFullScreenFX()
end
function LuaHook_TriggerFinalWarp()
  game.Compass.SetDesignerForcedHide(false)
  print("LuaHookGotWarp Message")
  local cal120 = game.FindLevel("Cal120_Airlock")
  if cal120 ~= nil then
    CalAirlockWarp()
    print("Doing Cal120 Warp")
  else
    MarkerCoordinateWarp()
    print("Doing Alt warp")
  end
  PlaySoundOnExitRealm()
end
function SetDestination(markerName)
  finalDestinationMarkerID = markerName
end
function MarkerCoordinateWarp()
  local found = false
  local fwdFound = false
  local coordinates, markerFwd
  found, coordinates = game.Map.GetMarkerCoordinates(finalDestinationMarkerID)
  fwdFound, markerFwd = game.Map.GetMarkerForwardDir(finalDestinationMarkerID)
  print("WARPING TO............", coordinates, markerFwd)
  if found and fwdFound then
    player:Warp(coordinates, markerFwd)
  end
  if found and son ~= nil and son:IsAvailableInLevel() then
    local adjustedCordinates = coordinates + engine.Vector.New(0.2, 0, 0)
    son:Warp(adjustedCordinates, son:GetWorldForward())
  end
  finalDestinationMarkerID = nil
end
function CalAirlockWarp()
  local cal120 = game.FindLevel("Cal120_Airlock")
  local spawnPointObject = cal120:FindSingleGameObject("FastTravelPoint").Child
  local teleLoc = spawnPointObject:GetWorldJointPosition(spawnPointObject:GetJointIndex("TeleportPoint"))
  local teleDir = spawnPointObject:GetWorldJointForward(spawnPointObject:GetJointIndex("TeleportPoint"))
  player:Warp(teleLoc, teleDir)
  print("Warp POS", teleLoc, teleDir)
  if son ~= nil and son:IsAvailableInLevel() then
    local coordinateOffset = teleDir * 0.2
    local adjustedCordinates = teleLoc + coordinateOffset:RotateXZ(90)
    son:Warp(adjustedCordinates, teleDir)
  end
  finalDestinationMarkerID = nil
end
local onInteractStartCallbacks = {}
function RegisterCallbackOnInteractStart(fn)
  if onInteractStartCallbacks == nil then
    onInteractStartCallbacks = {}
  end
  if fn ~= nil then
    table.insert(onInteractStartCallbacks, fn)
  end
end
function ExecuteCallbackOnInteractStart()
  for _, v in ipairs(onInteractStartCallbacks) do
    v()
  end
end
local portalEmitter
portalSoundEvents = {
  PortalAppear = "SND_MECH_Fast_Travel_Realm_Portal_Open",
  PortalLoop = "SND_MECH_Fast_Travel_Realm_Portal_LP",
  OnExitRealm = "SND_MECH_Fast_Travel_Realm_Exit"
}
function SoundInit()
  portalEmitter = thisObj:FindSingleSoundEmitterByName("SNDPortal")
end
function PlaySoundPortalLoop()
  LD.PlaySound(portalEmitter, portalSoundEvents.PortalAppear)
  LD.PlaySound(portalEmitter, portalSoundEvents.PortalLoop)
end
function StopSoundPortalLoop()
  LD.StopSound(portalEmitter, portalSoundEvents.PortalLoop)
end
function PlaySoundOnExitRealm()
  LD.PlaySound(player:FindSingleSoundEmitterByName("SNDKratos"), portalSoundEvents.OnExitRealm)
  PlayRevisitMusic()
end
function PlayRevisitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 610 then
    local realm
    if game.FindLevel("Alf050_Sound") then
      realm = game.FindLevel("Alf050_Sound")
    elseif game.FindLevel("Riv000_Sound") then
      realm = game.FindLevel("Riv000_Sound")
    elseif game.FindLevel("For050_Sound") then
      realm = game.FindLevel("For050_Sound")
    elseif game.FindLevel("Hel050_Sound") then
      realm = game.FindLevel("Hel050_Sound")
    elseif game.FindLevel("Peak050_Sound") then
      realm = game.FindLevel("Peak050_Sound")
    elseif game.FindLevel("Stn950_Sound") then
      realm = game.FindLevel("Stn050_Sound")
    end
    if realm ~= nil then
      realm:CallScript("revisitMusic")
    end
  end
end
