local LD = require("design.LevelDesignLibrary")
local uiCalls, timers, TUT, thisLevel, thisObj, player, frontInteractZone, backInteractZone, interactFunction, frontInteractEnabled, backInteractEnabled, isLocked, doorFormObject, subDoorObject, doorFX, rockParent, fastTravelDoorBack, fastTravelDoorFront, pointUndiscoveredFX, pointDiscoveredFX, pointDiscoveredIntialFX
local intermediateMarkerName = "FastTravel_Marker"
local calMarkerName = "CALT_120_FT"
local finaleMarkerName = "CALT_120_ENDGAME_FT"
local calDiscovered, finalDestinationMarkerID
local unloadZones = {}
local mapSelectionInProgress = false
local isBackInteract
local enableFTCheck = false
local fastTravelFog_FSE, fastTravelExposure_FSE, fastTravelMapOpen_FSE, fastTravelMapClose_FSE, fastTravel_MapOpenExposure_FSE, fastTravel_MapCloseExposure_FSE, fastTravelMapCloseFast_FSE, fastTravel_MapCloseFastExposure_FSE, mapMarkerID, regionSummaryQuest, ftPointIsDiscovered
local finaleUnlocked = false
local finaleSelected = false
local fastTravelWad, lockButAllowDiscovery
local timers_LoadLibrary = function()
  if timers == nil then
    timers = require("level.timer")
  end
end
local uiCalls_LoadLibrary = function()
  if uiCalls == nil then
    uiCalls = require("ui.uicalls")
  end
end
local TUT_LoadLibrary = function()
  if TUT == nil then
    TUT = require("game.GlobalTutorials")
  end
end
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  fastTravelFog_FSE = {
    EffectName = "FSE_FAST_TRAVEL_VOLUME_FOG",
    TweenInTime = 0.5,
    TweenOutTime = 0.5,
    Duration = 1.5
  }
  fastTravelExposure_FSE = {
    EffectName = "FSE_FAST_TRAVEL_EXPOSURE",
    TweenInTime = 0.7,
    TweenOutTime = 2,
    Duration = 0.8
  }
  fastTravel_MapOpenExposure_FSE = {
    EffectName = "FSE_FAST_TRAVEL_MAP_OPEN_EXPOSURE",
    TweenInTime = 0.2,
    TweenOutTime = 0.2,
    Duration = 0.5
  }
  fastTravelMapOpen_FSE = {
    EffectName = "FSE_FAST_TRAVEL_MAP_OPEN",
    TweenInTime = 0.2,
    TweenOutTime = 0.2,
    Duration = 0.5
  }
  fastTravelMapClose_FSE = {
    EffectName = "FSE_FAST_TRAVEL_MAP_OPEN",
    TweenInTime = 0,
    TweenOutTime = 0.3,
    Duration = 0.1
  }
  fastTravel_MapCloseExposure_FSE = {
    EffectName = "FSE_FAST_TRAVEL_MAP_OPEN_EXPOSURE",
    TweenInTime = 0,
    TweenOutTime = 0.8,
    Duration = 0.2
  }
  fastTravelMapCloseFast_FSE = {
    EffectName = "FSE_FAST_TRAVEL_MAP_OPEN",
    TweenInTime = 0,
    TweenOutTime = 0.3,
    Duration = 0.1
  }
  fastTravel_MapCloseFastExposure_FSE = {
    EffectName = "FSE_FAST_TRAVEL_MAP_OPEN_EXPOSURE",
    TweenInTime = 0,
    TweenOutTime = 0.8,
    Duration = 0.1
  }
  local unloadZoneNames = obj:FindLuaTableAttribute("unloadZones")
  unloadZones = LD.ConvertStringListToTable(unloadZoneNames)
  unloadZoneNames = obj:FindLuaTableAttribute("unloadZones")
  frontInteractEnabled = obj:FindLuaTableAttribute("frontInteractEnabled")
  backInteractEnabled = obj:FindLuaTableAttribute("backInteractEnabled")
  mapMarkerID = obj:GetLuaTableAttribute("MapMarkerName")
  regionSummaryQuest = obj:FindLuaTableAttribute("regionSummaryQuest")
  doorFX = obj:FindSingleGOByName("DoorFX")
  pointUndiscoveredFX = obj:FindSingleGOByName("PointUndiscoveredFX")
  pointDiscoveredFX = obj:FindSingleGOByName("PointDiscovered")
  pointDiscoveredIntialFX = obj:FindSingleGOByName("PointDiscoveredTriggeredFX")
  if pointDiscoveredIntialFX ~= nil then
    pointDiscoveredIntialFX:Hide()
  end
  rockParent = obj:FindSingleGOByName("fasttraveldoor_break")
  doorFormObject = rockParent.Child
  subDoorObject = doorFormObject:FindSingleGOByName("Door_ANIM")
  fastTravelDoorBack = obj:FindSingleGOByName("fastTravelDoorBack")
  fastTravelDoorFront = obj:FindSingleGOByName("fastTravelDoorFront")
  if frontInteractEnabled and obj:FindJointIndex("promptJoint") ~= nil then
    frontInteractZone = LD.CreateInteractZone_Standard_180(obj, "promptJoint")
    LD.OverrideInteractZoneTags(frontInteractZone, "NotWhileSonInteracting", true)
  end
  if backInteractEnabled and obj:FindJointIndex("promptJointBack") ~= nil then
    backInteractZone = LD.CreateInteractZone_Standard_180(obj, "promptJointBack")
    LD.OverrideInteractZoneTags(backInteractZone, "NotWhileSonInteracting", true)
  end
  if backInteractEnabled == nil or frontInteractEnabled == nil then
    frontInteractZone = LD.CreateInteractZone_Standard_180(obj, "promptJoint")
    LD.OverrideInteractZoneTags(frontInteractZone, "NotWhileSonInteracting", true)
    backInteractZone = LD.CreateInteractZone_Standard_180(obj, "promptJointBack")
    LD.OverrideInteractZoneTags(backInteractZone, "NotWhileSonInteracting", true)
  end
  print("this level", thisLevel, unloadZones)
  SoundInit()
  game.SubObject.Sleep(thisObj)
end
function OnFirstStart(level, obj)
  SetVisualState(0)
end
function OnStart(level, obj)
  if not isLocked then
    if FastTravelIsUnlocked() == true or ftPointIsDiscovered then
      Enable()
    else
      Disable()
    end
  else
    Disable()
  end
  SetVisualState(0)
end
function OnUseWorld(level, obj)
  if frontInteractZone and frontInteractZone:PlayerCanInteract() then
    FinaleLockCheck()
    isBackInteract = false
    interactFunction = PerformInteraction
    player:RequestInteract(obj, frontInteractZone)
  end
  if backInteractZone and backInteractZone:PlayerCanInteract() then
    FinaleLockCheck()
    isBackInteract = true
    interactFunction = PerformInteraction_Back
    player:RequestInteract(obj, backInteractZone)
  end
end
function OnInteractStart(level, obj, creature)
  uiCalls_LoadLibrary()
  uiCalls.UI_Global_Menu_Set_Exclusive_Access("GlobalInWorldMenu")
  uiCalls.UI_Journal_Log_Pause()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum == 387 then
    game.Audio.PlayBanter("040_FastTravelTinker_04", nil, nil, false)
  end
  if interactFunction ~= nil then
    thisObj:HideCollision()
    interactFunction()
    if not enableFTCheck and not finaleUnlocked and InMidgard() then
      LD.CheckFastTravelState()
      enableFTCheck = true
    end
  end
end
function OnInteractAbort(level, obj, creature)
  CancelInteraction()
end
function OnInteractFinish(level, obj, creature)
end
function OnInteractDone(level, obj, creature)
  uiCalls_LoadLibrary()
  uiCalls.UI_Global_Menu_Clear_Exclusive_Access("GlobalInWorldMenu")
  uiCalls.UI_Journal_Log_Unpause()
end
function LockFastTravelPoint()
  isLocked = true
  Disable()
end
function UnlockFastTravelPoint()
  isLocked = false
  if ftPointIsDiscovered then
    Enable()
  end
end
function LockFastTravelInteract()
  if frontInteractZone then
    frontInteractZone:Lock()
  end
end
function UnlockFastTravelInteract()
  if frontInteractZone then
    frontInteractZone:Unlock()
  end
end
function LockAllowDiscovery()
  isLocked = true
  lockButAllowDiscovery = true
  Disable()
end
function Enable()
  PointFX_IsActive(true)
  ClearAnimationCallbacks()
  if frontInteractZone ~= nil then
    frontInteractZone:Enable()
  end
  if backInteractZone then
    backInteractZone:Enable()
  end
end
function Disable()
  PointFX_IsActive(false)
  if frontInteractZone then
    frontInteractZone:Disable()
  end
  if backInteractZone then
    backInteractZone:Disable()
  end
end
function PerformInteraction()
  LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJoint", "Fast Travel Interact", "BRA_FastTravelEnter", "", frontInteractZone, false, "BareOnBack", {completion_percentage = 1})
  print("STARTING Front INTERACT!!!!!!!!!!!")
end
function PerformInteraction_Back()
  LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJointBack", "Fast Travel Interact BACK", "BRA_FastTravelEnter", "", backInteractZone, false, "BareOnBack", {completion_percentage = 1})
  print("STARTING Back INTERACT!!!!!!!!!!!")
end
function SetVisualState(data)
  if data == 0 then
    print("FAST TRAVEL VISUAL STATE 00")
    RealDoorIsActive(false)
    subDoorObject:Show()
    subDoorObject:JumpAnimToFrame(0)
    subDoorObject:PauseAnim()
    doorFormObject:Show()
    doorFormObject:JumpAnimToFrame(0)
    doorFormObject:PauseAnim()
    FXDoorActive(false)
  elseif data == 1 then
    print("FAST TRAVEL: Summoning Door")
    subDoorObject:OnAnimationDone(thisObj, "ExitLoop", {Force = true})
    subDoorObject:JumpAnimToFrame(0)
    subDoorObject:PlayAnimToFrame(140)
    subDoorObject:SetAnimRate(2)
    doorFormObject:JumpAnimToFrame(0)
    doorFormObject:PlayAnimToFrame(140)
    doorFormObject:SetAnimRate(2)
    PointFX_IsActive(true)
  elseif data == 2 then
    print("FAST TRAVEL: Door Warp Active")
    doorFormObject:JumpAnimToFrame(141)
    subDoorObject:JumpAnimToFrame(141)
    subDoorObject:Hide()
    RealDoorIsActive(true)
    FXDoorActive(true)
    PlaySoundRockFall(151)
  elseif data == 3 then
    print("FAST TRAVEL: Canceled ")
    thisObj:ShowCollision()
    FXDoorActive(false)
    PointFX_IsActive(true)
    RealDoorIsActive(false)
    subDoorObject:Show()
    subDoorObject:PlayAnimToFrame(150)
    subDoorObject:PlayAnimToEnd()
    doorFormObject:Show()
    doorFormObject:JumpAnimToFrame(150)
    doorFormObject:PlayAnimToEnd()
    PlaySoundSelectionCanceled()
  elseif data == 4 then
    print("FAST TRAVEL: Quick Canceled ")
    thisObj:ShowCollision()
    FXDoorActive(false)
    PointFX_IsActive(true)
    RealDoorIsActive(false)
    rockParent:PlayAnimToEnd()
    rockParent:SetAnimRate(-5)
    subDoorObject:Show()
    subDoorObject:PlayAnimToEnd()
    subDoorObject:SetAnimRate(-5)
    subDoorObject:OnAnimationDone(thisObj, "Enable", {Force = true})
    doorFormObject:Show()
    doorFormObject:PlayAnimToEnd()
    subDoorObject:SetAnimRate(-5)
  end
end
function FastTravelIsUnlocked()
  player = game.Player.FindPlayer()
  if game.Level.GetVariable("CompletedCineNumber") > 183 or player:PickupIsAcquired("FastTravelStone") then
    return true
  else
    return false
  end
end
function InMidgard()
  return LD.GetCurrentRealm() == "Midgard"
end
function ResetDiscoveryState()
  ftPointIsDiscovered = false
  LD.SetMarkerState(mapMarkerID, 0)
end
function FastTravelZoneEntered()
  if not isLocked then
    if FastTravelIsUnlocked() == true then
      CheckForFastTravelArrival()
      if not ftPointIsDiscovered then
        Enable()
        CheckForDiscovery()
      else
        ForceBrokShopDiscovery()
      end
    end
  elseif lockButAllowDiscovery then
    CheckForDiscovery()
  end
end
function CheckForDiscovery()
  if mapMarkerID ~= nil then
    if CheckIfMarkerIsUndiscovered(mapMarkerID) == true then
      SetPointDiscovered()
    else
      SetPointForceDiscovered()
    end
  end
end
function ExitLoop()
  player:TriggerMoveEvent("FastTravelDoor_SummonDone")
  ClearAnimationCallbacks()
end
function FastTravelZoneExited()
  enableFTCheck = false
end
function ForceBrokShopDiscovery()
  game.Map.ChangeMarkerState(calMarkerName, tweaks.eTokenState.kDiscovered)
end
function CheckIfMarkerIsUndiscovered(marker)
  local kUndiscovered = 0
  local markerTable = game.Map.GetMarkerInfo(marker)
  local markerName = markerTable.Id
  local markerState = markerTable.State
  print("marker State isss..........................", markerState)
  if markerState == kUndiscovered then
    return true
  else
    return false
  end
end
function SetPointDiscovered()
  if FastTravelIsUnlocked() == true then
    if not ftPointIsDiscovered and InMidgard() then
      LD.SetFastTravelMarkerDiscovered(mapMarkerID)
      print("Setting FT point", mapMarkerID)
      LD.UpdateMap(mapMarkerID, 0)
      if regionSummaryQuest ~= nil and regionSummaryQuest ~= "" then
        regionSummaryQuest = string.gsub(regionSummaryQuest, "%s+", "")
        LD.ActivateAndIncrementQuest(regionSummaryQuest)
      end
      if game.Level.GetVariable("CompletedCineNumber") < 400 then
        TUT_LoadLibrary()
        TUT.FastTravelPointDiscovered()
      else
        TUT_LoadLibrary()
        TUT.FastTravelPointDiscoveredStageTwo()
      end
      ftPointIsDiscovered = true
      pointDiscoveredIntialFX:Show()
      PlaySoundOnGateDiscovered()
      PointFX_IsActive(true)
    elseif not ftPointIsDiscovered and InMidgard() == false then
      TUT_LoadLibrary()
      TUT.FastTravelPointDiscoveredStageTwo()
      LD.SetMarkerState(mapMarkerID, 1)
      LD.UpdateMap(mapMarkerID, 0)
      if regionSummaryQuest ~= nil and regionSummaryQuest ~= "" then
        regionSummaryQuest = string.gsub(regionSummaryQuest, "%s+", "")
        LD.ActivateAndIncrementQuest(regionSummaryQuest)
      end
    end
  end
end
function SetPointForceDiscovered()
  if InMidgard() then
    if regionSummaryQuest ~= nil and regionSummaryQuest ~= "" then
      regionSummaryQuest = string.gsub(regionSummaryQuest, "%s+", "")
      LD.ActivateAndIncrementQuest(regionSummaryQuest)
    end
    ftPointIsDiscovered = true
    LD.SetFastTravelMarkerDiscovered(mapMarkerID)
    PointFX_IsActive(true)
  end
end
function RealDoorIsActive(value)
  if value == true then
    if isBackInteract then
      fastTravelDoorBack:Show()
      fastTravelDoorFront:Hide()
    else
      fastTravelDoorFront:Show()
      fastTravelDoorBack:Hide()
    end
  else
    fastTravelDoorFront:Hide()
    fastTravelDoorBack:Hide()
  end
end
function FXDoorActive(value)
  if value == true then
    doorFX:Show()
    doorFX:PlayAnimCycle()
  else
    doorFX:Hide()
    doorFX:JumpAnimToFrame(0)
    doorFX:PauseAnim()
  end
end
function PointFX_IsActive(value)
  if value == true then
    if not ftPointIsDiscovered then
      pointUndiscoveredFX:Show()
      pointUndiscoveredFX:PlayAnimCycle()
      pointDiscoveredFX:Hide()
    else
      pointDiscoveredFX:Show()
      pointDiscoveredFX:PlayAnimCycle()
      pointUndiscoveredFX:Hide()
    end
    PlaySoundGateLoop()
  else
    pointUndiscoveredFX:Hide()
    pointDiscoveredFX:Hide()
    StopSoundGateLoop()
  end
end
function ClearAnimationCallbacks()
  subDoorObject:ClearAllAnimCallbacks()
end
function LuaHook_SummonDoor()
  SetVisualState(1)
end
function CheckForFastTravelArrival()
  print("Check for Fast travel arrived started")
  local bboard = player:GetPrivateBlackboard()
  if bboard and bboard:Exists("PlayerIsFastTraveling") then
    if bboard:GetBoolean("PlayerIsFastTraveling") then
      print("triggering on arrrived from fast travel")
      PlayerArrivedFromFastTraveling()
      local gbl00 = game.FindLevel("Gbl000_FastTravel")
      if gbl00 ~= nil then
        gbl00:CallScript("ClearWarpData")
      end
      FXDoorActive(false)
      RealDoorIsActive(false)
      bboard:Erase("PlayerIsFastTraveling")
      bboard:Erase("FastTravelLoadRequested")
      game.World.StoreCheckpoint()
    else
      print("player NOT arriving from fast travel")
    end
  end
end
function PlayerArrivedFromFastTraveling()
  game.Compass.OnWarp()
  print("player arrived from fast travel callback triggered")
  if thisObj:FindLuaTableAttribute("onArrivedFromFastTravel") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:GetLuaTableAttribute("onArrivedFromFastTravel"), "PlayerArrived From Fast Travel")
  end
end
function LuaHook_LoadMap()
  if not mapSelectionInProgress then
    mapSelectionInProgress = true
    if not finaleUnlocked then
      SetOverrideValues()
    end
    uiCalls_LoadLibrary()
    if mapMarkerID ~= calMarkerName then
      uiCalls.UI_Event_Open_Map_Menu_FastTravel("", engine.Hash(mapMarkerID))
    elseif mapMarkerID == calMarkerName then
      if LD.GetCurrentRealm() == "Muspelheim" then
        uiCalls.UI_Event_Open_Map_Menu_FastTravel("", engine.Hash("CALT_120_MUSP_FT"))
      elseif LD.GetCurrentRealm() == "Alfheim" then
        uiCalls.UI_Event_Open_Map_Menu_FastTravel("", engine.Hash("CALT_120_ALF_FT"))
      elseif LD.GetCurrentRealm() == "Helheim" then
        uiCalls.UI_Event_Open_Map_Menu_FastTravel("", engine.Hash("CALT_120_HELHEIM_FT"))
      elseif LD.GetCurrentRealm() == "Niflheim" then
        uiCalls.UI_Event_Open_Map_Menu_FastTravel("", engine.Hash("CALT_120_NID_FT"))
      else
        uiCalls.UI_Event_Open_Map_Menu_FastTravel("", engine.Hash(mapMarkerID))
      end
    end
  end
end
function SetOverrideValues()
  LD.SetMarkerState(calMarkerName, 1)
  if game.Level.GetVariable("CompletedCineNumber") >= 400 and game.Level.GetVariable("CompletedCineNumber") < 470 then
    LD.SetMarkerState("PP_740_FT", 2)
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 440 and game.Level.GetVariable("CompletedCineNumber") < 500 then
    LD.SetMarkerState("PP_740_FT", 2)
    if CheckIfMarkerIsUndiscovered("FOOT_250_FT") == false then
      LD.SetMarkerState("FOOT_250_FT", 2)
    end
    if CheckIfMarkerIsUndiscovered("PP_205_FT") == false then
      LD.SetMarkerState("PP_205_FT", 2)
    end
  elseif game.Level.GetVariable("CompletedCineNumber") >= 500 then
    LD.SetMarkerState("PP_740_FT", 1)
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    LD.SetMarkerState("FOR_200_FT", 1)
    LD.SetMarkerState("RP_200_FT", 1)
  end
  if game.Level.GetVariable("_GBL_WaterDrop02Triggered") == true then
    LD.SetMarkerState("RP_935_Upper_FT", 0)
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 540 then
    LD.SetMarkerState("SM_100_FT", 0)
  end
end
function EndInteraction()
  if thisObj:FindLuaTableAttribute("onFastTravelPointSelected") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:GetLuaTableAttribute("onFastTravelPointSelected"), "Point Selected")
  end
  local bboard = player:GetPrivateBlackboard()
  if bboard then
    bboard:Set("FinalDestinationMarker", finalDestinationMarkerID)
    bboard:Set("FastTravelLoadRequested", true)
    if finaleSelected then
      bboard:Set("FinaleTravel", true)
    end
  end
  SetVisualState(2)
  LoadFTWAD()
  mapSelectionInProgress = false
end
function CancelInteraction()
  mapSelectionInProgress = false
  SetVisualState(3)
  Enable()
  player:TriggerMoveEvent("Cancel_FastTravelSelect")
end
function PerformTravelInteraction()
  player:TriggerMoveEvent("Confirm_FastTravelSelect")
  if not isBackInteract then
    fastTravelDoorFront.Child:StartAnim("FastTravelDoorPushOpen")
    fastTravelDoorFront.Child:JumpAnimToPercent(0)
    fastTravelDoorBack.Child:HideCollision()
  else
    fastTravelDoorBack.Child:StartAnim("FastTravelDoorPushOpen")
    fastTravelDoorBack.Child:JumpAnimToPercent(0)
  end
end
function TriggerFastTravelPointSelected(level, gameobject, Id)
  finalDestinationMarkerID = Id
  local finaleComparisonHash = engine.Hash(finaleMarkerName)
  if finaleComparisonHash == finalDestinationMarkerID then
    finaleSelected = true
    timers_LoadLibrary()
    timers.StartLevelTimer(0.1, EndInteraction)
  else
    finaleSelected = false
    timers_LoadLibrary()
    timers.StartLevelTimer(0.1, EndInteraction)
  end
  game.FX.SubmitEffect(fastTravelMapCloseFast_FSE)
  game.FX.SubmitEffect(fastTravel_MapCloseFastExposure_FSE)
end
function TriggerFastTravelCancel(level, gameObject)
  game.FX.SubmitEffect(fastTravelMapClose_FSE)
  game.FX.SubmitEffect(fastTravel_MapCloseExposure_FSE)
  CancelInteraction()
  Enable()
end
function LoadFTWAD()
  print("LOADING FT WAD", finaleSelected, finaleUnlocked)
  if finaleSelected and finaleUnlocked then
    game.Map.LoadFastTravelWads(finaleMarkerName, thisObj)
  else
    game.Map.LoadFastTravelWads(intermediateMarkerName, thisObj)
  end
end
function OnFastTravelWadsLoaded(level)
  PerformTravelInteraction()
end
function LuaHook_TriggerWarp()
  uiCalls_LoadLibrary()
  uiCalls.UI_Global_Menu_Clear_Exclusive_Access("GlobalInWorldMenu")
  TriggerWarp()
  timers_LoadLibrary()
  timers.StartLevelTimer(0.2, FastTravelComplete)
end
function TriggerWarp()
  if finaleSelected and finaleUnlocked then
    fastTravelWad = game.FindLevel("Cal400_FinaleWorldTravel")
  else
    fastTravelWad = game.FindLevel("Gbl000_FastTravel")
  end
  local son = game.AI.FindSon()
  if son ~= nil and son:IsAvailableInLevel() and son.OwnedPOI and son.OwnedPOI.Type == "ContextAction" then
    son.OwnedPOI:SendEvent("CA_Interrupt")
  end
  if fastTravelWad ~= nil then
    fastTravelWad:CallScript("WarpIntoFastTravel")
  end
end
function LuaHook_TriggerMapFlash()
  game.FX.SubmitEffect(fastTravelMapOpen_FSE)
  game.FX.SubmitEffect(fastTravel_MapOpenExposure_FSE)
end
function LuaHook_StartFullScreenFX()
  local gbl00 = game.FindLevel("Gbl000_FastTravel")
  if gbl00 ~= nil then
    gbl00:CallScript("WarpInFSE")
  else
    game.FX.SubmitEffect(fastTravelFog_FSE)
    game.FX.SubmitEffect(fastTravelExposure_FSE)
  end
end
function LuaHook_CancelDoorAnim()
  SetVisualState(4)
end
function LuaHook_EnableFT_Interact()
  Enable()
end
function FastTravelComplete()
  Enable()
  SetVisualState(0)
end
function TempFinalRemoveItem()
  if game.Level.GetVariable("CompletedCineNumber") >= 515 and game.Wallets.HasResource("HERO_SAVEONLY", "TyrAmuletUnlock") then
    game.Wallets.RemoveResource("HERO_SAVEONLY", "TyrAmuletUnlock", 1)
    ShowNonFinaleMarkers()
  end
end
function FinaleLockCheck()
  TempFinalRemoveItem()
  local finaleResourceCount = game.Wallets.GetResourceValue("HERO_SAVEONLY", "TyrAmuletUnlock")
  if 1 <= finaleResourceCount then
    finaleUnlocked = true
    HideNonFinaleMarkers()
    timers_LoadLibrary()
    timers.StartLevelTimer(0.1, ShowFinaleMarker)
  else
    finaleUnlocked = false
    LD.SetMarkerState(finaleMarkerName, 0)
  end
end
function ShowFinaleMarker()
  LD.SetMarkerState(finaleMarkerName, 1)
end
function HideNonFinaleMarkers()
  print("HIDING NON FINALE MARKERS")
  local regionInfoTable = game.Map.GetRegionsInfoTable("Midgard")
  for _, regionInfo in ipairs(regionInfoTable) do
    local regionID = regionInfo.Id
    local regionMarkerInfoTable = game.Map.GetMarkersInfoTable(regionID)
    for _, markerInfo in ipairs(regionMarkerInfoTable) do
      local markerID = markerInfo.Id
      local markerState = markerInfo.State
      local isFT = game.Map.MarkerHasFlag(markerID, {"FastTravel"})
      local isFTnonTrack = game.Map.MarkerHasFlag(markerID, {
        "FastTravelNoTrack"
      })
      if (isFT or isFTnonTrack) and markerState == tweaks.eTokenState.kDiscovered then
        game.Map.ChangeMarkerState(markerID, tweaks.eTokenState.kDiscoveredButLocked)
      end
    end
  end
end
function ShowNonFinaleMarkers()
  print("SHOWING NON FINALE MARKERS")
  local regionInfoTable = game.Map.GetRegionsInfoTable("Midgard")
  for _, regionInfo in ipairs(regionInfoTable) do
    local regionID = regionInfo.Id
    local regionMarkerInfoTable = game.Map.GetMarkersInfoTable(regionID)
    for _, markerInfo in ipairs(regionMarkerInfoTable) do
      local markerID = markerInfo.Id
      local markerState = markerInfo.State
      local isFT = game.Map.MarkerHasFlag(markerID, {"FastTravel"})
      local isFTnonTrack = game.Map.MarkerHasFlag(markerID, {
        "FastTravelNoTrack"
      })
      if (isFT or isFTnonTrack) and markerState == tweaks.eTokenState.kDiscoveredButLocked then
        game.Map.ChangeMarkerState(markerID, tweaks.eTokenState.kDiscovered)
      end
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    isLocked = isLocked,
    calDiscovered = calDiscovered,
    ftPointIsDiscovered = ftPointIsDiscovered
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  isLocked = savedInfo.isLocked
  calDiscovered = savedInfo.calDiscovered
  ftPointIsDiscovered = savedInfo.ftPointIsDiscovered
end
local fastTravelGateEmitter
local sound_SelectionCanceledFXPlaying = false
local fastTravelGateSounds = {
  Discover = "SND_MECH_Fast_Travel_Gate_Reveal",
  GateLoop = "SND_MECH_Fast_Travel_Gate_LP",
  Build = "SND_MECH_Fast_Travel_Gate_Build",
  Cancel = "SND_MECH_Fast_Travel_Gate_Build_Cancel",
  DestroyDoor = "SND_MECH_Fast_Travel_Gate_Destroy_Door",
  DestroyRocks = "SND_MECH_Fast_Travel_Gate_Destroy_Rocks",
  RealmEnter = "SND_MECH_Fast_Travel_Gate_Realm_Enter",
  RockFall = "SND_MECH_Fast_Travel_Gate_Realm_Enter_Rock_Fall",
  OpenDoor = "SND_MECH_Fast_Travel_Gate_Realm_Enter_Door_Open"
}
function SoundInit()
  fastTravelGateEmitter = thisObj:FindSingleSoundEmitterByName("SNDFastTravelGate")
end
function PlaySoundOnGateDiscovered()
  LD.PlaySound(fastTravelGateEmitter, fastTravelGateSounds.Discover)
end
function PlaySoundGateLoop()
  LD.PlayRestartableSoundLoop(fastTravelGateEmitter, fastTravelGateSounds.GateLoop)
end
function StopSoundGateLoop()
  LD.StopRestartableSoundLoop(fastTravelGateEmitter, fastTravelGateSounds.GateLoop)
end
function PlaySoundRockFall(frame)
  LD.PlaySoundOnFrame(fastTravelGateEmitter, doorFormObject, fastTravelGateSounds.RockFall, frame, "forward")
end
function PlaySoundSelectionCanceled()
  if not sound_SelectionCanceledFXPlaying then
    sound_SelectionCanceledFXPlaying = true
    doorFormObject:OnAnimationDone(thisObj, "SoundSelectionCanceledFinished")
    LD.PlaySound(fastTravelGateEmitter, fastTravelGateSounds.DestroyRocks)
    LD.PlaySound(fastTravelGateEmitter, fastTravelGateSounds.DestroyDoor)
  end
end
function SoundSelectionCanceledFinished()
  sound_SelectionCanceledFXPlaying = false
end
function LuaHook_Sound_PlaySoundFTBuildGate()
  LD.PlaySound(fastTravelGateEmitter, fastTravelGateSounds.Build)
end
function LuaHook_Sound_PlaySoundFTOnQuickCancel()
  LD.PlaySound(fastTravelGateEmitter, fastTravelGateSounds.DestroyDoor)
  LD.PlaySoundOnFrame(fastTravelGateEmitter, doorFormObject, fastTravelGateSounds.RockFall, 150, "forward")
end
function LuaHook_Sound_PlaySoundFTOpenDoor()
  LD.PlaySound(player:FindSingleSoundEmitterByName("SNDLeftHand"), fastTravelGateSounds.OpenDoor)
end
function LuaHook_Sound_PlaySoundFTRealmEnter()
  LD.PlaySound(player:FindSingleSoundEmitterByName("SNDKratos"), fastTravelGateSounds.RealmEnter)
  game.Audio.StartMusic("SND_MX_STOP_ALL_MUSIC")
  if game.FindLevel("Msp100_Base") then
    game.Audio.StartMusicMaster("SND_MX_MSP_start_master")
  end
  if game.FindLevel("Cal050_Sound") then
    game.Audio.StartMusicMaster("SND_MX_CAL_start_master")
  end
end
