local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local lightObj
function OnScriptLoaded(level, obj)
  lightObj = obj:FindSingleGOByName("LightAnim")
end
function PlayAnim_Init(realm, monitor)
  if monitor then
    monitor:Stop()
    monitor:Terminate()
    monitor = nil
  end
  if lightObj then
    lightObj:StartAnim("cr_" .. string.lower(realm) .. "_off")
    lightObj:JumpAnimToFrame(0)
    lightObj:PauseAnim()
  end
end
function PlayAnim_ActiveLoop(realm, monitor)
  if monitor then
    monitor:Stop()
    monitor:Terminate()
    monitor = nil
  end
  if realm == "Midgard" then
    PlayAnim_Init(realm)
  elseif lightObj then
    lightObj:ClearAllAnimCallbacks()
    lightObj:StartAnim("cr_" .. string.lower(realm) .. "_active")
    lightObj:PlayAnimCycle()
  end
end
function PlayAnim_Travel(realm)
  if lightObj then
    lightObj:StartAnim("cr_" .. string.lower(realm) .. "_travel")
    lightObj:PlayAnimToEnd(0.35)
  end
end
function PlayAnim_TravelReverse(realm)
  if lightObj then
    lightObj:PlayAnimToEnd(-0.35)
    local animMonitor = monitors.CreateAnimFrameMonitor(lightObj)
    if realm == "Midgard" then
      animMonitor:OnFrame(0, function()
        PlayAnim_Init(realm, animMonitor)
      end)
    else
      animMonitor:OnFrame(0, function()
        PlayAnim_ActiveLoop(realm, animMonitor)
      end)
    end
  end
end
