local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisObj, thisLevel, bridgeType, anim, mushroomFX, animMonitor, realmController, animDoneCallbacks
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  bridgeType = obj:GetName()
  mushroomFX = obj:FindSingleGOByName("rBridge_shrooms")
  realmController = GameObjects.realm_controller_object
  if bridgeType == "worldtreebridge00" then
    anim = "bridgeExtend"
  else
    anim = "worldCrystalRaise00_extend"
  end
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  if mushroomFX then
    mushroomFX:PauseAnim()
  end
  level:PauseGlobalMaterialAnimation("wt_moss_card_anim", "bridgeMoss_grow")
  level:PauseGlobalMaterialAnimation("t_wt_root_A_anim", "wt_root_a_bridge")
  level:PauseGlobalMaterialAnimation("t_wt_root_sm_a_anim", "wt_root_sm_a_bridge")
end
function Extend(rate)
  rate = rate or 1
  rate = math.abs(rate)
  thisObj:StartAnim(anim)
  thisObj:PlayAnimToEnd(rate)
  PlaySoundOnExtend()
  if bridgeType == "worldtreebridge00" then
    if animMonitor == nil then
      animMonitor = monitors.CreateAnimFrameMonitor(thisObj)
      local animPercentage = 75
      animMonitor:OnFrameForward(thisObj.AnimLengthFrames * (animPercentage / 100), function()
        if mushroomFX then
          mushroomFX:PlayAnimToEnd(0.7)
        end
        thisLevel:PlayGlobalMaterialAnimation("wt_moss_card_anim", "bridgeMoss_grow", {Rate = 0.5})
        realmController.LuaObjectScript.HideTravelCollision()
        realmController.LuaObjectScript.ShowOutterWallCollision_All()
        local currentPressurePlate = realmController.LuaObjectScript.GetCurrentPressurePlate()
        if currentPressurePlate then
          realmController.LuaObjectScript.HideOutterWallCollision(currentPressurePlate)
        else
          realmController.LuaObjectScript.HideOutterWallCollision()
        end
        realmController.LuaObjectScript.ShowRootBridgeCollision()
        if animDoneCallbacks then
          FireCustomCallbacksOnAnimDone()
        end
      end)
    end
    thisLevel:PlayGlobalMaterialAnimation("t_wt_root_A_anim", "wt_root_a_bridge", {Rate = rate})
    thisLevel:PlayGlobalMaterialAnimation("t_wt_root_sm_a_anim", "wt_root_sm_a_bridge", {Rate = rate})
  else
    thisObj:Show()
  end
end
function RegisterCustomCallbackOnAnimDone(fn)
  if animDoneCallbacks == nil then
    animDoneCallbacks = {}
  end
  animDoneCallbacks[#animDoneCallbacks + 1] = fn
end
function FireCustomCallbacksOnAnimDone()
  if animDoneCallbacks ~= nil then
    for _, fn in pairs(animDoneCallbacks) do
      fn()
    end
    animDoneCallbacks = nil
  end
end
function Retract(rate)
  rate = rate or -3
  rate = -math.abs(rate)
  thisObj:StartAnim(anim)
  thisObj:PlayAnimToEnd(rate)
  PlaySoundOnRetract()
  if bridgeType == "worldtreebridge00" then
    if mushroomFX then
      mushroomFX:PlayAnimToEnd(rate * 2)
    end
    thisLevel:PlayGlobalMaterialAnimation("wt_moss_card_anim", "bridgeMoss_grow", {Rate = rate})
    thisLevel:PlayGlobalMaterialAnimation("t_wt_root_A_anim", "wt_root_a_bridge", {Rate = rate})
    thisLevel:PlayGlobalMaterialAnimation("t_wt_root_sm_a_anim", "wt_root_sm_a_bridge", {Rate = rate})
    realmController.LuaObjectScript.HideRootBridgeCollision()
    realmController.LuaObjectScript.ShowTravelCollision()
    realmController.LuaObjectScript.ShowOutterWallCollision_All()
    LD.ForceAxeUnembed(GameObjects.rootCollision)
  else
    local hideMonitor = monitors.CreateAnimFrameMonitor(thisObj)
    hideMonitor:OnFrameBackward(0, function()
      hideMonitor:Terminate()
      hideMonitor = nil
      thisObj:Hide()
    end)
  end
end
function Reset()
  if bridgeType == "worldtreebridge00" then
    if mushroomFX then
      mushroomFX:JumpAnimToFrame(0)
      mushroomFX:PauseAnim()
    end
    thisLevel:PlayGlobalMaterialAnimation("wt_moss_card_anim", "bridgeMoss_grow", {Rate = -15})
    realmController.LuaObjectScript.ShowTravelCollision()
    realmController.LuaObjectScript.ShowOutterWallCollision_All()
  else
    thisObj:Hide()
  end
  thisObj:StartAnim(anim)
  thisObj:JumpAnimToFrame(0)
  thisObj:PauseAnim()
end
function IsRetracted()
  return thisObj.AnimFrame == 0
end
local bridgeEmitter
local bridgeSoundEvents = {
  OnExtend = "SND_MAG_Realm_Roots_Grow_LP",
  OnRetract = "SND_MAG_Realm_Roots_Grow_LP"
}
function SoundInit()
  bridgeEmitter = thisObj.SoundEmitters[1]
end
function PlaySoundOnExtend()
  if thisObj.AnimFrame ~= thisObj.AnimLengthFrames then
    LD.PlaySound(bridgeEmitter, bridgeSoundEvents.OnExtend)
    LD.StopSoundOnFrame(bridgeEmitter, thisObj, bridgeSoundEvents.OnExtend, thisObj.AnimLengthFrames - 1, "forward")
  end
end
function PlaySoundOnRetract()
  if not IsRetracted() then
    LD.PlaySound(bridgeEmitter, bridgeSoundEvents.OnRetract)
    LD.StopSoundOnFrame(bridgeEmitter, thisObj, bridgeSoundEvents.OnRetract, 1, "backward")
  end
end
