local thisObj, player, zoneSpeedPlayer
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  zoneSpeedPlayer = obj:GetLuaTableAttribute("zoneSpeedPlayer")
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
  thisObj:SetInhibitSave()
end
function OnStart(level, obj)
  local refnode = obj.Parent
  local zoneParent = refnode.Parent
  if zoneParent ~= nil and not zoneParent.IsRefNode then
    game.SubObject.SetEntityZoneHandler(thisObj, zoneParent)
  else
    engine.Warning("SpeedControlZone refnode '", refnode:GetName(), "' must be parented under a group with zones")
  end
  if player:IsInsideEntityZone(zoneParent) then
    ConsiderSpeedControlZone()
  end
end
function OnMarkerEnterZone(level, scriptObj, zoneGameObject, markerGameObject, markerId)
  if markerGameObject == player and (game.LargeInteger.HashString(3) == markerId or game.LargeInteger.HashString(3) == game.LargeInteger.HashString(tostring(markerId))) then
    ConsiderSpeedControlZone()
  end
end
function OnMarkerExitZone(level, scriptObj, zoneGameObject, markerGameObject, markerId)
  if markerGameObject == player and (game.LargeInteger.HashString(3) == markerId or game.LargeInteger.HashString(3) == game.LargeInteger.HashString(tostring(markerId))) then
    IgnoreSpeedControlZone()
  end
end
function ConsiderSpeedControlZone()
  player:CallScript("SpeedControl_AddZone", thisObj, zoneSpeedPlayer)
end
function IgnoreSpeedControlZone()
  player:CallScript("SpeedControl_RemoveZone", thisObj)
end
