local PlayGoLibrary = require("design.PlayGoLibrary")
timer = require("level.timer")
local uiCalls, thisObj, parent
local bDetectVolumeEnter = true
local bDetectVolumeExit = false
local blockers, playgo, requiredCineNumber
local checkIfDownloaded = false
local LoadUICallsLibrary = function()
  if not uiCalls then
    uiCalls = require("ui.uicalls")
  end
end
function PlaygoDownloadComplete()
  checkIfDownloaded = false
  LoadComplete()
end
function PlaygoDialogBackOut()
  checkIfDownloaded = true
  timer.StartLevelTimer(1, IsPlaygoDownloadedCheck)
end
function IsPlaygoDownloadedCheck()
  if checkIfDownloaded then
    if IsLoaded() == false then
      timer.StartLevelTimer(1, IsPlaygoDownloadedCheck)
    else
      LoadComplete()
    end
  end
end
local DisplayProgressBar = function()
  LoadUICallsLibrary()
  uiCalls.UI_Event_PlaygoDownloading(playgo, thisObj)
end
local HideProgressBar = function()
  LoadUICallsLibrary()
  uiCalls.UI_Event_Turn_off_PlaygoDownloading()
end
function IsLoaded()
  return PlayGoLibrary.IsLoaded(playgo)
end
local IsPlayerMarker = function(markerId)
  local hs3 = game.LargeInteger.HashString(3)
  return hs3 == markerId or hs3 == game.LargeInteger.HashString(tostring(markerId))
end
local ShowBlockers = function()
  for _, v in ipairs(blockers) do
    v:Show()
  end
end
local HideBlockers = function()
  for _, v in ipairs(blockers) do
    v:Hide()
  end
end
function OnScriptLoaded(level, obj)
  thisObj = obj
  parent = obj.Parent.Parent
  blockers = parent:FindGOsByName(tostring(obj:GetLuaTableAttribute("SiblingBlockerName")) .. "*")
  playgo = obj:GetLuaTableAttribute("BlockingPlayGoName")
  requiredCineNumber = PlayGoLibrary.RequiredCineNumber[playgo]
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  local PrepareForZoneEntry = function()
    parent:ShowEntityVolume()
    HideBlockers()
    bDetectVolumeEnter = true
    game.SubObject.SetEntityZoneHandler(thisObj, parent)
  end
  local player = game.Player.FindPlayer()
  if player:InsideZone(parent) then
    bDetectVolumeEnter = true
    OnMarkerEnterZone(level, obj, parent, player, 3)
  else
    PrepareForZoneEntry()
  end
end
function OnMarkerEnterZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  local OnMarkerEnterZone_Validate = function(markerId)
    if bDetectVolumeEnter ~= true then
      return false
    end
    if IsPlayerMarker(markerId) == false then
      return false
    end
    if requiredCineNumber ~= nil and game.Level.GetVariable("CompletedCineNumber") < requiredCineNumber then
      return false
    end
    return true
  end
  if OnMarkerEnterZone_Validate(markerId) == false then
    return false
  end
  bDetectVolumeEnter = false
  if IsLoaded() == false then
    DisplayProgressBar()
    ShowBlockers()
    bDetectVolumeExit = true
  else
    LoadComplete()
  end
end
function LoadComplete()
  game.SetPlayGoRequired(playgo)
  HideBlockers()
  parent:HideEntityVolume()
  bDetectVolumeEnter = false
  bDetectVolumeExit = false
  PlayGoLibrary = nil
  checkIfDownloaded = false
  if uiCalls then
    uiCalls = nil
  end
end
function OnMarkerExitZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  local OnMarkerExitZone_Validate = function(markerId)
    if bDetectVolumeExit ~= true then
      return false
    end
    if IsPlayerMarker(markerId) == false then
      return false
    end
    return true
  end
  if OnMarkerExitZone_Validate(markerId) == false then
    return
  end
  checkIfDownloaded = false
  bDetectVolumeExit = false
  bDetectVolumeEnter = true
end
