local LD = require("design.LevelDesignLibrary")
local Son, thisLevel, thisGO, breakable
local droppedLoot = false
local propName, onDestructionEvent, visuals
function OnScriptLoaded(level, obj)
  Son = game.AI.FindSon()
  thisLevel = level
  thisGO = obj
  breakable = obj:GetBreakable()
  propName = obj:GetLuaTableAttribute("PropName")
  if obj:FindLuaTableAttribute("OnDestructionEvent") ~= nil then
    onDestructionEvent = LD.ExtractCallbacksForEvent(thisLevel, thisGO, obj:FindLuaTableAttribute("OnDestructionEvent"))
  end
  visuals = thisGO:FindSingleGOByName("barrelVisuals")
  thisGO:SetInhibitSave()
  game.SubObject.SetForgetOnCheckpoint(obj)
  game.SubObject.Sleep(thisGO)
  SoundInit()
end
function OnStart(level, obj)
  BoatLoot_CheckForWaterLevel()
end
function OnBreakableBroken(level, obj)
  if breakable.Broken == true and droppedLoot == false then
    if thisGO:FindLuaTableAttribute("OnDestructionEvent") ~= nil then
      LD.ExecuteCallbacksForEvent(thisLevel, thisGO, onDestructionEvent, "OnDestructionEvent")
    end
    game.Loot.RollCondition("CORPSE_COMMON_TIER2", "HERO")
    droppedLoot = true
    StopSoundIdleLoop()
    PlaySoundBreak()
    visuals:Hide()
  end
end
function OnInteractStart(level, obj, creature)
  local sonInBoat = Son:IsInVehicle()
  if sonInBoat == true then
    Son:ForceMove("BRA_BoatReachDownEnter")
  end
  droppedLoot = true
end
function OnInterectPreBoatPickup(level, obj, creature)
  obj:SpawnProp(propName, Son:GetWorldPosition())
  game.Loot.CollectLootReward("HERO", "CommonChestReward")
end
function BoatLoot_CheckForWaterLevel()
  local waterLevel = thisGO:FindLuaTableAttribute("waterLevel")
  if waterLevel then
    if waterLevel == "2" and game.Level.GetVariable("_GBL_WaterDrop02Triggered") then
      Enable()
    elseif waterLevel == "1" and game.Level.GetVariable("_GBL_WaterDrop01Triggered") and not game.Level.GetVariable("_GBL_WaterDrop02Triggered") then
      Enable()
    else
      Disable()
    end
  else
    Enable()
  end
end
function Disable()
  thisGO:Hide()
  StopSoundIdleLoop()
  print("disabling boat breakable pickup")
end
function Enable()
  thisGO:Show()
  PlaySoundIdleLoop()
  print("enabling boat breakable pickup")
end
local soundEvents = {
  SoundEmitter = nil,
  isLooping = false,
  LoopIdle = "SND_BRK_Wood_Barrel_Float_Water_Laps_LP",
  OnBreak = "SND_BRK_Wood_Barrel_Explo"
}
function SoundInit()
  soundEvents.SoundEmitter = thisGO:FindSingleSoundEmitterByName("SNDBarrel")
  print("soundiniting boat breakable pickup", thisGO)
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEvents.SoundEmitter = thisGO:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key, value in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(value))
    end
  end
end
function PlaySoundIdleLoop()
  LD.PlayRestartableSoundLoop(soundEvents.SoundEmitter, soundEvents.LoopIdle)
  print("i should be playing a sound loop of a barrel floating")
end
function StopSoundIdleLoop()
  LD.StopRestartableSoundLoop(soundEvents.SoundEmitter, soundEvents.LoopIdle)
end
function PlaySoundBreak()
  LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnBreak)
end
