local LD = require("design.LevelDesignLibrary")
local Son, frontInteractZone, thisObj, thisLevel, SonPosition, ObjPosition, sonLeft, LootToSon, rarity, rewardTier, rewardTierIndex, WADName, propObject
local enabled = true
local lookAtEmitter
function OnScriptLoaded(level, obj)
  Son = game.AI.FindSon()
  thisObj = obj
  thisLevel = level
  frontInteractZone = game.InteractZone.New(obj, "promptJointFront")
  if frontInteractZone.SetAsInteractFromBoat then
    frontInteractZone:SetAsInteractFromBoat()
  end
  frontInteractZone:SetAngle(360)
  frontInteractZone:SetXZRange(10)
  frontInteractZone:SetOnScreenPercent(0.1)
  rarity = obj:FindLuaTableAttribute("Rarity") or "Rare"
  rewardTier = obj:FindLuaTableAttribute("RewardTier") or 0
  rewardTierIndex = obj:FindLuaTableAttribute("RewardTierIndex") or 0
  WADName = obj:FindLuaTableAttribute("WADName") or "TB"
  lookAtEmitter = thisObj:FindSingleGOByName("_LookAtEmitter")
  SoundInit()
  PlaySoundIdleLoop()
  game.SubObject.SetUpdateDisableDistance(thisObj, 20)
end
function OnStart(level, obj)
  if enabled then
    Enable()
  else
    Disable()
  end
end
function OnUpdate(level, obj)
  if enabled and frontInteractZone:IsDisabled() and game.Interact.IsTagSetFiltered("NotAllowedOnBoat") then
    frontInteractZone:Enable()
  elseif frontInteractZone:IsEnabled() and not game.Interact.IsTagSetFiltered("NotAllowedOnBoat") then
    frontInteractZone:Disable()
  end
end
function OnUseWorld(level, obj)
  if frontInteractZone:CanInteract() then
    local lootObjectSpawnArgs = {
      SpawnObject = "goLootPouchWater",
      HookName = "WaterPouchSpawned",
      OffSetPosition = Son:GetWorldPosition() + engine.Vector.New(0, -5, 0),
      Level = game.Level.GetPermLevel()
    }
    print("Calling spawn loot.")
    obj:SpawnGameObject(lootObjectSpawnArgs)
  end
end
function WaterPouchSpawned(level, go, spawnedObject)
  propObject = spawnedObject
  Son:RequestInteract(go, {InteractZone = frontInteractZone, LerpObject = spawnedObject})
end
function OnInteractStart(level, go, creature)
  Son = game.AI.FindSon()
  SonPosition = Son:GetWorldPosition()
  ObjPosition = thisObj:GetWorldPosition()
  sonLeft = Son:GetWorldLeft()
  LootToSon = SonPosition - ObjPosition
  local DotToLoot = LootToSon:Dot(sonLeft)
  enabled = false
  game.SubObject.Sleep(thisObj)
  frontInteractZone:Disable()
  engine.Print("Son interact starting.")
  engine.Print("Interact zone location is ", frontInteractZone)
  engine.Print("Son position = ", SonPosition)
  engine.Print("Son left is = ", sonLeft)
  engine.Print("Object position = ", ObjPosition)
  if 0 < DotToLoot then
    Son:ForceMove("BRA_BoatReachDownLEnter")
    engine.Print("Reach down left")
    engine.Print("Dot to loot = ", DotToLoot)
    StopSoundIdleLoop()
  else
    Son:ForceMove("BRA_BoatReachDownEnter")
    engine.Print("Reach down right")
    engine.Print("Dot to loot = ", DotToLoot)
    StopSoundIdleLoop()
  end
  local waterFX = thisObj:FindSingleGOByName("BioLume_PickupArea1")
  if waterFX ~= nil then
    LD.HideFX(waterFX)
  end
  DisableAllSonAwareness()
end
function OnInteractFinish(level, obj, creature)
  print("got interact finish msg")
  LD.ExtractAndExecuteCallbacksForEvent(level, thisObj, thisObj:FindLuaTableAttribute("OnInteractFinish"), "Interact Completed Succesfully on Boat Pickup")
  game.SubObject.SoftSave(thisObj)
  thisObj:Hide()
end
function LuaHook_AwardLoot()
  local rewardName = "BOAT_" .. rarity .. "_TIER"
  LD.RollContainerConditionLoot(rewardName, rewardTier, WADName, rewardTierIndex, thisObj:GetName() .. "water")
end
function LuaHook_TouchWater()
  LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("OnPickup"), "WaterTouched in Boat Pickup")
end
function LuaHook_DestroyObject()
  if propObject then
    propObject:Destroy()
  end
end
function Disable()
  enabled = false
  thisObj:Hide()
  frontInteractZone:Disable()
  DisableAllSonAwareness()
  local waterFX = thisObj:FindSingleGOByName("BioLume_PickupArea1")
  if waterFX ~= nil then
    LD.HideFX(waterFX)
  end
end
function Enable()
  enabled = true
  thisObj:Show()
  frontInteractZone:Enable()
  EnableAllSonAwareness()
end
function OnSaveCheckpoint(level, obj)
  return {enabled = enabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
function OnAwarenessZoneEnter()
  local keepBanterOnCooldown = math.random(0, 10) <= 3
  if keepBanterOnCooldown then
    game.Audio.SetBanterFact("boatLootCooldown", keepBanterOnCooldown, 75)
  end
  game.Audio.PlayBanterNonCritical("ca_boatloot_notice")
end
function DisableAllSonAwareness()
  lookAtEmitter.LuaObjectScript.DisableEventEmitter()
end
function EnableAllSonAwareness()
  lookAtEmitter.LuaObjectScript.EnableEventEmitter()
end
local soundEvents = {
  SoundEmitter = nil,
  isLooping = false,
  LoopIdle = "",
  OnPickup = ""
}
function SoundInit()
  soundEvents.SoundEmitter = thisObj:FindSingleSoundEmitterByName("SNDBoatPickup")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEvents.SoundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key, value in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(value))
    end
  end
end
function PlaySoundIdleLoop()
  LD.PlaySound(soundEvents.SoundEmitter, soundEvents.LoopIdle)
end
function StopSoundIdleLoop()
  LD.StopSound(soundEvents.SoundEmitter, soundEvents.LoopIdle)
  LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnPickup)
end
