local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, rewardTier, rewardTierIndex, WADName, enableLight
local enabled = false
local rarity = "LEGENDARY"
local pluckedObject, treeVisual, Event_OnComplete
local awarenessEmitter = {lookAt = nil, point = nil}
local entityEvents = {point = nil, boatContext = nil}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  rewardTier = obj:FindLuaTableAttribute("RewardTier") or 0
  rewardTierIndex = obj:FindLuaTableAttribute("RewardTierIndex") or 0
  WADName = obj:FindLuaTableAttribute("WADName")
  if WADName == nil or WADName == "" then
    WADName = "TB"
  end
  enabled = obj:FindLuaTableAttribute("StartEnabled")
  enableLight = obj:FindLuaTableAttribute("EnableLight")
  pluckedObject = obj:FindSingleGOByName("PickedObject").Child
  treeVisual = obj.Parent.Parent:FindSingleGOByName("TreeVisual").Child
  Event_OnComplete = obj:FindLuaTableAttribute("Event_OnComplete")
  if Event_OnComplete then
    Event_OnComplete = LD.ExtractCallbacksForEvent(level, obj, Event_OnComplete)
  end
  awarenessEmitter.lookAt = thisObj:FindSingleGOByName("BoatPluck_LookAtEmitter")
  awarenessEmitter.point = thisObj:FindSingleGOByName("BoatPluck_PointEvent")
  entityEvents.point = thisObj:FindSingleGOByName("EntityEvents_TriggerPoint")
  entityEvents.boatContext = thisObj:FindSingleGOByName("EntityEvents_BoatContext")
  treeVisual:HideLights()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if not enabled then
    Disable()
    pluckedObject:Hide()
    return
  end
  if enableLight then
    treeVisual:ShowLights()
  end
end
function OnSaveCheckpoint(level, obj)
  return {enabled = enabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
function Disable()
  local marker = thisObj:FindSingleGOByName("PluckMarker")
  if marker then
    marker:Destroy()
  end
  enabled = false
  DisableAllSonAwareness()
end
function LuaHook_StartInteract()
  pluckedObject:RegisterAsProp("pluckObject")
  Disable()
end
function LuaHook_AwardLoot()
  local rewardName = "BOAT_" .. rarity .. "_TIER"
  LD.RollContainerConditionLoot(rewardName, rewardTier, WADName, rewardTierIndex, thisObj:GetName() .. "water")
  pluckedObject:Hide()
  if enableLight then
    treeVisual:HideLights()
  end
  game.SubObject.SoftSave(thisObj)
end
function LuaHook_BoatPluck_EndInteract()
  if Event_OnComplete then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, Event_OnComplete)
  end
end
function TriggerPointEvent()
  local son = game.AI.FindSon()
  if son and son:IsAvailableInLevel() and game.Boat.GetPlayerBoat() then
    awarenessEmitter.point.LuaObjectScript.Trigger()
    entityEvents.point.Parent:Hide()
  end
end
function StartSonAwareness()
  awarenessEmitter.lookAt.LuaObjectScript.EnableEventEmitter()
end
function DisableAllSonAwareness()
  awarenessEmitter.lookAt.LuaObjectScript.DisableEventEmitter()
  entityEvents.boatContext.LuaObjectScript.Disable()
  entityEvents.boatContext.Parent:Hide()
end
function StartBoatContext()
end
function EndBoatContext()
end
