local LD = require("design.LevelDesignLibrary")
local isBroken = false
local thisLevel, thisGO, playerRef, breakable
local droppedLoot = false
local potType, onDestructionEvent
function OnScriptLoaded(level, go)
  thisLevel = level
  thisGO = go
  breakable = go:GetBreakable()
  potType = go:GetLuaTableAttribute("PotType")
  onDestructionEvent = go:GetLuaTableAttribute("OnDestructionEvent")
  onDestructionEvent = LD.ExtractCallbacksForEvent(thisLevel, thisGO, onDestructionEvent)
  game.SubObject.Sleep(thisGO)
  game.SubObject.SetForgetOnCheckpoint(thisGO)
end
function OnBreakableBroken(level, go)
  if breakable.Broken == true and droppedLoot == false then
    if thisGO:FindLuaTableAttribute("OnDestructionEvent") ~= nil then
      LD.ExecuteCallbacksForEvent(thisLevel, thisGO, onDestructionEvent, "OnDestructionEvent")
    end
    if potType == "Money" then
      local amount = math.random(1, 10)
      game.Wallets.AddResource("HERO", "Hacksilver", amount, thisGO:GetName(), "BreakablePots")
      droppedLoot = true
    elseif potType == "Health" then
      local spawnArgs = {
        SpawnObject = "golootGenericHealthRune",
        DisablePointTestMarkers = true,
        OffsetPosition = thisGO:GetWorldPosition() + engine.Vector.New(0, 0.3, -0.5),
        Level = game.Level.GetPermLevel(),
        CullDistance = 100
      }
      go:SpawnGameObject(spawnArgs)
      droppedLoot = true
    else
      game.Wallets.AddResource("HERO", "Hacksilver", 1, thisGO:GetName(), "BreakablePots")
      droppedLoot = true
    end
  end
end
