local LD = require("design.LevelDesignLibrary")
local FFB_OnBreak = {EffectName = "FFB_MEDIUM", Duration = 1}
local FSE_OnBreak = {
  Name = "FSE_SHAKE_GENERIC_VERYSMALL",
  Duration = 1.5,
  TweenIn = {Time = 0},
  TweenOut = {Time = 0.2}
}
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function Enable(obj)
  obj.Child:SetInhibitSave()
  obj.Child:JumpAnimToFrame(math.random(0, obj.Child.AnimLengthFrames))
  obj.Child:PlayAnimCycle()
  obj.Child:Show()
  local breakable = obj.Child:FindSingleGOByName("Breakable")
  breakable:ShowBehaviors()
  breakable:ShowCollision()
  breakable:SetInhibitSave()
  breakable:Show()
  obj:SetInhibitSave()
  obj:Show()
  PlaySoundIdleLoop(obj)
end
function Disable(obj)
  obj:Hide()
  obj.Child:PauseAnim()
  local breakable = obj.Child:FindSingleGOByName("Breakable")
  breakable:HideBehaviors()
  breakable:HideCollision()
  StopSoundIdleLoop(obj)
end
function OnBreakableBroken(level, obj)
  if obj:FindLuaTableAttribute("OnDestructionEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, obj:FindLuaTableAttribute("OnDestructionEvent"), "CalderaBoatLoot_Barrel_Manager")
  end
  game.Loot.RollCondition("CORPSE_COMMON_TIER2", "HERO")
  StopSoundIdleLoop(obj)
  PlaySoundBreak(obj)
  game.FX.SubmitEffect(FFB_OnBreak)
  game.Blender.Trigger(FSE_OnBreak)
end
local soundEvents = {
  LoopIdle = "SND_BRK_Wood_Barrel_Float_Water_Laps_LP",
  OnBreak = "SND_BRK_Wood_Barrel_Explo"
}
function PlaySoundIdleLoop(obj)
  local emitter = obj:FindSingleSoundEmitterByName("SNDBarrel")
  LD.PlayRestartableSoundLoop(emitter, soundEvents.LoopIdle)
end
function StopSoundIdleLoop(obj)
  local emitter = obj:FindSingleSoundEmitterByName("SNDBarrel")
  LD.StopRestartableSoundLoop(emitter, soundEvents.LoopIdle)
end
function PlaySoundBreak(obj)
  local emitter = obj:FindSingleSoundEmitterByName("SNDBarrel")
  LD.PlaySound(emitter, soundEvents.OnBreak)
end
