local LD = require("design.LevelDesignLibrary")
local thisLevel, thisObj, son
local lootObjectOffset = engine.Vector.New(0, -5, 0)
local lootObjectSpawnArgs = {
  SpawnObject = "goLootPouchWater",
  HookName = "WaterPouchSpawned",
  Level = game.Level.GetPermLevel()
}
local lootObject_Spawned, lootObject_Broken
local FFB_OnBreak = {EffectName = "FFB_MEDIUM", Duration = 1}
local FSE_OnBreak = {
  Name = "FSE_SHAKE_GENERIC_VERYSMALL",
  Duration = 1.5,
  TweenIn = {Time = 0},
  TweenOut = {Time = 0.2}
}
local IsSonSick = function()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 360 <= cineNumber and cineNumber <= 390 then
    return true
  end
  return false
end
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function Enable(obj)
  local corpseVisual = obj.Child:FindSingleGOByName("visuals")
  if math.random(0, 1) == 1 then
    corpseVisual:SetCharacterConfig("Body2")
  else
    corpseVisual:SetCharacterConfig("Body1")
  end
  corpseVisual:StartAnim("navFloatingIdle00")
  corpseVisual:JumpAnimToFrame(math.random(0, corpseVisual.AnimLengthFrames))
  corpseVisual:PlayAnimCycle()
  corpseVisual:SetInhibitSave()
  corpseVisual:Show()
  local breakable = obj.Child:FindSingleGOByName("Breakable")
  breakable:ShowBehaviors()
  breakable:ShowCollision()
  breakable:SetInhibitSave()
  breakable:Show()
  obj:SetInhibitSave()
  obj:Show()
end
function Disable(obj)
  obj:Hide()
  local breakable = obj.Child:FindSingleGOByName("Breakable")
  breakable:HideBehaviors()
  breakable:HideCollision()
  local corpseVisual = obj.Child:FindSingleGOByName("visuals")
  corpseVisual:PauseAnim()
  corpseVisual:Hide()
end
function OnBreakableBroken(level, obj)
  local corpseVisual = obj:FindSingleGOByName("visuals")
  corpseVisual:StartAnim("navFloatingSink")
  corpseVisual:PlayAnimToEnd()
  lootObject_Broken = obj
  game.FX.SubmitEffect(FFB_OnBreak)
  game.Blender.Trigger(FSE_OnBreak)
  PlaySoundBreak(lootObject_Broken)
  if game.Boat.GetPlayerBoat() ~= nil and IsSonSick() == false then
    StartSonMove()
    return
  end
  LuaHook_AwardLoot()
  LuaHook_DestroyObject()
end
function StartSonMove()
  lootObjectSpawnArgs.OffsetPosition = son:GetWorldPosition() + lootObjectOffset
  thisObj:SpawnGameObject(lootObjectSpawnArgs)
end
function WaterPouchSpawned(level, go, spawnedObject)
  lootObject_Spawned = spawnedObject
  thisObj:SetWorldPosition(lootObject_Broken:GetWorldPosition())
  son:RequestInteract(thisObj, {LerpObject = lootObject_Spawned})
end
function OnInteractStart(level, go, creature)
  if (son:GetWorldPosition() - lootObject_Spawned:GetWorldPosition()):Dot(son:GetWorldLeft()) > 0 then
    son:ForceMove("BRA_BoatReachDownLEnter")
  else
    son:ForceMove("BRA_BoatReachDownEnter")
  end
end
function LuaHook_AwardLoot()
  local rewardTier = lootObject_Broken:FindLuaTableAttribute("RewardTier") or 0
  local rewardTierIndex = lootObject_Broken:FindLuaTableAttribute("RewardTierIndex") or 0
  LD.RollContainerConditionLoot("BOAT_COMMON_TIER", rewardTier, "Cal200_Shore", rewardTierIndex, lootObject_Broken:GetName())
end
function LuaHook_DestroyObject()
  if lootObject_Broken:FindLuaTableAttribute("PickupCallbacks") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, lootObject_Broken:FindLuaTableAttribute("PickupCallbacks"), "CalderaBoatLoot_Corpse_Manager")
  end
  if lootObject_Spawned ~= nil then
    lootObject_Spawned:Destroy()
  end
  lootObject_Spawned = nil
  lootObject_Broken = nil
end
local soundEvents = {
  OnBreak = "SND_VEH_Boat_Hit"
}
function PlaySoundBreak(obj)
  local emitter = obj:FindSingleSoundEmitterByName("SNDCorpseWater")
  LD.PlaySound(emitter, soundEvents.OnBreak)
end
