local LD = require("design.LevelDesignLibrary")
local active_group
local last_index = math.random(0, 2)
local type_managers = {
  corpses = GameObjects.CalderaBoatLoot_Corpse_Manager,
  barrels = GameObjects.CalderaBoatLoot_Barrel_Manager
}
local waterLevelGroups = {
  [1] = {
    {
      corpses = GameObjects.CalderaBoatLoot_WaterLevel1_Group1_Corpses,
      barrels = GameObjects.CalderaBoatLoot_WaterLevel1_Group1_Barrels
    },
    {
      corpses = GameObjects.CalderaBoatLoot_WaterLevel1_Group2_Corpses,
      barrels = GameObjects.CalderaBoatLoot_WaterLevel1_Group2_Barrels
    },
    {
      corpses = GameObjects.CalderaBoatLoot_WaterLevel1_Group3_Corpses,
      barrels = GameObjects.CalderaBoatLoot_WaterLevel1_Group3_Barrels
    }
  },
  [2] = {
    {
      corpses = GameObjects.CalderaBoatLoot_WaterLevel2_Group1_Corpses,
      barrels = GameObjects.CalderaBoatLoot_WaterLevel2_Group1_Barrels
    },
    {
      corpses = GameObjects.CalderaBoatLoot_WaterLevel2_Group2_Corpses,
      barrels = GameObjects.CalderaBoatLoot_WaterLevel2_Group2_Barrels
    },
    {
      corpses = GameObjects.CalderaBoatLoot_WaterLevel2_Group3_Corpses,
      barrels = GameObjects.CalderaBoatLoot_WaterLevel2_Group3_Barrels
    }
  }
}
local EnableGroup = function(g)
  active_group = g
  for t, set in pairs(g) do
    for _, child in ipairs(set.Children) do
      type_managers[t].LuaObjectScript.Enable(child)
    end
  end
end
local DisableGroup = function(g)
  for t, set in pairs(g) do
    for _, child in ipairs(set.Children) do
      type_managers[t].LuaObjectScript.Disable(child)
    end
  end
end
function Enable(waterLevel)
  Disable()
  if waterLevel == nil then
    waterLevel = LD.GetCurrentWaterLevel()
  end
  if type(waterLevel) ~= "number" or waterLevel < 1 or 2 < waterLevel then
    return
  end
  local waterLevelGroup = waterLevelGroups[waterLevel]
  last_index = (last_index + math.random(1, #waterLevelGroup - 1)) % #waterLevelGroup
  local group = waterLevelGroup[last_index + 1]
  EnableGroup(group)
end
function Disable()
  if active_group ~= nil then
    DisableGroup(active_group)
    active_group = nil
  else
    for _, waterLevelGroup in ipairs(waterLevelGroups) do
      for _, group in ipairs(waterLevelGroup) do
        DisableGroup(group)
      end
    end
  end
end
function OnBreakableBroken(level, obj)
  local IsBoatLootBreakable = function(obj)
    local t = obj.Parent:FindLuaTableAttribute("CalderaBoatLootType")
    if t then
      return true, t
    end
    return false, nil
  end
  local isBoatLoot, t = IsBoatLootBreakable(obj)
  if isBoatLoot == false then
    return false
  end
  type_managers[t].LuaObjectScript.OnBreakableBroken(level, obj.Parent)
end
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
