local LD = require("design.LevelDesignLibrary")
local player, thisObj, parent, latchBreakable, ropeJointIndex, tendrilBreakable
local destroyed = false
local includeScreenShake, includeControllerVibration
local offsetVector = engine.Vector.New(0, -0.2, 0)
local isFalling = false
local spawnedLoot
function OnScriptLoaded(level, obj)
  thisObj = obj
  parent = obj.Parent
  includeScreenShake = obj:GetLuaTableAttribute("includeScreenShake")
  includeControllerVibration = obj:GetLuaTableAttribute("includeControllerVibration")
  latchBreakable = parent:FindSingleGOByName("s_hook_breakable")
  tendrilBreakable = parent:FindSingleGOByName("TendrilBreakable")
  if latchBreakable ~= nil then
    if latchBreakable.IsRefNode then
      latchBreakable = latchBreakable.Child
    end
    ropeJointIndex = parent:FindJointIndex("animGroup_Rope_VisOff")
    latchBreakable.LuaObjectScript.OnBroken(LatchBroken)
  end
  if tendrilBreakable ~= nil then
    tendrilBreakable.LuaObjectScript.RegisterHitCallback(LatchBroken)
    offsetVector.y = -0.4
  end
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
end
function OnStart(level, obj)
  if destroyed then
    if parent then
      parent:HideBehaviors()
      parent:HideCollision()
      parent:Hide()
    end
    if latchBreakable then
      latchBreakable.LuaObjectScript.HideBreakableBehavior()
      latchBreakable:Hide()
    end
    if tendrilBreakable then
      tendrilBreakable.LuaObjectScript.TendrilDestroyed(true)
      tendrilBreakable:HideBehaviors()
      tendrilBreakable:HideCollision()
      tendrilBreakable:Hide()
    end
    thisObj:HideBehaviors()
    thisObj:HideCollision()
    thisObj:Hide()
  end
  SoundOnStart()
end
function OnUpdate(level, obj)
  if isFalling then
    local startCheckPos = obj:GetWorldJointPosition(obj:GetJointIndex("Pristine"))
    local hitCheck = game.World.RaycastCollision(startCheckPos, startCheckPos + offsetVector, {SourceGameObject = obj})
    if hitCheck then
      HitGround()
    end
  end
end
function HitGround()
  isFalling = false
  BreakBreakable()
  game.SubObject.Sleep(thisObj)
end
function BreakBreakable()
  local brk = thisObj:GetBreakable()
  if brk.Broken == false then
    brk:Break()
  end
end
function OnBreakableBroken(level, obj)
  parent:PlayAnimToEnd()
  TriggerEffect()
  if latchBreakable then
    parent:HideJoint(ropeJointIndex)
    if latchBreakable:GetBreakable().Broken == false then
      latchBreakable.LuaObjectScript.OnBreakableBroken(level, latchBreakable)
      latchBreakable.LuaObjectScript.Disable()
    end
  end
  if destroyed == false then
    destroyed = true
    local levelCount = level:PoolCount("golootHangingPouch")
    local permCount = game.Level.GetPermLevel():PoolCount("golootHangingPouch")
    if 0 < levelCount or 0 < permCount then
      local useLevel = levelCount ~= 0 and levelCount ~= permCount
      local spawnLevel = useLevel and level or game.Level.GetPermLevel()
      local lootSpawnPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("Broken1"))
      local spawnArgs = {
        SpawnObject = "golootHangingPouch",
        OffsetPosition = lootSpawnPos,
        CullDistance = 100,
        Level = spawnLevel
      }
      thisObj:SpawnGameObject(spawnArgs)
    end
    game.SubObject.SoftSave(thisObj)
  end
end
function OnHitByArrow(level, go, arrow_owner, arrow_go, arrow_tweak)
end
function LatchBroken()
  if destroyed == false then
    isFalling = true
    game.SubObject.Wake(thisObj)
    StartSafetyCheckTimer()
    parent:PlayAnimToEnd()
    thisObj:ShowPhysics()
    if latchBreakable then
      parent:HideJoint(ropeJointIndex)
    end
    if tendrilBreakable ~= nil then
      tendrilBreakable.LuaObjectScript.TendrilDestroyed()
      LD.CallFunctionAfterDelay(function()
        tendrilBreakable:Hide()
      end, 0.85)
    end
  end
end
function StartSafetyCheckTimer()
  LD.CallFunctionAfterDelay(HitGround, 3)
end
function TriggerEffect()
  if includeScreenShake then
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_SMALL",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.2}
    })
  end
  if includeControllerVibration then
    local rumbleParams = {EffectName = "FFB_MEDIUM", Duration = 0.5}
    game.FX.SubmitEffect(rumbleParams)
  end
end
function OnSaveCheckpoint(level, obj)
  return {destroyed = destroyed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  destroyed = savedInfo.destroyed
end
local tendrilSoundOverrides = {
  IdleLoop = "SND_BRK_Hive_Loot_Tendril_LP",
  OnOpen = "SND_BRK_Hive_Loot_Tendril_Break"
}
function SoundOnStart()
  if tendrilBreakable ~= nil then
    tendrilBreakable.LuaObjectScript.SoundSetup(tendrilSoundOverrides)
  end
end
