local LD = require("design.LevelDesignLibrary")
local chestScript
function OnScriptLoaded(level, obj)
  chestScript = obj:FindSingleGOByName("ChestObj").Child:FindSingleGOByName("ChestScript")
  if chestScript.IsRefNode then
    chestScript = chestScript.Child
  end
  assert(chestScript)
  LD.ForwardUserFunctionToObject(obj, chestScript)
  chestScript = chestScript.LuaObjectScript
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if chestScript then
    if chestScript.GetState() == chestScript.GetPossibleStates().OPENED then
      local breakable = obj:FindSingleGOByName("breakableRoots")
      if breakable then
        breakable:Destroy()
      end
    end
    chestScript.PlaySoundChestIdle_Roots()
  end
end
function RootsBroken()
  chestScript.StopSoundChestIdle_Roots()
  chestScript.UnlockChest()
end
