local LD = require("design.LevelDesignLibrary")
local thisLevel, thisObj, player, son, LootObject, idleFX_Sparkle, regionSummaryQuest, frontInteractZone, interactionOnStart, interactionOnFinish, artifactType, uniqueResource, pickupType, typeSpecificData, state
local states = {
  ENABLED = 1,
  DISABLED = 2,
  ACQUIRED = 3
}
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  LootObject = thisObj.Parent.Parent:FindSingleGOByName("LootObject")
  idleFX_Sparkle = thisObj.Parent.Parent:FindSingleGOByName("ArtifactMaskFX")
  artifactType = obj:FindLuaTableAttribute("ArtifactType")
  pickupType = obj:FindLuaTableAttribute("PickupType")
  regionSummaryQuest = thisObj:FindLuaTableAttribute("regionSummaryQuest")
  frontInteractZone = LD.CreateInteractZone_LootPickup_360(LootObject.Child, "zeroJoint")
  frontInteractZone:SetTags("CarryActive")
  if artifactType == "Lambs Cress" then
    frontInteractZone:SetHintXZRange(5)
  end
  local startEnabled = obj:GetLuaTableAttribute("StartEnabled")
  interactionOnStart = obj:FindLuaTableAttribute("interactionOnStart")
  interactionOnFinish = obj:FindLuaTableAttribute("interactionOnFinish")
  uniqueResource = obj:FindLuaTableAttribute("ArtifactUniqueName")
  local useLOSTest = thisObj:GetLuaTableAttribute("UseLineOfSightTest")
  if useLOSTest and frontInteractZone then
    frontInteractZone:SetEnableLineOfSightTest(true)
  end
  if interactionOnStart ~= nil then
    interactionOnStart = LD.ExtractCallbacksForEvent(thisLevel, obj, interactionOnStart)
  end
  if interactionOnFinish ~= nil then
    interactionOnFinish = LD.ExtractCallbacksForEvent(thisLevel, obj, interactionOnFinish)
  end
  if startEnabled then
    state = states.ENABLED
  else
    state = states.DISABLED
  end
  typeSpecificData = {}
  game.SubObject.Sleep(obj)
  SoundInit()
end
function OnSaveCheckpoint(level, obj)
  return {state = state}
end
function OnRestoreCheckpoint(level, obj, tab)
  state = tab.state
end
function OnStart(level, obj)
  if state == states.ACQUIRED then
    Disable()
    HideAllFX()
    LootObject:Hide()
    return
  elseif state == states.ENABLED then
    Enable()
  else
    Disable()
  end
end
function OnUseWorld(level, obj)
  if frontInteractZone:PlayerCanInteract() then
    LD.SetFacingTowardObject(obj, player, {ignoreYAxis = true, invertFacing = true})
    player:RequestInteract(obj, {
      InteractZone = frontInteractZone,
      LerpObject = LootObject.Child
    })
  end
end
function OnInteractStart(level, obj, creature)
  if interactionOnStart ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnStart, "Interaction Event Start")
  end
  local weaponMode = "Any"
  if player:GetCurrentWeapon() ~= "Axe" then
    weaponMode = "Bare"
  end
  if pickupType == "Wrap" then
    LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJoint", "picking up artifact, type: " .. tostring(artifactType), "BRA_PickUpArtifactEnterWrap", "", frontInteractZone, true, weaponMode)
  elseif pickupType == "Palm" then
    LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJoint", "picking up artifact, type: " .. tostring(artifactType), "BRA_PickUpArtifactEnterPalm", "", frontInteractZone, true, weaponMode)
  end
end
function OnInteractFinish()
  if interactionOnFinish ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnFinish, "Interaction Event Finish")
  end
end
function PickUp(level, obj, creature)
  HideAllFX()
  PlaySoundPickup()
end
function HideAllFX()
  local glowFX = LootObject:FindGOsByName("PickUp_Glow*")
  if glowFX then
    for _, fx in pairs(glowFX) do
      LD.HideFX(fx)
    end
  end
  if idleFX_Sparkle then
    LD.HideFX(idleFX_Sparkle)
  end
end
function LuaHook_GiveLoot()
  if artifactType ~= "Lambs Cress" then
    IncrementCounter()
  end
end
function LuaHook_HideLoot()
  LootObject.Child:HideModel()
  LootObject.Child:HideAudio()
end
function SetTypeData()
  if artifactType == "Alfheim" then
    typeSpecificData.questState = "Quest_Artifacts_Alfheim_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_Alfheim"
    typeSpecificData.questProgress = "Quest_Artifacts_Alfheim"
    typeSpecificData.resource = "AlfheimArtifact"
  elseif artifactType == "Brooch" then
    typeSpecificData.questState = "Quest_Artifacts_Brooches_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_Brooches"
    typeSpecificData.questProgress = "Quest_Artifacts_Brooches"
    typeSpecificData.resource = "Brooch"
  elseif artifactType == "Cup" then
    typeSpecificData.questState = "Quest_Artifacts_OrnateCups_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_Cups"
    typeSpecificData.questProgress = "Quest_Artifacts_OrnateCups"
    typeSpecificData.resource = "OrnateCup"
  elseif artifactType == "Horn" then
    typeSpecificData.questState = "Quest_Artifacts_VikingHorns_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_Horns"
    typeSpecificData.questProgress = "Quest_Artifacts_VikingHorns"
    typeSpecificData.resource = "VikingHorn"
  elseif artifactType == "Mask" then
    typeSpecificData.questState = "Quest_Artifacts_NorseMasks_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_NorseMasks"
    typeSpecificData.questProgress = "Quest_Artifacts_NorseMasks"
    typeSpecificData.resource = "NorseMask"
  elseif artifactType == "Ship Head" then
    typeSpecificData.questState = "Quest_Artifacts_ShipHeads_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_ShipHeads"
    typeSpecificData.questProgress = "Quest_Artifacts_ShipHeads"
    typeSpecificData.resource = "ShipHead"
  elseif artifactType == "Toy" then
    typeSpecificData.questState = "Quest_Artifacts_LostToys_Parent"
    typeSpecificData.recipe = "Recipe_Artifacts_Toys"
    typeSpecificData.questProgress = "Quest_Artifacts_LostToys"
    typeSpecificData.resource = "LostToy"
  end
end
function IncrementCounter(level, obj)
  SetTypeData()
  local questState = game.QuestManager.GetQuestState(typeSpecificData.questState)
  local audioPlayed = false
  if questState == "Inactive" then
    game.QuestManager.StartQuest(typeSpecificData.questState)
    game.Wallets.AddRecipe("HERO", typeSpecificData.recipe)
    if son:IsAvailableInLevel() and game.Audio.CanBanterConversationPlay("Artifact_FirstCollected") then
      game.Audio.PlayBanterNonCritical("Artifact_FirstCollected")
      audioPlayed = true
    end
  end
  ActivateRegionSummaryQuest()
  game.QuestManager.IncrementQuestProgress(typeSpecificData.questProgress, 1)
  if CheckAllArtifactQuestStatus() == true then
    AwardTrophy()
  end
  game.Wallets.AddResource("HERO", typeSpecificData.resource, 1, LootObject:GetName(), "Artifact")
  game.Wallets.AddResource("HERO", uniqueResource, 1, LootObject:GetName(), "Artifact")
  state = states.ACQUIRED
  SoftSave()
  if audioPlayed == false then
    CheckQuestStatus(typeSpecificData.questState)
  end
  if game.QuestManager.GetQuestState("Quest_Artifacts_ShipHeads") == "Complete" then
    FixupShipHeadRegion()
  end
end
function CheckQuestStatus(questInfo)
  if son:IsAvailableInLevel() then
    local questState = game.QuestManager.GetQuestState(questInfo)
    if questState == "Complete" then
      game.Audio.PlayBanterNonCritical("Artifact_Complete")
    else
      game.Audio.PlayBanterNonCritical("Artifact_Subsequent")
    end
  end
end
function CheckAllArtifactQuestStatus()
  if game.QuestManager.GetQuestState("Quest_Artifacts_Alfheim") == "Complete" and game.QuestManager.GetQuestState("Quest_Artifacts_Brooches") == "Complete" and game.QuestManager.GetQuestState("Quest_Artifacts_OrnateCups") == "Complete" and game.QuestManager.GetQuestState("Quest_Artifacts_VikingHorns") == "Complete" and game.QuestManager.GetQuestState("Quest_Artifacts_NorseMasks") == "Complete" and game.QuestManager.GetQuestState("Quest_Artifacts_ShipHeads") == "Complete" and game.QuestManager.GetQuestState("Quest_Artifacts_LostToys") == "Complete" then
    return true
  end
  return false
end
function ActivateRegionSummaryQuest()
  if regionSummaryQuest ~= nil and regionSummaryQuest ~= "" then
    regionSummaryQuest = string.gsub(regionSummaryQuest, "%s+", "")
    LD.ActivateAndIncrementQuest(regionSummaryQuest)
  end
end
function AwardTrophy()
  print("Award Trophy: My Precious")
  game.UnlockTrophy(24)
end
function SoftSave(level, obj)
  print("soft save occurred")
  game.SubObject.SoftSave(thisObj)
end
function FixupShipHeadRegion()
  print("FIXING UP SHIP HEAD")
  LD.ActivateAndIncrementQuest("RegionSummary_CALS_Shiphead_Parent")
end
function Enable()
  if state ~= states.ACQUIRED then
    state = states.ENABLED
    frontInteractZone:Enable()
  end
end
function Disable()
  if state ~= states.ACQUIRED then
    state = states.DISABLED
  end
  frontInteractZone:Disable()
end
local soundEmitter
local soundEvents = {
  Alfheim_Idle = "SND_LOOT_Chalice_Idle_LP",
  Alfheim_Pickup = "SND_LOOT_Artifact_Alfheim_Pickup",
  Brooch_Idle = "SND_LOOT_Chalice_Idle_LP",
  Brooch_Pickup = "SND_LOOT_Artifact_Brooch_Pickup",
  Cup_Idle = "SND_LOOT_Chalice_Idle_LP",
  Cup_Pickup = "SND_LOOT_Artifact_Cup_Pickup",
  Horn_Idle = "SND_LOOT_Chalice_Idle_LP",
  Horn_Pickup = "SND_LOOT_Artifact_Horn_Pickup",
  Mask_Idle = "SND_LOOT_Chalice_Idle_LP",
  Mask_Pickup = "SND_LOOT_Artifact_Mask_Pickup",
  Ship_Head_Idle = "SND_LOOT_Chalice_Idle_LP",
  Ship_Head_Pickup = "SND_LOOT_Artifact_Ship_Head_Pickup",
  Toy_Idle = "SND_LOOT_Chalice_Idle_LP",
  Toy_Pickup = "SND_LOOT_Artifact_Toy_Pickup",
  LambsCress_Pickup = "SND_EVNT_Freya_Garden_Flower_Pull_Kratos",
  Default_Idle = "SND_LOOT_Shard_White_LP",
  Default_Pickup = "SND_CHR_Kratos_Foley_Item_Pickup_Generic"
}
function SoundInit()
  soundEmitter = LootObject.Child.SoundEmitters[1]
  PlaySoundIdleLoop()
end
function PlaySoundIdleLoop()
  if artifactType == "Alfheim" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Alfheim_Idle)
  elseif artifactType == "Brooch" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Brooch_Idle)
  elseif artifactType == "Cup" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Cup_Idle)
  elseif artifactType == "Horn" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Horn_Idle)
  elseif artifactType == "Mask" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Mask_Idle)
  elseif artifactType == "Ship Head" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Ship_Head_Idle)
  elseif artifactType == "Toy" then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Toy_Idle)
  else
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.Default_Idle)
  end
end
function PlaySoundPickup()
  if artifactType == "Alfheim" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Alfheim_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Alfheim_Pickup)
  elseif artifactType == "Brooch" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Brooch_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Brooch_Pickup)
  elseif artifactType == "Cup" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Cup_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Cup_Pickup)
  elseif artifactType == "Horn" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Horn_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Horn_Pickup)
  elseif artifactType == "Mask" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Mask_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Mask_Pickup)
  elseif artifactType == "Ship Head" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Ship_Head_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Ship_Head_Pickup)
  elseif artifactType == "Toy" then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Toy_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Toy_Pickup)
  elseif artifactType == "Lambs Cress" then
    LD.PlaySound(player:FindSingleSoundEmitterByName("SNDLeftHand"), soundEvents.LambsCress_Pickup)
  else
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents.Default_Idle)
    LD.PlaySound(soundEmitter, soundEvents.Default_Pickup)
  end
end
