local LD = require("design.LevelDesignLibrary")
local TUT, thisLevel, thisObj, player, reward, onCollectedEvent, interactionOnStart, interactionOnFinish, LootObject, RewardTier, RewardTierIndex, WADName, rarity, frontInteractZone, state
local states = {
  ENABLED = 1,
  DISABLED = 2,
  ACQUIRED = 3
}
local TUT_LoadLibrary = function()
  if TUT == nil then
    TUT = require("game.GlobalTutorials")
  end
end
function OnScriptLoaded(level, go)
  thisLevel = level
  thisObj = go
  player = game.Player.FindPlayer()
  LootObject = thisObj.Parent.Parent:FindSingleGOByName("LootObject")
  frontInteractZone = LD.CreateInteractZone_LootPickup_360(LootObject.Child, "zeroJoint")
  frontInteractZone:ClearTags("NotInCombat")
  local enabled = thisObj:GetLuaTableAttribute("StartEnabled")
  reward = thisObj:GetLuaTableAttribute("Reward")
  onCollectedEvent = thisObj:FindLuaTableAttribute("onCollectedEvent")
  interactionOnStart = thisObj:FindLuaTableAttribute("interactionOnStart")
  interactionOnFinish = thisObj:FindLuaTableAttribute("interactionOnFinish")
  RewardTier = thisObj:FindLuaTableAttribute("RewardTier") or 0
  RewardTierIndex = thisObj:FindLuaTableAttribute("RewardTierIndex") or 0
  WADName = thisObj:FindLuaTableAttribute("WADName") or "TB"
  rarity = thisObj:FindLuaTableAttribute("Rarity") or "common"
  if onCollectedEvent ~= nil then
    onCollectedEvent = LD.ExtractCallbacksForEvent(thisLevel, thisObj, onCollectedEvent)
  end
  if interactionOnStart ~= nil then
    interactionOnStart = LD.ExtractCallbacksForEvent(thisLevel, thisObj, interactionOnStart)
  end
  if interactionOnFinish ~= nil then
    interactionOnFinish = LD.ExtractCallbacksForEvent(thisLevel, thisObj, interactionOnFinish)
  end
  if enabled then
    state = states.ENABLED
  else
    state = states.DISABLED
  end
  thisObj:SetInhibitSave()
  LootObject:SetInhibitSave()
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  SoundOnStart()
  if state == states.ACQUIRED then
    SoftSaveCleanup()
  elseif state == states.DISABLED then
    Disable()
  elseif state == states.ENABLED then
    Enable()
  end
end
function OnUseWorld(level, go)
  if frontInteractZone:PlayerCanInteract() then
    player:RequestInteract(go, {
      InteractZone = frontInteractZone,
      LerpObject = LootObject.Child
    })
  end
end
function OnInteractStart()
  Disable()
  if interactionOnStart ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnStart, "Interaction Event Start")
  end
  HideFX()
  local puppeteer = game.Puppeteer.NewForce(thisObj, "Loot Grab", player)
  puppeteer:StartBranch("BRA_LootScoop_Still")
  puppeteer:OnComplete(function()
    if puppeteer ~= nil then
      puppeteer:Clear()
      puppeteer = nil
    end
  end)
  if onCollectedEvent ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onCollectedEvent, "onCollectedEvent")
  end
  PlaySoundPickup()
end
function OnInteractAbort()
end
function OnInteractFinish()
  if interactionOnFinish ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnFinish, "Interaction Event Finish")
  end
end
function OnInteractDone()
end
function PickUp(level, obj, creature)
  PlaySoundPickup_Anim()
end
function AwardLoot(level, obj, creature)
  local resourceTestTable = PreAwardResourceTest()
  state = states.ACQUIRED
  LD.RollContainerConditionLoot("CORPSE_" .. string.upper(rarity) .. "_TIER", RewardTier, WADName, RewardTierIndex)
  CheckTutorialHint()
  game.SubObject.SoftSave(obj)
  PostAwardResourceTest(resourceTestTable)
end
function PutAway(level, obj, creature)
  LootObject.Child:HideModel()
  LootObject.Child:HideAudio()
end
function CheckTutorialHint()
  if reward == "StartingTrinketReward" then
    local showHint = LD.GetEntityVariable("TUT_ShowTrinketTutorialHint")
    if showHint == true then
      TUT_LoadLibrary()
      TUT.ArmorTrinkets_Tutorial()
      LD.SetEntityVariable("TUT_ShowTrinketTutorialHint", false)
    end
  elseif reward == "StartingWristArmorReward" then
    local showHint = LD.GetEntityVariable("TUT_ShowWristArmorTutorialHint")
    if showHint == true then
      TUT_LoadLibrary()
      TUT.WristArmor_Tutorial()
      LD.SetEntityVariable("TUT_ShowWristArmorTutorialHint", false)
    end
  elseif reward == "StartingWaistArmorReward" then
    local showHint = LD.GetEntityVariable("TUT_ShowWaistArmorTutorialHint")
    if showHint == true then
      TUT_LoadLibrary()
      TUT.WaistArmor_Tutorial()
      LD.SetEntityVariable("TUT_ShowWaistArmorTutorialHint", false)
    end
  elseif reward == "FrostSpecialAxeFlurryChopReward" then
    local showHint = LD.GetEntityVariable("TUT_ShowWeaponGemTutorialHint")
    if showHint == true then
      LD.SetEntityVariable("TUT_ShowWeaponGemTutorialHint", false)
    end
  else
    local showHint = LD.GetEntityVariable("TUT_ShowResourceTutorialHint")
    if showHint == true then
      TUT_LoadLibrary()
      TUT.CollectResources_Tutorial()
      LD.SetEntityVariable("TUT_ShowResourceTutorialHint", false)
    end
  end
end
function GetState()
  return state
end
function Enable()
  if state ~= states.ACQUIRED then
    state = states.ENABLED
    frontInteractZone:Enable()
  end
end
function Disable()
  if state ~= states.ACQUIRED then
    state = states.DISABLED
  end
  frontInteractZone:Disable()
end
function HideFX(immediate)
  immediate = immediate or false
  local glowFX = LootObject:FindGOsByName("PickUp_Glow*")
  if glowFX then
    for _, fx in pairs(glowFX) do
      LD.HideFX(fx, {immediate = immediate})
    end
  end
end
function SoftSaveCleanup()
  Disable()
  PutAway()
  HideFX(true)
end
function PreAwardResourceTest()
  local result = {}
  result.NifTankArmor_Chest_Pattern = game.Wallets.GetResourceValue("HERO", "NifTankArmor_Chest_Pattern")
  return result
end
function PostAwardResourceTest(resourceTestTable)
  local nifArmorPattern_Chest = game.Wallets.GetResourceValue("HERO", "NifTankArmor_Chest_Pattern")
  if nifArmorPattern_Chest > resourceTestTable.NifTankArmor_Chest_Pattern then
    game.Audio.PlayBanter("Niflheim_Armor_Quest")
    LD.ActivateQuest("Quest_NiflheimArmorChest_Parent")
    LD.CompleteQuest("Quest_NiflheimArmorChest_01")
    game.SubObject.SoftSave(thisObj)
  end
end
function OnSaveCheckpoint(level)
  return {state = state}
end
function OnRestoreCheckpoint(level, go, savedInfo)
  state = savedInfo.state
end
local soundEmitter
local soundEvents = {
  Blue_Idle = "SND_LOOT_Silver_Collect_LP",
  Blue_Pickup = "SND_LOOT_Silver_Collect_Pickup",
  Orange_Idle = "SND_LOOT_Silver_Collect_LP",
  Orange_Pickup = "SND_LOOT_Silver_Collect_Pickup",
  Purple_Idle = "SND_LOOT_Silver_Collect_LP",
  Purple_Pickup = "SND_LOOT_Silver_Collect_Pickup",
  White_Idle = "SND_LOOT_Silver_Collect_LP",
  White_Pickup = "SND_LOOT_Silver_Collect_Pickup"
}
local rarityColor
function SoundOnStart()
  soundEmitter = LootObject.Child.SoundEmitters[1]
  DetermineColorRarity_UsingRarityAttribute()
  PlaySoundIdleLoop()
end
function PlaySoundIdleLoop()
  if rarityColor ~= nil then
    LD.PlayRestartableSoundLoop(soundEmitter, soundEvents[rarityColor .. "_Idle"])
  end
end
function StopSoundIdleLoop()
  if rarityColor ~= nil then
    LD.StopRestartableSoundLoop(soundEmitter, soundEvents[rarityColor .. "_Idle"])
  end
end
function PlaySoundPickup()
  StopSoundIdleLoop()
  if rarityColor ~= nil then
    LD.PlaySound(player:FindSingleSoundEmitterByName("SNDKratos"), soundEvents[rarityColor .. "_Pickup"])
  end
end
function PlaySoundPickup_Anim()
  LD.PlaySound(player:FindSingleSoundEmitterByName("SNDLeftHand"), "SND_CHR_Kratos_Foley_Item_Pickup_Generic")
end
function DetermineColorRarity_UsingRarityAttribute()
  local rarityTag = string.upper(rarity)
  if rarityTag == "RARE" then
    rarityColor = "Blue"
  elseif rarityTag == "LEGENDARY" then
    rarityColor = "Purple"
  elseif rarityTag == "EPIC" then
    rarityColor = "Orange"
  else
    rarityColor = "White"
  end
end
function DetermineColorRarity_UsingFXObject()
  local fxObject
  local glowFX = LootObject:FindGOsByName("PickUp_Glow*")
  if glowFX ~= nil and #glowFX == 1 then
    fxObject = glowFX[1]
  end
  if fxObject ~= nil then
    local fxObjectName = fxObject:GetName()
    fxObjectName = string.upper(fxObjectName)
    if string.find(fxObjectName, "BLUE") ~= nil then
      rarityColor = "Blue"
    elseif string.find(fxObjectName, "PURPLE") ~= nil then
      rarityColor = "Purple"
    elseif string.find(fxObjectName, "ORANGE") ~= nil then
      rarityColor = "Orange"
    else
      rarityColor = "White"
    end
  end
end
