local LD = require("design.LevelDesignLibrary")
local player, thisObj, thisLevel, frontInteractZone, startEnabled, questName, LootObject, Sparkle, reward, onInteractEvent, rewardTier, rewardTierIndex, WADName
local rarity = "COMMON"
local useLOSTest, state
local states = {
  ENABLED = 1,
  DISABLED = 2,
  ACQUIRED = 3
}
function OnScriptLoaded(level, go)
  player = game.Player.FindPlayer()
  thisObj = go
  thisLevel = level
  frontInteractZone = LD.CreateInteractZone_Standard_360(go, "promptJointFront")
  LD.EnableInteractZoneGlint(frontInteractZone)
  startEnabled = go:GetLuaTableAttribute("StartEnabled")
  questName = go:GetLuaTableAttribute("QuestName")
  rewardTier = go:FindLuaTableAttribute("RewardTier") or 0
  rewardTierIndex = go:FindLuaTableAttribute("RewardTierIndex") or 0
  WADName = go:FindLuaTableAttribute("WADName") or "TB"
  useLOSTest = go:FindLuaTableAttribute("UseLineOfSightTest")
  if go:FindLuaTableAttribute("Reward") ~= nil then
    reward = go:GetLuaTableAttribute("Reward")
  end
  if go:FindLuaTableAttribute("onInteractEvent") ~= nil then
    onInteractEvent = LD.ExtractCallbacksForEvent(level, go, go:FindLuaTableAttribute("onInteractEvent"))
  end
  LootObject = go.Parent:FindSingleGOByName("LootObject")
  Sparkle = go.Parent:FindSingleGOByName("Sparkle_Icon")
  if startEnabled then
    state = states.ENABLED
  else
    state = states.DISABLED
  end
  game.SubObject.Sleep(go)
  SoundInit()
end
function OnFirstStart(level, go)
  LD.HideFX(LootObject.Child)
end
function OnStart(level, go)
  if questName ~= "" then
    local questState = game.QuestManager.GetQuestState(questName)
    if questState ~= "Complete" then
      game.QuestManager.RegisterListener(go, questName)
    end
    if questState == "Active" then
      state = states.ENABLED
    else
      state = states.DISABLED
    end
  end
  if state == states.ENABLED then
    Enable()
  else
    Disable()
  end
  if useLOSTest == true and state == states.ENABLED then
    frontInteractZone:SetEnableLineOfSightTest(true)
  else
    frontInteractZone:SetEnableLineOfSightTest(false)
  end
end
function OnUseWorld(level, go)
  if frontInteractZone:PlayerCanInteract() then
    LD.SetFacingTowardObject(go, player)
    player:RequestInteract(go, {
      InteractZone = frontInteractZone,
      LerpObject = LootObject.Child
    })
  end
end
function OnInteractStart(level, go, creature)
  state = states.ACQUIRED
  Disable()
  LD.ShowFX(LootObject)
  PlaySoundLootIdle()
  LD.PlaySingleSynchMove_KratosObject(go, "synchJoint", "dirt dig loot", "BRA_PickUpDirt", "", frontInteractZone, false, "Axe")
  CameraApproach()
  game.QuestManager.UnregisterListener(go, questName)
  if go:FindLuaTableAttribute("onInteractEvent") ~= nil then
    LD.ExecuteCallbacksForEvent(level, go, onInteractEvent, "onInteractEvent")
  end
end
function LuaHook_DirtFX(level, obj, creature)
  local spawnFX = game.FX.Spawn("DirtDig_FX", thisLevel, {GameObject = thisObj, AutoDelete = true})
end
function PickUp(level, obj, creature)
  PlaySoundLootPickup()
end
function AwardLoot(level, obj, creature)
  if reward ~= nil then
    if reward == "TyrOffering" then
      game.Wallets.AddResource("HERO", "TyrOffering", 1, "Quest", "Resource")
      if game.Wallets.GetResourceValue("HERO", reward) == 1 then
        if game.Audio.CanBanterConversationPlay("Son_New_Mat_Found") then
          game.Audio.PlayBanterNonCritical("Son_New_Mat_Found", function()
            LD.ActivateQuest("Quest_TyrArmor_Parent")
          end)
        else
          LD.ActivateQuest("Quest_TyrArmor_Parent")
        end
        return
      end
    elseif reward == "Perk_Quest_TyrTalisman" then
      game.Wallets.AddResource("HERO", "Perk_Quest_TyrTalisman", 1, "Quest", "Talisman")
    end
  end
  reward = "MISC_" .. rarity .. "_TIER"
  LD.RollContainerConditionLoot(reward, rewardTier, WADName, rewardTierIndex)
  UpdateQuest()
  LD.CallFunctionAfterDelay(SoftSave, 1)
end
function PutAway(level, obj, creature)
  LootObject:Hide()
end
function UpdateQuest(level, go)
  if questName ~= "" then
    local questState = game.QuestManager.GetQuestState(questName)
    if questState == "Active" then
      game.QuestManager.ProposeQuestState(questName, "Complete")
      game.Audio.PlayBanterNonCritical("treasure_map_found_treasure")
      TrophyCheck()
      if questName == "Quest_TreasureMap01" then
        local uiCalls = require("ui.uicalls")
        uiCalls.UI_Event_SendPlaytestFullscreenMessage("You\226\128\153ve reached a stopping point! Please click the Dead and Bloated survey.", 3, uiCalls.msgParam.ADVANCE_TAP)
      end
    end
  end
end
function TrophyCheck()
  if game.QuestManager.GetQuestState("Quest_TreasureMap01_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_ThorStatue_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_Shipwreck_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_Oarsmen_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_VF_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_Stronghold_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_ForestDungeon_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_IslandClimb_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_ValkyrieArena_Parent") == "Complete" and game.QuestManager.GetQuestState("Quest_TreasureMap_BlackBreath_Parent") == "Complete" then
    AwardTrophy()
  end
end
function AwardTrophy()
  print("Trophy Awarded: Treasure Hunter")
  game.UnlockTrophy(32)
end
function Handle_Quest_Activate(level, go, questName, parentQuestName)
  if questName ~= "" then
    Enable()
  end
end
function Enable()
  if state ~= states.ACQUIRED then
    state = states.ENABLED
    frontInteractZone:Enable()
    Sparkle:Show()
  end
end
function Disable()
  if state ~= states.ACQUIRED then
    state = states.DISABLED
  end
  Sparkle:Hide()
  LD.HideFX(LootObject.Child)
  frontInteractZone:Disable()
end
function CameraApproach()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 2,
    LockRecenter = 1,
    YawRange = -1,
    TriggerLeft = 0,
    TriggerRight = 0,
    ReturnLeft = 0,
    ReturnRight = 0,
    PitchRange = 0,
    ReturnUp = -8,
    ReturnDown = -8
  })
end
function SoftSave(level, go)
  game.SubObject.SoftSave(thisObj)
  print("soft save has occurred")
end
function OnSaveCheckpoint(level)
  return {state = state}
end
function OnRestoreCheckpoint(level, go, tab)
  state = tab.state
end
local soundEmitter
local soundEvents = {
  OnPickUp = "SND_CHR_Kratos_Foley_Item_Pickup_Generic",
  IdleLoop = "SND_LOOT_Shard_White_LP"
}
function SoundInit()
  soundEmitter = LootObject.Child.SoundEmitters[1]
end
function PlaySoundLootIdle()
  print()
  LD.PlaySound(soundEmitter, soundEvents.IdleLoop)
end
function PlaySoundLootPickup()
  LD.PlaySound(player:FindSingleSoundEmitterByName("SNDLeftHand"), soundEvents.OnPickUp)
end
