local LD = require("design.LevelDesignLibrary")
local thisObj, RuneParticle
local completed = false
local sonInteractObject
function OnScriptLoaded(level, obj)
  thisObj = obj
  RuneParticle = obj:FindSingleGOByName("RuneParticlesFX")
  sonInteractObject = obj:FindSingleGOByName("pSonInteractRune").Child.Child
  game.SubObject.Sleep(obj)
  SoundInit()
end
function OnStart(level, obj)
  if completed then
    RuneParticle:Hide()
  else
    SoundStartLoopEvent()
  end
end
function OnSaveCheckpoint(level, obj)
  return {completed = completed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  completed = savedInfo.completed
end
function HideParticle()
  completed = true
  RuneParticle:Hide()
  SoundStopLoopEvent()
end
function EnableSonInteract()
  sonInteractObject.LuaObjectScript.Enable()
end
function DisableSonInteract()
  sonInteractObject.LuaObjectScript.DisableModule()
end
local soundEmitterQuestLoreMarker
function SoundInit()
  soundEmitterQuestLoreMarker = thisObj:FindSingleSoundEmitterByName("SNDQuestLoreMarker")
  local sonInteractRuneReadScript = thisObj:FindSingleGOByName("pSonInteractRune").LuaObjectScript
  if sonInteractRuneReadScript ~= nil then
    sonInteractRuneReadScript.LoreMarkerRuneReadSoundSetup(soundEmitterQuestLoreMarker)
  end
end
function SoundStartLoopEvent()
  if soundEmitterQuestLoreMarker ~= nil then
    LD.PlayRestartableSoundLoop(soundEmitterQuestLoreMarker, "SND_MAG_Rune_Read_Lore_Marker_LP")
  end
end
function SoundStopLoopEvent()
  if soundEmitterQuestLoreMarker ~= nil then
    LD.StopRestartableSoundLoop(soundEmitterQuestLoreMarker, "SND_MAG_Rune_Read_Lore_Marker_LP")
  end
end
