local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, son, SonPosition, ObjPosition, sonLeft, LootToSon, enabled, pickupCallbacks, pose, propObject, soundEmitter, rewardTier, rewardTierIndex, WADName
local rarity = "COMMON"
local corpseVisual
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  rewardTier = thisObj:FindLuaTableAttribute("RewardTier") or 0
  rewardTierIndex = thisObj:FindLuaTableAttribute("RewardTierIndex") or 0
  WADName = thisObj:FindLuaTableAttribute("WADName") or "TB"
  pose = thisObj:FindLuaTableAttribute("Pose")
  if obj:FindLuaTableAttribute("PickupCallbacks") ~= nil then
    pickupCallbacks = LD.ExtractCallbacksForEvent(thisLevel, thisObj, obj:FindLuaTableAttribute("PickupCallbacks"))
  end
  corpseVisual = thisObj:FindSingleGOByName("corpseVisual")
  enabled = obj:GetLuaTableAttribute("StartEnabled")
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDCorpseWater")
  thisObj:SetInhibitSave()
  game.SubObject.SetForgetOnCheckpoint(thisObj)
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  BoatLoot_CheckForWaterLevel()
  if enabled then
    if pose == 0 then
      corpseVisual:SetCharacterConfig("Body2")
    else
      corpseVisual:SetCharacterConfig("Body1")
    end
    Enable()
  else
    Disable()
  end
end
function OnBreakableBroken(_, _)
  print("Floating corpse hit")
  game.FX.SubmitEffect({EffectName = "FFB_MEDIUM", Duration = 1})
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_VERYSMALL",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.2}
  })
  corpseVisual:ClonePose()
  corpseVisual:PlayAnimationToEnd({
    Animation = "navFloatingSink"
  })
  StartSonMove()
  LD.PlaySound(soundEmitter, "SND_VEH_Boat_Hit")
end
function OnInteractStart(level, go, creature)
  son = game.AI.FindSon()
  SonPosition = son:GetWorldPosition()
  ObjPosition = thisObj:GetWorldPosition()
  sonLeft = son:GetWorldLeft()
  LootToSon = SonPosition - ObjPosition
  local DotToLoot = LootToSon:Dot(sonLeft)
  if 0 < DotToLoot then
    son:ForceMove("BRA_BoatReachDownLEnter")
  else
    son:ForceMove("BRA_BoatReachDownEnter")
  end
end
function LuaHook_AwardLoot()
  local rewardName = "BOAT_" .. rarity .. "_TIER"
  LD.RollContainerConditionLoot(rewardName, rewardTier, WADName, rewardTierIndex, thisObj:GetName())
end
function LuaHook_DestroyObject()
  LD.ExecuteCallbacksForEvent(thisLevel, thisObj, pickupCallbacks, "loot corpse water pickup")
  if propObject then
    propObject:Destroy()
  end
end
function Enable()
  enabled = true
  thisObj:Show()
end
function Disable()
  enabled = false
  thisObj:Hide()
end
function StartSonMove()
  local lootObjectSpawnArgs = {
    SpawnObject = "goLootPouchWater",
    HookName = "WaterPouchSpawned",
    OffSetPosition = son:GetWorldPosition() + engine.Vector.New(0, -5, 0),
    Level = game.Level.GetPermLevel()
  }
  thisObj:SpawnGameObject(lootObjectSpawnArgs)
end
function WaterPouchSpawned(level, go, spawnedObject)
  propObject = spawnedObject
  son:RequestInteract(go, {LerpObject = spawnedObject})
end
function BoatLoot_CheckForWaterLevel()
  local waterLevel = thisObj:FindLuaTableAttribute("waterLevel")
  if waterLevel then
    if waterLevel == "2" and game.Level.GetVariable("_GBL_WaterDrop02Triggered") then
      Enable()
    elseif waterLevel == "1" and game.Level.GetVariable("_GBL_WaterDrop01Triggered") and not game.Level.GetVariable("_GBL_WaterDrop02Triggered") then
      Enable()
    else
      Disable()
    end
  else
    Enable()
  end
end
