local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local bIsAnimated, thisObj
local ravenKilled = false
local BirdMesh, OnKilledCallbacks, regionSummaryQuest
function OnScriptLoaded(level, obj)
  thisObj = obj
  OnKilledCallbacks = thisObj:FindLuaTableAttribute("OnKilledEvent")
  bIsAnimated = thisObj:FindLuaTableAttribute("IsAnimated")
  regionSummaryQuest = thisObj:FindLuaTableAttribute("regionSummaryQuest")
  BirdMesh = thisObj:FindSingleGOByName("BirdMesh")
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if ravenKilled == true then
    HideBird()
    return
  elseif BirdMesh ~= nil then
    BirdMesh:PlayAnimCycle()
    thisObj:PlayAnimCycle()
    SoundOnStart()
  end
end
function OnHitByWeapon(level, obj, attacker, weapon)
  timers.StartLevelTimer(1.5, HideBird())
  local questState = game.QuestManager.GetQuestState("Quest_Labor_KillRavens_Parent")
  if questState == "Inactive" then
    game.QuestManager.StartQuest("Quest_Labor_KillRavens_Parent")
  end
  game.QuestManager.IncrementQuestProgress("Quest_Labor_KillRavens", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_KillRavens_25", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_KillRavens_50", 1)
  if game.QuestManager.GetQuestState("Quest_Labor_KillRavens") == "Complete" then
    game.UnlockTrophy(25)
  end
  ravenKilled = true
  SpawnFX()
  PlayDeathSound()
  OnKilledCallback(level, obj)
  ActivateRegionSummaryQuest()
  timers.StartLevelTimer(1, SoftSave)
end
function OnKilledCallback(level, obj)
  if OnKilledCallbacks ~= nil or OnKilledCallbacks ~= "" then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, OnKilledCallbacks, "On Killed Event")
  end
end
function ActivateRegionSummaryQuest()
  if regionSummaryQuest ~= nil and regionSummaryQuest ~= "" then
    regionSummaryQuest = string.gsub(regionSummaryQuest, "%s+", "")
    LD.ActivateAndIncrementQuest(regionSummaryQuest)
  end
end
function HideBird()
  thisObj:Hide()
end
function SpawnFX()
  if BirdMesh ~= nil then
    local spawnJoint = BirdMesh:GetJointIndex("synchJoint")
    local spawnJointPos = BirdMesh:GetWorldJointPosition(spawnJoint)
    local deathFX = game.FX.Spawn("Raven_Death_FX", BirdMesh, {AutoDelete = true})
    deathFX:SetWorldPosition(spawnJointPos)
  elseif bIsAnimated ~= nil then
    local spawnJoint = thisObj:GetJointIndex("synchJoint")
    local spawnJointPos = thisObj:GetWorldJointPosition(spawnJoint)
    local deathFX = game.FX.Spawn("Raven_Death_FX", thisObj, {AutoDelete = true})
    deathFX:SetWorldPosition(spawnJointPos)
  else
    local deathFX = game.FX.Spawn("Raven_Death_FX", thisObj, {AutoDelete = true})
    deathFX:SetWorldPosition(thisObj:GetWorldPosition())
  end
end
function SoftSave(level, obj)
  game.SubObject.SoftSave(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {ravenKilled = ravenKilled}
end
function OnRestoreCheckpoint(level, obj, tab)
  ravenKilled = tab.ravenKilled
end
local emitter
function SoundInit()
  print(string.upper(thisObj:GetName()))
  if BirdMesh ~= nil then
    emitter = BirdMesh:FindSingleSoundEmitterByName("SNDRaven")
  else
    emitter = thisObj:FindSingleSoundEmitterByName("SNDRaven")
  end
end
local soundEvents = {
  IdleLoop = "SND_LOOT_Odins_Ravens_Magic_LP",
  Death = "SND_LOOT_Odins_Ravens_Explode"
}
function SoundOnStart()
  LD.CallFunctionAfterDelay(PlayIdleLoop, 0.1)
end
function DisableIdleLoop()
  LD.StopRestartableSoundLoop(emitter, soundEvents.IdleLoop)
end
function PlayIdleLoop()
  LD.PlayRestartableSoundLoop(emitter, soundEvents.IdleLoop)
end
function PlayDeathSound()
  LD.PlaySound(emitter, soundEvents.Death)
  LD.StopRestartableSoundLoop(emitter, soundEvents.IdleLoop)
end
