local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local interactZone, thisObj, thisLevel, playerRef
local bEnabled = true
local spawnedHelm, iValkyrieSpawned, spawnedGhost, config
local valkyrieSpawned = false
local talkIcon, infoBanterEnabled
local firstTimeBanter = false
local triangleMonitor
local hasResources = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  thisObj = obj
  thisLevel = level
  playerRef = game.Player.FindPlayer()
  interactZone = LD.CreateInteractZone_Standard_90(obj, "promptJoint")
  interactZone:SetHintXZRange(15)
  interactZone:SetTags("NotInBanter")
  talkIcon = {
    normal = "WORLD_INTERACT_TALK",
    unavailable = "WORLD_INTERACT_UNAVAILABLE",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  }
end
function OnSaveCheckpoint(level, obj)
  return {
    bEnabled = interactZone:IsEnabled(),
    iValkyrieSpawned = iValkyrieSpawned,
    valkyrieSpawned = valkyrieSpawned,
    config = config,
    infoBanterEnabled = infoBanterEnabled
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bEnabled = savedInfo.bEnabled
  iValkyrieSpawned = savedInfo.iValkyrieSpawned
  config = savedInfo.config
  valkyrieSpawned = savedInfo.valkyrieSpawned
  infoBanterEnabled = savedInfo.infoBanterEnabled
end
function OnStart(level, obj)
  local questState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Parent")
  if questState == "Inactive" then
    Disable()
    return
  end
  if bEnabled == true then
    Enable()
  else
    Disable()
  end
  if infoBanterEnabled == true then
    Enable_InfoBanter()
  else
    Disable_InfoBanter()
  end
  if valkyrieSpawned == true then
    LuaHook_SpawnValkyrie(level, obj)
  else
    InventoryCheck()
    if hasResources == true then
      Enable()
    end
  end
end
function OnUseWorld(level, obj)
  if infoBanterEnabled ~= true and interactZone:PlayerCanInteract() then
    if iValkyrieSpawned == nil then
      for i = 1, 8 do
        if game.Wallets.GetResourceValue("HERO", "ValkyrieLoot0" .. i) == 1 then
          iValkyrieSpawned = i
          local spawnArgs = {
            SpawnObject = "goSpawnedHelm0" .. i,
            HookName = "HelmSpawned"
          }
          thisObj:SpawnGameObject(spawnArgs)
          SetConfig()
          return
        end
      end
    else
      Disable()
    end
  end
end
function SetConfig()
  if iValkyrieSpawned == 1 then
    config = "raven"
  elseif iValkyrieSpawned == 2 then
    config = "vulture"
  elseif iValkyrieSpawned == 3 then
    config = "owl"
  elseif iValkyrieSpawned == 4 then
    config = "ram"
  elseif iValkyrieSpawned == 5 then
    config = "stag"
  elseif iValkyrieSpawned == 6 then
    config = "bear"
  elseif iValkyrieSpawned == 7 then
    config = "boar"
  elseif iValkyrieSpawned == 8 then
    config = "eagle"
  end
end
function OnInteractStart(level, obj)
  LD.GoToLocationSyncAndPlayBranch(playerRef, thisObj, "BRA_PutDownValkyrieHelmetEnter", 3.5, true, "synchJoint", "", 1, false)
  Disable()
end
function OnInteractAbort()
end
function OnInteractFinish()
  game.Wallets.RemoveResource("HERO", "ValkyrieLoot0" .. iValkyrieSpawned, 1)
  InventoryCheck()
  infoBanterEnabled = true
  Enable_InfoBanter()
  LD.CompleteQuest("Quest_Valkyrie_Council_Objective01")
  game.QuestManager.IncrementQuestProgress("Quest_Valkyrie_Council_Objective02", 1)
  local questState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Objective02")
  if questState == "Complete" then
    GameObjects.QueenCombatRift.LuaObjectScript.Enable()
    CheckPoint()
  else
    CheckPoint()
  end
end
function OnInteractDone()
end
function LuaHook_StartHelmetPlace()
  game.Audio.StartMusic("SND_MX_XPL600_place_helmet")
end
function HelmSpawned(level, obj, spawnedObject)
  spawnedHelm = spawnedObject
  spawnedHelm:Hide()
  playerRef:RequestInteract(obj, {InteractZone = interactZone, LerpObject = spawnedHelm})
end
function LuaHook_ShowHelmet()
  spawnedHelm:Show()
end
function LuaHook_DestroyHelm()
  spawnedHelm:Hide()
end
function LuaHook_SpawnValkyrie(level, obj)
  local index = thisObj:GetJointIndex("spawnJoint")
  local pos = thisObj:GetWorldJointPosition(index)
  local dir = thisObj:GetWorldForward(index)
  spawnedGhost = game.AI.Spawn(level, pos, dir, "CRT_ValkyrieGhost00", "BRA_SpawnSit")
  spawnedGhost:SetCharacterConfig(config)
  valkyrieSpawned = true
  LD.CallFunctionAfterDelay(CheckFirstBanter, 2.5)
end
function CheckFirstBanter()
  local _, councilProgress = game.QuestManager.GetQuestProgressAndGoal("Quest_Valkyrie_Council_Objective02")
  if councilProgress == 0 then
    game.Audio.PlayBanter("MT_CouncilRoom_PlaceHelm_FirstTime")
    firstTimeBanter = true
  end
end
function Enable_InfoBanter()
  if triangleMonitor == nil then
    triangleMonitor = monitors.CreateTriangleButtonMonitor()
    triangleMonitor:OnButtonDown(CheckCanInteract)
    interactZone:Enable()
    SetInteractToTalk()
  end
end
function Disable_InfoBanter()
  if triangleMonitor ~= nil then
    triangleMonitor:Stop()
    interactZone:Disable()
    Disable()
  end
end
function CheckCanInteract()
  if interactZone:PlayerCanInteract() then
    PlayInfoBanter()
  end
end
function SetInteractToTalk()
  interactZone:SetPromptIconSet(talkIcon)
end
function PlayInfoBanter()
  Disable_InfoBanter()
  if firstTimeBanter == true then
    game.Audio.PlayBanter("MT_CouncilRoom_ValkInfo_Intro", PlayInfoBanter)
    firstTimeBanter = false
  else
    local banterToPlay = "MT_CouncilRoom_ValkInfo_" .. tostring(iValkyrieSpawned)
    game.Audio.PlayBanter(banterToPlay, SoftSave)
    infoBanterEnabled = false
    BestiaryEntries()
  end
end
function BestiaryEntries()
  if iValkyrieSpawned == 1 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Gunnr")
  elseif iValkyrieSpawned == 2 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Gondul")
  elseif iValkyrieSpawned == 3 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Geirdriful")
  elseif iValkyrieSpawned == 4 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Kara")
  elseif iValkyrieSpawned == 5 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Rota")
  elseif iValkyrieSpawned == 6 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Eir")
  elseif iValkyrieSpawned == 7 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Hildr")
  elseif iValkyrieSpawned == 8 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Olrun")
  end
end
function ZoneDisableTriangleMonitor()
  if triangleMonitor ~= nil then
    triangleMonitor:Stop()
  end
end
function ZoneEnableTriangleMonitor()
  if infoBanterEnabled == true and triangleMonitor ~= nil then
    triangleMonitor:Start()
  end
end
function ZoneInventoryCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Parent")
  if questState == "Inactive" then
    Disable()
    return
  end
  InventoryCheck()
  if hasResources == true then
    Enable()
  end
end
function Enable()
  if infoBanterEnabled ~= true and valkyrieSpawned ~= true then
    bEnabled = true
    interactZone:Enable()
  end
end
function Disable()
  bEnabled = false
  if infoBanterEnabled ~= true then
    interactZone:Disable()
  end
end
function InventoryCheck(level, obj)
  hasResources = false
  for i = 1, 8 do
    if game.Wallets.GetResourceValue("HERO", "ValkyrieLoot0" .. i) == 1 then
      hasResources = true
    end
  end
  if hasResources == false then
    DisableAll()
  end
end
function DisableAll()
  Disable()
  for j = 1, 8 do
    local stand = thisLevel:FindSingleGameObject("TrophyStand_0" .. j)
    stand.LuaObjectScript.Disable()
  end
end
function CheckPoint()
  game.World.StoreCheckpoint()
end
function SoftSave()
  game.SubObject.SoftSave(thisObj)
end
