local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timer = require("level.timer")
local CCOS = require("camera.camera_oneshot")
local son, player, thisLevel, thisObj, interactZone
local tutorialActive = false
local sonPuppeteer, cameraOneShotApproach, includeSon, lostItemTutorialInProgress
local hasFixedUp = false
local playerInArmorSection = false
local playerInPurchaseSection = false
local newItemsAdded, playerHasMadePurchase
local niflheimEntryBought = false
local vendorIsActive = false
local notificationCard, vendorWalletName
local autoEnableAllowed = true
local vendorInteractRequested, warpSyncAllowed, vendorExitRequested
local triggerCinematic = false
local currentVendorNPC, vendorIconTable, mainQuestIconTable, storeLightParent, vendorKeyFSE, vendorExposure, isLargeShop
local questTestTable = {
  EnhancedGolemLoot = {}
}
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  thisLevel = level
  thisObj = obj
  son = game.AI.FindSon()
  interactZone = LD.CreateInteractZone_Standard_90(obj, "promptJointFront")
  LD.OverrideInteractZoneTags(interactZone, "NotWhileSonInteracting", true)
  LD.OverrideInteractZoneTags(interactZone, "NotWhileLoreReadActive", true)
  interactZone:SetCameraFrontAngle(135)
  interactZone:SetInteractFrontAngle(135)
  interactZone:SetCameraFrontAngleWeight(3)
  interactZone:SetPlayerFrontAngleWeight(2)
  interactZone:SetHintXZRange(8)
  vendorIconTable = {
    normal = "WORLD_INTERACT_VENDOR",
    unavailable = "WORLD_INTERACT_UNAVAILABLE",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  }
  mainQuestIconTable = {
    normal = "WORLD_INTERACT_MAIN_QUEST",
    unavailable = "WORLD_INTERACT_UNAVAILABLE",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  }
  vendorExitRequested = obj:FindLuaTableAttribute("vendorExitRequested")
  vendorInteractRequested = obj:FindLuaTableAttribute("vendorInteractRequested")
  interactZone:Disable()
  local parent = obj.Parent
  print("vendor", vendorIsActive)
  vendorKeyFSE = {
    EffectName = "FSE_VENDOR_CINEMATIC_KEY",
    TweenInTime = 0.2,
    TweenOutTime = 0.35,
    Duration = 100000
  }
  vendorExposure = {
    EffectName = "FSE_VENDOR_EXPOSURE",
    TweenInTime = 0.2,
    TweenOutTime = 0.35,
    Duration = 100000
  }
  storeLightParent = thisObj:FindSingleGOByName("Store_LightSetup")
  if vendorInteractRequested then
    vendorInteractRequested = LD.ExtractCallbacksForEvent(level, obj, vendorInteractRequested)
  end
  if vendorExitRequested then
    vendorExitRequested = LD.ExtractCallbacksForEvent(level, obj, vendorExitRequested)
  end
  game.SubObject.SetUpdateDisableDistance(thisObj, 12)
end
function OnFirstStart(level, obj)
  HideLights()
  CheckArtifactRecipes()
end
function OnStart(level, obj)
  HideLights()
  CheckArtifactRecipes()
  RemoveFaultyRunes()
  LostItemsCheck()
end
function OnUpdate(level, obj)
  if cameraOneShotApproach ~= nil then
    cameraOneShotApproach:Update()
  end
end
function StartVendorFX()
  game.FX.SubmitEffect(vendorExposure)
  game.FX.SubmitEffect(vendorKeyFSE)
end
function StopVendorFX()
  game.FX.StopEffect(vendorExposure)
  game.FX.StopEffect(vendorKeyFSE)
end
function LostItemsCheck()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 510 <= cineNumber then
    local spaceGem = game.Wallets.GetRunesWithFlags("HERO", {
      "Runestone_Tag_InfinitySpace"
    })
    local spaceGemLost = game.Wallets.GetResourceValue("LOST_ITEMS", "RuneCreator_Unique_Hellheim")
    if spaceGem ~= nil and #spaceGem <= 0 and spaceGemLost == -1 then
      game.Wallets.GenerateRune("LOST_ITEMS", "RuneCreator_Unique_Hellheim")
      game.Wallets.AddResource("LOST_ITEMS", "RuneCreator_Unique_Hellheim", 1, "NO_TELEMETRY")
    end
  end
  if 570 <= cineNumber then
    local glacialCatalystObtained = game.Wallets.GetResourceValue("HERO", "GlacialCatalyst")
    local glacialCatalystLost = game.Wallets.GetResourceValue("LOST_ITEMS", "GlacialCatalyst")
    if glacialCatalystObtained == 2 and glacialCatalystLost == -1 then
      local treasureMapBlink = game.QuestManager.GetQuestState("Quest_TreasureMap_BlackBreath_Parent")
      local treasureMapOars = game.QuestManager.GetQuestState("Quest_TreasureMap_Oarsmen_Parent")
      if treasureMapBlink == "Complete" and treasureMapOars == "Complete" then
        game.Wallets.AddResource("LOST_ITEMS", "GlacialCatalyst", 1, "NO_TELEMETRY")
      end
    end
  end
end
function DisableLights()
  if storeLightParent ~= nil then
    for _, desc in pairs(storeLightParent.Descendants) do
      desc:JumpAnimToFrame(45)
      desc:PlayAnimToFrame(60)
    end
  end
  timer.StartLevelTimer(1, HideLights)
end
function EnableLights()
  if storeLightParent ~= nil then
    storeLightParent:Show()
    for _, desc in pairs(storeLightParent.Descendants) do
      desc:JumpAnimToFrame(0)
      desc:PlayAnimToFrame(45)
    end
  end
end
function HideLights()
  if storeLightParent ~= nil then
    storeLightParent:Hide()
  end
end
function SetTutorialModeActive()
  tutorialActive = true
end
function EnableCinematicTrigger()
  print("vendor........cinematic trigger on...")
  interactZone:SetPromptIconSet(mainQuestIconTable)
  triggerCinematic = true
end
function DisableCinematicTrigger()
  print("vendor........cinematic trigger OFF...")
  interactZone:SetPromptIconSet(vendorIconTable)
  triggerCinematic = false
end
function SetVendorType(character)
  local name = character:GetName()
  vendorWalletName = string.upper(name)
  if character:GetName() == "brok00" then
    currentVendorNPC = "Brok"
  elseif character:GetName() == "sindri00" then
    currentVendorNPC = "Sindri"
  end
end
function SetLargeShopActive()
  isLargeShop = true
end
function ClearVendorNPC()
  currentVendorNPC = nil
  Disable()
end
function OnUseWorld(level, obj)
  if interactZone:PlayerCanInteract() then
    if vendorInteractRequested then
      LD.ExecuteCallbacksForEvent(thisObj.Level, thisObj, vendorInteractRequested, "VendorInteractRequested")
    end
    if not triggerCinematic then
      DetectSpecialRecipes()
      CullRuneRecipes()
      NGP_CullInvalidBackupHuldraArmor()
      NGP_FixupInvalidBowUpgrades()
      RemoveLostItemObjects()
      CheckQuestFailSafes()
      questTestTable.EnhancedGolemLoot.Before = game.Wallets.GetResourceValue("HERO", "EnhancedGolemLoot")
      StartVendorInteract()
    else
      Disable()
    end
    triggerCinematic = false
  end
end
function StartVendorInteract()
  player:RequestInteract(thisObj, interactZone)
  if son ~= nil and son:IsAvailableInLevel() then
    son:RequestInteract(thisObj, interactZone)
  end
  CameraApproachVendor()
  CheckArtifactRecipes()
  RemoveAcquiredRunicAttacks()
  CheckForWeaponFixUp()
  CheckForSpecialReinforcementFixUp()
end
function SindriServedCheck()
  print("SINDRI SERVED!!!")
  if LD.GetEntityVariable("CompletedCineNumber") >= 450 and LD.GetEntityVariable("CompletedCineNumber") < 510 then
    game.Audio.SetBanterFact("peakSindriServedMode", "True")
  else
    game.Audio.SetBanterFact("peakSindriServedMode", "False")
  end
end
local CheckIfSonInValidRange = function()
  local sonCameraPercent = game.Camera.GetViewPenetration(son:GetWorldPosition(), 0.5, 0.5)
  local distanceToSyncJoint = (thisObj:GetWorldPosition() - son:GetWorldPosition()):Length()
  local distanceToKratos = (player:GetWorldPosition() - son:GetWorldPosition()):Length()
  if distanceToKratos <= 2 then
    return true
  elseif 0.15 <= sonCameraPercent and distanceToSyncJoint <= 8 then
    return true
  else
    return false
  end
end
function PerformBrokIntroInteraction()
  if player == nil then
    player = game.Player.FindPlayer()
  end
  LD.PlaySingleSynchMove_KratosObject(thisObj, "syncJoint", "Vendor Enter", "BRA_VendorBrokEnter", "", interactZone, true, "Any")
  interactZone:Disable()
  if not game.GetNewGamePlus() then
    uiCalls.UI_Event_Setup_Tutorial("Vendor_UpgradeWeapon")
  else
    uiCalls.UI_Event_Setup_Tutorial("Vendor_NGPItems")
  end
  uiCalls.UI_Event_Hide_Attribute_Descriptions()
  game.UI.Idle(false, false)
end
function PerformInteraction()
  if player == nil then
    player = game.Player.FindPlayer()
  end
  LD.PlaySingleSynchMove_KratosObject(thisObj, "syncJoint", "Vendor Enter", "BRA_VendorEnter", "", interactZone, true, "Any")
  interactZone:Disable()
  game.UI.Idle(false, false)
end
function PerformSonInteraction()
  includeSon = true
  if CheckIfSonInValidRange() == true then
    SyncSon()
    warpSyncAllowed = false
  else
    warpSyncAllowed = true
  end
end
function LuaHook_StartSonWarp()
  if warpSyncAllowed then
    WarpAndSyncSon()
  end
end
function WarpAndSyncSon()
  local warpPos = thisObj:FindSingleGOByName("warpPosSon")
  son:Warp(warpPos:GetWorldPosition(), warpPos:GetWorldForward())
  SetSonOccupied()
  SonApproach()
end
function SyncSon()
  SetSonOccupied()
  SonApproach()
end
function SonApproach()
  local stoppingDist = 0.5
  local approachParam = {
    joint_name = "syncJointSon",
    branch_name = "BRA_VendorEnter",
    focus_end_direction = true,
    speed = 4,
    stop_distance = stoppingDist,
    complete_radius = stoppingDist,
    close_range_distance = 0.5,
    ignore_navmesh = true
  }
  son:AddMarker("InVendor")
  sonPuppeteer = game.Puppeteer.NewForce(thisObj, "Vendor Enter", son)
  sonPuppeteer:Approach(approachParam)
  son:SetActuator({StartDistance = 0.001})
  sonPuppeteer:OnComplete(SonArrival)
end
function SonArrival()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Sync("BRA_VendorEnter", true, {}, "syncJointSon")
    sonPuppeteer:OnComplete(ClearSonPuppeteer)
  end
end
function ClearSonPuppeteer()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Clear()
    sonPuppeteer:DetachPuppet()
    sonPuppeteer = nil
  end
end
function Enable()
  if autoEnableAllowed then
    interactZone:Enable()
    if triggerCinematic then
      interactZone:SetPromptIconSet(mainQuestIconTable)
    else
      interactZone:SetPromptIconSet(vendorIconTable)
    end
  end
end
function Disable()
  interactZone:Disable()
end
function PlayVendorBanterLine(banterName, npc)
  if CheckIfBanterAllowed() == true then
    if npc ~= nil then
      local banterPlay = tostring(banterName .. npc)
      game.Audio.PlayBanterNonCritical(banterPlay)
      print("PLAYING SHOP BANTER...............", banterPlay)
    else
      print("NPC is not valid, skip banter playing")
    end
  end
end
function CheckIfBanterAllowed()
  if LD.GetEntityVariable("CompletedCineNumber") >= 365 and LD.GetEntityVariable("CompletedCineNumber") < 390 then
    return false
  else
    return true
  end
end
function Trigger_Enter_Sell(level, gameObject)
  CheckArtifactRecipes()
end
function Trigger_Craft_Enter_SonArmor(level, gameObject)
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToSon")
  PlayVendorBanterLine("SonFocus", currentVendorNPC)
  player:AddMarker("SonSectionActive")
  son:AddMarker("ArmorActive")
  if son:HasMarker("QuiverActive") then
    son:RemoveMarker("QuiverActive")
  end
end
function Trigger_Craft_Exit_SonArmor(level, gameObject)
  son:TriggerMoveEvent("SwapToKratos")
  player:TriggerMoveEvent("SwapToKratos")
  PlayVendorBanterLine("KratosFocus", currentVendorNPC)
  RemoveCharacterMarkers()
end
function Trigger_Sell_Enter_SonArmor(level, gameObject)
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToSon")
  PlayVendorBanterLine("SonFocus", currentVendorNPC)
  player:AddMarker("SonSectionActive")
  son:AddMarker("ArmorActive")
  if son:HasMarker("QuiverActive") then
    son:RemoveMarker("QuiverActive")
  end
end
function Trigger_Sell_Exit_SonArmor(level, gameObject)
  player:TriggerMoveEvent("SwapToKratos")
  son:TriggerMoveEvent("SwapToKratos")
  PlayVendorBanterLine("KratosFocus", currentVendorNPC)
  RemoveCharacterMarkers()
end
function Trigger_Buy_Enter_SonArmor(level, gameObject)
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToSon")
  PlayVendorBanterLine("SonFocus", currentVendorNPC)
  player:AddMarker("SonSectionActive")
  son:AddMarker("ArmorActive")
  if son:HasMarker("QuiverActive") then
    son:RemoveMarker("QuiverActive")
  end
end
function Trigger_Buy_Exit_SonArmor(level, gameObject)
  player:TriggerMoveEvent("SwapToKratos")
  son:TriggerMoveEvent("SwapToKratos")
  PlayVendorBanterLine("KratosFocus", currentVendorNPC)
  RemoveCharacterMarkers()
end
function Trigger_Upgrade_Enter_Quiver(level, gameObject)
  print("GOT ENTER QUIVER")
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToQuiver")
  player:AddMarker("SonSectionActive")
  son:AddMarker("QuiverActive")
  if son:HasMarker("ArmorActive") then
    son:RemoveMarker("ArmorActive")
  end
end
function Trigger_Upgrade_Exit_Quiver(level, gameObject)
  player:TriggerMoveEvent("SwapToKratos")
  son:TriggerMoveEvent("SwapToKratos")
  player:AddMarker("SonSectionActive")
  son:AddMarker("QuiverActive")
  RemoveCharacterMarkers()
end
function Trigger_Buy_Enter_SonSpecial(level, gameObject)
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToSon")
end
function Trigger_Buy_Exit_SonSpecial(level, gameObject)
  player:TriggerMoveEvent("SwapToKratos")
  son:TriggerMoveEvent("SwapToKratos")
end
function RemoveCharacterMarkers()
  if son ~= nil then
    if son:HasMarker("QuiverActive") then
      son:RemoveMarker("QuiverActive")
    end
    if son:HasMarker("ArmorActive") then
      son:RemoveMarker("ArmorActive")
    end
  end
  if player:HasMarker("SonSectionActive") then
    player:RemoveMarker("SonSectionActive")
  end
  if player:HasMarker("AxeActive") then
    player:RemoveMarker("AxeActive")
  end
  if player:HasMarker("BladesActive") then
    player:RemoveMarker("BladesActive")
  end
  if player:HasMarker("PommelActive") then
    player:RemoveMarker("PommelActive")
  end
end
function Trigger_Buy_ResurrectionStone(level, gameObject)
  if game.Wallets.GetResourceValue("HERO", "ResurrectionStoneASold") == 1 and game.Wallets.GetResourceValue("HERO", "ResurrectionRuneStoneA") > 0 then
    game.Wallets.RemoveResource("HERO", "ResurrectionStoneASold", 1)
  end
  if game.Wallets.GetResourceValue("HERO", "ResurrectionStoneBSold") == 1 and 0 < game.Wallets.GetResourceValue("HERO", "ResurrectionRuneStoneB") then
    game.Wallets.RemoveResource("HERO", "ResurrectionStoneBSold", 1)
  end
  if game.Wallets.GetResourceValue("HERO", "ResurrectionStoneCSold") == 1 and 0 < game.Wallets.GetResourceValue("HERO", "ResurrectionRuneStoneC") then
    game.Wallets.RemoveResource("HERO", "ResurrectionStoneCSold", 1)
  end
  LD.SyncResurrectionStones(false)
  if CheckTutorialResource("ResStoneSecondTutorial") then
    game.Wallets.AddResource("HERO", "ResStoneSecondTutorial", 1, "NO_TELEMETRY")
    uiCalls.SendSplashScreenDesignerMessage({
      Title = 44307,
      Text = 44331,
      AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
      ImageMaterialName = "ResStones"
    })
  end
  playerHasMadePurchase = true
end
function Trigger_Buy_WeaponSpecial_Light(level, gameObject)
  playerHasMadePurchase = true
end
function Trigger_Buy_WeaponSpecial_Heavy(level, gameObject)
  playerHasMadePurchase = true
end
function Trigger_Buy_WeaponSpecial_Blades_Light(level, gameObject)
  playerHasMadePurchase = true
end
function Trigger_Buy_WeaponSpecial_Blades_Heavy(level, gameObject)
  playerHasMadePurchase = true
end
function Trigger_Sell_ArmorChest()
  PlayVendorBanterLine("CombinedResources", currentVendorNPC)
end
function Trigger_Sell_ArmorWrist()
  PlayVendorBanterLine("CombinedResources", currentVendorNPC)
end
function Trigger_Sell_ArmorLegs()
  PlayVendorBanterLine("CombinedResources", currentVendorNPC)
end
function Trigger_Sell_ResurrectionStone(level, gameObject)
  LD.SyncResurrectionStones(false)
  playerHasMadePurchase = true
  PlayVendorBanterLine("CombinedResources", currentVendorNPC)
end
function Trigger_Sell_Resource(level, gameObject)
  if game.GetNewGamePlus() == true then
    if game.Wallets.GetResourceValue("HERO", "OblivionStone") > 0 then
      LD.AddRecipe_Safe("HERO", "Recipe_OblivionStone_Sellback")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "UnstableOre") then
      LD.AddRecipe_Safe("HERO", "Recipe_UnstableOre_Sellback")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "LeiptrAlloy") then
      LD.AddRecipe_Safe("HERO", "Recipe_LeiptrAlloy_Sellback")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "GlacialCatalyst") then
      LD.AddRecipe_Safe("HERO", "Recipe_GlacialCatalyst_Sellback")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "UnyieldingCinders") then
      LD.AddRecipe_Safe("HERO", "Recipe_UnyieldingCinders_Sellback")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "BladesReinforcement") then
      LD.AddRecipe_Safe("HERO", "Recipe_ChaosFlame_Sellback")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "AxeReinforcement") then
      LD.AddRecipe_Safe("HERO", "Recipe_FrozenFlame_Sellback")
    end
  end
end
function Trigger_Sell_Artifact(level, gameObject)
  local cal120 = game.FindLevel("Cal120_Airlock")
  if cal120 ~= nil then
    cal120:CallScript("ArtifactVisibility")
  end
  PlayVendorBanterLine("CombinedResources", currentVendorNPC)
end
function Trigger_Craft_Enter_WeaponComponent(level, gameObject)
  CheckForWeaponPommelTutorial()
  if not player:HasMarker("PommelActive") then
    player:AddMarker("PommelActive")
  end
  local weapon = player:GetCurrentWeapon()
  if weapon ~= "Axe" then
    player:TriggerMoveEvent("VendorEquipAxe")
    if not player:HasMarker("AxeActive") and not player:HasMarker("ThrowEquipInProgress") then
      player:AddMarker("AxeActive")
    end
  else
    player:TriggerMoveEvent("SwapIdleToPommel")
  end
end
function Trigger_Craft_Exit_WeaponComponent(level, gameObject)
  if player:HasMarker("PommelActive") then
    player:RemoveMarker("PommelActive")
  end
  if player:HasMarker("AxeActive") then
    player:RemoveMarker("AxeActive")
  end
  player:TriggerMoveEvent("SwapPommelToIdle")
end
function Trigger_Craft_Enter_WeaponComponent_Blades(level, gameObject)
  if not player:HasMarker("PommelActive") then
    player:AddMarker("PommelActive")
  end
  local weapon = player:GetCurrentWeapon()
  if weapon ~= "Blades" then
    if not player:HasMarker("ThrowEquipInProgress") then
      player:TriggerMoveEvent("VendorEquipBlades")
    end
    if not player:HasMarker("BladesActive") then
      player:AddMarker("BladesActive")
    end
  else
    player:TriggerMoveEvent("SwapIdleToPommel")
  end
end
function Trigger_Craft_Exit_WeaponComponent_Blades(level, gameObject)
  if player:HasMarker("BladesActive") then
    player:RemoveMarker("BladesActive")
  end
  if player:HasMarker("PommelActive") then
    player:RemoveMarker("PommelActive")
  end
  player:TriggerMoveEvent("SwapPommelToIdle")
end
function Trigger_Craft_Enter_ArmorTrinket(level, gameObject)
  CheckForTalismanTutorial()
end
function Trigger_Craft_ArmorChest(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartChestReact")
  PlayVendorBanterLine("ShopExitArmorSale", currentVendorNPC)
  SpecificArmorCheck()
end
function Trigger_Craft_ArmorWrist(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartBracerReact")
  PlayVendorBanterLine("ShopExitArmorSale", currentVendorNPC)
  SpecificArmorCheck()
end
function Trigger_Craft_ArmorLegs(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartLegReact")
  PlayVendorBanterLine("ShopExitArmorSale", currentVendorNPC)
  SpecificArmorCheck()
end
function Trigger_Craft_SonArmor(level, gameObject, pickupName)
  playerHasMadePurchase = true
  print("triggering bow react")
  son:TriggerMoveEvent("StartChestReact")
  PlayVendorBanterLine("SonArmorCraft", currentVendorNPC)
  game.UnlockTrophy(19)
end
function Trigger_Buy_Resource(level, gameObject, resourceName)
  if resourceName == "AxeReinforcement" then
    player:CallScript("LuaHook_IncrementAxeQuest")
    print("AxeReinforcement Gained")
  end
  if resourceName == "BladesReinforcement" then
    player:CallScript("LuaHook_IncrementBladesQuest")
  end
  if resourceName == "EntryStoneNiflheim" then
    LD.CompleteQuest("Quest_Sindri_Niflheim_Objective01b")
    niflheimEntryBought = true
  end
  playerHasMadePurchase = true
end
function Trigger_Buy_Rune(level, gameObject)
  playerHasMadePurchase = true
end
function Trigger_Craft_WeaponComponent(level, gameObject, pickupName)
  playerHasMadePurchase = true
end
function Trigger_Exit_Craft_WeaponComponent(level, gameObject, pickupName)
  player:TriggerMoveEvent("SwapPommelToIdle")
end
function Trigger_Craft_WeaponComponent_Blades(level, gameObject, pickupName)
  playerHasMadePurchase = true
end
function Trigger_Craft_ArmorTrinket(level, gameObject, pickupName)
  playerHasMadePurchase = true
end
function Trigger_Upgrade_Enter_ArmorChest(level, gameObject)
end
function Trigger_Upgrade_Enter_ArmorWrist(level, gameObject)
end
function Trigger_Upgrade_Enter_ArmorLegs(level, gameObject)
end
function Trigger_Upgrade_Enter_SonArmor(level, gameObject, submenuIndex)
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToSon")
  son:AddMarker("ArmorActive")
  player:AddMarker("SonSectionActive")
  PlayVendorBanterLine("SonFocus", currentVendorNPC)
  if son:HasMarker("QuiverActive") then
    son:RemoveMarker("QuiverActive")
  end
end
function Trigger_Upgrade_Enter_Axe(level, gameObject)
  local weapon = player:GetCurrentWeapon()
  if weapon ~= "Axe" then
    player:TriggerMoveEvent("VendorEquipAxe")
    if not player:HasMarker("AxeActive") and not player:HasMarker("ThrowEquipInProgress") then
      player:AddMarker("AxeActive")
    end
  end
end
function Trigger_Upgrade_Exit_Axe(level, gameObject)
  if player:HasMarker("AxeActive") then
    player:RemoveMarker("AxeActive")
  end
end
function Trigger_Upgrade_Enter_Blades(level, gameObject)
  local weapon = player:GetCurrentWeapon()
  if weapon ~= "Blades" then
    if not player:HasMarker("ThrowEquipInProgress") then
      player:TriggerMoveEvent("VendorEquipBlades")
    end
    if not player:HasMarker("BladesActive") then
      player:AddMarker("BladesActive")
    end
  end
end
function Trigger_Upgrade_Exit_Blades(level, gameObject)
  if player:HasMarker("BladesActive") then
    player:RemoveMarker("BladesActive")
  end
end
function Trigger_Upgrade_Enter_SonBow(level, gameObject)
  player:TriggerMoveEvent("SwapToSon")
  son:TriggerMoveEvent("SwapToSon")
  PlayVendorBanterLine("SonFocus", currentVendorNPC)
  son:AddMarker("ArmorActive")
  player:AddMarker("SonSectionActive")
  if son:HasMarker("QuiverActive") then
    son:RemoveMarker("QuiverActive")
  end
end
function Trigger_Upgrade_Enter_WeaponComponent(level, gameObject)
  CheckForWeaponPommelTutorial()
  if not player:HasMarker("PommelActive") then
    player:AddMarker("PommelActive")
  end
  local weapon = player:GetCurrentWeapon()
  if weapon ~= "Axe" then
    player:TriggerMoveEvent("VendorEquipAxe")
    if not player:HasMarker("AxeActive") and not player:HasMarker("ThrowEquipInProgress") then
      player:AddMarker("AxeActive")
    end
  else
    player:TriggerMoveEvent("SwapIdleToPommel")
  end
end
function Trigger_Upgrade_Enter_WeaponComponent_Blades(level, gameObject)
  if not player:HasMarker("PommelActive") then
    player:AddMarker("PommelActive")
  end
  local weapon = player:GetCurrentWeapon()
  if weapon ~= "Blades" then
    if not player:HasMarker("ThrowEquipInProgress") then
      player:TriggerMoveEvent("VendorEquipBlades")
    end
    if not player:HasMarker("BladesActive") then
      player:AddMarker("BladesActive")
    end
  else
    player:TriggerMoveEvent("SwapIdleToPommel")
  end
end
function Trigger_Upgrade_Enter_ArmorTrinket(level, gameObject)
  CheckForTalismanTutorial()
end
function Trigger_Upgrade_Exit_ArmorChest(level, gameObject)
end
function Trigger_Upgrade_Exit_ArmorWrist(level, gameObject)
end
function Trigger_Upgrade_Exit_ArmorLegs(level, gameObject)
end
function Trigger_Upgrade_Exit_SonArmor(level, gameObject)
  son:TriggerMoveEvent("SwapToKratos")
  player:TriggerMoveEvent("SwapToKratos")
  PlayVendorBanterLine("KratosFocus", currentVendorNPC)
  RemoveCharacterMarkers()
end
function Trigger_Upgrade_Exit_SonBow(level, gameObject)
  son:TriggerMoveEvent("SwapToKratos")
  player:TriggerMoveEvent("SwapToKratos")
  PlayVendorBanterLine("KratosFocus", currentVendorNPC)
  RemoveCharacterMarkers()
end
function Trigger_Upgrade_Exit_WeaponComponent(level, gameObject)
  if player:HasMarker("PommelActive") then
    player:RemoveMarker("PommelActive")
  end
  if player:HasMarker("AxeActive") then
    player:RemoveMarker("AxeActive")
  end
  player:TriggerMoveEvent("SwapPommelToIdle")
end
function Trigger_Upgrade_Exit_WeaponComponent_Blades(level, gameObject)
  if player:HasMarker("PommelActive") then
    player:RemoveMarker("PommelActive")
  end
  if player:HasMarker("BladesActive") then
    player:RemoveMarker("BladesActive")
  end
  player:TriggerMoveEvent("SwapPommelToIdle")
end
function Trigger_Upgrade_Exit_ArmorTrinket(level, gameObject)
end
function Trigger_Upgrade_ArmorChest(level, gameObject, pickupName)
  player:TriggerMoveEvent("StartChestReact")
  PlayVendorBanterLine("ShopExitArmorSale", currentVendorNPC)
  playerHasMadePurchase = true
  game.UnlockTrophy(15)
end
function Trigger_Upgrade_ArmorWrist(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartBracerReact")
  PlayVendorBanterLine("ShopExitArmorSale", currentVendorNPC)
  game.UnlockTrophy(15)
end
function Trigger_Upgrade_ArmorLegs(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartLegReact")
  PlayVendorBanterLine("ShopExitArmorSale", currentVendorNPC)
  game.UnlockTrophy(15)
end
function Trigger_Upgrade_SonArmor(level, gameObject, pickupName)
  playerHasMadePurchase = true
end
function Trigger_Upgrade_Axe(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartAxeReact")
  if not tutorialActive then
    PlayVendorBanterLine("ShopExitAxeSale", currentVendorNPC)
  end
  StripOutSpecialReinforcementRecipes()
  CheckForWeaponFixUp()
  TrophyCheck()
  game.QuestManager.IncrementQuestProgress("Quest_AxeUpgrade_Craft", 1)
end
function Trigger_Upgrade_Blades(level, gameObject, pickupName)
  playerHasMadePurchase = true
  player:TriggerMoveEvent("StartBladesReact")
  PlayVendorBanterLine("ShopExitBladesSale", currentVendorNPC)
  StripOutSpecialReinforcementRecipes()
  TrophyCheck()
  game.QuestManager.IncrementQuestProgress("Quest_BladesUpgrade_Craft", 1)
end
function Trigger_Upgrade_SonBow(level, gameObject, pickupName)
  playerHasMadePurchase = true
  son:TriggerMoveEvent("StartBowReact")
  PlayVendorBanterLine("SonWeaponCraft", currentVendorNPC)
end
function Trigger_Upgrade_WeaponComponent(level, gameObject, pickupName)
  playerHasMadePurchase = true
  if not tutorialActive then
    PlayVendorBanterLine("ShopExitAxeSale", currentVendorNPC)
  end
end
function Trigger_Upgrade_Quiver(level, gameObject, pickupName)
  son:TriggerMoveEvent("StartQuiverReact")
  playerHasMadePurchase = true
end
function Trigger_Upgrade_WeaponComponent_Blades(level, gameObject, pickupName)
  PlayVendorBanterLine("ShopExitBladesSale", currentVendorNPC)
  playerHasMadePurchase = true
end
function Trigger_Upgrade_ArmorTrinket(level, gameObject, pickupName)
  playerHasMadePurchase = true
end
function LuaHook_CheckForPickup()
  if player:PickupIsAcquired("InteractAbort") then
    player:PickupRelinquish("InteractAbort")
  end
end
function TriggerExit()
  if not player:PickupIsAcquired("InteractAbort") then
    player:PickupAcquire("InteractAbort")
  end
  RemoveCharacterMarkers()
  if not tutorialActive then
    if playerHasMadePurchase then
      PlayVendorBanterLine("ShopExitSale", currentVendorNPC)
    else
      PlayVendorBanterLine("ShopExitNoSale", currentVendorNPC)
    end
  end
  ClearSonPuppeteer()
  if son ~= nil and son:HasMarker("InVendor") then
    son:RemoveMarker("InVendor")
  end
  if playerHasMadePurchase and not tutorialActive then
    if niflheimEntryBought == true then
      niflheimEntryBought = false
      game.World.StoreCheckpoint()
    else
      game.SubObject.SoftSave(thisObj)
    end
    playerHasMadePurchase = false
  end
  if not tutorialActive then
    player:TriggerMoveEvent("ExitCrafting")
    if son ~= nil then
      son:TriggerMoveEvent("ExitCrafting")
    end
    vendorIsActive = false
  else
    tutorialActive = false
    player:TriggerMoveEvent("ExitCraftingTutorial")
    LD.SetMarkerState("RP_300_VendorLocation", 1)
    LD.UpdateMap("RP_300_VendorLocation", 0)
  end
  if game.QuestManager.GetQuestState("Quest_TravelerArmor_Parent") == "Inactive" and 0 < game.Wallets.GetResourceValue("HERO", "TravelerLoot") then
    LD.ActivateQuest("Quest_TravelerArmor_Parent")
  end
end
function LuaHook_ExitAnimDone()
  StopVendorFX()
  if vendorExitRequested then
    print("Vendor Exit requested")
    LD.ExecuteCallbacksForEvent(thisObj.Level, thisObj, vendorExitRequested, "Vendor Exit Requested")
  end
end
function BlockAutoEnable(data)
  print("blocking vendor auto enable..", data)
  if data == true then
    autoEnableAllowed = false
  else
    autoEnableAllowed = true
    Enable()
  end
end
function LuaHook_RemoveAxeMarker()
  if player:HasMarker("AxeActive") then
    player:RemoveMarker("AxeActive")
  end
end
function LuaHook_RemoveBladeMarker()
  if player:HasMarker("BladesActive") then
    player:RemoveMarker("BladesActive")
  end
end
function SetSonOccupied()
  local availabilityState = {Unoccupied = false}
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function RemoveSonOccupied()
  son:EndInteract()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function OnMenuExclusiveAccess()
  if not tutorialActive then
    CheckForNewTutorials()
  end
end
function OnInteractStart(level, obj, creature)
  if creature:GetName() == "heroa00" then
    print("INTERACT STARTED")
    SindriServedCheck()
    uiCalls.UI_Global_Menu_Set_Exclusive_Access("GlobalVendor")
    uiCalls.UI_Global_Menu_Request_Exclusive_Access("GlobalVendor", thisObj)
    print("Creature granted is....", creature)
    vendorIsActive = true
    if not tutorialActive then
      PerformInteraction()
    else
      PerformBrokIntroInteraction()
    end
    if CheckIfBanterAllowed() == true then
      if newItemsAdded then
        PlayVendorBanterLine("NewItems", currentVendorNPC)
      else
        PlayVendorBanterLine("ShopStart", currentVendorNPC)
      end
    elseif currentVendorNPC == "Brok" then
      game.Audio.PlayBanterNonCritical("BoylessBrok")
    end
    if player:PickupIsAcquired("InteractAbort") then
      player:PickupRelinquish("InteractAbort")
    end
    if son ~= nil and son:IsAvailableInLevel() == true then
      PerformSonInteraction()
    end
    if thisObj:FindLuaTableAttribute("onEnterShopEvent") ~= nil then
      LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onEnterShopEvent"), "Vendor Entered")
    end
  end
end
function OnInteractAbort(level, obj, creature)
  uiCalls.UI_Event_Close_Vendor_Menu()
end
function OnInteractDone(level, obj, creature)
  uiCalls.UI_Global_Menu_Clear_Exclusive_Access("GlobalVendor")
  if includeSon then
    RemoveSonOccupied()
  end
  timer.StartLevelTimer(1.5, Enable)
  vendorIsActive = false
  if thisObj:FindLuaTableAttribute("onExitShopEvent") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onExitShopEvent"), "Vendor Exited")
  end
  includeSon = false
  MoveFromMainToSaveOnly()
  questTestTable.EnhancedGolemLoot.After = game.Wallets.GetResourceValue("HERO", "EnhancedGolemLoot")
  if questTestTable.EnhancedGolemLoot.After ~= nil and questTestTable.EnhancedGolemLoot.Before ~= nil and questTestTable.EnhancedGolemLoot.After > questTestTable.EnhancedGolemLoot.Before then
    LD.ActivateQuest("Quest_GolemArmor_Parent")
    timer.StartLevelTimer(1, function()
      game.SubObject.SoftSave()
    end)
  end
end
function LuaHook_OpenVendorMenu()
  timer.StartLevelTimer(0.1, StartVendorFX)
  if vendorWalletName ~= nil then
    if CheckForSharedShop() == true then
      uiCalls.UI_Event_Open_Vendor_Menu(vendorWalletName, true)
    else
      uiCalls.UI_Event_Open_Vendor_Menu(vendorWalletName)
    end
  else
    uiCalls.UI_Event_Open_Vendor_Menu("BROK00")
  end
  LostItemTutorialCheck()
  if not warpSyncAllowed then
    timer.StartLevelTimer(1.5, AllowVendorExit)
  end
  timer.StartLevelTimer(2.5, AllowVendorExit)
end
function CheckForSharedShop()
  if game.Level.GetVariable("CompletedCineNumber") >= 510 and isLargeShop then
    return true
  else
    return false
  end
end
function LuaHook_SonArrivedAtVendor()
  AllowVendorExit()
end
function LuaHook_StartLightRamp()
  EnableLights()
end
function LuaHook_RampOffLights()
  DisableLights()
end
function DontAllowExit()
  uiCalls.UI_Event_SetExitNotAllowed()
end
function AllowVendorExit()
  uiCalls.UI_Event_SetExitAllowed()
end
function CheckForNewTutorials()
  if (game.Wallets.HasResource("HERO", "ResurrectionStoneFlag") == true or player:PickupIsAcquired("ResurrectionStoneFlag")) and LD.GetEntityVariable("CompletedCineNumber") >= 185 and CheckTutorialResource("ResurrectionStoneTutorial") and HasStoneBeenCreated() == false then
    uiCalls.UI_Event_Setup_Tutorial("Vendor_ResurrectionStone")
    game.Wallets.AddResource("HERO", "ResurrectionStoneTutorial", 1, "NO_TELEMETRY")
  end
  if LD.GetEntityVariable("CompletedCineNumber") == 183 and CheckTutorialResource("ArmorUpgradeTutorial") then
    uiCalls.UI_Event_Setup_Tutorial("Vendor_UpgradeArmor")
    game.Wallets.AddResource("HERO", "ArmorUpgradeTutorial", 1, "NO_TELEMETRY")
    playerHasMadePurchase = true
  end
end
function HasStoneBeenCreated()
  local valueA = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneA")
  local valueB = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneB")
  local valueC = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneC")
  local created = -1 < valueA or -1 < valueB or -1 < valueC
  if created then
    return true
  else
    return false
  end
end
function LostItemTutorialCheck()
  local lostItemsCount = 0
  local lostRunes = game.Wallets.GetAllRunes("LOST_ITEMS")
  local lostResources = game.Wallets.GetExistingResources("LOST_ITEMS")
  for i = #lostResources, 1, -1 do
    if not game.Resources.HasFlag(lostResources[i], "Resource") and not game.Resources.HasFlag(lostResources[i], "Pickup") then
      table.remove(lostResources, i)
    end
  end
  lostItemsCount = #lostResources + #lostRunes
  print("Lost item count is...", lostItemsCount)
  if 0 < lostItemsCount and LD.GetEntityVariable("CompletedCineNumber") > 185 then
    FireLostItemsTutorial()
  end
end
function FireLostItemsTutorial()
  if CheckTutorialResource("LostItemTutorial") then
    uiCalls.UI_Event_Setup_And_Begin_Tutorial("LostItemTutorial", "Vendor_LostItems")
    playerHasMadePurchase = true
  end
end
function CheckForWeaponPommelTutorial()
  if CheckTutorialResource("AxePommelTutorial") then
    uiCalls.UI_Event_Setup_And_Begin_Tutorial("AxePommelTutorial", "Shared_AxePommelTutorial")
    playerHasMadePurchase = true
  end
end
function CheckForTalismanTutorial()
  if CheckTutorialResource("TalismanTutorial") then
    uiCalls.UI_Event_Setup_And_Begin_Tutorial("TalismanTutorial", "Shared_Talisman")
    playerHasMadePurchase = true
  end
end
function CheckTutorialResource(resource)
  local resourceValue = game.Wallets.GetResourceValue("HERO", resource)
  local hasResource = -1 < resourceValue
  return not hasResource
end
function CheckArtifactRecipes()
  local toyRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_Toys")
  local maskRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_NorseMasks")
  local shipRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_ShipHeads")
  local alfheimRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_Alfheim")
  local cupRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_Cups")
  local hornRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_Horns")
  local broochRecipe = game.Wallets.CanPurchase("HERO", "Recipe_Artifacts_Brooches")
  if toyRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_Toys")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_Toys") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_Toys")
  end
  if maskRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_NorseMasks")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_NorseMasks") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_NorseMasks")
  end
  if shipRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_ShipHeads")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_ShipHeads") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_ShipHeads")
  end
  if alfheimRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_Alfheim")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_Alfheim") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_Alfheim")
  end
  if cupRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_Cups")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_Cups") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_Cups")
  end
  if hornRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_Horns")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_Horns") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_Horns")
  end
  if broochRecipe == true then
    game.Wallets.AddRecipe("HERO", "Recipe_Artifacts_Brooches")
  elseif game.Wallets.HasRecipe("HERO", "Recipe_Artifacts_Brooches") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_Artifacts_Brooches")
  end
end
function RemoveFaultyRunes()
  if game.Wallets.GetRunesWithFlags("HERO", {"Artifact"}) ~= nil then
    local result = game.Wallets.GetRunesWithFlags("LOST_ITEMS", {"Artifact"})
    for _, runeId in ipairs(result) do
      game.Wallets.ExchangeRune("BROK00", "LOST_ITEMS", runeId)
    end
  end
end
function CheckForSpecialReinforcementFixUp()
  if game.Wallets.GetResourceValue("HERO", "MuspelheimBladesReinforcement") >= 1 or LD.GetEntityVariable("CompletedCineNumber") >= 610 and not game.Wallets.HasResource("HERO", "MuspRecipeTracker") then
    LD.AddRecipe_Safe("HERO", "Recipe_BladesReinforcement")
  end
  if 1 <= game.Wallets.GetResourceValue("HERO", "NiflheimAxeReinforcement") or LD.GetEntityVariable("CompletedCineNumber") >= 610 and not game.Wallets.HasResource("HERO", "NifRecipeTracker") then
    LD.AddRecipe_Safe("HERO", "Recipe_AxeReinforcement")
  end
end
function CheckForWeaponFixUp()
  local axeStage = player:PickupGetStage("Axe")
  if game.Wallets.GetResourceValue("HERO", "AxeReinforcement") == 0 and axeStage == 4 and game.Wallets.HasResource("HERO", "NifRecipeTracker") and hasFixedUp == false then
    hasFixedUp = true
    game.Resources.SetDebugAddMode(true)
    game.Wallets.AddResource("HERO", "AxeReinforcement", 1)
    game.Resources.SetDebugAddMode(false)
    playerHasMadePurchase = true
  end
end
function StripOutSpecialReinforcementRecipes()
  if game.Wallets.HasResource("HERO", "MuspRecipeTracker") and game.Wallets.HasRecipe("HERO", "Recipe_BladesReinforcement") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladesReinforcement")
  end
  if game.Wallets.HasResource("HERO", "NifRecipeTracker") and game.Wallets.HasRecipe("HERO", "Recipe_AxeReinforcement") then
    game.Wallets.RemoveRecipe("HERO", "Recipe_AxeReinforcement")
  end
end
function RemoveAcquiredRunicAttacks()
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeQuickClear") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeQuickClear") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeQuickClear")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeQuickClear")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeSweep") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeSweep") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeSweep")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeSweep")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeTossGrind") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeTossGrind") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeTossGrind")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeTossGrind")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeFlurryChop") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeFlurryChop") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeFlurryChop")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeFlurryChop")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeSpin") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeSpin") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeSpin")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeSpin")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeRake") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeRake") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeRake")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeRake")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_BladeSpecialSpin") and (game.Wallets.HasResource("HERO", "BladeSpecialSpin") or game.Wallets.HasResource("LOST_ITEMS", "BladeSpecialSpin")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladeSpecialSpin")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_BladeSpecialCross") and (game.Wallets.HasResource("HERO", "BladeSpecialCross") or game.Wallets.HasResource("LOST_ITEMS", "BladeSpecialCross")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladeSpecialCross")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_BladeSpecialFlurryStab") and (game.Wallets.HasResource("HERO", "BladeSpecialFlurryStab") or game.Wallets.HasResource("LOST_ITEMS", "BladeSpecialFlurryStab")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladeSpecialFlurryStab")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_BladeSpecialFlurrySpin") and (game.Wallets.HasResource("HERO", "BladeSpecialFlurrySpin") or game.Wallets.HasResource("LOST_ITEMS", "BladeSpecialFlurrySpin")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladeSpecialFlurrySpin")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_FrostSpecialAxeWeaponBuff") and (game.Wallets.HasResource("HERO", "FrostSpecialAxeWeaponBuff") or game.Wallets.HasResource("LOST_ITEMS", "FrostSpecialAxeWeaponBuff")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_FrostSpecialAxeWeaponBuff")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_BladeSpecialTripleSlam") and (game.Wallets.HasResource("HERO", "BladeSpecialTripleSlam") or game.Wallets.HasResource("LOST_ITEMS", "BladeSpecialTripleSlam")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladeSpecialTripleSlam")
  end
  if game.Wallets.HasRecipe("HERO", "Recipe_BladeSpecialTwirlBarrage") and (game.Wallets.HasResource("HERO", "BladeSpecialTwirlBarrage") or game.Wallets.HasResource("LOST_ITEMS", "BladeSpecialTwirlBarrage")) then
    game.Wallets.RemoveRecipe("HERO", "Recipe_BladeSpecialTwirlBarrage")
  end
end
function DetectSpecialRecipes()
  local weaponSpecialRecipes = game.Wallets.GetRecipesWithFlags("HERO", {
    "WeaponSpecial_Recipe"
  })
  if 0 <= #weaponSpecialRecipes then
    return
  end
  for _, recipeName in pairs(weaponSpecialRecipes) do
    local resourceName = string.sub(recipeName, string.len("Recipe_") + 1, -1)
    if -1 < game.Wallets.GetResourceValue("HERO", resourceName) then
      game.Wallets.RemoveRecipe(recipeName)
    end
  end
end
function MoveFromMainToSaveOnly()
  local resources = game.Wallets.GetResourcesWithFlags("HERO", {"SaveOnly"}, {
    "ResurrectionStone"
  })
  for _, v in pairs(resources) do
    local amount = game.Wallets.GetResourceValue("HERO", v)
    game.Wallets.RemoveResource("HERO", v, amount)
    game.Wallets.AddResource("HERO_SAVEONLY", v, amount, "NO_TELEMETRY", "", true)
  end
end
function RemoveLostItemObjects()
  local lostItemDrops = game.World.FindGameObjectsByMarker("LostItem", player:GetWorldPosition(), 100)
  for _, lostItem in pairs(lostItemDrops) do
    if lostItem:GetLuaTableAttribute("Reward") ~= "STN750_RUNIC_REWARD" then
      lostItem:CallScript("DestroyLostItem")
    end
  end
end
function CullRuneRecipes()
  local cullingTable = {
    Recipe_PurchaseCommonRune_Tier2 = {
      "Recipe_PurchaseCommonRune_Tier3",
      "Recipe_PurchaseCommonRune_Tier4"
    },
    Recipe_PurchaseCommonRune_Tier3 = {
      "Recipe_PurchaseCommonRune_Tier4"
    },
    Recipe_PurchaseRareRune_Tier3 = {
      "Recipe_PurchaseRareRune_Tier4",
      "Recipe_PurchaseRareRune_Tier5"
    },
    Recipe_PurchaseRareRune_Tier4 = {
      "Recipe_PurchaseRareRune_Tier5"
    },
    Recipe_PurchaseLegendaryRune_Tier5 = {
      "Recipe_PurchaseLegendaryRune_Tier6"
    },
    Recipe_PurchaseEpicRune_Tier6 = {
      "Recipe_PurchaseEpicRune_Tier7",
      "Recipe_PurchaseEpicRune_Tier8"
    },
    Recipe_PurchaseEpicRune_Tier7 = {
      "Recipe_PurchaseEpicRune_Tier8"
    }
  }
  local buyRecipes = {}
  for _, r in pairs(game.Wallets.GetRecipesWithFlags("HERO", {"Buy", "Rune"})) do
    buyRecipes[r] = true
  end
  for r, _ in pairs(buyRecipes) do
    if cullingTable[r] ~= nil then
      for i = 1, #cullingTable[r] do
        if buyRecipes[cullingTable[r][i]] ~= nil then
          game.Wallets.RemoveRecipe("HERO", r)
          break
        end
      end
    end
  end
end
function NGP_CullInvalidBackupHuldraArmor()
  if not game.GetNewGamePlus() then
    return
  end
  local cullingTable = {
    Recipe_KratosArmorChest_HuldraBrokSet_Tier06_Backup = {
      "Recipe_KratosArmorChest_HuldraBrokSet_Tier06"
    },
    Recipe_KratosArmorWrist_HuldraBrokSet_Tier06_Backup = {
      "Recipe_KratosArmorWrist_HuldraBrokSet_Tier06"
    },
    Recipe_KratosArmorLegs_HuldraBrokSet_Tier06_Backup = {
      "Recipe_KratosArmorLegs_HuldraBrokSet_Tier06"
    },
    Recipe_KratosArmorChest_HuldraSindriSet_Tier06_Backup = {
      "Recipe_KratosArmorChest_HuldraSindriSet_Tier06"
    },
    Recipe_KratosArmorWrist_HuldraSindriSet_Tier06_Backup = {
      "Recipe_KratosArmorWrist_HuldraSindriSet_Tier06"
    },
    Recipe_KratosArmorLegs_HuldraSindriSet_Tier06_Backup = {
      "Recipe_KratosArmorLegs_HuldraSindriSet_Tier06"
    },
    Recipe_KratosArmorChest_HuldraBrokSet_Tier06_Backup_NGP = {
      "Recipe_KratosArmorChest_HuldraBrokSet_Tier06_NGP"
    },
    Recipe_KratosArmorWrist_HuldraBrokSet_Tier06_Backup_NGP = {
      "Recipe_KratosArmorWrist_HuldraBrokSet_Tier06_NGP"
    },
    Recipe_KratosArmorLegs_HuldraBrokSet_Tier06_Backup_NGP = {
      "Recipe_KratosArmorLegs_HuldraBrokSet_Tier06_NGP"
    },
    Recipe_KratosArmorChest_HuldraSindriSet_Tier06_Backup_NGP = {
      "Recipe_KratosArmorChest_HuldraSindriSet_Tier06_NGP"
    },
    Recipe_KratosArmorWrist_HuldraSindriSet_Tier06_Backup_NGP = {
      "Recipe_KratosArmorWrist_HuldraSindriSet_Tier06_NGP"
    },
    Recipe_KratosArmorLegs_HuldraSindriSet_Tier06_Backup_NGP = {
      "Recipe_KratosArmorLegs_HuldraSindriSet_Tier06_NGP"
    }
  }
  local buyRecipes = {}
  for _, r in pairs(game.Wallets.GetRecipesWithFlags("HERO", {"Brok", "Sindri"})) do
    buyRecipes[r] = true
  end
  for r, _ in pairs(buyRecipes) do
    if cullingTable[r] ~= nil then
      for i = 1, #cullingTable[r] do
        if buyRecipes[cullingTable[r][i]] ~= nil then
          game.Wallets.RemoveRecipe("HERO", r)
          break
        end
      end
    end
  end
end
function FixupRecipesByStage(list, stage)
  for i = 1, #list do
    if i ~= stage + 1 and game.Wallets.HasRecipe("HERO", list[i]) then
      game.Wallets.RemoveRecipe("HERO", list[i])
    end
    if i == stage + 1 and not game.Wallets.HasRecipe("HERO", list[i]) then
      game.Wallets.AddRecipe("HERO", list[i])
    end
  end
end
function NGP_FixupInvalidBowUpgrades()
  if not game.GetNewGamePlus() then
    return
  end
  local sonBowStage = game.Pickup.GetProfileStage("SonBow")
  local sonQuiverStage = game.Pickup.GetProfileStage("SonQuiver")
  local sonBowUpgrades = {
    "Recipe_ReinforceBow_Tier02",
    "Recipe_ReinforceBow_Tier03",
    "Recipe_ReinforceBow_Tier04",
    "Recipe_ReinforceBow_Tier05",
    "Recipe_ReinforceBow_Tier06"
  }
  local sonQuiverUpgrades = {
    "Recipe_ReinforcementQuiver_Tier02",
    "Recipe_ReinforcementQuiver_Tier03",
    "Recipe_ReinforcementQuiver_Tier04"
  }
  FixupRecipesByStage(sonBowUpgrades, sonBowStage)
  FixupRecipesByStage(sonQuiverUpgrades, sonQuiverStage)
end
function CheckQuestFailSafes()
  if game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker1") == 1 and game.QuestManager.GetQuestState("Quest_GolemArmor_Parent") == "Inactive" then
    LD.ActivateQuest("Quest_GolemArmor_Parent")
  end
  if game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker1") == 1 and game.QuestManager.GetQuestState("Quest_TravelerArmor_Parent") == "Inactive" then
    LD.ActivateQuest("Quest_TravelerArmor_Parent")
  end
  local golem, amount = game.QuestManager.GetQuestProgressAndGoal("Quest_Labor_AncientKills")
  if 1 > game.Wallets.GetResourceValue("HERO", "GolemFailsafe") and 0 < amount then
    VerifyGolemContent()
  end
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_Labor_TravelerKills")
  if 1 > game.Wallets.GetResourceValue("HERO", "TravelerFailSafe") and 0 < progress then
    VerifyTravelerContent()
  end
  if 0 > game.Wallets.GetResourceValue("LOST_ITEMS", "LeiptrAlloy") and game.QuestManager.GetQuestState("Quest_StoneMason_Objective400") == "Complete" then
    game.Wallets.AddResource("LOST_ITEMS", "LeiptrAlloy", 1)
  end
end
function VerifyGolemContent()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_Labor_AncientKills")
  if game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker1") < 1 and 1 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedGolemLoot", 1)
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot_Tracker1", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker2") and 2 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedGolemLoot", 1)
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot_Tracker2", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker3") and 3 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedGolemLoot", 1)
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot_Tracker3", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker4") and 4 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedGolemLoot", 1)
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot_Tracker4", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker5") and 5 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedGolemLoot", 1)
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot_Tracker5", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "GolemLoot_Tracker6") and progress == 6 then
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedGolemLoot", 1)
    game.Wallets.AddResource("LOST_ITEMS", "GolemLoot_Tracker6", 1)
  end
  if progress == 6 then
    game.Wallets.AddResource("HERO", "GolemFailsafe", 1)
  end
end
function VerifyTravelerContent()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_Labor_TravelerKills")
  if game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker1") < 1 and 1 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 6)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 2)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker1", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker2") and 2 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 6)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 2)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker2", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker3") and 3 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 9)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 2)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker3", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker4") and 4 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 9)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 2)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker4", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker5") and 5 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 12)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 4)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker5", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker6") and 6 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 12)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 4)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker6", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker7") and 7 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 15)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 4)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker7", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker8") and 8 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 15)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 4)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker8", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker9") and 9 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 18)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker9", 1)
  end
  if 1 > game.Wallets.GetResourceValue("LOST_ITEMS", "TravelerLoot_Tracker10") and 10 <= progress then
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot", 18)
    game.Wallets.AddResource("LOST_ITEMS", "EnhancedTravelerLoot", 5)
    game.Wallets.AddResource("LOST_ITEMS", "TravelerLoot_Tracker10", 1)
  end
  if 10 <= progress then
    game.Wallets.AddResource("HERO", "TravelerFailSafe", 1)
  end
end
function CameraApproachVendor()
  local playerPosition = player:GetWorldPosition()
  local interactPosition = player:GetBestTraversePathChoicePosition()
  local toInteract = interactPosition - playerPosition
  local interactFwd = thisObj:GetWorldForward()
  local interactAngle
  local cameraWorldSpaceForward = engine.Vector.New(0, 0, 1)
  interactAngle = LD.GetAngleBetweenVector(interactFwd, cameraWorldSpaceForward)
  interactAngle = interactAngle - 40
  game.SubObject.Wake(thisObj)
  game.Camera.Recenter({
    RotationSpace = 1,
    TimeStart = 0,
    TimeDuration = 2,
    LockRecenter = 1,
    YawRange = -1,
    TriggerLeft = 0,
    TriggerRight = 0,
    ReturnLeft = interactAngle,
    ReturnRight = interactAngle,
    PitchRange = 0,
    ReturnUp = -8,
    ReturnDown = -8
  })
  cameraOneShotApproach = CCOS.OneShotCamera.New("PLYR_UI_Vendor_Approach", 3, interactAngle)
  cameraOneShotApproach:SetCallback(CameraDestroyAndSleepScript)
  cameraOneShotApproach:Start()
end
function CameraDestroyAndSleepScript()
  cameraOneShotApproach = nil
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {hasFixedUp = hasFixedUp}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  hasFixedUp = savedInfo.hasFixedUp or false
end
function TrophyCheck()
  if game.Wallets.GetResourceValue("HERO", "ReinforcementAxe_Tier06") == 1 then
    game.UnlockTrophy(27)
  end
  if game.Wallets.GetResourceValue("HERO", "ReinforcementBlades_Tier05") == 1 then
    game.UnlockTrophy(28)
  end
end
function SpecificArmorCheck()
  local zealotChest = game.Wallets.HasResource("HERO", "KratosArmorChest_TravelerSet_Tier06") == true or game.Wallets.HasResource("HERO", "KratosArmorChest_TravelerSet_Tier06_NGP") == true
  local zealotWrist = game.Wallets.HasResource("HERO", "KratosArmorWrist_TravelerSet_Tier06") == true or game.Wallets.HasResource("HERO", "KratosArmorWrist_TravelerSet_Tier06_NGP") == true
  local zealotLegs = game.Wallets.HasResource("HERO", "KratosArmorLegs_TravelerSet_Tier06") == true or game.Wallets.HasResource("HERO", "KratosArmorLegs_TravelerSet_Tier06_NGP") == true
  if zealotChest and zealotWrist and zealotLegs then
    game.UnlockTrophy(29)
  end
  local primordialChest = game.Wallets.HasResource("HERO", "KratosArmorChest_ElementalSet_Tier06") == true or game.Wallets.HasResource("HERO", "KratosArmorChest_ElementalSet_Tier06_NGP") == true
  local primordialWrist = game.Wallets.HasResource("HERO", "KratosArmorWrist_ElementalSet_Tier06") == true or game.Wallets.HasResource("HERO", "KratosArmorWrist_ElementalSet_Tier06_NGP") == true
  local primordialLegs = game.Wallets.HasResource("HERO", "KratosArmorLegs_ElementalSet_Tier06") == true or game.Wallets.HasResource("HERO", "KratosArmorLegs_ElementalSet_Tier06_NGP") == true
  if primordialChest and primordialWrist and primordialLegs then
    game.UnlockTrophy(30)
  end
end
