local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, vendorInteract, talkInteract
brok = nil
sindri = nil
local thisLevel, brokSpawner, sindriSpawner, greetingDoneTimer
local greetingCooldownTime = 4
local shopExitTimer
local shopExitCooldownTime = 10
local triggerCinematic = false
local workBlade, workBladeGrindStone, grindStone, bellow, hammer, wasJustHammering, counterSpawnRequested, preventHammering, vendorAtCounter, brokPuppeteer, sindriPuppeteer, playerAtCounter
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  brokSpawner = thisObj:FindSingleGOByName("VendorSpawner")
  sindriSpawner = thisObj:FindSingleGOByName("VendorSpawner1")
  vendorInteract = thisObj:FindSingleGOByName("vendorInteract")
  talkInteract = thisObj:FindSingleGOByName("TalkInteract_LS")
  greetingDoneTimer = StartLevelTimer(greetingCooldownTime, ResetToIdle)
  greetingDoneTimer:Stop()
  shopExitTimer = StartLevelTimer(shopExitCooldownTime, ResetToIdle)
  shopExitTimer:Stop()
  workBlade = thisObj:FindSingleGOByName("workBlade")
  hammer = thisObj:FindSingleGOByName("brokHammer")
  workBladeGrindStone = thisObj:FindSingleGOByName("workBladeGrindStone")
  grindStone = thisObj:FindSingleGOByName("huldraGrindstone")
  bellow = thisObj:FindSingleGOByName("bellow00Prop")
  local goQuestCamera = obj:FindSingleGOByName("HuldraBrothersCamera")
  if goQuestCamera ~= nil then
    goQuestCamera.LuaObjectScript.SetCameraType("HuldraBrothersInteract_LargeTable")
  end
  local brokSpawner = obj:FindSingleGOByName("VendorSpawner")
  brokSpawner.LuaObjectScript.RegisterOnSpawnCallback(AltSpawnSync)
  local sindriSpawner = obj:FindSingleGOByName("VendorSpawner1")
  sindriSpawner.LuaObjectScript.RegisterOnSpawnCallback(AltSindriSpawnSync)
end
function OnStart(level, obj)
  game.Audio.SetBanterFact("SindriInLargeShop", "False")
  InitializeProps(grindStone)
  InitializeProps(workBlade)
  InitializeProps(workBladeGrindStone)
  InitializeProps(bellow)
  InitializeProps(hammer)
end
function InitializeProps(propName)
  local animObj = propName
  if animObj ~= nil then
    animObj.Child:StartAnimation({
      Animation = "envBrokKratosIdle01"
    })
  end
end
function DespawnTriggered()
  VendorInteractDisable()
  ClearTalkInteractNPC()
  InitializeProps(grindStone)
  InitializeProps(workBlade)
  InitializeProps(workBladeGrindStone)
  InitializeProps(bellow)
  InitializeProps(hammer)
  if brokPuppeteer ~= nil then
    brokPuppeteer:Clear()
    brokPuppeteer = nil
  end
  if sindriPuppeteer ~= nil then
    sindriPuppeteer:Clear()
    sindriPuppeteer = nil
  end
  greetingDoneTimer:Stop()
  shopExitTimer:Stop()
  game.Audio.SetBanterFact("SindriInLargeShop", "False")
end
function SendVendorToTable()
  print("sending vendor to table")
  vendorAtCounter = true
  shopExitTimer:Reset()
  shopExitTimer:Stop()
  greetingDoneTimer:Reset()
  greetingDoneTimer:Stop()
  if brok == nil then
    brok = LD.GetSingleAIByMarker("brok00")
  else
    brok:TriggerMoveEvent("ExitToCounter")
  end
end
function SendVendorToAnvil()
  print("Vendor to Anvil")
  GetSpawnedNPC()
  wasJustHammering = true
  vendorAtCounter = false
  if brok ~= nil then
    brok:TriggerMoveEvent("ExitToAnvil")
  end
end
function SendVendorToGrindStone()
  GetSpawnedNPC()
  vendorAtCounter = false
  if brok ~= nil then
    brok:TriggerMoveEvent("ExitToGrindStone")
  end
end
function ExitShopCheck()
  if not playerAtCounter then
    print("got my exit check")
    GetSpawnedNPC()
    if brok ~= nil then
      if vendorAtCounter or brok:IsPlayingMove("MOV_Vendor_CounterIdle") then
        if (preventHammering or wasJustHammering) and not sindri then
          SendVendorToGrindStone()
          wasJustHammering = false
        else
          SendVendorToAnvil()
        end
      elseif brok ~= nil then
        brok:TriggerMoveEvent("LookAtExit")
      end
    end
  end
end
function TalkInteractInitiated()
  VendorInteractDisable()
end
function TalkInteractDone()
  timers.StartLevelTimer(1, VendorInteractEnable)
  shopExitTimer:Start()
  print("Restarting shop exit timer")
end
function VendorInteractDisable()
  vendorInteract.LuaObjectScript.Disable()
end
function VendorInteractEnable()
  if brok ~= nil then
    vendorInteract.LuaObjectScript.Enable()
  else
    GetSpawnedNPC()
    if brok ~= nil then
      vendorInteract.LuaObjectScript.Enable()
    end
  end
end
function TalkEnded()
  shopExitTimer:Start()
  playerAtCounter = false
  if brok ~= nil then
    brok:RemoveMarker("PlayerCounterRequest")
    print("Restarting shop exit timer")
  end
end
function GreetingEnded()
  greetingDoneTimer:Start()
end
function TalkStarted()
  ForceTalkLookAt()
  shopExitTimer:Stop()
  shopExitTimer:Reset()
  greetingDoneTimer:Stop()
  greetingDoneTimer:Reset()
end
function ClearTalkInteractNPC()
  talkInteract.LuaObjectScript.ClearTalkNPC()
end
function OnInteractStart(level, obj, creature)
  print("Interact started............", creature)
  GetSpawnedNPC()
  if creature == brok then
    if sindri ~= nil then
      if counterSpawnRequested then
        StartCounterSyncAlt()
      else
        StartHammerSyncAlt()
      end
    else
      game.Audio.SetBanterFact("BrokInLargeShop", "True")
      if counterSpawnRequested then
        StartCounterSync()
      else
        StartHammerSync()
      end
    end
  end
end
function OnInteractAbort(level, obj, creature)
  InitializeProps(grindStone)
  InitializeProps(workBlade)
  InitializeProps(workBladeGrindStone)
  InitializeProps(bellow)
  InitializeProps(hammer)
end
function OnInteractDone(level, obj, creature)
  InitializeProps(grindStone)
  InitializeProps(workBlade)
  InitializeProps(workBladeGrindStone)
  InitializeProps(bellow)
  InitializeProps(hammer)
end
function LuaHook_TriggerHammerSpark()
  local glowFX = game.FX.Spawn("Vendor_BladeGlow", thisLevel, {
    GameObject = thisObj,
    Joint = "hammerTempJoint",
    AutoDelete = true
  })
  local sparkFX = game.FX.Spawn("Vendor_Hammer_Sparks", thisLevel, {
    GameObject = thisObj,
    Joint = "hammerTempJoint",
    AutoDelete = true
  })
end
function LuaHook_StartBellow()
end
function LuaHook_BellowCompressed()
  local bellowFX = game.FX.Spawn("Vendor_CoalFire", thisLevel, {
    GameObject = thisObj,
    Joint = "coalFXJoint",
    AutoDelete = true
  })
end
function LuaHook_BladeInCoals()
  local smokeFX = game.FX.Spawn("Vendor_CoalSmoke", thisLevel, {
    GameObject = thisObj,
    Joint = "coalFXJoint",
    AutoDelete = true
  })
end
function LuaHook_TriggerGrindSparkL()
  local grindSparkFX = game.FX.Spawn("Vendor_Grind_Sparks", thisLevel, {
    GameObject = thisObj,
    Joint = "grindstoneJointL",
    AutoDelete = true
  })
end
function LuaHook_TriggerGrindSparkR()
  local grindSparkFX = game.FX.Spawn("Vendor_Grind_Sparks", thisLevel, {
    GameObject = thisObj,
    Joint = "grindstoneJointR",
    AutoDelete = true
  })
end
function VendorInteractEnable()
  vendorInteract.LuaObjectScript.Enable()
end
function PlaySpawnSync()
end
function PlaySpawnSindriStart()
end
function AltSpawnSync(brok)
  if triggerCinematic == false then
    GetSpawnedNPC()
    local currentCineNumber = game.Level.GetVariable("CompletedCineNumber")
    if currentCineNumber < 510 and 500 <= currentCineNumber and LD.GetCurrentRealm() == "Midgard" or currentCineNumber == 515 and game.Level.GetVariable("CAL_NAR_EyesOnThePrize") == false and game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed") then
      vendorInteract.LuaObjectScript.EnableCinematicTrigger()
      StartCounterSpawn()
    else
      BrokRequestHammerSync()
    end
  end
  triggerCinematic = false
end
function StartCounterSpawn()
  LD.SyncAndPlayBranch(brok, thisObj, "BRA_VendorCounterSpawn", true, "shopSync")
  VendorInteractEnable()
end
function StartGrindSync()
  wasJustHammering = false
  GetSpawnedNPC()
  VendorInteractEnable()
  local shopPropTable = {
    {
      brok,
      "BRA_VendorGrindStoneSpawn"
    },
    {
      grindStone.Child,
      "envBrokPos02Idle"
    },
    {
      workBlade.Child,
      "envBrokPos02Idle"
    },
    {
      hammer.Child,
      "envBrokPos02Idle"
    },
    {
      bellow.Child,
      "envBrokPos02Idle"
    },
    {
      workBladeGrindStone.Child,
      "envBrokPos02Idle"
    }
  }
  brokPuppeteer = LD.PlayGroupSync(thisObj, shopPropTable, "envBrokPos02Idle", true, "shopSync")
end
function StartCounterRequest(npc)
  if npc ~= nil then
    print("spawned NPC IS.......", npc)
    counterSpawnRequested = true
    npc:RequestInteract(thisObj)
    talkInteract.LuaObjectScript.SetTalkNpc(npc)
  else
    print("spawned npc is nil")
  end
end
function SetPreventHammering(newPreventHammering)
  preventHammering = newPreventHammering
end
function StartCounterSync()
  counterSpawnRequested = false
  wasJustHammering = false
  VendorInteractEnable()
  vendorAtCounter = true
  local shopPropTable = {
    {
      brok,
      "BRA_VendorCounterSpawn"
    },
    {
      grindStone.Child,
      "envBrokKratosIdle01"
    },
    {
      workBlade.Child,
      "envBrokKratosIdle01"
    },
    {
      hammer.Child,
      "envBrokKratosIdle01"
    },
    {
      bellow.Child,
      "envBrokKratosIdle01"
    },
    {
      workBladeGrindStone.Child,
      "envBrokKratosIdle01"
    }
  }
  brokPuppeteer = LD.PlayGroupSync(thisObj, shopPropTable, "envBrokKratosIdle01", true, "shopSync")
end
function StartCounterSyncAlt()
  counterSpawnRequested = false
  wasJustHammering = false
  VendorInteractEnable()
  vendorAtCounter = true
  local shopPropTable = {
    {
      brok,
      "BRA_VendorCounterSpawn"
    },
    {
      workBlade.Child,
      "envBrokPos01Idle"
    },
    {
      hammer.Child,
      "envBrokPos01Idle"
    },
    {
      bellow.Child,
      "envBrokPos01Idle"
    }
  }
  brokPuppeteer = LD.PlayGroupSync(thisObj, shopPropTable, "envBrokKratosIdle01", true, "shopSync")
end
function StartSindriGrindSync()
  wasJustHammering = false
  vendorAtCounter = false
  game.Audio.SetBanterFact("SindriInLargeShop", "True")
  GetSpawnedNPC()
  sindri:RequestInteract(thisObj)
  local sindriPropTable = {
    {
      sindri,
      "BRA_VendorGrindStoneSpawn"
    },
    {
      grindStone.Child,
      "envSindriPos02Idle"
    },
    {
      workBladeGrindStone.Child,
      "envSindriPos02Idle"
    }
  }
  sindriPuppeteer = LD.PlayGroupSync(thisObj, sindriPropTable, "envSindriPos02Idle", true, "shopSync")
end
function BrokRequestHammerSync()
  if brok ~= nil then
    brok:RequestInteract(thisObj)
  end
end
function StartHammerSync()
  wasJustHammering = true
  GetSpawnedNPC()
  workBlade:Show()
  hammer:Show()
  vendorAtCounter = false
  VendorInteractEnable()
  local shopPropTable = {
    {
      brok,
      "BRA_VendorSpawn"
    },
    {
      grindStone.Child,
      "envBrokPos01Idle"
    },
    {
      workBlade.Child,
      "envBrokPos01Idle"
    },
    {
      hammer.Child,
      "envBrokPos01Idle"
    },
    {
      bellow.Child,
      "envBrokPos01Idle"
    },
    {
      workBladeGrindStone.Child,
      "envBrokPos01Idle"
    }
  }
  brokPuppeteer = LD.PlayGroupSync(thisObj, shopPropTable, "envBrokPos01Idle", true, "shopSync")
end
function StartHammerSyncAlt()
  wasJustHammering = true
  GetSpawnedNPC()
  VendorInteractEnable()
  local shopPropTable = {
    {
      brok,
      "BRA_VendorSpawn"
    },
    {
      workBlade.Child,
      "envBrokPos01Idle"
    },
    {
      hammer.Child,
      "envBrokPos01Idle"
    },
    {
      bellow.Child,
      "envBrokPos01Idle"
    }
  }
  brokPuppeteer = LD.PlayGroupSync(thisObj, shopPropTable, "envBrokPos01Idle", true, "shopSync")
end
function AltSindriSpawnSync(sindri)
  if triggerCinematic == false then
    StartSindriGrindSync()
  end
  triggerCinematic = false
end
function EnableCinematicTrigger()
  triggerCinematic = true
end
function DisableCinematicTrigger()
  triggerCinematic = false
end
function VendorExited()
  shopExitTimer:Start()
  playerAtCounter = false
  if brok ~= nil then
    brok:RemoveMarker("PlayerCounterRequest")
  end
  print("GOT VENDOR EXIT FROM INTERACT")
  if thisObj:FindLuaTableAttribute("onVendorInteractExited") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onVendorInteractExited"), "Vendor Interact Entered")
  end
end
function VendorEntered()
  vendorAtCounter = true
  playerAtCounter = true
  if brok ~= nil then
    brok:AddMarker("PlayerCounterRequest")
  end
  shopExitTimer:Stop()
  greetingDoneTimer:Stop()
  shopExitTimer:Reset()
  greetingDoneTimer:Reset()
  if thisObj:FindLuaTableAttribute("onVendorInteractEntered") ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, thisObj:FindLuaTableAttribute("onVendorInteractEntered"), "Vendor Interact Entered")
  end
  if brok == nil then
    GetSpawnedNPC()
    if brok ~= nil then
      SendVendorToTable()
    end
  else
    SendVendorToTable()
  end
end
function GetSpawnedNPC()
  brok = brokSpawner.LuaObjectScript.GetLastEnemy()
  sindri = sindriSpawner.LuaObjectScript.GetLastEnemy()
  if brok ~= nil then
    vendorInteract.LuaObjectScript.SetVendorType(brok)
    vendorInteract.LuaObjectScript.SetLargeShopActive()
    talkInteract.LuaObjectScript.SetTalkNpc(brok)
  end
end
function ForceTalkLookAt()
  if brok == nil then
    GetSpawnedNPC()
    if brok ~= nil then
      brok:TriggerMoveEvent("LookAtEnter")
    end
  elseif brok ~= nil then
    brok:TriggerMoveEvent("LookAtEnter")
  end
end
function CombatStart()
  if brok == nil then
    GetSpawnedNPC()
    if brok ~= nil then
      brok:TriggerMoveEvent("EnterCombat")
    end
  elseif brok ~= nil then
    brok:TriggerMoveEvent("EnterCombat")
  end
end
function CombatExit()
  if brok == nil then
    GetSpawnedNPC()
    if brok ~= nil then
      brok:TriggerMoveEvent("EnterCombat")
    end
  elseif brok ~= nil then
    brok:TriggerMoveEvent("EnterCombat")
  end
end
function EnteredLargeShop()
  LD.SetEntityVariable("QST_InLargeShop", true)
end
function ExitedLargeShop()
  LD.SetEntityVariable("QST_InLargeShop", false)
end
function ResetToIdle()
  print("Attempting to reset to idle, large shop")
  ExitShopCheck()
end
