local LD = require("design.LevelDesignLibrary")
local thisObj, DrainBell1, DrainBell2
function OnScriptLoaded(level, obj)
  thisObj = obj
  DrainBell1 = GameObjects.DrainBell1
  DrainBell2 = GameObjects.DrainBell2
  SoundInit()
end
function DrainPause()
  DrainBell1.LuaObjectScript.StopTurning()
  DrainBell1:OnAnimationDone(thisObj, "StopSoundDrainBell1")
end
function DrainPlay()
  DrainBell1.LuaObjectScript.StartTurning()
  PlaySoundDrainBell1()
end
function DrainPause2()
  DrainBell2.LuaObjectScript.StopTurning()
  DrainBell2:OnAnimationDone(thisObj, "StopSoundDrainBell2")
end
function DrainPlay2()
  DrainBell2.LuaObjectScript.StartTurning()
  PlaySoundDrainBell2()
end
local drainBellSoundEmitter_1, drainBellSoundEmitter_2
local soundEvents = {
  Bell1TurningLoop = "SND_MECH_Bell_Puzzle_Rotating_LP",
  Bell2TurningLoop = "SND_MECH_Bell_Puzzle_Rotating_LP"
}
function SoundInit()
  drainBellSoundEmitter_1 = DrainBell1.SoundEmitters[1]
  drainBellSoundEmitter_2 = DrainBell2.SoundEmitters[1]
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter_1 ~= nil then
      drainBellSoundEmitter_1 = sounds.SoundEmitter_1
    end
    if sounds.SoundEmitter_2 ~= nil then
      drainBellSoundEmitter_2 = sounds.SoundEmitter_2
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function PlaySoundDrainBell1()
  LD.PlayRestartableSoundLoop(drainBellSoundEmitter_1, soundEvents.Bell1TurningLoop)
end
function StopSoundDrainBell1()
  LD.StopRestartableSoundLoop(drainBellSoundEmitter_1, soundEvents.Bell1TurningLoop)
end
function PlaySoundDrainBell2()
  LD.PlayRestartableSoundLoop(drainBellSoundEmitter_2, soundEvents.Bell2TurningLoop)
end
function StopSoundDrainBell2()
  LD.StopRestartableSoundLoop(drainBellSoundEmitter_2, soundEvents.Bell2TurningLoop)
end
