local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, Flame_VFX, RuneParticle
local completed = false
local sonInteractObject
function OnScriptLoaded(level, obj)
  thisObj = obj
  RuneParticle = obj:FindSingleGOByName("RuneParticlesFX")
  sonInteractObject = obj:FindSingleGOByName("pSonInteractRune").Child.Child
  Flame_VFX = thisObj:FindSingleGOByName("LightMarker_VFXs")
  Flame_VFX:HideLights()
  Flame_VFX:HideParticleEmitter()
  game.SubObject.Sleep(obj)
  SoundInit()
end
function OnSaveCheckpoint(level, obj)
  return {completed = completed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  completed = savedInfo.completed
  if completed then
    HideParticle()
  end
end
function HideParticle()
  if not completed then
    PlaySoundFireIgnition()
  end
  completed = true
  RuneParticle:Hide()
  TurnOn()
end
function EnableSonInteract()
  sonInteractObject.LuaObjectScript.Enable()
end
function DisableSonInteract()
  sonInteractObject.LuaObjectScript.DisableModule()
end
function TurnOn()
  Flame_VFX:ShowLights()
  Flame_VFX:ShowParticleEmitter()
  PlaySoundFireLP()
end
local flameEmitter
local flameLoopSoundEvent = "SND_AMB_EMIT_Quest_Brazier_Start_LP"
local flameIgnitionSoundEvent = "SND_AMB_EMIT_Quest_Brazier_On"
function SoundInit()
  flameEmitter = thisObj.SoundEmitters[1]
  local runeReadScript = thisObj:FindSingleGOByName("pSonInteractRune").LuaObjectScript
  if runeReadScript ~= nil then
    runeReadScript.LoreMarkerRuneReadSoundSetup()
  end
end
function PlaySoundFireLP()
  LD.PlayRestartableSoundLoop(flameEmitter, flameLoopSoundEvent)
end
function PlaySoundFireIgnition()
  LD.PlaySound(flameEmitter, flameIgnitionSoundEvent)
end
