local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timer = require("level.timer")
local TUT = require("game.GlobalTutorials")
local thisLevel, thisObj, playerRef, propName, branchlist, fxObject, reward
onCollectedEvent = nil
local interactionOnStart, interactionOnFinish, frontInteractZone, soundEmitter, soundIdleEvent, soundPickUpEvent, state
local states = {
  ENABLED = 1,
  DISABLED = 2,
  ACQUIRED = 3
}
function OnScriptLoaded(level, go)
  thisLevel = level
  thisObj = go
  playerRef = game.Player.FindPlayer()
  frontInteractZone = game.InteractZone.New(go, "promptJointFront")
  frontInteractZone:SetAngle(360)
  branchlist = thisObj:GetLuaTableAttribute("Branchlist")
  propName = thisObj:GetLuaTableAttribute("propName")
  reward = thisObj:GetLuaTableAttribute("Reward")
  onCollectedEvent = thisObj:FindLuaTableAttribute("onCollectedEvent")
  interactionOnStart = thisObj:FindLuaTableAttribute("interactionOnStart")
  interactionOnFinish = thisObj:FindLuaTableAttribute("interactionOnFinish")
  soundEmitter = thisObj.SoundEmitters[1]
  soundIdleEvent = "SND_LOOT_Shard_Red_Idle_LP"
  soundPickUpEvent = "SND_LOOT_Artifact_Bones_Pickup"
  if interactionOnStart ~= nil then
    interactionOnStart = LD.ExtractCallbacksForEvent(thisLevel, thisObj, interactionOnStart)
  end
  if interactionOnFinish ~= nil then
    interactionOnFinish = LD.ExtractCallbacksForEvent(thisLevel, thisObj, interactionOnFinish)
  end
  local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Objective_01")
  if questState == "Active" then
    Enable()
  else
    Disable()
  end
  if questState == "Inactive" then
    game.QuestManager.RegisterListener(thisObj, "Quest_UnfinishedBusiness02_Objective_01")
  end
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level)
  return {state = state}
end
function OnRestoreCheckpoint(level, go, tab)
  state = tab.state
end
function OnStart(level, go)
  if state == states.ACQUIRED then
    frontInteractZone:Disable()
    HideFX()
    thisObj.Parent.Parent:Hide()
    print("UB-Bones: object state is Acquired")
    return
  elseif state ~= states.ACQUIRED then
    LD.CallFunctionAfterDelay(QuestStateCheck, 1)
  end
end
function QuestStateCheck()
  local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness02_Objective_01")
  if questState == "Active" then
    Enable()
    print("UB-Bones: quest is active, bones are enabled")
  else
    Disable()
    print("UB-Bones: quest is inactive, bones are disabled")
  end
end
function OnUseWorld(level, go)
  if frontInteractZone:PlayerCanInteract() then
    playerRef:RequestInteract(go, frontInteractZone)
  end
end
function OnInteractStart()
  thisObj.Parent.Parent:RegisterAsProp(propName)
  LD.GoToLocationSyncAndPlayBranch(playerRef, thisObj, branchlist, 3.5, true, "synchJoint", "", 1, false)
  frontInteractZone:Disable()
  HideFX()
end
function OnInteractAbort()
end
function OnInteractFinish()
  if interactionOnFinish ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnFinish, "Interaction Event Finish")
  end
end
function OnInteractDone()
end
function LuaHook_GiveLoot(level, go)
  game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness02_Objective_01", 1)
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness02_Objective_01")
  if progress < 3 then
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness02_Objective_01")
  elseif progress == 3 then
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness02_Objective_02")
  end
  if reward == "WitchSkull" then
    LD.CompleteQuest("Quest_UnfinishedBusiness02_Objective_01_skull")
  elseif reward == "WitchLeftHand" then
    LD.CompleteQuest("Quest_UnfinishedBusiness02_Objective_01_lefthand")
  elseif reward == "WitchRightHand" then
    LD.CompleteQuest("Quest_UnfinishedBusiness02_Objective_01_righthand")
  end
  state = states.ACQUIRED
  SoftSave()
  _G.StartLevelTimer(1.5, BonePickupBanter)
end
function LuaHook_PickUpLoot()
  LD.StopRestartableSoundLoop(soundEmitter, soundIdleEvent)
  LD.PlaySound(soundEmitter, soundPickUpEvent)
end
function BonePickupBanter()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness02_Objective_01")
  if progress == 1 then
    game.Audio.PlayBanter("UB1DesMdn_FirstBonePickup")
  elseif progress == 2 then
    game.Audio.PlayBanter("UB1DesMdn_SecondBonePickup")
  elseif progress == 3 then
    game.Audio.PlayBanter("UB1DesMdn_ThirdBonePickup")
  end
end
function Handle_Quest_Activate(level, go, questName, parentQuestName)
  print("quest event!")
  if questName == "Quest_UnfinishedBusiness02_Objective_01" then
    Enable()
  end
end
function HideFX()
  thisObj:HideJoint(thisObj:GetJointIndex("fxJoint"))
end
function ShowFX()
  thisObj:ShowJoint(thisObj:GetJointIndex("fxJoint"))
end
function Enable()
  state = states.ENABLED
  frontInteractZone:Enable()
  _G.StartLevelTimer(0.1, ShowFX)
  LD.PlayRestartableSoundLoop(soundEmitter, soundIdleEvent)
end
function Disable()
  frontInteractZone:Disable()
  HideFX()
  state = states.DISABLED
end
function SoftSave(level, go)
  print("soft save occurred")
  print("state = ", state)
  game.SubObject.SoftSave(thisObj)
end
