local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local thisObj, playerCreature
local explorationValkyrieSeen = false
local chiselValkyrieSeen, chiselValkyriesDefeated, valkyriesDefeated, niflheimValkyrie, muspelheimValkyrie, valkyrieMuspSeen, valkyrieNifSeen, queenValkyrie, activeValkyrie
local valkyrieSummaryTable = {}
local helmPickupReminderTimer
local elevatorBanterPlayed = false
local valkyrieHelmet, pad
function OnScriptLoaded(level, go)
  playerCreature = game.Player.FindPlayer()
  thisObj = go
  pad = playerCreature.Pad
  valkyrieSummaryTable = {
    {
      SummaryQuest = "RegionSummary_Foothills_Valkryie_Parent",
      valk = "Geirdriful",
      mapMarker = "FOOT_250_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Riverpass_Valkryie_Parent",
      valk = "Kara",
      mapMarker = "RP_975_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_StoneMason_Valkryie_Parent",
      valk = "Gunnr",
      mapMarker = "SM_110_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Alfheim_Valkryie_Parent",
      valk = "Olrun",
      mapMarker = "ALF_355_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Helheim_Valkryie_Parent",
      valk = "Rota",
      mapMarker = "HEL_350_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Peakspass_Valkryie_Parent",
      valk = "Eir",
      mapMarker = "PP_205_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Muspelheim_Valkryie_Parent",
      valk = "Gondul",
      mapMarker = "MSP_100_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Niflheim_Valkryie_Parent",
      valk = "Hildr",
      mapMarker = "NIF_100_ValkyrieLocation"
    },
    {
      SummaryQuest = "RegionSummary_Valkryie_Queen_Parent",
      valk = "Sigrun",
      mapMarker = "MT_600_ValkQueen"
    }
  }
end
function OnSaveCheckpoint(level, go)
  return {}
end
function OnRestoreCheckpoint()
end
function OnStart(level, go)
  VariableCheck()
  SetValkyrieHelmets(level)
end
function OnUseWorld()
end
function VariableCheck(level, go)
  valkyriesDefeated = game.Level.GetVariable("ValkyriesDefeated")
  chiselValkyrieSeen = game.Level.GetVariable("ValkyrieChiselSeen")
  chiselValkyriesDefeated = game.Level.GetVariable("ValkyrieChiselKilled")
  valkyrieMuspSeen = game.Level.GetVariable("ValkyrieMuspSeen")
  valkyrieNifSeen = game.Level.GetVariable("ValkyrieNifSeen")
  if valkyrieMuspSeen == true or valkyrieNifSeen == true then
    explorationValkyrieSeen = true
  else
    explorationValkyrieSeen = false
  end
  local valkyrie01 = game.FindLevel("Foot250_ChiselArena")
  local valkyrie02 = game.FindLevel("Riv975_ChiselArena")
  local valkyrie03 = game.FindLevel("Stn110_ChiselArena")
  local valkyrie04 = game.FindLevel("Alf355_ChiselDungeon")
  local valkyrie05 = game.FindLevel("Hel350_ChiselArena")
  local valkyrie06 = game.FindLevel("Peak205_ChiselArena")
  local muspCheck = game.FindLevel("Msp100_Base")
  local nifCheck = game.FindLevel("Nid100_Entrance")
  local queenCheck = game.FindLevel("Xpl600_MasonTrail")
  local testBed = game.FindLevel("TB_Valkyrie")
  if valkyrie01 ~= nil then
    activeValkyrie = "Geirdriful"
  elseif valkyrie02 ~= nil then
    activeValkyrie = "Kara"
  elseif valkyrie03 ~= nil then
    activeValkyrie = "Gunnr"
  elseif valkyrie04 ~= nil then
    activeValkyrie = "Olrun"
  elseif valkyrie05 ~= nil then
    activeValkyrie = "Rota"
  elseif valkyrie06 ~= nil then
    activeValkyrie = "Eir"
  elseif muspCheck ~= nil then
    activeValkyrie = "Gondul"
  elseif nifCheck ~= nil then
    activeValkyrie = "Hildr"
  elseif queenCheck ~= nil then
    activeValkyrie = "Sigrun"
  elseif testBed ~= nil then
    activeValkyrie = "Gunnr"
  else
    activeValkyrie = "Gunnr"
  end
  if muspCheck ~= nil then
    muspelheimValkyrie = true
  else
    muspelheimValkyrie = false
  end
  if nifCheck ~= nil then
    niflheimValkyrie = true
  else
    niflheimValkyrie = false
  end
  if queenCheck ~= nil then
    queenValkyrie = true
  else
    queenValkyrie = false
  end
end
function ElevatorDownBanterCheck()
  chiselValkyrieSeen = game.Level.GetVariable("ValkyrieChiselSeen")
  chiselValkyriesDefeated = game.Level.GetVariable("ValkyrieChiselKilled")
  if chiselValkyrieSeen == 0 and elevatorBanterPlayed == false and chiselValkyriesDefeated == 0 then
    if game.FindLevel("Stn950_BossSound") ~= nil then
      game.Audio.PlayBanterNonCritical("VLKRY1ElevatorDown_NoLock", nil, false, false, function()
        elevatorBanterPlayed = true
      end)
    elseif game.FindLevel("Hel325_ChiselSite") ~= nil then
      game.Audio.PlayBanter("VLKRY1ElevatorDown_NoLock")
      elevatorBanterPlayed = true
    elseif game.FindLevel("Stn905_ChiselSite") ~= nil then
      game.Audio.PlayBanter("VLKRY1ElevatorDown_NoLock")
      elevatorBanterPlayed = true
    else
      game.Audio.PlayBanter("VLKRY1ElevatorDown")
      elevatorBanterPlayed = true
    end
  end
end
function ValkyriePreFightBanterCheck()
  RegionSummaryValkryrieFound(activeValkyrie)
  if muspelheimValkyrie == false and niflheimValkyrie == false then
    if chiselValkyriesDefeated == 0 then
      if chiselValkyrieSeen == 0 then
        if explorationValkyrieSeen == false then
          game.Audio.PlayBanter("VLKRY1ThereSheIs", PrefightBanterDone)
          ValkyrieSeen()
          EnableSlowWalk()
          LockFastTravel()
        elseif explorationValkyrieSeen == true then
          game.Audio.PlayBanter("VLKRY1ThereSheIs_Seen", PrefightBanterDone)
          ValkyrieSeen()
          EnableSlowWalk()
          LockFastTravel()
        end
      elseif chiselValkyrieSeen == 1 then
        game.Audio.PlayBanter("VLKRY2ThereSheIs", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
        LockFastTravel()
      elseif chiselValkyrieSeen == 2 then
        game.Audio.PlayBanter("VLKRY3ThereSheIs", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
        LockFastTravel()
      elseif chiselValkyrieSeen == 3 then
        game.Audio.PlayBanter("VLKRY4ThereSheIs", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
        LockFastTravel()
      elseif chiselValkyrieSeen == 4 then
        game.Audio.PlayBanter("VLKRY5ThereSheIs", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
        LockFastTravel()
      elseif chiselValkyrieSeen == 5 then
        game.Audio.PlayBanter("VLKRY6ThereSheIs", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
        LockFastTravel()
      end
    elseif chiselValkyriesDefeated == 1 then
      game.Audio.PlayBanter("VLKRY2ThereSheIs_1Down", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 2 then
      game.Audio.PlayBanter("VLKRY3ThereSheIs_2Down", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 3 then
      game.Audio.PlayBanter("VLKRY4ThereSheIs_3Down", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 4 then
      game.Audio.PlayBanter("VLKRY5ThereSheIs_4Down", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 5 then
      game.Audio.PlayBanter("VLKRY6ThereSheIs_5Down", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
      LockFastTravel()
    end
  elseif muspelheimValkyrie == true then
    if game.Level.GetVariable("CompletedCineNumber") >= 330 then
      if explorationValkyrieSeen == true or 0 < chiselValkyrieSeen then
        game.Audio.PlayBanter("VLKRY7ThereSheIs_Mimir", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
      else
        game.Audio.PlayBanter("VLKRY7ThereSheIs_Mimir_First", PrefightBanterDone)
        ValkyrieSeen()
        EnableSlowWalk()
      end
    elseif explorationValkyrieSeen == true or 0 < chiselValkyrieSeen then
      game.Audio.PlayBanter("VLKRY7ThereSheIs", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
    else
      game.Audio.PlayBanter("VLKRY7ThereSheIs_First", PrefightBanterDone)
      ValkyrieSeen()
      EnableSlowWalk()
    end
  elseif niflheimValkyrie == true and game.Wallets.GetResourceValue("HERO", "ValkyrieLoot07") == -1 then
    if explorationValkyrieSeen == true or 0 < chiselValkyrieSeen then
      game.Audio.PlayBanter("VLKRY8ThereSheIs")
      ValkyrieSeen()
      LD.CallFunctionAfterDelay(ActivateValkyrieQuest, 0.5)
    else
      game.Audio.PlayBanter("VLKRY8ThereSheIs_First")
      ValkyrieSeen()
      LD.CallFunctionAfterDelay(ActivateValkyrieQuest, 0.5)
    end
  end
end
function PrefightBanterDone()
  ClearSlowWalk()
  UnlockFastTravel()
  LD.CallFunctionAfterDelay(ActivateValkyrieQuest, 0.5)
  LD.CallFunctionAfterDelay(ClearAlertZonesAndCheckpoint, 1)
end
function ShowSplashScreen()
  uiCalls.SendSplashScreenDesignerMessage({
    Title = 43075,
    Text = 43076,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE
  })
end
function ActivateValkyrieQuest()
  LD.ActivateQuest("Quest_Valkyrie_Sisters_Parent")
end
function ClearAlertZonesAndCheckpoint()
  local foot250 = game.FindLevel("Foot250_ChiselArena")
  local riv975 = game.FindLevel("Riv975_ChiselArena")
  local stn110 = game.FindLevel("Stn110_ChiselArena")
  local alf355 = game.FindLevel("Alf355_ChiselDungeon")
  local hel350 = game.FindLevel("Hel350_ChiselArena")
  local peak205 = game.FindLevel("Peak205_ChiselArena")
  local musp = game.FindLevel("Msp100_Base")
  if foot250 ~= nil then
    GameObjects.EntZn_Alert_ValkyrieFight:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  elseif riv975 ~= nil then
    GameObjects.EntZn_Valkyrie_Alert:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  elseif stn110 ~= nil then
    GameObjects.EntZn_Alert_ValkyrieFight:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  elseif alf355 ~= nil then
    GameObjects.EntZn_Valkyrie_Alert:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  elseif hel350 ~= nil then
    GameObjects.EntZn_Valkyrie_Alert:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  elseif peak205 ~= nil then
    GameObjects.EntZn_Valkyrie_Alert:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  elseif musp ~= nil then
    GameObjects.EntZn_Valkyrie_Alert:Show()
    GameObjects.Col_ValkyrieBarrier:Hide()
    GameObjects.Col_ValkyrieBarrier:HideCollision()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.CheckpointOverride_Precombat.Child
    })
  else
    Checkpoint()
  end
end
function EnableSlowWalk()
  playerCreature:SetMaxSpeedOverride(1.5)
  if pad.DisableGameButton and pad.EnableGameButton then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadR3)
  end
end
function EnablePostFightSlowWalk()
  playerCreature:SetMaxSpeedOverride(1.75)
  if pad.DisableGameButton and pad.EnableGameButton then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadR3)
  end
end
function ClearSlowWalk()
  playerCreature:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function ValkyrieFightStart()
  VariableCheck()
  if muspelheimValkyrie == false and niflheimValkyrie == false then
    if chiselValkyriesDefeated == 0 then
      if chiselValkyrieSeen == 1 then
        if explorationValkyrieSeen == false then
          game.Audio.PlayBanter("VLKRY1_NeverSeen_Fight")
        elseif explorationValkyrieSeen == true then
          game.Audio.PlayBanter("VLKRY1_SeenXPL_Fight")
        end
      elseif chiselValkyrieSeen == 2 then
        game.Audio.PlayBanter("VLKRY2_SeenOne_Fight")
      elseif chiselValkyrieSeen == 3 then
        game.Audio.PlayBanter("VLKRY3_SeenTwo_Fight")
      elseif chiselValkyrieSeen == 4 then
        game.Audio.PlayBanter("VLKRY4_SeenThree_Fight")
      elseif chiselValkyrieSeen == 5 then
        game.Audio.PlayBanter("VLKRY5_SeenFour_Fight")
      elseif chiselValkyrieSeen == 6 then
        game.Audio.PlayBanter("VLKRY6_SeenFive_Fight")
      end
    elseif chiselValkyriesDefeated == 1 then
      game.Audio.PlayBanter("VLKRY2_KilledOne_Fight")
    elseif chiselValkyriesDefeated == 2 then
      game.Audio.PlayBanter("VLKRY3_KilledTwo_Fight")
    elseif chiselValkyriesDefeated == 3 then
      game.Audio.PlayBanter("VLKRY4_KilledThree_Fight")
    elseif chiselValkyriesDefeated == 4 then
      game.Audio.PlayBanter("VLKRY5_KilledFour_Fight")
    elseif chiselValkyriesDefeated == 5 then
      game.Audio.PlayBanter("VLKRY6_KilledFive_Fight")
    end
  elseif muspelheimValkyrie == true then
    if game.Level.GetVariable("CompletedCineNumber") >= 330 then
      if explorationValkyrieSeen == true or 0 < chiselValkyrieSeen then
        game.Audio.PlayBanter("VLKRY7_Musp_Mimir_Fight")
      else
        game.Audio.PlayBanter("VLKRY7_Musp_Mimir_First_Fight")
      end
    elseif explorationValkyrieSeen == true or 0 < chiselValkyrieSeen then
      game.Audio.PlayBanter("VLKRY7_Musp_Fight")
    else
      game.Audio.PlayBanter("VLKRY7_Musp_First_Fight")
    end
  elseif niflheimValkyrie == true then
    game.Audio.PlayBanter("VLKRY8_Nif_Fight")
  end
end
function ValkyriePostFightBanterCheck()
  VariableCheck()
  if muspelheimValkyrie == false and niflheimValkyrie == false and queenValkyrie == false then
    if chiselValkyriesDefeated == 0 then
      game.Audio.PlayBanter("VLKRY1Defeated_" .. activeValkyrie, Valkyrie01HelmCheck)
    elseif chiselValkyriesDefeated == 1 then
      game.Audio.PlayBanter("VLKRY2Defeated_" .. activeValkyrie, PostFightBanterTriggered)
    elseif chiselValkyriesDefeated == 2 then
      game.Audio.PlayBanter("VLKRY3Defeated_" .. activeValkyrie, PostFightBanterTriggered)
    elseif chiselValkyriesDefeated == 3 then
      game.Audio.PlayBanter("VLKRY4Defeated_" .. activeValkyrie, PostFightBanterTriggered)
    elseif chiselValkyriesDefeated == 4 then
      game.Audio.PlayBanter("VLKRY5Defeated_" .. activeValkyrie, PostFightBanterTriggered)
    elseif chiselValkyriesDefeated == 5 then
      game.Audio.PlayBanter("VLKRY6Defeated_" .. activeValkyrie, PostFightBanterTriggered)
    end
  elseif muspelheimValkyrie == true then
    if valkyriesDefeated == 0 then
      game.Audio.PlayBanter("VLKRYDefeated_Musp_First", XplPostFightTriggered)
    elseif 0 < valkyriesDefeated then
      game.Audio.PlayBanter("VLKRYDefeated_Musp", PostFightBanterTriggered)
    end
  elseif niflheimValkyrie == true then
    if valkyriesDefeated == 0 then
      game.Audio.PlayBanter("VLKRYDefeated_Nif_First", XplPostFightTriggered)
    elseif 0 < valkyriesDefeated then
      game.Audio.PlayBanter("VLKRYDefeated_Nif", NifPostFightBanterTriggered)
    end
  elseif queenValkyrie == true then
    game.Audio.PlayBanter("VLKRYDefeated_Queen", PostFightBanterTriggered)
    LD.SetMarkerState("MT_600_ValkQueen", 0)
    LD.ActivateAndIncrementQuest("RegionSummary_Valkryie_Queen_Parent")
  end
end
function Valkyrie01HelmCheck()
  playerCreature:TriggerMoveEvent("Valkyrie_LookAtHelm")
  game.Audio.PlayBanter("VLKRY1Defeated_Contd_" .. activeValkyrie, PostFightBanterTriggered)
end
function XplPostFightTriggered()
  playerCreature:TriggerMoveEvent("Valkyrie_Exit")
  valkyrieHelmet:Show()
  if game.Level.GetVariable("CompletedCineNumber") >= 330 then
    game.Audio.PlayBanter("VLKRYDefeated_XPL_First_Mimir_Contd")
  end
end
function NifPostFightBanterTriggered()
  playerCreature:TriggerMoveEvent("Valkyrie_Exit")
  valkyrieHelmet:Show()
  if game.Level.GetVariable("CompletedCineNumber") >= 330 then
    game.Audio.PlayBanter("VLKRYDefeated_Nif_Contd")
  end
end
function PostFightBanterTriggered()
  playerCreature:TriggerMoveEvent("Valkyrie_Exit")
  valkyrieHelmet:Show()
end
function ValkyrieReminderCheck()
  helmPickupReminderTimer = timer.StartLevelTimer(30, PlayReminderBanter)
end
function PlayReminderBanter()
  game.Audio.PlayBanterNonCritical("HelmPickupReminder")
  ClearReminderTimer()
  helmPickupReminderTimer:Start()
end
function ClearReminderTimer()
  helmPickupReminderTimer:Stop()
  helmPickupReminderTimer:Reset()
end
function SetValkyrieHelmets(level)
  valkyrieHelmet = level:FindSingleGameObject("valkyrieHelmets00Prop")
  if valkyrieHelmet ~= nil then
    if activeValkyrie == "Gunnr" then
      valkyrieHelmet.Child:SetCharacterConfig("raven")
    elseif activeValkyrie == "Geirdriful" then
      valkyrieHelmet.Child:SetCharacterConfig("owl")
    elseif activeValkyrie == "Eir" then
      valkyrieHelmet.Child:SetCharacterConfig("bear")
    elseif activeValkyrie == "Kara" then
      valkyrieHelmet.Child:SetCharacterConfig("ram")
    elseif activeValkyrie == "Rota" then
      valkyrieHelmet.Child:SetCharacterConfig("stag")
    elseif activeValkyrie == "Olrun" then
      valkyrieHelmet.Child:SetCharacterConfig("eagle")
    elseif activeValkyrie == "Gondul" then
      valkyrieHelmet.Child:SetCharacterConfig("vulture")
    elseif activeValkyrie == "Hildr" then
      valkyrieHelmet.Child:SetCharacterConfig("boar")
    elseif activeValkyrie == "Sigrun" then
      valkyrieHelmet.Child:SetCharacterConfig("queen")
    end
    valkyrieHelmet:Hide()
  else
    print("Valkyrie Helmet is nil. If you are in a Chisel LH, this is ok. If you are in the Chisel Dungeon, the helmet is missing from the wad")
  end
end
function HideHelmetAfterPickup(level, go)
  valkyrieHelmet:Hide()
end
function RegionSummaryKillQuest(activeValkyrie)
  print("SUMMARY: START REGION SUMMMARY", activeValkyrie)
  for _, y in ipairs(valkyrieSummaryTable) do
    if y ~= nil and y.SummaryQuest ~= nil and activeValkyrie == y.valk then
      print("SUMMARY: FINISH REGION SUMMMARY", activeValkyrie, y.SummaryQuest)
      LD.ActivateAndIncrementQuest(y.SummaryQuest)
      LD.SetMarkerState(y.mapMarker, 0)
    end
  end
end
function RegionSummaryValkryrieFound(activeValkyrie)
  print("SUMMARY: START ACTIVATING REGION SUMMMARY", activeValkyrie)
  for _, y in ipairs(valkyrieSummaryTable) do
    if y ~= nil and y.SummaryQuest ~= nil and activeValkyrie == y.valk then
      print("SUMMARY: ACTIVATING REGION SUMMMARY", activeValkyrie, y.SummaryQuest)
      LD.ActivateQuest(y.SummaryQuest)
      LD.SetMarkerState(y.mapMarker, 1)
    end
  end
end
function ValkyriePostLootBanterCheck()
  ClearReminderTimer()
  VariableCheck()
  RegionSummaryKillQuest(activeValkyrie)
  if chiselValkyrieSeen == 1 and explorationValkyrieSeen == false then
    ShowSplashScreen()
  elseif chiselValkyrieSeen == 0 then
    if valkyrieMuspSeen == true and valkyrieNifSeen == false then
      ShowSplashScreen()
    elseif valkyrieMuspSeen == false and valkyrieNifSeen == true then
      ShowSplashScreen()
    end
  end
  CheckValkyrieQuest()
  LD.CallFunctionAfterDelay(PlayPostLootValkyrieBanter, 1)
end
function PlayPostLootValkyrieBanter()
  if muspelheimValkyrie == false and niflheimValkyrie == false and queenValkyrie == false then
    if chiselValkyriesDefeated == 1 then
      game.Audio.PlayBanter("VLKRY1WrapUp", UnlockFastTravel)
      timer.StartLevelTimer(1.5, function()
        OpenArenaDoors()
      end)
      EnablePostFightSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 2 then
      local beenToCouncil = game.Level.GetVariable("BeenToValkyrieCouncil")
      if beenToCouncil == false then
        game.Audio.PlayBanter("VLKRY2WrapUp_Never_Been", UnlockFastTravel)
        timer.StartLevelTimer(1.5, function()
          OpenArenaDoors()
        end)
        EnablePostFightSlowWalk()
        LockFastTravel()
      elseif beenToCouncil == true then
        game.Audio.PlayBanter("VLKRY2WrapUp_Been", UnlockFastTravel)
        timer.StartLevelTimer(1.5, function()
          OpenArenaDoors()
        end)
        EnablePostFightSlowWalk()
        LockFastTravel()
      end
    elseif chiselValkyriesDefeated == 3 then
      game.Audio.PlayBanter("VLKRY3WrapUp", UnlockFastTravel)
      timer.StartLevelTimer(1.5, function()
        OpenArenaDoors()
      end)
      EnablePostFightSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 4 then
      game.Audio.PlayBanter("VLKRY4WrapUp", UnlockFastTravel)
      timer.StartLevelTimer(1.5, function()
        OpenArenaDoors()
      end)
      EnablePostFightSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 5 then
      game.Audio.PlayBanter("VLKRY5WrapUp", UnlockFastTravel)
      timer.StartLevelTimer(1.5, function()
        OpenArenaDoors()
      end)
      EnablePostFightSlowWalk()
      LockFastTravel()
    elseif chiselValkyriesDefeated == 6 then
      if valkyriesDefeated == 8 then
        game.Audio.PlayBanter("VLKRY6WrapUp_All", UnlockFastTravel)
        timer.StartLevelTimer(1.5, function()
          OpenArenaDoors()
        end)
        EnablePostFightSlowWalk()
        LockFastTravel()
      elseif valkyriesDefeated < 8 then
        game.Audio.PlayBanter("VLKRY6WrapUp_NotAll", UnlockFastTravel)
        timer.StartLevelTimer(1.5, function()
          OpenArenaDoors()
        end)
        EnablePostFightSlowWalk()
        LockFastTravel()
      end
    end
  elseif muspelheimValkyrie == true then
    if valkyriesDefeated == 1 then
      game.Audio.PlayBanter("VLKRYWrapUp_Musp_First", WrapUpTriggered)
    elseif 1 < valkyriesDefeated and valkyriesDefeated < 8 then
      game.Audio.PlayBanter("VLKRYWrapUp_Musp")
    elseif valkyriesDefeated == 8 then
      game.Audio.PlayBanter("VLKRYWrapUp_Musp_Last")
    end
  elseif niflheimValkyrie == true then
    if valkyriesDefeated == 1 then
      game.Audio.PlayBanter("VLKRYWrapUp_Nif_First")
    elseif 1 < valkyriesDefeated and valkyriesDefeated < 8 then
      game.Audio.PlayBanter("VLKRYWrapUp_Nif")
    elseif valkyriesDefeated == 8 then
      game.Audio.PlayBanter("VLKRYWrapUp_Nif_Last")
    end
  elseif queenValkyrie == true then
    game.UnlockTrophy(36)
    game.Audio.PlayBanter("VLKRYWrapUp_Queen")
  end
  HideHelmetAfterPickup()
  if queenValkyrie ~= true then
    game.Loot.RollCondition("VALKYRIE_ROLL", "HERO")
  end
  if niflheimValkyrie == false then
    Checkpoint()
  else
    local isSoftSaveDisabled = game.World.IsSoftSaveDisabled()
    game.World.EnableSoftSave()
    LD.CallFunctionAfterDelay(function()
      SoftSave()
    end, 0.25)
    if isSoftSaveDisabled then
      LD.CallFunctionAfterDelay(function()
        game.World.DisableSoftSave()
      end, 1.5)
    end
  end
end
function WrapUpTriggered()
  if game.Level.GetVariable("CompletedCineNumber") >= 330 then
    game.Audio.PlayBanter("VLKRYWrapUp_Musp_Mimir_Contd")
  end
end
function OpenArenaDoors()
  local foot250 = game.FindLevel("Foot250_ChiselArena")
  local riv975 = game.FindLevel("Riv975_ChiselArena")
  local stn110 = game.FindLevel("Stn110_ChiselArena")
  local alf355 = game.FindLevel("Alf355_ChiselDungeon")
  local hel350 = game.FindLevel("Hel350_ChiselArena")
  local peak205 = game.FindLevel("Peak205_ChiselArena")
  if foot250 ~= nil then
    foot250:CallScript("UnlockArena")
  elseif riv975 ~= nil then
    riv975:CallScript("UnlockArena")
  elseif stn110 ~= nil then
    stn110:CallScript("UnlockArena")
  elseif alf355 ~= nil then
    alf355:CallScript("UnlockArena")
  elseif hel350 ~= nil then
    hel350:CallScript("UnlockArena")
  elseif peak205 ~= nil then
    peak205:CallScript("UnlockArena")
  end
end
function LockFastTravel()
  local foot250 = game.FindLevel("Foot250_ChiselArena")
  local riv975 = game.FindLevel("Riv975_ChiselArena")
  local stn110 = game.FindLevel("Stn110_ChiselArena")
  local alf355 = game.FindLevel("Alf355_ChiselDungeon")
  local hel350 = game.FindLevel("Hel350_ChiselArena")
  local peak205 = game.FindLevel("Peak205_ChiselArena")
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if foot250 ~= nil then
    if cineNumber < 440 or 500 <= cineNumber then
      GameObjects.FastTravelController.LuaObjectScript.LockFastTravelInteract()
    end
  elseif riv975 ~= nil then
    if cineNumber < 387 or 400 <= cineNumber then
      GameObjects.FastTravelController.LuaObjectScript.LockFastTravelInteract()
    end
  elseif peak205 ~= nil then
    if cineNumber < 440 or 500 <= cineNumber then
      GameObjects.FastTravelController.LuaObjectScript.LockFastTravelInteract()
    end
  elseif stn110 ~= nil then
    GameObjects.FastTravelController.LuaObjectScript.LockFastTravelInteract()
  elseif alf355 ~= nil then
    GameObjects.FastTravelController.LuaObjectScript.LockFastTravelInteract()
  elseif hel350 ~= nil then
    GameObjects.FastTravelController.LuaObjectScript.LockFastTravelInteract()
  end
end
function UnlockFastTravel()
  local foot250 = game.FindLevel("Foot250_ChiselArena")
  local riv975 = game.FindLevel("Riv975_ChiselArena")
  local stn110 = game.FindLevel("Stn110_ChiselArena")
  local alf355 = game.FindLevel("Alf355_ChiselDungeon")
  local hel350 = game.FindLevel("Hel350_ChiselArena")
  local peak205 = game.FindLevel("Peak205_ChiselArena")
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if foot250 ~= nil then
    if cineNumber < 440 or 500 <= cineNumber then
      GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
    end
  elseif riv975 ~= nil then
    if cineNumber < 387 or 400 <= cineNumber then
      GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
    end
  elseif peak205 ~= nil then
    if cineNumber < 440 or 500 <= cineNumber then
      GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
    end
  elseif stn110 ~= nil then
    GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
  elseif alf355 ~= nil then
    GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
  elseif hel350 ~= nil then
    GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
  end
  ClearSlowWalk()
end
function ValkyrieSeen()
  if muspelheimValkyrie == false and niflheimValkyrie == false then
    chiselValkyrieSeen = game.Level.GetVariable("ValkyrieChiselSeen")
    chiselValkyrieSeen = chiselValkyrieSeen + 1
    game.Level.SetVariable("ValkyrieChiselSeen", chiselValkyrieSeen)
  elseif muspelheimValkyrie == true then
    game.Level.SetVariable("ValkyrieMuspSeen", true)
  elseif niflheimValkyrie == true then
    game.Level.SetVariable("ValkyrieNifSeen", true)
  end
end
function CheckValkyrieQuest()
  valkyriesDefeated = game.Level.GetVariable("ValkyriesDefeated")
  valkyriesDefeated = valkyriesDefeated + 1
  game.Level.SetVariable("ValkyriesDefeated", valkyriesDefeated)
  if muspelheimValkyrie == false and niflheimValkyrie == false and queenValkyrie == false then
    chiselValkyriesDefeated = game.Level.GetVariable("ValkyrieChiselKilled")
    chiselValkyriesDefeated = chiselValkyriesDefeated + 1
    game.Level.SetVariable("ValkyrieChiselKilled", chiselValkyriesDefeated)
  end
  local questStateParent = game.QuestManager.GetQuestState("Quest_Valkyrie_Sisters_Parent")
  local questStateObjective00 = game.QuestManager.GetQuestState("Quest_Valkyrie_Sisters_Objective00")
  local questStateObjective01 = game.QuestManager.GetQuestState("Quest_Valkyrie_Sisters_Objective01")
  local questStateCounter = game.QuestManager.GetQuestState("Quest_Valkyrie_Counter")
  local _, objective02Progress = game.QuestManager.GetQuestProgressAndGoal("Quest_Valkyrie_Sisters_Objective02")
  local questQueenParent = game.QuestManager.GetQuestState("Quest_Valkyrie_Queen_Kill")
  if questStateParent == "Inactive" then
    game.QuestManager.StartQuest("Quest_Valkyrie_Sisters_Parent")
    LD.CompleteQuest("Quest_Valkyrie_Sisters_Objective00")
  elseif questStateObjective00 == "Active" then
    LD.CompleteQuest("Quest_Valkyrie_Sisters_Objective00")
  elseif questStateObjective01 == "Active" then
    game.QuestManager.ProposeQuestState("Quest_Valkyrie_Sisters_Objective01", "Complete")
    CheckValkyrieQuestInProgress()
  elseif questStateObjective01 == "Complete" and questQueenParent == "Inactive" then
    CheckValkyrieQuestInProgress()
  end
  if questQueenParent == "Active" then
    LD.CompleteQuest("Quest_Valkyrie_Queen_Kill")
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Sigrun")
  end
end
function CheckValkyrieQuestInProgress()
  local _, objective02Progress = game.QuestManager.GetQuestProgressAndGoal("Quest_Valkyrie_Sisters_Objective02")
  if objective02Progress == 0 then
    game.QuestManager.IncrementQuestProgress("Quest_Valkyrie_Sisters_Objective02", 2)
    StartValkyrieCouncilQuest()
  else
    game.QuestManager.IncrementQuestProgress("Quest_Valkyrie_Sisters_Objective02", 1)
  end
end
function StartValkyrieCouncilQuest()
  LD.ActivateQuest("Quest_Valkyrie_Council_Parent")
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function SoftSave(level, go)
  game.SubObject.SoftSave(thisObj)
end
