local player
local noDropMarker = "NoDropZone"
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  local zoneParent = obj.Parent.Parent
  game.SubObject.SetEntityZoneHandler(obj, zoneParent)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  local zoneParent = obj.Parent.Parent
  if player:InsideZone(zoneParent) then
    local playerMarker = 3
    OnMarkerEnterZone(level, obj, zoneParent, player, playerMarker)
  end
end
function OnMarkerEnterZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  if markerGameObject == player then
    player:AddMarker(noDropMarker)
  end
end
function OnMarkerExitZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  if markerGameObject == player and not player:IsInsideEntityZone("CarryBifrostLight_Base2") then
    player:RemoveMarker(noDropMarker)
  end
end
