local LD = require("design.LevelDesignLibrary")
local thisObj, zoneObj, onlyCheckpointOnce, checkpointOverrideObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  onlyCheckpointOnce = thisObj:GetLuaTableAttribute("onlyCheckpointOnce")
  checkpointOverrideObj = thisObj:FindLuaTableAttribute("CheckpointOverrideName")
  if checkpointOverrideObj and checkpointOverrideObj ~= "" then
    checkpointOverrideObj = GameObjects[checkpointOverrideObj]
  end
  zoneObj = obj.Parent.Parent
  game.SubObject.SetEntityZoneHandler(thisObj, zoneObj)
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
end
function OnMarkerEnterZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  if tostring(markerId) ~= tostring(3) then
    return
  end
  if onlyCheckpointOnce then
    Disable()
  end
  local checkpointParams = {
    OverrideObject = checkpointOverrideObj and checkpointOverrideObj.Child
  }
  game.World.StoreCheckpoint(checkpointParams)
  engine.Print([[
      Storing Checkpoint using a Checkpoint Zone.
      CheckpointZone: ]] .. thisObj.Parent.Parent:GetName() .. "      LevelName: " .. level.Name .. "      Trace: " .. LD.GetParentTrace(thisObj) .. "    ")
end
function Enable()
  zoneObj:ShowEntityVolume()
end
function Disable()
  zoneObj:HideEntityVolume()
end
