local uiCalls, thisObj, player, zoneObj
local textMsg = ""
local waitTime = 15
local uiCalls_LoadLibrary = function()
  if uiCalls == nil then
    uiCalls = require("ui.uicalls")
  end
end
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  for i = 1, 5 do
    local line = obj:FindLuaTableAttribute("Line" .. tostring(i))
    if line ~= nil and line ~= "" then
      textMsg = textMsg .. line .. "\n"
    end
  end
  waitTime = obj:FindLuaTableAttribute("ButtonPrompt_WaitTime")
  if obj.Parent.IsRefNode == false then
    engine.error("In " .. obj:GetName() .. " Playtest Text UI script is being used in an imported module!!! ", level)
    return
  end
  zoneObj = obj.Parent.Parent
  game.SubObject.SetEntityZoneHandler(thisObj, zoneObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  game.SubObject.Sleep(obj)
end
function OnMarkerEnterZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  if markerGameObject == player and (game.LargeInteger.HashString(3) == markerId or game.LargeInteger.HashString(3) == game.LargeInteger.HashString(tostring(markerId))) then
    zoneObj:HideEntityVolume()
    uiCalls_LoadLibrary()
    uiCalls.UI_Event_SendPlaytestFullscreenMessage(textMsg, waitTime, uiCalls.msgParam.ADVANCE_TAP)
  end
end
function ShowDebugText()
  if engine.IsDebug() == false then
    return
  end
  local debugText = [[
PlaytestWardPad: 
 InGameplayOnlyPlaytestMode: ]] .. tostring(game.InGameplayOnlyPlaytestMode())
  local color = require("core.color")
  engine.DrawTextInWorld(thisObj:GetWorldPosition(), debugText .. [[

 ]] .. textMsg, color.white)
end
