local axeEmbedded = false
local saveAxeState = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
local OnWeaponEmbedCallbacks
function OnWeaponEmbed(level, go, attacker, weapon)
  if weapon:GetName() == "axe00" then
    axeEmbedded = true
    if OnWeaponEmbedCallbacks ~= nil then
      for i = 1, #OnWeaponEmbedCallbacks do
        OnWeaponEmbedCallbacks[i](level, go, attacker, weapon)
      end
    end
  end
end
function RegisterOnWeaponEmbed(fn)
  if OnWeaponEmbedCallbacks == nil then
    OnWeaponEmbedCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnWeaponEmbedCallbacks, fn)
  end
end
local OnWeaponUnembedCallbacks
function OnWeaponUnembed(level, go, attacker, weapon)
  if weapon:GetName() == "axe00" then
    axeEmbedded = false
    if OnWeaponUnembedCallbacks ~= nil then
      for i = 1, #OnWeaponUnembedCallbacks do
        OnWeaponUnembedCallbacks[i](level, go, attacker, weapon)
      end
    end
  end
end
function RegisterOnWeaponUnembed(fn)
  if OnWeaponUnembedCallbacks == nil then
    OnWeaponUnembedCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnWeaponUnembedCallbacks, fn)
  end
end
local OnWeaponUnembedStartCallbacks
function OnWeaponUnembedStart(level, go, weapon, attacker)
  axeEmbedded = false
  if OnWeaponUnembedStartCallbacks ~= nil then
    for i = 1, #OnWeaponUnembedStartCallbacks do
      OnWeaponUnembedStartCallbacks[i](level, go, weapon, attacker)
    end
  end
end
function RegisterOnWeaponUnembedStart(fn)
  if OnWeaponUnembedStartCallbacks == nil then
    OnWeaponUnembedStartCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnWeaponUnembedStartCallbacks, fn)
  end
end
local OnWeaponLockedOnCallbacks
function OnWeaponLockedOn(level, go, weapon, attacker)
  if OnWeaponLockedOnCallbacks ~= nil then
    for i = 1, #OnWeaponLockedOnCallbacks do
      OnWeaponLockedOnCallbacks[i](level, go, weapon, attacker)
    end
  end
end
function RegisterOnWeaponLockedOn(fn)
  if OnWeaponLockedOnCallbacks == nil then
    OnWeaponLockedOnCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnWeaponLockedOnCallbacks, fn)
  end
end
local OnWeaponPassthroughCallbacks
function OnWeaponPassThrough(level, go, weapon, attacker)
  if OnWeaponPassthroughCallbacks ~= nil then
    for i = 1, #OnWeaponPassthroughCallbacks do
      OnWeaponPassthroughCallbacks[i](level, go, weapon, attacker)
    end
  end
end
function RegisterOnWeaponPassThrough(fn)
  if OnWeaponPassthroughCallbacks == nil then
    OnWeaponPassthroughCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnWeaponPassthroughCallbacks, fn)
  end
end
local OnWeaponIncomingCallbacks
function OnWeaponIncoming(level, go, weapon, attacker)
  if OnWeaponIncomingCallbacks ~= nil then
    for i = 1, #OnWeaponIncomingCallbacks do
      OnWeaponIncomingCallbacks[i](level, go, weapon, attacker)
    end
  end
end
function RegisterOnWeaponIncoming(fn)
  if OnWeaponIncomingCallbacks == nil then
    OnWeaponIncomingCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnWeaponIncomingCallbacks, fn)
  end
end
local OnHitGameObjectCallbacks
function OnHitGameObject(level, go, attacker, goHit)
  if OnHitGameObjectCallbacks ~= nil then
    for i = 1, #OnHitGameObjectCallbacks do
      OnHitGameObjectCallbacks[i](level, go, attacker, goHit)
    end
  end
end
function RegisterOnHitGameObject(fn)
  if OnHitGameObjectCallbacks == nil then
    OnHitGameObjectCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnHitGameObjectCallbacks, fn)
  end
end
local OnHitByWeaponCallbacks
function OnHitByWeapon(level, go, weapon, attacker)
  if OnHitByWeaponCallbacks ~= nil then
    for i = 1, #OnHitByWeaponCallbacks do
      OnHitByWeaponCallbacks[i](level, go, weapon, attacker)
    end
  end
end
function RegisterOnHitByWeapon(fn)
  if OnHitByWeaponCallbacks == nil then
    OnHitByWeaponCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnHitByWeaponCallbacks, fn)
  end
end
local OnHitByArrowCallbacks
function OnHitByArrow(level, go, arrow_owner, arrow_go, arrow_tweak)
  if OnHitByArrowCallbacks ~= nil then
    for i = 1, #OnHitByArrowCallbacks do
      OnHitByArrowCallbacks[i](level, go, arrow_owner, arrow_go, arrow_tweak)
    end
  end
end
function RegisterOnHitByArrow(fn)
  if OnHitByArrowCallbacks == nil then
    OnHitByArrowCallbacks = {}
  end
  if fn ~= nil then
    table.insert(OnHitByArrowCallbacks, fn)
  end
end
function SetSaveAxeState(bool)
  saveAxeState = bool
end
function OnSaveCheckpoint(level, obj)
  if not saveAxeState then
    axeEmbedded = nil
  end
  return {axeEmbedded = axeEmbedded}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  axeEmbedded = savedInfo.axeEmbedded
end
function OnStart(level, obj)
  if saveAxeState and axeEmbedded and obj:IsAxeEmbedded() == false then
    if OnWeaponUnembedStartCallbacks ~= nil then
      for i = 1, #OnWeaponUnembedStartCallbacks do
        OnWeaponUnembedStartCallbacks[i](level, obj, nil, nil)
      end
    end
    if OnWeaponUnembedCallbacks ~= nil then
      for i = 1, #OnWeaponUnembedCallbacks do
        OnWeaponUnembedCallbacks[i](level, obj, nil, nil)
      end
    end
  end
end
