local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local CCOS = require("camera.camera_oneshot")
local thisObj
local nodesBroken = 0
local node01, node02, node03, rune01, rune02, rune03, nodeRune01, nodeRune02, nodeRune03, sonDispellAnimContainer
local dispellComplete = false
local sonDispelObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  node01 = GameObjects[thisObj:FindLuaTableAttribute("node01")]
  if node01.IsRefNode then
    node01 = node01.Child
    node01 = node01:FindSingleGOByName("Breakable")
  end
  node02 = GameObjects[thisObj:FindLuaTableAttribute("node02")]
  if node02.IsRefNode then
    node02 = node02.Child
    node02 = node02:FindSingleGOByName("Breakable")
  end
  node03 = GameObjects[thisObj:FindLuaTableAttribute("node03")]
  if node03.IsRefNode then
    node03 = node03.Child
    node03 = node03:FindSingleGOByName("Breakable")
  end
  sonDispellAnimContainer = obj:FindSingleGOByName("SonDispellAnimationContainer")
  sonDispelObj = obj:FindSingleGOByName("SonDispell")
  game.SubObject.Sleep(obj)
end
function OnPreStart(level, obj)
  rune01 = obj:FindSingleGOByName("rune01")
  rune02 = obj:FindSingleGOByName("rune02")
  rune03 = obj:FindSingleGOByName("rune03")
  nodeRune01 = node01:FindSingleGOByName("RuneVisual1")
  nodeRune02 = node02:FindSingleGOByName("RuneVisual2")
  nodeRune03 = node03:FindSingleGOByName("RuneVisual3")
  rune01.LuaObjectScript.SelectRune(1)
  rune02.LuaObjectScript.SelectRune(2)
  rune03.LuaObjectScript.SelectRune(3)
  if node01.Broken == false then
    node01.LuaObjectScript.SelectRune(1)
  end
  if node02.Broken == false then
    node02.LuaObjectScript.SelectRune(2)
  end
  if node03.Broken == false then
    node03.LuaObjectScript.SelectRune(3)
  end
end
function OnFirstStart(level, obj)
  sonDispellAnimContainer:JumpAnimationToFrame(0)
  sonDispellAnimContainer:PauseAnimation()
end
function OnStart(level, obj)
  sonDispelObj.LuaObjectScript.SetOnArrivalCameraCallback(ActivateCameraOnArrival)
  sonDispelObj.LuaObjectScript.SetOnCompleteCameraCallback(ActivateCameraOnComplete)
  sonDispelObj.LuaObjectScript.SetOnButtonPressedCameraCallback(ActivateCameraOnButtonPressed)
  local sonInteract = sonDispelObj.LuaObjectScript.GetSonInteractZone()
  sonInteract:SetTags("NotInCombat")
  sonInteract:SetXZRange(6)
  sonInteract:SetHintXZRange(10)
  if nodesBroken < 3 then
    node01.LuaObjectScript.OnBroken(function()
      NodeBroken(1)
    end)
    node02.LuaObjectScript.OnBroken(function()
      NodeBroken(2)
    end)
    node03.LuaObjectScript.OnBroken(function()
      NodeBroken(3)
    end)
    sonDispelObj.LuaObjectScript.DisableInteract()
  end
  if dispellComplete then
    sonDispelObj.LuaObjectScript.Disable()
  end
  if game.FindLevel("Xpl650_MasonTrailCave") ~= nil and dispellComplete == true then
    local questState = game.QuestManager.GetQuestState("Quest_WorldDragon_Fafnir_Objective_01_Return")
    if questState == "Active" then
      LD.CompleteQuest("Quest_WorldDragon_Fafnir_Objective_01_Return")
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {nodesBroken = nodesBroken, dispellComplete = dispellComplete}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  nodesBroken = savedInfo.nodesBroken
  dispellComplete = savedInfo.dispellComplete
end
function LowerDispellGate()
  thisObj:OnAnimationDone(thisObj, "ExtendDispellMask")
  thisObj:PlayAnimationToEnd()
end
function ExtendDispellMask()
  sonDispellAnimContainer:OnAnimationDone(thisObj, "MaskExtended")
  sonDispellAnimContainer:PlayAnimationToEnd(0.5)
end
function MaskExtended()
  sonDispelObj.LuaObjectScript.Enable()
  sonDispelObj.LuaObjectScript.EnableInteract()
end
function DispellComplete()
  dispellComplete = true
  LD.ExtractAndExecuteCallbacksForEvent(thisObj.Level, thisObj, thisObj:FindLuaTableAttribute("Event_Complete"), "Event Complete - All Nodes Destroyed")
end
function DispellStarted()
  LD.ExtractAndExecuteCallbacksForEvent(thisObj.Level, thisObj, thisObj:FindLuaTableAttribute("Event_Started"), "Event Started - All Nodes Destroyed")
end
function NodeBroken(index)
  nodesBroken = nodesBroken + 1
  if index == 1 then
    rune01.LuaObjectScript.Disable()
    nodeRune01:Hide()
  elseif index == 2 then
    rune02.LuaObjectScript.Disable()
    sonDispelObj.LuaObjectScript.Enable()
    nodeRune02:Hide()
  elseif index == 3 then
    rune03.LuaObjectScript.Disable()
    nodeRune03:Hide()
  end
  if nodesBroken == 3 then
    LowerDispellGate()
  end
end
local camOneShot_LookAtInteract, camOneShot_LookAtKnifeDispell, camOneShot_LookAtKnifeDispellPushIn, camOneShot_LookAtDragon, camOneShot_LookAtDragonHead, camOneShot_LookAtDragonHead_FrameForUI
function ActivateCameraOnButtonPressed()
  game.SubObject.Wake(thisObj)
  local safeWarpObj = thisObj:FindSingleGOByName("SonWarpSafe")
  if safeWarpObj then
    safeWarpObj.LuaObjectScript.WarpSon()
  end
  LookAtDragonInteract()
  timers.StartLevelTimer(3, LookAtSonKnifeTheDispell)
  SetSlowWalk()
  timers.StartLevelTimer(16, ClearSlowWalk)
end
function ActivateCameraOnArrival()
end
function ActivateCameraOnComplete()
  timers.StartLevelTimer(0.39, LookAtSonKnifeTheDispellPushIn)
  timers.StartLevelTimer(0.56, PlayDispellStrikeEffect)
  timers.StartLevelTimer(1.7, LookAtDragon)
  timers.StartLevelTimer(7, LookAtDragonHead)
  timers.StartLevelTimer(10.9, LookAtDragonHead_FrameForUI)
end
function SetSlowWalk()
  local player = game.Player.FindPlayer()
  player:SetMaxSpeedOverride(1.5)
end
function ClearSlowWalk()
  local player = game.Player.FindPlayer()
  player:ClearMaxSpeedOverride()
end
function PlayDispellStrikeEffect()
  local shakeParams = {
    EffectName = "FSE_SHAKE_SWITCH_CLUNK",
    Duration = 0.2
  }
  game.FX.SubmitEffect(shakeParams)
end
function DestroyOneShot_LookAtInteract()
  if camOneShot_LookAtInteract ~= nil then
    camOneShot_LookAtInteract = nil
  end
end
function DestroyOneShot_LookAtKnifeDispell()
  if camOneShot_LookAtKnifeDispell ~= nil then
    camOneShot_LookAtKnifeDispell = nil
  end
end
function DestroyOneShot_LookAtKnifeDispellPushIn()
  if camOneShot_LookAtKnifeDispell ~= nil then
    camOneShot_LookAtKnifeDispell = nil
  end
end
function DestroyOneShot_LookAtDragon()
  if camOneShot_LookAtDragon ~= nil then
    camOneShot_LookAtDragon = nil
  end
end
function DestroyOneShot_LookAtDragonHead()
  DestroyOneShot_LookAtInteract()
  DestroyOneShot_LookAtKnifeDispell()
  DestroyOneShot_LookAtKnifeDispellPushIn()
  if camOneShot_LookAtDragonHead ~= nil then
    camOneShot_LookAtDragonHead = nil
  end
end
function DestroyOneShot_LookAtDragonHead_FrameForUI()
  DestroyOneShot_LookAtInteract()
  DestroyOneShot_LookAtKnifeDispell()
  DestroyOneShot_LookAtKnifeDispellPushIn()
  if camOneShot_LookAtDragonHead_FrameForUI ~= nil then
    camOneShot_LookAtDragonHead_FrameForUI = nil
  end
  game.SubObject.Sleep(thisObj)
end
function LookAtDragonInteract()
  camOneShot_LookAtInteract = CCOS.OneShotCamera.New("PLYR_NAR_LookAtDragonInteract_010", 10)
  camOneShot_LookAtInteract:SetCallback(DestroyOneShot_LookAtInteract)
  camOneShot_LookAtInteract:Start()
end
function LookAtSonKnifeTheDispell()
  camOneShot_LookAtKnifeDispell = CCOS.OneShotCamera.New("PLYR_NAR_LookAtDragonInteract_020", 10)
  camOneShot_LookAtKnifeDispell:SetCallback(DestroyOneShot_LookAtKnifeDispell)
  camOneShot_LookAtKnifeDispell:Start()
end
function LookAtSonKnifeTheDispellPushIn()
  camOneShot_LookAtKnifeDispellPushIn = CCOS.OneShotCamera.New("PLYR_NAR_LookAtDragonInteract_030", 4.2)
  camOneShot_LookAtKnifeDispellPushIn:SetCallback(DestroyOneShot_LookAtKnifeDispellPushIn)
  camOneShot_LookAtKnifeDispellPushIn:Start()
end
function LookAtDragon()
  camOneShot_LookAtDragon = CCOS.OneShotCamera.New("PLYR_NAR_LookAtDragon_010", 7)
  camOneShot_LookAtDragon:SetCallback(DestroyOneShot_LookAtDragon)
  camOneShot_LookAtDragon:Start()
end
function LookAtDragonHead()
  camOneShot_LookAtDragonHead = CCOS.OneShotCamera.New("PLYR_NAR_LookAtDragon_020", 6)
  camOneShot_LookAtDragonHead:SetCallback(DestroyOneShot_LookAtDragonHead)
  camOneShot_LookAtDragonHead:Start()
end
function GetDisplayTimeForFinalCamera()
  local levelname = thisObj.Parent.Parent:GetName()
  if levelname == "xpl650_ents_nooffset" then
    return 13.7
  elseif levelname == "xpl100_ents_nooffset" then
    return 6.2
  elseif levelname == "xpl200_ents_nooffset" then
    return 13.7
  else
    assert(nil, "DragonDispell: WHAT WAD IS THIS DRAGON COMING FROM")
  end
end
function LookAtDragonHead_FrameForUI()
  local submissionTime = GetDisplayTimeForFinalCamera()
  camOneShot_LookAtDragonHead_FrameForUI = CCOS.OneShotCamera.New("PLYR_NAR_LookAtDragon_030", submissionTime)
  camOneShot_LookAtDragonHead_FrameForUI:SetCallback(DestroyOneShot_LookAtDragonHead_FrameForUI)
  camOneShot_LookAtDragonHead_FrameForUI:Start()
end
function OnUpdate()
  if camOneShot_LookAtInteract ~= nil then
    camOneShot_LookAtInteract:Update()
  end
  if camOneShot_LookAtKnifeDispell ~= nil then
    camOneShot_LookAtKnifeDispell:Update()
  end
  if camOneShot_LookAtKnifeDispellPushIn ~= nil then
    camOneShot_LookAtKnifeDispellPushIn:Update()
  end
  if camOneShot_LookAtDragon ~= nil then
    camOneShot_LookAtDragon:Update()
  end
  if camOneShot_LookAtDragonHead ~= nil then
    camOneShot_LookAtDragonHead:Update()
  end
  if camOneShot_LookAtDragonHead_FrameForUI ~= nil then
    camOneShot_LookAtDragonHead_FrameForUI:Update()
  end
end
