local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, player, son, questLoreMarker, bifrostBase, Locked
local STATE_OFF, STATE_VISIBLE, STATE_INTERACTED = 0, 1, 2
local runeDecalState = STATE_OFF
local contextAction, totemBallFx, totemBallFxActivate, runeParticleFX, runeDecalFX
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  bifrostBase = obj:FindSingleGOByName("pInvisibleInkTotemBase")
  questLoreMarker = obj:FindSingleGOByName("pQuestLoreMarker")
  runeParticleFX = obj:FindSingleGOByName("RuneParticlesFX")
  totemBallFx = obj:FindSingleGOByName("TotemBall_Passive")
  runeDecalFX = obj:FindSingleGOByName("RuneRead_Decal")
  contextAction = obj:FindSingleGOByName("SonInkObserve")
  Locked = obj:GetLuaTableAttribute("StartLocked")
  if Locked == true then
    Lock()
  end
  runeDecalFX:Hide()
  runeParticleFX:Show()
  runeDecalState = STATE_OFF
end
function OnStart(level, obj)
end
function RevealRune()
  if runeDecalState == STATE_INTERACTED then
    return
  end
  questLoreMarker.LuaObjectScript.EnableSonInteract()
  local totemBallFxActivate = game.FX.Spawn("TotemBall_End", thisLevel, {
    GameObject = thisObj,
    AutoDelete = true,
    Joint = "jointFXBall"
  })
  totemBallFx:Hide()
  runeDecalFX:Show()
  runeDecalState = STATE_VISIBLE
end
function EnableContextAction()
  if not contextAction then
    engine.Warning("Attempting to enable contextAction: '", contextAction, "' when it does not exist")
    return
  end
  if not runeDecalState == STATE_INTERACTED then
    contextAction.LuaObjectScript.Enable()
  end
end
function DisableContextAction()
  if not contextAction then
    engine.Warning("Attempting to Disable contextAction: '", contextAction, "' when it does not exist")
    return
  end
  contextAction.LuaObjectScript.Disable()
end
function DisableSonInteract()
  if runeDecalState == STATE_INTERACTED then
    return
  end
  runeDecalState = STATE_OFF
end
function Lock()
  bifrostBase.LuaObjectScript.Lock()
end
function Unlock()
  bifrostBase.LuaObjectScript.Unlock()
end
function SetStateInteracted()
  runeDecalState = STATE_INTERACTED
  DisableContextAction()
end
function IsParent()
  return true
end
function OnSaveCheckpoint(level, go)
  return {runeDecalState = runeDecalState}
end
function OnRestoreCheckpoint(level, go, tab)
  runeDecalState = tab.runeDecalState
  if runeDecalState == STATE_INTERACTED then
    totemBallFx:Hide()
    runeParticleFX:Hide()
    questLoreMarker.LuaObjectScript.DisableSonInteract()
  end
end
