local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel
player = nil
local questParent, interactCompleteEvents
local collected = false
local interact
local markerRevealed = false
local overrideReward, isRevealPickup, journalUpdateID
local VariantTable = {
  "VIKING_FUNERAL_REVEAL",
  "MASON_DRAGON_REVEAL",
  "FALLEN_WARRIOR_REVEAL",
  "UB02_REVEAL",
  "UB03_REVEAL",
  "UB04_REVEAL",
  "UB05_REVEAL"
}
local MarkerReveals = {
  VIKING_FUNERAL_REVEAL = "CAL_VF_Entrance",
  MASON_DRAGON_REVEAL = "MTC_Fafnir_Return",
  FALLEN_WARRIOR_REVEAL = "SMLH_UFB_01_Obj01_BBB_Return",
  UB02_REVEAL = "SMLH_UFB_02_Obj02",
  UB03_REVEAL = "BWAT_UFB_03_Obj957_Return",
  UB04_REVEAL = "BC_UFB_04_Obj6356_Return",
  UB05_REVEAL = "BC_USB_05_Obj01_LightBeacon"
}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  questParent = obj:FindLuaTableAttribute("QuestParent")
  if obj:FindLuaTableAttribute("Event_InteractComplete") ~= "" then
    interactCompleteEvents = LD.ExtractCallbacksForEvent(level, obj, obj:FindLuaTableAttribute("Event_InteractComplete"))
  end
  journalUpdateID = thisObj:FindLuaTableAttribute("journalUpdateID")
  local genericSonInteract = obj:FindSingleGOByName("GenericSonInteract")
  if genericSonInteract then
    LD.ForwardUserFunctionToObject(obj, genericSonInteract)
  end
  isRevealPickup = thisObj:FindLuaTableAttribute("IsRevealPickup")
  game.SubObject.Sleep(thisObj)
  SoundInit()
end
function OnStart(level, obj)
  if questParent ~= nil and questParent ~= "" then
    thisObj:SetCharacterConfig("blue")
  else
    thisObj:SetCharacterConfig("red")
  end
  interact = obj:FindSingleGOByName("GenericSonInteract")
  if isRevealPickup then
    local interactObj = interact.IsRefNode and interact.Child or interact
    local interactZone = game.InteractZone.New(interactObj, "synchJoint")
    interactZone:SetPromptIconSet({
      normal = "WORLD_INTERACT_SON_DYNAMIC",
      unavailable = "WORLD_INTERACT_UNAVAILABLE_LOOT",
      locked = "WORLD_INTERACT_LOCKED_LOOT",
      hint = "WORLD_INTERACT_HINT_LOOT"
    })
    interactZone:SetAsSonInteract()
    interact.LuaObjectScript.OverrideInteractZone(interactZone)
  end
  if collected == true then
    thisObj:Hide()
    interact.LuaObjectScript.Disable()
  end
  thisObj:JumpAnimationToFrame(0, {
    Animation = "envGlobPickupExamineScroll"
  })
  thisObj:PauseAnimation()
end
function LuaHook_FireBanter()
  if questParent ~= nil and questParent ~= "" then
    local tMap = {
      game.QuestManager.GetQuestState("Quest_TreasureMap01_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_ThorStatue_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_Shipwreck_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_Oarsmen_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_VF_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_Stronghold_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_ForestDungeon_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_IslandClimb_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_ValkyrieArena_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_BlackBreath_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_TurtleHouse_Parent"),
      game.QuestManager.GetQuestState("Quest_TreasureMap_IslandArch_Parent")
    }
    local mapQuest
    local allInactive = true
    for _, mapQuest in ipairs(tMap) do
      if mapQuest ~= "Inactive" then
        allInactive = false
      end
    end
    if allInactive == true then
      game.Audio.PlayBanterNonCritical("TreasureMapFirstFound", nil, nil, false)
    else
      game.Audio.PlayBanterNonCritical("Quest_TreasureMap02_Parent_Activate", nil, nil, false)
    end
  elseif journalUpdateID ~= nil and journalUpdateID ~= "" and not IsLibraryScroll() then
    if journalUpdateID ~= "Sindri02_FatherSon_Lore" then
      game.Audio.PlayBanterNonCritical("Scroll_Pickup")
    end
  elseif overrideReward and MarkerReveals[overrideReward] then
    game.Audio.PlayBanterNonCritical("Scroll_Pickup")
  end
end
function LuaHook_RevealMarker()
  if overrideReward and not markerRevealed then
    LD.SetMarkerState(MarkerReveals[overrideReward], 1)
    LD.UpdateMap(MarkerReveals[overrideReward], 2)
    game.Loot.RollCondition(overrideReward, "HERO")
    thisObj:HideParticles()
    markerRevealed = true
  end
end
function LuaHook_PickupScroll()
  PlaySoundOnPickup()
end
function LuaHook_SonReachedScroll()
  local glowFX = thisObj:FindGOsByName("PickUp_Glow*")
  if glowFX then
    for _, fx in pairs(glowFX) do
      LD.HideFX(fx)
    end
  end
end
function UpdateJournal()
  if journalUpdateID ~= nil and journalUpdateID ~= "" then
    journalUpdateID = string.gsub(journalUpdateID, "%s+", "")
    LD.UpdateJournal(journalUpdateID, 5)
  end
  SoftSave()
end
function IsLibraryScroll()
  if journalUpdateID and (journalUpdateID == "AsgardScroll_Lore" or journalUpdateID == "CAL_170_Lore_01" or journalUpdateID == "SerpentScroll_Lore") then
    return true
  else
    return false
  end
end
function AlignInteract()
  local oldForward = thisObj:GetWorldForward()
  local newForward = engine.Vector.New(oldForward.x, 0, oldForward.z):Normalized()
  local physicsLocation = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("zeroJoint"))
  thisObj:HidePhysics()
  thisObj:SetWorldPosition(physicsLocation)
  thisObj:SetWorldFacing(newForward)
end
function OnInteractStart(level, obj, creature)
  interact.LuaObjectScript.OnInteractStart(level, obj, creature)
end
function OnInteractDone(level, obj, creature)
  interact.LuaObjectScript.OnInteractFinish(level, obj, creature)
end
function InteractComplete()
  LuaHook_RevealMarker()
  if questParent ~= "" then
    local questState = game.QuestManager.GetQuestState(questParent)
    if questState == "Inactive" then
      game.QuestManager.StartQuest(questParent)
    end
  else
    UpdateJournal()
    game.Wallets.AddResource("HERO", "EconomyXP", 100, nil, "Scroll")
  end
  if thisObj:FindLuaTableAttribute("Event_InteractComplete") ~= "" then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactCompleteEvents, "Son Interact Complete")
  end
  if journalUpdateID == "Sindri02_FatherSon_Lore" then
    LD.ActivateQuest("Quest_SecretBusiness02_Parent")
  end
  collected = true
  interact.LuaObjectScript.Disable()
  thisObj:ShowPhysics()
  thisObj:Hide()
  SoftSave()
end
function OverrideInteract()
  return thisObj
end
function OnSaveCheckpoint(level)
  return {collected = collected}
end
function OnRestoreCheckpoint(level, obj, tab)
  collected = tab.collected
end
function SoftSave(level, obj)
  game.SubObject.SoftSave(thisObj)
end
function OverrideReward(level, go, newReward)
  if newReward ~= nil then
    overrideReward = newReward
  end
end
function LuaHook_SpawnLootObject(level, go, variant, spawnedObjectName)
  OverrideReward(level, go, VariantTable[variant])
end
local soundEmitter
local soundEvents = {
  IdleLoop = "SND_LOOT_Shard_Purple_Idle_LP",
  OnPickup = "SND_FOLY_Hand_Small_Grab_Strong"
}
function SoundInit()
  soundEmitter = thisObj.SoundEmitters[1]
  PlaySoundIdleLoop()
end
function PlaySoundIdleLoop()
  LD.PlaySound(soundEmitter, soundEvents.IdleLoop)
end
function StopSoundIdleLoop()
  LD.StopSound(soundEmitter, soundEvents.IdleLoop)
end
function PlaySoundOnPickup()
  LD.PlaySound(soundEmitter, soundEvents.OnPickup)
  StopSoundIdleLoop()
end
